/*
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* This program 2001 by Sam Trenholme.  This is under the same license as
   the rest of the whirlpool code */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <fcntl.h>

#include "nessie.h"

main(int argc, char **argv) {
    struct NESSIEstruct whirlpool_ctx;
    int desc, readed, counter;
    char buf[4100];
    char digest[72];

    if(argc != 2) {
        printf("Usage: whirlpool {filename}\n");
	exit(1);
	}
 
    if((desc = open(argv[1],O_RDONLY)) < 0) {
        perror("Could not open file");
	exit(2);
	}

    NESSIEinit(&whirlpool_ctx);
    
    readed = 1;
    while(readed > 0) {
        readed = read(desc,buf,4096);
        if(readed > 0) 
	    NESSIEadd(buf,readed * 8,&whirlpool_ctx);
        }

    NESSIEfinalize(&whirlpool_ctx,digest);

    printf("Whirlpool digest: ");
    for(counter = 0; counter < 64; counter++)
        printf("%02x",digest[counter] & 0xff);
    printf("\n");

    }

