/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "tablemodelshelper.h"

#include <QApplication>

#include "data/datamanager.h"
#include "data/datarows.h"
#include "tablemodels.h"

QString TableModelsHelper::formatId( int id )
{
    return QString( "#%1" ).arg( id );
}

QString TableModelsHelper::formatSize( int size )
{
    if ( size >= 1048576 ) {
        double mb = (double)size / 1048576.0;
        return tr( "%1 MB" ).arg( mb, 0, 'f', 1 );
    }
    if ( size >= 1024 ) {
        double kb = (double)size / 1024.0;
        return tr( "%1 kB" ).arg( kb, 0, 'f', 1 );
    }
    return tr( "%1 bytes" ).arg( size );
}

QString TableModelsHelper::userName( int userId )
{
    const UserRow* row = dataManager->users()->find( userId );
    if ( !row )
        return QString();
    return row->name();
}

QString TableModelsHelper::typeName( int typeId )
{
    const TypeRow* row = dataManager->types()->find( typeId );
    if ( !row )
        return QString();
    return row->name();
}

QString TableModelsHelper::attributeName( int attributeId )
{
    const AttributeRow* row = dataManager->attributes()->find( attributeId );
    if ( !row )
        return QString();
    return row->name();
}

QString TableModelsHelper::columnName( int column )
{
    switch ( column ) {
        case Column_Name:
            return tr( "Name" );
        case Column_ID:
            return tr( "ID" );
        case Column_CreatedDate:
            return tr( "Created Date" );
        case Column_CreatedBy:
            return tr( "Created By" );
        case Column_ModifiedDate:
            return tr( "Modified Date" );
        case Column_ModifiedBy:
            return tr( "Modified By" );
        case Column_Login:
            return tr( "Login" );
        case Column_Size:
            return tr( "Size" );
        case Column_Description:
            return tr( "Description" );
        case Column_Access:
            return tr( "Access Level" );
        case Column_Required:
            return tr( "Required" );
        case Column_Details:
            return tr( "Details" );
        case Column_DefaultValue:
            return tr( "Default Value" );
        case Column_OldValue:
            return tr( "Previous Value" );
        case Column_NewValue:
            return tr( "New Value" );
        case Column_Type:
            return tr( "Type" );
        default:
            if ( column > Column_UserDefined ) {
                const AttributeRow* attribute = dataManager->attributes()->find( column - Column_UserDefined );
                if ( attribute )
                    return attribute->name();
            }
            return QString();
    }
}

QString TableModelsHelper::tr( const char* text )
{
    return qApp->translate( "TableModelsHelper", text );
}
