/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef NOTIFYBATCH_H
#define NOTIFYBATCH_H

#include "commands/abstractbatch.h"
#include "batchjob.h"

class Reply;

/**
* Batch for changing folder and issue notification settings.
*
* This batch sends the <tt>NOTIFY FOLDER</tt> and/or <tt>NOTIFY ISSUE</tt>
* commands. The notification state is automatically updated.
*/
class NotifyBatch : public AbstractBatch
{
    Q_OBJECT
public:
    /**
    * Default constructor.
    */
    NotifyBatch();

    /**
    * Destructor.
    */
    ~NotifyBatch();

public:
    /**
    * Enable or disable notifications for a folder.
    */
    void notifyFolder( int folderId, bool notify );

    /**
    * Enable or disable notifications for an issue.
    */
    void notifyIssue( int issueId, bool notify );

public: // overrides
    Command* fetchNext();

private:
    typedef BatchJob<NotifyBatch> Job;
    typedef BatchJobQueue<NotifyBatch> JobQueue;

private:
    Command* notifyFolderJob( const Job& job );
    Command* notifyIssueJob( const Job& job );

private slots:
    void setUpdate();

private:
    JobQueue m_queue;

    bool m_update;
};

#endif
