/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef PREFERENCESHELPER_H
#define PREFERENCESHELPER_H

#include <QString>

/**
* Helper functions for validating and parsing user preferences.
*/
class PreferencesHelper
{
public:
    /**
    * Convert time zone offset (in seconds) to string format.
    */
    static QString formatTimeZone( int zone );

    /**
    * Convert time zone string to offset in seconds.
    */
    static int parseTimeZone( const QString& text );

    /**
    * Check if the string is a valid email address.
    */
    static bool isValidEmail( const QString& email );
};

#endif
