/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "gradientwidget.h"

#include <QPainter>
#include <QStyleOption>

#include "dotnetstyle.h"

using namespace WebIssues;

GradientWidget::GradientWidget( QWidget* parent ) : QWidget( parent )
{
#if defined( WI_NO_STYLE_DOTNET )
    setPalette( QPalette( QColor( 255, 255, 255 ) ) );
    setAutoFillBackground( true );
#endif
}

GradientWidget::~GradientWidget()
{
}

void GradientWidget::paintEvent( QPaintEvent* e )
{
#if !defined( WI_NO_STYLE_DOTNET )
    QPainter painter( this );

    QStyleOption option;
    option.initFrom( this );

    ( (DotNetStyle*)style() )->fillGradient( &option, &painter, this );
#endif
}
