/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "metadatadialogfactory.h"

#include "metadatadialogs.h"

using namespace WebIssues;

MetadataDialogBase* MetadataDialogFactory::createMetadataDialog( DefinitionInfo::Type type, QWidget* parent )
{
    switch ( type ) {
        case DefinitionInfo::Text:
            return new TextMetadataDialog( parent );
        case DefinitionInfo::Enum:
            return new EnumMetadataDialog( parent );
        case DefinitionInfo::Numeric:
            return new NumericMetadataDialog( parent );
        case DefinitionInfo::DateTime:
            return new DateTimeMetadataDialog( parent );
        case DefinitionInfo::User:
            return new UserMetadataDialog( parent );
    }

    return NULL;
}
