package org.apache.maven.wagon.providers.ssh.knownhost;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.IOException;

/**
 * Common base for known hosts providers.
 *
 * @author <a href="mailto:brett@apache.org">Brett Porter</a>
 * @version $Id: AbstractKnownHostsProvider.java 477186 2006-11-20 14:14:45Z brett $
 */
public abstract class AbstractKnownHostsProvider
    implements KnownHostsProvider
{
    /**
     * Valid values are ask, yes, no.
     */
    private String hostKeyChecking = "yes";

    /**
     * the known hosts, in the openssh format
     */
    protected String contents;

    public void setHostKeyChecking( String hostKeyChecking )
    {
        this.hostKeyChecking = hostKeyChecking;
    }

    public String getHostKeyChecking()
    {
        return hostKeyChecking;
    }

    public String getContents()
    {
        return contents;
    }

    public void storeKnownHosts( String contents )
        throws IOException
    {
    }
}
