// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        inetaddr.C
// 
// Purpose:     
// 
// Created:     5 Jul 96   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: inetaddr.C,v 1.2 1996/10/03 15:59:07 jfasch Exp $
// 
// $Log: inetaddr.C,v $
// Revision 1.2  1996/10/03 15:59:07  jfasch
// adaptions due to moving it from the previous location in DcCommon to HgUtilities
//
// Revision 1.1  1996/07/08 13:16:36  jfasch
// Initial revision
//
// 
// </file> 
#include "inetaddr.h"

#include "assert.h"

#include <string.h>
#include <arpa/inet.h>
#include <sys/socket.h>


#ifndef VERBOSE
#  define VERBOSE
#endif
#include "verbose.h"

#ifndef INADDR_NONE
#  define INADDR_NONE (u_long)0xffffffff
#endif


// --------------------------------------------------------------------
INETAddress :: INETAddress() {
   ::memset (this, '\0', sizeof (INETAddress)) ;
   sin_family = AF_INET ;
}

INETAddress :: INETAddress (const char* hostaddr, int port) {
   ::memset (this, '\0', sizeof (INETAddress)) ;
   sin_family = AF_INET ;
   unsigned long addr = inet_addr (hostaddr) ;
   if (addr == INADDR_NONE) {
      DEBUGNL ("INETAddress::INETAddress(const char*,int): ::inet_addr() failed") ;
      return ;
   }
   sin_addr.s_addr = addr ;
   sin_port = htons ((u_short)port) ;
}

INETAddress :: INETAddress (const sockaddr_in& a) {
   operator = (a) ;
}

INETAddress& INETAddress :: operator = (const sockaddr_in& a) {
   hgassert (a.sin_family==AF_INET, 
             "INETAddress::operator=(const sockaddr_in&): not AF_INET") ;
   ::memcpy (this, &a, sizeof (INETAddress)) ;
   return *this ;
}

const char* INETAddress :: host() const {
   return ::inet_ntoa (sin_addr) ;
}
   

int INETAddress :: port() const {
   return ntohs (sin_port) ;
}

bool INETAddress :: operator == (const INETAddress& a) const {
   return sin_addr.s_addr == a.sin_addr.s_addr  &&  sin_port == a.sin_port ;
}

bool INETAddress :: operator < (const INETAddress& a) const {
   return sin_addr.s_addr < a.sin_addr.s_addr ||
      (sin_addr.s_addr == a.sin_addr.s_addr && sin_port < a.sin_port) ;
}

