/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.xslt;

import java.io.InputStream;
import java.io.Writer;
import java.util.Hashtable;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class TraxTransform {
    private static Hashtable _stylesheetCache = new Hashtable();

    public static Transformer getTransformer(String string, boolean bl) {
        try {
            if (bl && _stylesheetCache.containsKey(string)) {
                Templates templates = (Templates)_stylesheetCache.get(string);
                return templates.newTransformer();
            }
            StreamSource streamSource = new StreamSource(string);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Templates templates = transformerFactory.newTemplates(streamSource);
            if (bl) {
                _stylesheetCache.put(string, templates);
            }
            return templates.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
            return null;
        }
    }

    public static void transform(String string, String string2, Writer writer) {
        TraxTransform.transform(new StreamSource(string), new StreamSource(string2), new StreamResult(writer));
    }

    public static void transform(String string, String string2, String string3) {
        TraxTransform.transform(new StreamSource(string), new StreamSource(string2), new StreamResult(string3));
    }

    public static void transform(Source source, Source source2, Result result) {
        try {
            Transformer transformer;
            if (source2.getSystemId() == null) {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                transformer = transformerFactory.newTransformer(source2);
            } else {
                transformer = TraxTransform.getTransformer(source2.getSystemId(), true);
            }
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
    }

    public static void transform(Document document, InputStream inputStream, Document document2) {
        TraxTransform.transform(new DOMSource(document), new StreamSource(inputStream), new DOMResult(document2));
    }

    public static void transform(Document document, String string, String string2) {
        TraxTransform.transform(new DOMSource(document), new StreamSource(string), new StreamResult(string2));
    }
}

