/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "gtk_wire.h"

#include <gtk/gtk.h>

#include <visu_object.h>
#include <visu_tools.h>
#include <gtk_pairs.h>
#include <extraGtkFunctions/gtk_stippleComboBoxWidget.h>
#include <extraGtkFunctions/gtk_shadeComboBoxWidget.h>

#include "wire.h"

/**
 * SECTION: gtk_wire
 * @short_description: The additional widgets displayed in the pair
 * dialog to handle wire pairs.
 */

static GtkWidget *spinThickness;
static GtkWidget *comboStipple;
static gulong signalSpinWidthId, signalComboStippleId;

/* Callbacks */
static void onThicknessChanged(GtkSpinButton *spin, gpointer data);
static void onUseShade(GtkToggleButton *button, gpointer data);
static void onStippleChanged(StippleComboBox *combo, guint value, gpointer data);
static void onComboShadeChanged(GtkComboBox *combo, gpointer data);

void gtkPairsWireInit(void)
{
/*   g_signal_connect(VISU_INSTANCE, "resourcesLoaded", */
/* 		   G_CALLBACK(wireValuesChangedOnResources), (gpointer)0); */
}

GtkWidget* gtkPairsWireBuild_widgets()
{
  GtkWidget *hbox, *comboShade;
  GtkWidget *vbox, *checkNonLinear;
  GtkWidget *label;
  Shade *shade;
#if GTK_MAJOR_VERSION == 2 && GTK_MINOR_VERSION < 12
  GtkTooltips *tooltips;
  tooltips = gtk_tooltips_new ();
#endif

  DBG_fprintf(stderr, "Gtk Wire: building interface for wire pairs.\n");

  vbox = gtk_vbox_new(FALSE, 0);

  hbox = gtk_hbox_new(FALSE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

  label = gtk_label_new(_("Thickness:"));
  gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
  gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);
  spinThickness = gtk_spin_button_new_with_range(1, 10, 1);
  gtk_box_pack_start(GTK_BOX(hbox), spinThickness, FALSE, FALSE, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spinThickness), TRUE);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinThickness), wireGet_generalWidth());
  gtk_entry_set_width_chars(GTK_ENTRY(spinThickness), 3);
  label = gtk_label_new(_("Pattern:"));
  gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
  gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);
  comboStipple = stippleComboBox_new();
  gtk_box_pack_start(GTK_BOX(hbox), comboStipple, FALSE, FALSE, 0);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

  shade = wireGet_shade();
  comboShade = shadeComboBox_new(TRUE, FALSE);
  if(shade)
    shadeComboBoxSet_selectionByShade(SHADE_COMBOX(comboShade), shade);
  gtk_widget_set_sensitive(comboShade,(shade != (Shade*)0));
  gtk_box_pack_end(GTK_BOX(hbox), comboShade, FALSE, FALSE, 0);
  checkNonLinear = gtk_check_button_new_with_mnemonic
   (_("Color _varies with length:"));
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkNonLinear),
			      (shade != (Shade*)0));
  gtk_box_pack_end(GTK_BOX(hbox), checkNonLinear, FALSE, FALSE, 0);

  g_signal_connect(G_OBJECT(comboShade), "changed",
		   G_CALLBACK(onComboShadeChanged), (gpointer)checkNonLinear);
  signalSpinWidthId = g_signal_connect(G_OBJECT(spinThickness), "value-changed",
				       G_CALLBACK(onThicknessChanged), (gpointer)0);
  g_signal_connect(G_OBJECT(checkNonLinear), "toggled",
		   G_CALLBACK(onUseShade), (gpointer)comboShade);
  signalComboStippleId = g_signal_connect(G_OBJECT(comboStipple), "stipple-selected",
					  G_CALLBACK(onStippleChanged), (gpointer)0);

  return vbox;
}

gchar* gtkPairsWireGet_valuesAsLabel(VisuPairData *data)
{
  int width;
  guint16 stipple;
  gchar *str;

  width = wireGet_width(data);
  stipple = wireGet_stipple(data);

  /* px is for pixels and pat. for pattern. */
  str = g_strdup_printf("%s %2d%s, %s %d", _("wire:"),
                        width, _("px"), _("pat."), stipple);

  return str;
}

void gtkPairsWireSet_values(VisuPairData *data)
{
  int width;
  guint16 stipple;

  width = wireGet_width(data);
  g_signal_handler_block(G_OBJECT(spinThickness), signalSpinWidthId);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinThickness), width);
  g_signal_handler_unblock(G_OBJECT(spinThickness), signalSpinWidthId);

  stipple = wireGet_stipple(data);
  g_signal_handler_block(G_OBJECT(comboStipple), signalComboStippleId);
  if (!stippleComboBoxSet_selectionByStipple(STIPPLE_COMBOX(comboStipple), stipple))
    {
      stippleComboBoxAdd_pattern(STIPPLE_COMBOX(comboStipple), stipple);
      stippleComboBoxSet_selectionByStipple(STIPPLE_COMBOX(comboStipple), stipple);
    }
  g_signal_handler_unblock(G_OBJECT(comboStipple), signalComboStippleId);
}

static void onThicknessChanged(GtkSpinButton *spin, gpointer data _U_)
{
  int res;
  GtkPairsIter iter;
  gchar* label;

  res = FALSE;
  /* We run on all selected pairs. */
  for (gtkPairsIter_startSelected(&iter); iter.data;
       gtkPairsIter_nextSelected(&iter))
    {
      /* We change the value for this pair. */
      res = wireSet_width(iter.data, (float)gtk_spin_button_get_value(spin)) || res;
      label = gtkPairsWireGet_valuesAsLabel(iter.data);
      /* We change the drawn label. */
      gtkPairsSet_specificLabels(&(iter.iter), label);
      g_free(label);
    }

  if (res)
    gtkPairs_createPairs();
}
static void onStippleChanged(StippleComboBox *combo _U_, guint value,
			     gpointer data _U_)
{
  int res;
  GtkPairsIter iter;
  gchar* label;

  DBG_fprintf(stderr, "Gtk Wire: caught 'stipple-selected' signal.\n");
  res = FALSE;
  /* We run on all selected pairs. */
  for (gtkPairsIter_startSelected(&iter); iter.data;
       gtkPairsIter_nextSelected(&iter))
    {
      /* We change the value for this pair. */
      res = wireSet_stipple(iter.data, (guint16)value) || res;
      label = gtkPairsWireGet_valuesAsLabel(iter.data);
      /* We change the drawn label. */
      gtkPairsSet_specificLabels(&(iter.iter), label);
      g_free(label);
    }

  if (res)
    gtkPairs_createPairs();
}
static void setShade(ShadeComboBox *combo, GtkToggleButton *button)
{
  gboolean use;
  Shade *sh;

  use = gtk_toggle_button_get_active(button);
  gtk_widget_set_sensitive(GTK_WIDGET(combo), use);
  sh = (use)?shadeComboBoxGet_selectedShade(combo):(Shade*)0;
  if (wireSet_shade(sh))
    gtkPairs_createPairs();
}
static void onComboShadeChanged(GtkComboBox *combo, gpointer data)
{
  setShade(SHADE_COMBOX(combo), GTK_TOGGLE_BUTTON(data));
}

static void onUseShade(GtkToggleButton *button, gpointer data)
{
  setShade(SHADE_COMBOX(data), button);
}
