/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeur : Damien CALISTE,
	laboratoire L_Sim, (2001-2006)
  
	Adresse ml :
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Damien CALISTE,
	laboratoire L_Sim, (2001-2006)

	E-mail address:
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include "dumpThroughGdkPixbuf.h"
#include <visu_tools.h>

/**
 * SECTION:dumpThroughGdkPixbuf
 * @short_description: add an export capability into PNG and JPG files.
 *
 * This provides a write routine to export V_Sim views into PNG and JPG
 * files. It uses the GdkPixbuf to do it.
 */

static gpointer waitData;
static ToolVoidDataFunc waitFunc;

static gboolean writeViewInPngFormat(ToolFileFormat *format, const char* filename,
				     int width, int height, VisuData *dataObj,
				     guchar* imageData, GError **error,
				     ToolVoidDataFunc functionWait, gpointer data);
static gboolean writeViewInJpegFormat(ToolFileFormat *format, const char* filename,
				      int width, int height, VisuData *dataObj,
				      guchar* imageData, GError **error,
				      ToolVoidDataFunc functionWait, gpointer data);


VisuDump* dumpToPNG_init()
{
  VisuDump *png;
  char *typePng[] = {"*.png", (char*)0};
  ToolFileFormat* fmt;

  png = g_malloc(sizeof(VisuDump));
  fmt = tool_file_format_new(_("Png file"), typePng);
  if (!fmt)
    {
      g_error("Can't initialize the Png dump module, aborting.\n");
    }

  png->bitmap = TRUE;
  png->hasAlpha = TRUE;
  png->glRequired = TRUE;
  png->fileType = fmt;
  png->writeFunc = writeViewInPngFormat;
  
  waitFunc = (ToolVoidDataFunc)0;
  waitData = (gpointer)0;

  return png;
}

VisuDump* dumpToJPEG_init()
{
  VisuDump *jpeg;
  char *typeJpeg[] = {"*.jpg", "*.jpeg", (char*)0};
  ToolFileFormat* fmt;

  jpeg = g_malloc(sizeof(VisuDump));
  fmt = tool_file_format_new(_("Jpeg file"), typeJpeg);
  if (!fmt)
    {
      g_error("Can't initialize the Jpeg dump module, aborting.\n");
    }

  jpeg->bitmap = TRUE;
  jpeg->hasAlpha = FALSE;
  jpeg->glRequired = TRUE;
  jpeg->fileType = fmt;
  jpeg->writeFunc = writeViewInJpegFormat;

  tool_file_format_addPropertyInt(fmt, "quality",
                                  _("Compression ratio (given in percent)"), 85);
  
  waitFunc = (ToolVoidDataFunc)0;
  waitData = (gpointer)0;

  return jpeg;
}

static gboolean writeViewWithGdkPixbuf(ToolFileFormat *format, const char* filename,
				       int width, int height, char *type,
				       VisuData *dataObj _U_, guchar* imageData,
				       GError **error)
{
  unsigned char *image;
  GdkPixbuf *pixbuf;
  gboolean success, hasAlpha;
  const GList *prop;
  char **propName, **propValues;
  int nb, length;
  ToolFileFormatIter iter;

  g_return_val_if_fail(error && !*error, FALSE);
  g_return_val_if_fail(imageData, FALSE);

  image = imageData;

  DBG_fprintf(stderr, "Dump with GdkPixbuf : begin %s export in %dx%d : %s.\n",
	      type, width, height, filename);

  if (strcmp(type, "png"))
    {
      length = 3;
      hasAlpha = FALSE;
    }
  else
    {
      length = 4;
      hasAlpha = TRUE;
    }
  pixbuf = gdk_pixbuf_new_from_data((guchar*)imageData,
				    GDK_COLORSPACE_RGB,
				    hasAlpha,
				    8,
				    width,
				    height,
				    length * width,
				    NULL,
				    (gpointer)0);

  if (!pixbuf)
    {
      *error = g_error_new(VISU_ERROR_DUMP, DUMP_ERROR_FILE,
			   _("Cannot convert pixmap to pixbuf."));
      return FALSE;
    }
  
  prop = tool_file_format_getPropertyList(format);
  nb = g_list_length((GList*)prop) + 1;
  propName = g_malloc(sizeof(gchar*) * nb);
  propValues = g_malloc(sizeof(gchar*) * nb);
  nb = 0;
  iter.lst = (GList*)0;
  for (tool_file_format_iterNextProperty(format, &iter); iter.lst;
       tool_file_format_iterNextProperty(format, &iter))
    {
      propName[nb] = g_strdup(iter.name);
      propValues[nb] = g_strdup_value_contents(iter.val);
      nb += 1;
    }
  propName[nb] = (char*)0;
  propValues[nb] = (char*)0;
  success = gdk_pixbuf_savev(pixbuf, filename, type, propName, propValues, error);
  g_strfreev(propName);
  g_strfreev(propValues);
  gdk_pixbuf_unref(pixbuf);
  return success;
}

static gboolean writeViewInJpegFormat(ToolFileFormat *format, const char* filename,
				     int width, int height, VisuData *dataObj,
				     guchar* imageData, GError **error,
				     ToolVoidDataFunc functionWait, gpointer data)
{
  int i, res;

  res = writeViewWithGdkPixbuf(format, filename, width, height, "jpeg",
			       dataObj, imageData, error);

  /* Must call 100 times functionWait if exists before leaving... */
  if (functionWait)
    for (i = 0; i < 100; i++)
      functionWait(data);

  return res;
}

static gboolean writeViewInPngFormat(ToolFileFormat *format, const char* filename,
				     int width, int height, VisuData *dataObj,
				     guchar* imageData, GError **error,
				     ToolVoidDataFunc functionWait, gpointer data)
{
  int i, res;

  res = writeViewWithGdkPixbuf(format, filename, width, height, "png",
			       dataObj, imageData, error);

  /* Must call 100 times functionWait if exists before leaving... */
  if (functionWait)
    for (i = 0; i < 100; i++)
      functionWait(data);

  return res;
}
