/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef RENDERINGATOMIC_ASCII_H
#define RENDERINGATOMIC_ASCII_H

#include <visu_data.h>
#include <visu_tools.h>

#include "renderingAtomic.h"

/**
 * dataAscii:
 * @ele: a #VisuElement object ;
 * @pos: the number of the read element @ele ;
 * @nbNodes: number of nodes for this @ele.
 *
 * This structure is used when the file is parsed. Each time a node is successfully
 * read, its #VisuElement is compared to those already found. If none is found,
 * a new instance of this structure is created with @ele pointing to the #VisuElement,
 * @pos is the nth #visuElement found and @nbPos is initialized to one. If the read
 * #VisuElement has already been found, the @nbPos is increased by one.
 */
struct dataAscii
{
  VisuElement *ele;
  int pos;
  int nbNodes;
};

/**
 * freeDataAscii:
 * @data: a pointer to #stuct dataAscii instances.
 *
 * This method is used to free an allocated #stuct dataAscii, and can
 * be used as a destructor when creating an hashtable with such datas.
 */
void freeDataAscii(gpointer data);
/**
 * putValTypeInAsciiType:
 * @key: a #VisuElement pointer ;
 * @value: a #struct dataAscii pointer ;
 * @data: a pointer on array of pointers of #VisuElement.
 *
 * This method is used in a g_hash_table_foreach() method that work on @data.
 * @data is an array of pointers to #VisuElement and this method puts its
 * nth value to point to @key. The value nth is read from the @pos attribute of
 * the structure object pointed by @value.
 */
void putValTypeInAsciiType(gpointer key, gpointer value, gpointer data);
/**
 * putValNbInAsciiType:
 * @key: a #VisuElement pointer ;
 * @value: a #struct dataAscii pointer ;
 * @data: a pointer on array of int.
 *
 * This method is used in a g_hash_table_foreach() method that work on @data.
 * @data is an array of int and this method puts its
 * nth value to the value read from the @nbNodes attribute of
 * the structure object pointed by @value.
 */
void putValNbInAsciiType(gpointer key, gpointer value, gpointer data);


/**
 * atomicAsciiInit:
 *
 * Create the structure that gives access to a load method and
 * some description of it (file formats associated, name...).
 *
 * Returns: a loading method.
 */
RenderingFormatLoad* atomicAsciiInit();

#endif
