/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef GTK_COLORCOMBOBOXWIDGET_H
#define GTK_COLORCOMBOBOXWIDGET_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtk.h>

#include <coreTools/toolColor.h>

#include <openGLFunctions/light.h>

G_BEGIN_DECLS
/**
 * COLOR_COMBOX_TYPE
 *
 * Return the associated #GType to the ColorComboBox objects.
 *
 * Since: 3.1
 */
#define COLOR_COMBOX_TYPE         (colorComboBox_get_type ())
/**
 * COLOR_COMBOX:
 *
 * Cast the given object to a #ColorComboBox object.
 *
 * Since: 3.1
 */
#define COLOR_COMBOX(obj)         (G_TYPE_CHECK_INSTANCE_CAST ((obj), COLOR_COMBOX_TYPE, ColorComboBox))
/**
 * COLOR_COMBOX_CLASS
 *
 * Cast the given class to a #ColorComboBoxClass object.
 *
 * Since: 3.1
 */
#define COLOR_COMBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), COLOR_COMBOX_TYPE, ColorComboBoxClass))
/**
 * IS_COLOR_COMBOX
 *
 * Return if the given object is a valid #ColorComboBox object.
 *
 * Since: 3.1
 */
#define IS_COLOR_COMBOX(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), COLOR_COMBOX_TYPE))
/**
 * IS_COLOR_COMBOX_CLASS
 *
 * Return if the given class is a valid #ColorComboBoxClass class.
 *
 * Since: 3.1
 */
#define IS_COLOR_COMBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), COLOR_COMBOX_TYPE))

/**
 * ColorComboBox
 *
 * Private structure to store informations of a #ColorComboBox object.
 *
 * Since: 3.1
 */
typedef struct _ColorComboBox ColorComboBox;
/**
 * ColorComboBoxClass
 *
 * Private structure to store informations of a #ColorComboBoxClass object.
 *
 * Since: 3.1
 */
typedef struct _ColorComboBoxClass ColorComboBoxClass;

/**
 * colorComboBox_get_type
 *
 * #GType are unique numbers to identify objects.
 *
 * Returns: the #GType associated with #ColorComboBox objects.
 *
 * Since: 3.1
 */
GType colorComboBox_get_type(void);
/**
 * colorComboBox_new :
 * @hasAlphaChannel : a boolean.
 *
 * A #ColorComboBox widget is like a #GtkComboBox widget, but it is already filled
 * with the colors stores in the structures adhoc in visu_tools.h. Using this widget
 * is a convienient way to share colors between all part of V_Sim and to give a consistent
 * look of all color selection. If the argument @hasAlphaChannel is FALSE, the widget
 * display all colors but without their alpha channel, assuming it to be fully opaque.
 *
 * Returns: a newly created #ColorComboBox widget.
 *
 * Since: 3.1
 */
GtkWidget* colorComboBox_new(gboolean hasAlphaChannel);
/**
 * colorComboBox_newWithRanges :
 * @hasAlphaChannel : a boolean.
 *
 * Create a color combo and several ranges.
 *
 * Returns: a newly created #ColorComboBox widget.
 *
 * Since: 3.3
 */
GtkWidget* colorComboBox_newWithRanges(gboolean hasAlphaChannel);

/**
 * colorComboBoxSet_selectionByColor:
 * @colorComboBox: a #ColorComboBox widget ;
 * @color: a #Color object.
 *
 * Use this method to set the ComboBox on the given color. This emits a 'color-channel'
 * signal if the color is changed, which means, a previous color has been modified,
 * or a new color is selected.
 *
 * Returns: TRUE if the @color already exists in the model.
 *
 * Since: 3.1
 */
gboolean colorComboBoxSet_selectionByColor(ColorComboBox* colorComboBox, Color *color);
/**
 * colorComboBoxSet_color:
 * @colorComboBox: a #ColorComboBox widget ;
 * @rgba: 4 floating point values ;
 * @raiseSignal: if TRUE a material-value-changed can be raised.
 *
 * Change the values for the ranges that control the color. If the color exists
 * in the list, it is also selected.
 * This is possible only if the @colorComboBox has been created with
 * colorComboBox_newWithRanges().
 *
 * Since: 3.3
 */
void colorComboBoxSet_color(ColorComboBox *colorComboBox, float rgba[4],
			    gboolean raiseSignal);
/**
 * colorComboBoxSet_material:
 * @colorComboBox: a #ColorComboBox widget ;
 * @material: nb_material (see #Material) floating point values ;
 * @raiseSignal: if TRUE a material-value-changed can be raised.
 *
 * Change the values for the ranges that control the light (emission, diffuse...).
 * This is possible only if the @colorComboBox has been created with
 * colorComboBox_newWithRanges().
 *
 * Since: 3.3
 */
void colorComboBoxSet_material(ColorComboBox *colorComboBox, float material[nb_material],
			       gboolean raiseSignal);
/**
 * colorComboBoxGet_selectedPixbuf:
 * @colorComboBox: a #ColorComboBox widget.
 *
 * The @colorComboBox has little pixbufs to represent the color. User methods can
 * use these pixbufs but should considered them read-only.
 *
 * Returns: a pixbuf pointer corresponding to the little image shown on
 *          the @colorComboBox.
 *
 * Since: 3.1
 */
GdkPixbuf* colorComboBoxGet_selectedPixbuf(ColorComboBox *colorComboBox);
/**
 * colorComboBoxGet_selectedColor:
 * @colorComboBox: a #ColorComboBox widget.
 *
 * The user can access to the selected #Color object using this method.
 *
 * Returns: a pointer to the selected #Color object (or NULL). This object is read-only.
 *
 * Since: 3.1
 */
Color* colorComboBoxGet_selectedColor(ColorComboBox *colorComboBox);
/**
 * colorComboBoxGet_pixbufFromColor:
 * @colorComboBox: a #ColorComboBox widget ;
 * @color: a #Color object.
 *
 * The @colorComboBox has little pixbufs to represent the color. User methods can
 * use these pixbufs but should considered them read-only.
 *
 * Returns: a pixbuf pointer corresponding to the little image shown on
 *          the @colorComboBox.
 *
 * Since: 3.1
 */
GdkPixbuf* colorComboBoxGet_pixbufFromColor(ColorComboBox *colorComboBox, Color *color);
/**
 * colorComboBoxGet_material:
 * @colorComboBox: a #ColorComboBox widget.
 *
 * If the @colorComboBox uses ranges (see colorComboBox_newWithRanges()), this method
 * is used to get the values from the material ranges.
 *
 * Returns: a newly created array of size nb_material (see #Material). Use g_free()
 *          to delete it.
 *
 * Since: 3.3
 */
float* colorComboBoxGet_material(ColorComboBox *colorComboBox);
/**
 * colorComboBoxGet_color:
 * @colorComboBox: a #ColorComboBox widget.
 *
 * If the @colorComboBox uses ranges (see colorComboBox_newWithRanges()), this method
 * is used to get the values from the color ranges.
 *
 * Returns: a newly created array of size 4. Use g_free() to delete it.
 *
 * Since: 3.2
 */
float* colorComboBoxGet_color(ColorComboBox *colorComboBox);

/**
 * colorComboBoxBuild_colorStamp:
 * @color: a #Color object ;
 * @alpha: a boolean.
 *
 * This method is used by #ColorComboBox object to create little stamps
 * representing the color. If the pixbuf of such stamps are needed, use
 * colorComboBoxGet_pixbufFromColor() if the color is registered in an
 * already existing #ColorComboBox object or use this method to create
 * a new stamp.
 *
 * Returns: a pixbuf pointer corresponding to the little image as shown on
 *          a @colorComboBox (use g_object_unref() to free this pixbuf).
 *
 * Since: 3.1
 */
GdkPixbuf* colorComboBoxBuild_colorStamp(Color *color, gboolean alpha);
/**
 * colorComboBoxSet_expanded:
 * @colorComboBox: a #Color object ;
 * @value: a boolean value.
 *
 * Set the expanded state of the ranges. This is usable only if the colorComboBox
 * has been created with ranges.
 *
 * Since: 3.3
 */
void colorComboBoxSet_expanded(ColorComboBox *colorComboBox, gboolean value);
/**
 * colorComboBoxGet_rangesWidgets:
 * @colorComboBox: a #Color object.
 *
 * Retrieve the wiodget using to represent the ranges, or NULL if the object
 * has no ranges.
 *
 * Returns: a widget owned by @color.
 *
 * Since: 3.3
 */
GtkWidget* colorComboBoxGet_rangesWidgets(ColorComboBox *colorComboBox);
/**
 * colorComboBoxSet_printValues:
 * @colorComboBox: a #Color object ;
 * @value: a boolean.
 *
 * Print or not the RGB values.
 *
 * Since: 3.4
 */
void colorComboBoxSet_printValues(ColorComboBox *colorComboBox, gboolean value);

G_END_DECLS

#endif
