/**
 * UGENE - Integrated Bioinformatics Tools.
 * Copyright (C) 2008-2011 UniPro <ugene@unipro.ru>
 * http://ugene.unipro.ru
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifndef _U2_MSA_UTILS_H_
#define _U2_MSA_UTILS_H_

#include <U2Core/global.h>
#include <U2Core/DNASequence.h>

namespace U2 {

class GObject;
class MAlignment;
class MAlignmentRow;
class TaskStateInfo;
class U2OpStatus;

class U2CORE_EXPORT MSAUtils : public QObject {
    Q_OBJECT
public:

    static bool equalsIgnoreGaps(const MAlignmentRow& row, int startPos, const QByteArray& pattern);
    
    static MAlignment seq2ma(const QList<GObject*>& dnas, U2OpStatus& os);

    static QList<DNASequence> ma2seq(const MAlignment& ma, bool trimGaps);

    // Returns row index or -1 if name is not present
    static int getRowIndexByName(const MAlignment& ma, const QString& name);

    //checks that alignment is not empty and all packed sequence parts has equal length
    static bool checkPackedModelSymmetry(MAlignment& ali, TaskStateInfo& ti);
};


}//namespace

#endif
