//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Peter A. Buhr 1993
// 
// uBoundedBuffer.h -- Generic bounded buffer problem using a monitor and uAccept
// 
// Author           : Peter A. Buhr
// Created On       : Sun Apr  4 10:20:32 1993
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Nov 30 09:00:13 2005
// Update Count     : 15
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_BOUNDEDBUFFER_H__
#define __U_BOUNDEDBUFFER_H__


template<class ELEMTYPE> _Monitor uBoundedBuffer {
  protected:
    const int size;					// number of buffer elements
    int front, back;					// position of front and back of queue
    int count;						// number of used elements in the queue
    ELEMTYPE *Elements;
  public:
    uBoundedBuffer( const int size = 10 ) : size( size ) {
        front = back = count = 0;
        Elements = new ELEMTYPE[size];
    } // uBoundedBuffer::uBoundedBuffer

    ~uBoundedBuffer() {
        delete [] Elements;
    } // uBoundedBuffer::~uBoundedBuffer

    _Nomutex int query() {
        return count;
    } // uBoundedBuffer::query

    void insert( ELEMTYPE elem );
    ELEMTYPE remove();
}; // uBoundedBuffer

template<class ELEMTYPE> inline void uBoundedBuffer<ELEMTYPE>::insert( ELEMTYPE elem ) {
    if ( count == size ) {				// buffer full ?
        _Accept( remove );				// only allow removals
    } // if

    Elements[back] = elem;
    back = ( back + 1 ) % size;
    count += 1;
} // uBoundedBuffer::insert

template<class ELEMTYPE> inline ELEMTYPE uBoundedBuffer<ELEMTYPE>::remove() {
    ELEMTYPE elem;

    if ( count == 0 ) {					// buffer empty ?
        _Accept( insert );				// only allow insertions
    } // if

    elem = Elements[front];
    front = ( front + 1 ) % size;
    count -= 1;

    return elem;
} // uBoundedBuffer::remove


#endif // __U_BOUNDEDBUFFER_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
