//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef APPSTARTUP_H
#define APPSTARTUP_H
#include <string>
#include <QtGui/QMovie>
#include "AppStartUpData.h"

namespace tlp {
  struct TulipPluginLoader;
}

class AppStartUp : public QDialog, public Ui::AppStartUpData { 
  Q_OBJECT

  QMovie *movie;
  int totalSteps;
  int currentFrame;
  std::string errorMgs;

public:
  AppStartUp( QWidget* parent = 0);
  ~AppStartUp();
  void addErrorMsg(const std::string &errMsg);
  
public slots:
    ///Change the label in the widget
    void setLabel(std::string label);
    ///Change the progress bar.
    void setProgress(int);
    ///Change the total step of the progress bar.
    void setTotalSteps(int);
    void initTulip(tlp::TulipPluginLoader *loader,std::string& errors);
};

#endif // APPSTARTUP_H
