from gettext import gettext as _
import gobject
import gtk

class DurationChooser(gtk.VBox):
    __gsignals__ = {'duration-changed': (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, ())}

    def __init__(self, size_group):
        gtk.VBox.__init__(self, False, 6)
        
        self._hours_spin = self._add_row(_('_Hours:'), size_group, 48)
        self._minutes_spin = self._add_row(_('_Minutes:'), size_group, 59)
        self._seconds_spin = self._add_row(_('_Seconds:'), size_group, 59)
    
    def get_duration(self):
        """Return numerical representations of the values in the spinbuttons.
        
        This method does not just call get_value_as_int() on each spinbutton because
        get_value_as_int() does not return the most up-to-date value if the user is
        in the middle of editing the value in a spinbutton. Instead, it actually
        returns the value previously "confirmed" for the spinbutton (for example,
        by moving focus to another widget).
        
        Example: User starts with all spinboxes set to 0. He types 5 in 'Minutes' and
        immediately uses the keyboard to activate the 'Save as Preset' button. Because
        the user never moved focus out of the spinbutton, get_value_as_int() will report
        the previous value of 0, and the saved preset will not have the expected duration
        of 5 minutes.
        
        If a particular spinbutton is empty or contains a non-integer value, then this method
        will report its value as zero.
        
        Returns a tuple in this format: (hours, minutes, seconds)
        
        """
        hours_str = self._hours_spin.props.text
        minutes_str = self._minutes_spin.props.text
        seconds_str = self._seconds_spin.props.text
        hours = 0
        minutes = 0
        seconds = 0
        try:
            if (len(hours_str) > 0):
                hours = int(hours_str)
            if (len(minutes_str) > 0):
                minutes = int(minutes_str)
            if (len(seconds_str) > 0):
                seconds = int(seconds_str)
        except:
            pass
            
        return (hours, minutes, seconds)
    
    def set_duration(self, hours, minutes, seconds):
        self._hours_spin.set_value(hours)
        self._minutes_spin.set_value(minutes)
        self._seconds_spin.set_value(seconds)
        
    def clear(self):
        self._hours_spin.set_value(0)
        self._minutes_spin.set_value(0)
        self._seconds_spin.set_value(0)
        
    def focus_hours(self):
        self._hours_spin.grab_focus()
        
    def _add_row(self, row_label_str, size_group, max_spin_val):
        row_hbox = gtk.HBox(False, 6)
        
        label = gtk.Label(row_label_str)
        label.set_property('xalign', 0.0)
        label.set_property('use-underline', True)
        size_group.add_widget(label)
        
        spin_adj = gtk.Adjustment(0, 0, max_spin_val, 1, 1, 1)
        spin_button = gtk.SpinButton(spin_adj, 1.0, 0)
        spin_button.props.activates_default = True
        spin_button.props.numeric = True
        
        label.set_mnemonic_widget(spin_button)
        
        row_hbox.pack_start(label, False, False, 0)
        row_hbox.pack_start(spin_button, True, True, 0)
        self.pack_start(row_hbox, False, False, 0)
        
        spin_button.connect('changed', self._on_spin_button_val_changed)
        
        label.show()
        spin_button.show()
        row_hbox.show()
        
        return spin_button
        
    def _on_spin_button_val_changed(self, spin_button):
        self.emit('duration-changed')


