/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * page-contacts.h:
 * A GtkNotebook page exposing
 * org.freedesktop.Telepathy.Connection.Interface.Contacts
 * functionality.
 *
 * Copyright (C) 2008 Collabora Ltd. <http://www.collabora.co.uk/>
 * Copyright (C) 2008 Nokia Corporation
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Originally by Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_PAGE_CONTACTS_H__
#define __TI_PAGE_CONTACTS_H__

#include <gtk/gtk.h>
#include <glib-object.h>
#include <telepathy-glib/connection.h>

#include "page.h"
#include "handle-mapper.h"

/*
 * Type macros.
 */

typedef struct _TIPageContacts TIPageContacts;
typedef struct _TIPageContactsClass TIPageContactsClass;

#define TI_TYPE_PAGE_CONTACTS               ti_page_contacts_get_type()
#define TI_PAGE_CONTACTS(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_PAGE_CONTACTS, TIPageContacts))
#define TI_PAGE_CONTACTS_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_PAGE_CONTACTS, TIPageContactsClass))
#define TI_IS_PAGE_CONTACTS(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_PAGE_CONTACTS))
#define TI_IS_PAGE_CONTACTS_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_PAGE_CONTACTS))
#define TI_PAGE_CONTACTS_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_PAGE_CONTACTS, TIPageContactsClass))

struct _TIPageContacts {
    TIPage parent;
};

GType ti_page_presence_get_type (void);

TIPageContacts *ti_page_contacts_new (GtkWindow *parent_wnd,
    GtkNotebook *parent_notebook, TpConnection *connection,
    TIHandleMapper *handle_mapper);

#endif
