/* gnome-ask-password-agent.c generated by valac 0.11.7, the Vala compiler
 * generated from gnome-ask-password-agent.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <time.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <stdio.h>
#include <libnotify/notify.h>
#include <gio/gunixoutputstream.h>


#define TYPE_PASSWORD_DIALOG (password_dialog_get_type ())
#define PASSWORD_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PASSWORD_DIALOG, PasswordDialog))
#define PASSWORD_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PASSWORD_DIALOG, PasswordDialogClass))
#define IS_PASSWORD_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PASSWORD_DIALOG))
#define IS_PASSWORD_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PASSWORD_DIALOG))
#define PASSWORD_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PASSWORD_DIALOG, PasswordDialogClass))

typedef struct _PasswordDialog PasswordDialog;
typedef struct _PasswordDialogClass PasswordDialogClass;
typedef struct _PasswordDialogPrivate PasswordDialogPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MY_STATUS_ICON (my_status_icon_get_type ())
#define MY_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MY_STATUS_ICON, MyStatusIcon))
#define MY_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MY_STATUS_ICON, MyStatusIconClass))
#define IS_MY_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MY_STATUS_ICON))
#define IS_MY_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MY_STATUS_ICON))
#define MY_STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MY_STATUS_ICON, MyStatusIconClass))

typedef struct _MyStatusIcon MyStatusIcon;
typedef struct _MyStatusIconClass MyStatusIconClass;
typedef struct _MyStatusIconPrivate MyStatusIconPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))

struct _PasswordDialog {
	GtkDialog parent_instance;
	PasswordDialogPrivate * priv;
	GtkEntry* entry;
};

struct _PasswordDialogClass {
	GtkDialogClass parent_class;
};

struct _MyStatusIcon {
	GtkStatusIcon parent_instance;
	MyStatusIconPrivate * priv;
};

struct _MyStatusIconClass {
	GtkStatusIconClass parent_class;
};

struct _MyStatusIconPrivate {
	GFile* directory;
	GFile* current;
	GFileMonitor* file_monitor;
	gchar* message;
	gchar* icon;
	gchar* socket;
	PasswordDialog* password_dialog;
};


static gpointer password_dialog_parent_class = NULL;
static gpointer my_status_icon_parent_class = NULL;

gint clock_gettime (gint id, struct timespec* ts);
GType password_dialog_get_type (void) G_GNUC_CONST;
enum  {
	PASSWORD_DIALOG_DUMMY_PROPERTY
};
PasswordDialog* password_dialog_new (const gchar* message, const gchar* icon);
PasswordDialog* password_dialog_construct (GType object_type, const gchar* message, const gchar* icon);
void password_dialog_on_entry_activated (PasswordDialog* self);
static void _password_dialog_on_entry_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void password_dialog_finalize (GObject* obj);
GType my_status_icon_get_type (void) G_GNUC_CONST;
#define MY_STATUS_ICON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MY_STATUS_ICON, MyStatusIconPrivate))
enum  {
	MY_STATUS_ICON_DUMMY_PROPERTY
};
MyStatusIcon* my_status_icon_new (GError** error);
MyStatusIcon* my_status_icon_construct (GType object_type, GError** error);
static void my_status_icon_file_monitor_changed (MyStatusIcon* self, GFile* file, GFile* other_file, GFileMonitorEvent event_type);
static void _my_status_icon_file_monitor_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void my_status_icon_look_for_password (MyStatusIcon* self, GError** error);
static void my_status_icon_status_icon_activate (MyStatusIcon* self);
static void _my_status_icon_status_icon_activate_gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self);
void show_error (const gchar* e);
static gboolean my_status_icon_load_password (MyStatusIcon* self, GError** error);
static void my_status_icon_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const GOptionEntry entries[1] = {{NULL}};

/***
  This file is part of systemd.

  Copyright 2010 Lennart Poettering

  systemd is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  systemd is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with systemd; If not, see <http://www.gnu.org/licenses/>.
***/
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _password_dialog_on_entry_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	password_dialog_on_entry_activated (self);
}


PasswordDialog* password_dialog_construct (GType object_type, const gchar* message, const gchar* icon) {
	PasswordDialog * self = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkContainer* _tmp1_;
	GtkContainer* content;
	GtkHBox* _tmp2_ = NULL;
	GtkBox* hbox;
	GtkImage* _tmp3_ = NULL;
	GtkImage* image;
	GtkVBox* _tmp4_ = NULL;
	GtkBox* vbox;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* label;
	GtkEntry* _tmp6_ = NULL;
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (icon != NULL, NULL);
	self = (PasswordDialog*) g_object_new (object_type, NULL);
	gtk_window_set_title ((GtkWindow*) self, "System Password");
	gtk_dialog_set_has_separator ((GtkDialog*) self, FALSE);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 8);
	gtk_dialog_set_default_response ((GtkDialog*) self, (gint) GTK_RESPONSE_OK);
	gtk_window_set_icon_name ((GtkWindow*) self, icon);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_OK, (gint) GTK_RESPONSE_OK);
	_tmp0_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp1_ = _g_object_ref0 (GTK_CONTAINER (_tmp0_));
	content = _tmp1_;
	_tmp2_ = (GtkHBox*) gtk_hbox_new (FALSE, 16);
	hbox = (GtkBox*) g_object_ref_sink (_tmp2_);
	gtk_container_set_border_width ((GtkContainer*) hbox, (guint) 8);
	gtk_container_add (content, (GtkWidget*) hbox);
	_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name (icon, GTK_ICON_SIZE_DIALOG);
	image = g_object_ref_sink (_tmp3_);
	gtk_box_pack_start (hbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	_tmp4_ = (GtkVBox*) gtk_vbox_new (FALSE, 8);
	vbox = (GtkBox*) g_object_ref_sink (_tmp4_);
	gtk_box_pack_start (hbox, (GtkWidget*) vbox, TRUE, TRUE, (guint) 0);
	_tmp5_ = (GtkLabel*) gtk_label_new (message);
	label = g_object_ref_sink (_tmp5_);
	gtk_box_pack_start (vbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	_tmp6_ = (GtkEntry*) gtk_entry_new ();
	_g_object_unref0 (self->entry);
	self->entry = g_object_ref_sink (_tmp6_);
	gtk_entry_set_visibility (self->entry, FALSE);
	gtk_entry_set_activates_default (self->entry, TRUE);
	gtk_box_pack_start (vbox, (GtkWidget*) self->entry, FALSE, FALSE, (guint) 0);
	g_signal_connect_object (self->entry, "activate", (GCallback) _password_dialog_on_entry_activated_gtk_entry_activate, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (label);
	_g_object_unref0 (vbox);
	_g_object_unref0 (image);
	_g_object_unref0 (hbox);
	_g_object_unref0 (content);
	return self;
}


PasswordDialog* password_dialog_new (const gchar* message, const gchar* icon) {
	return password_dialog_construct (TYPE_PASSWORD_DIALOG, message, icon);
}


void password_dialog_on_entry_activated (PasswordDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_dialog_response ((GtkDialog*) self, (gint) GTK_RESPONSE_OK);
}


static void password_dialog_class_init (PasswordDialogClass * klass) {
	password_dialog_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = password_dialog_finalize;
}


static void password_dialog_instance_init (PasswordDialog * self) {
}


static void password_dialog_finalize (GObject* obj) {
	PasswordDialog * self;
	self = PASSWORD_DIALOG (obj);
	_g_object_unref0 (self->entry);
	G_OBJECT_CLASS (password_dialog_parent_class)->finalize (obj);
}


GType password_dialog_get_type (void) {
	static volatile gsize password_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&password_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasswordDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) password_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasswordDialog), 0, (GInstanceInitFunc) password_dialog_instance_init, NULL };
		GType password_dialog_type_id;
		password_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "PasswordDialog", &g_define_type_info, 0);
		g_once_init_leave (&password_dialog_type_id__volatile, password_dialog_type_id);
	}
	return password_dialog_type_id__volatile;
}


static void _my_status_icon_file_monitor_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	my_status_icon_file_monitor_changed (self, file, other_file, event_type);
}


static void _my_status_icon_status_icon_activate_gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self) {
	my_status_icon_status_icon_activate (self);
}


MyStatusIcon* my_status_icon_construct (GType object_type, GError** error) {
	MyStatusIcon * self = NULL;
	GFile* _tmp0_ = NULL;
	GFileMonitor* _tmp1_ = NULL;
	GFileMonitor* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (MyStatusIcon*) g_object_new (object_type, "icon-name", "dialog-password", NULL);
	gtk_status_icon_set_title ((GtkStatusIcon*) self, "System Password Request");
	_tmp0_ = g_file_new_for_path ("/run/systemd/ask-password/");
	_g_object_unref0 (self->priv->directory);
	self->priv->directory = _tmp0_;
	_tmp1_ = g_file_monitor_directory (self->priv->directory, 0, NULL, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (self->priv->file_monitor);
	self->priv->file_monitor = _tmp2_;
	g_signal_connect_object (self->priv->file_monitor, "changed", (GCallback) _my_status_icon_file_monitor_changed_g_file_monitor_changed, self, 0);
	_g_object_unref0 (self->priv->current);
	self->priv->current = NULL;
	my_status_icon_look_for_password (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	g_signal_connect_object ((GtkStatusIcon*) self, "activate", (GCallback) _my_status_icon_status_icon_activate_gtk_status_icon_activate, self, 0);
	return self;
}


MyStatusIcon* my_status_icon_new (GError** error) {
	return my_status_icon_construct (TYPE_MY_STATUS_ICON, error);
}


static void my_status_icon_file_monitor_changed (MyStatusIcon* self, GFile* file, GFile* other_file, GFileMonitorEvent event_type) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_basename (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_str_has_prefix (_tmp1_, "ask.");
	_tmp3_ = !_tmp2_;
	_g_free0 (_tmp1_);
	if (_tmp3_) {
		return;
	}
	if (event_type == G_FILE_MONITOR_EVENT_CREATED) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = event_type == G_FILE_MONITOR_EVENT_DELETED;
	}
	if (_tmp4_) {
		my_status_icon_look_for_password (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			show_error (e->message);
			_g_error_free0 (e);
		}
		__finally0:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void my_status_icon_look_for_password (MyStatusIcon* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->current != NULL) {
		gboolean _tmp0_;
		_tmp0_ = g_file_query_exists (self->priv->current, NULL);
		if (!_tmp0_) {
			_g_object_unref0 (self->priv->current);
			self->priv->current = NULL;
			if (self->priv->password_dialog != NULL) {
				gtk_dialog_response ((GtkDialog*) self->priv->password_dialog, (gint) GTK_RESPONSE_REJECT);
			}
		}
	}
	if (self->priv->current == NULL) {
		GFileEnumerator* _tmp1_ = NULL;
		GFileEnumerator* enumerator;
		GFileInfo* i = NULL;
		_tmp1_ = g_file_enumerate_children (self->priv->directory, "standard::name", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
		enumerator = _tmp1_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		while (TRUE) {
			GFileInfo* _tmp2_ = NULL;
			GFileInfo* _tmp3_;
			const gchar* _tmp4_ = NULL;
			gboolean _tmp5_;
			const gchar* _tmp6_ = NULL;
			GFile* _tmp7_ = NULL;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp2_ = g_file_enumerator_next_file (enumerator, NULL, &_inner_error_);
			_tmp3_ = _tmp2_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (i);
				_g_object_unref0 (enumerator);
				return;
			}
			_g_object_unref0 (i);
			i = _tmp3_;
			if (!(i != NULL)) {
				break;
			}
			_tmp4_ = g_file_info_get_name (i);
			_tmp5_ = g_str_has_prefix (_tmp4_, "ask.");
			if (!_tmp5_) {
				continue;
			}
			_tmp6_ = g_file_info_get_name (i);
			_tmp7_ = g_file_get_child (self->priv->directory, _tmp6_);
			_g_object_unref0 (self->priv->current);
			self->priv->current = _tmp7_;
			_tmp8_ = my_status_icon_load_password (self, &_inner_error_);
			_tmp9_ = _tmp8_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (i);
				_g_object_unref0 (enumerator);
				return;
			}
			if (_tmp9_) {
				break;
			}
			_g_object_unref0 (self->priv->current);
			self->priv->current = NULL;
		}
		_g_object_unref0 (i);
		_g_object_unref0 (enumerator);
	}
	if (self->priv->current == NULL) {
		gtk_status_icon_set_visible ((GtkStatusIcon*) self, FALSE);
	}
}


static gboolean my_status_icon_load_password (MyStatusIcon* self, GError** error) {
	gboolean result = FALSE;
	GKeyFile* _tmp0_ = NULL;
	GKeyFile* key_file;
	struct timespec ts = {0};
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* not_after_as_string;
	struct timespec _tmp4_ = {0};
	guint64 now;
	guint64 not_after = 0ULL;
	gint _tmp5_;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	const gchar* _tmp17_ = NULL;
	NotifyNotification* _tmp18_ = NULL;
	NotifyNotification* n;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_key_file_new ();
	key_file = _tmp0_;
	_tmp1_ = g_file_get_path (self->priv->current);
	_tmp2_ = _tmp1_;
	g_key_file_load_from_file (key_file, _tmp2_, G_KEY_FILE_NONE, &_inner_error_);
	_g_free0 (_tmp2_);
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	_tmp3_ = g_key_file_get_string (key_file, "Ask", "NotAfter", &_inner_error_);
	not_after_as_string = _tmp3_;
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	clock_gettime (1, &_tmp4_);
	ts = _tmp4_;
	now = (guint64) ((ts.tv_sec * 1000000) + (ts.tv_nsec / 1000));
	_tmp5_ = sscanf (not_after_as_string, "%llu", &not_after);
	if (_tmp5_ != 1) {
		result = FALSE;
		_g_free0 (not_after_as_string);
		_g_key_file_free0 (key_file);
		return result;
	}
	if (not_after > 0) {
		_tmp6_ = not_after < now;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		result = FALSE;
		_g_free0 (not_after_as_string);
		_g_key_file_free0 (key_file);
		return result;
	}
	_tmp7_ = g_key_file_get_string (key_file, "Ask", "Socket", &_inner_error_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		_g_free0 (not_after_as_string);
		goto __catch1_g_error;
	}
	_g_free0 (self->priv->socket);
	self->priv->socket = _tmp8_;
	_g_free0 (not_after_as_string);
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		_g_key_file_free0 (key_file);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_key_file_free0 (key_file);
		return FALSE;
	}
	_tmp9_ = g_key_file_get_string (key_file, "Ask", "Message", &_inner_error_);
	_tmp10_ = _tmp9_;
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strcompress (_tmp11_);
	_g_free0 (self->priv->message);
	self->priv->message = _tmp12_;
	_g_free0 (_tmp11_);
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = g_strdup ("Please Enter System Password!");
		_g_free0 (self->priv->message);
		self->priv->message = _tmp13_;
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_key_file_free0 (key_file);
		return FALSE;
	}
	gtk_status_icon_set_tooltip_text ((GtkStatusIcon*) self, self->priv->message);
	_tmp14_ = g_key_file_get_string (key_file, "Ask", "Icon", &_inner_error_);
	_tmp15_ = _tmp14_;
	if (_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	_g_free0 (self->priv->icon);
	self->priv->icon = _tmp15_;
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		gchar* _tmp16_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = g_strdup ("dialog-password");
		_g_free0 (self->priv->icon);
		self->priv->icon = _tmp16_;
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_key_file_free0 (key_file);
		return FALSE;
	}
	gtk_status_icon_set_from_icon_name ((GtkStatusIcon*) self, self->priv->icon);
	gtk_status_icon_set_visible ((GtkStatusIcon*) self, TRUE);
	_tmp17_ = gtk_status_icon_get_title ((GtkStatusIcon*) self);
	_tmp18_ = notify_notification_new (_tmp17_, self->priv->message, self->priv->icon);
	n = _tmp18_;
	notify_notification_set_timeout (n, 5000);
	notify_notification_show (n, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (n);
		_g_key_file_free0 (key_file);
		return FALSE;
	}
	result = TRUE;
	_g_object_unref0 (n);
	_g_key_file_free0 (key_file);
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	guint8* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = -1;
	_tmp0_ = strlen (self);
	res_length1 = (gint) _tmp0_;
	_tmp1_ = res;
	*result_length1 = res_length1;
	result = _tmp1_;
	return result;
}


static void my_status_icon_status_icon_activate (MyStatusIcon* self) {
	PasswordDialog* _tmp0_ = NULL;
	gint _tmp1_;
	gint _result_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* password;
	gboolean _tmp4_ = FALSE;
	gint to_process = 0;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gint _tmp12_;
	GUnixOutputStream* _tmp13_ = NULL;
	GOutputStream* stream;
	guint8* _tmp14_ = NULL;
	gint _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->current == NULL) {
		return;
	}
	if (self->priv->password_dialog != NULL) {
		gtk_window_present ((GtkWindow*) self->priv->password_dialog);
		return;
	}
	_tmp0_ = password_dialog_new (self->priv->message, self->priv->icon);
	_g_object_unref0 (self->priv->password_dialog);
	self->priv->password_dialog = g_object_ref_sink (_tmp0_);
	_tmp1_ = gtk_dialog_run ((GtkDialog*) self->priv->password_dialog);
	_result_ = _tmp1_;
	_tmp2_ = gtk_entry_get_text (self->priv->password_dialog->entry);
	_tmp3_ = g_strdup (_tmp2_);
	password = _tmp3_;
	gtk_object_destroy ((GtkObject*) self->priv->password_dialog);
	_g_object_unref0 (self->priv->password_dialog);
	self->priv->password_dialog = NULL;
	if (_result_ == GTK_RESPONSE_REJECT) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = _result_ == GTK_RESPONSE_DELETE_EVENT;
	}
	if (_tmp4_) {
		_g_free0 (password);
		return;
	}
	if (_result_ == GTK_RESPONSE_OK) {
		_tmp5_ = "1";
	} else {
		_tmp5_ = "0";
	}
	_tmp6_ = g_strdup ("/usr/bin/pkexec");
	_tmp7_ = g_strdup ("/lib/systemd/systemd-reply-password");
	_tmp8_ = g_strdup (_tmp5_);
	_tmp9_ = g_strdup (self->priv->socket);
	_tmp10_ = g_new0 (gchar*, 4 + 1);
	_tmp10_[0] = _tmp6_;
	_tmp10_[1] = _tmp7_;
	_tmp10_[2] = _tmp8_;
	_tmp10_[3] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 4;
	g_spawn_async_with_pipes (NULL, _tmp11_, NULL, 0, NULL, NULL, NULL, &_tmp12_, NULL, NULL, &_inner_error_);
	to_process = _tmp12_;
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	if (_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	_tmp13_ = (GUnixOutputStream*) g_unix_output_stream_new (to_process, TRUE);
	stream = (GOutputStream*) _tmp13_;
	_tmp14_ = string_get_data (password, &_tmp15_);
	g_output_stream_write (stream, _tmp14_, (gsize) _tmp15_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (stream);
		goto __catch4_g_error;
	}
	_g_object_unref0 (stream);
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		show_error (e->message);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (password);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (password);
}


static void my_status_icon_class_init (MyStatusIconClass * klass) {
	my_status_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MyStatusIconPrivate));
	G_OBJECT_CLASS (klass)->finalize = my_status_icon_finalize;
}


static void my_status_icon_instance_init (MyStatusIcon * self) {
	self->priv = MY_STATUS_ICON_GET_PRIVATE (self);
}


static void my_status_icon_finalize (GObject* obj) {
	MyStatusIcon * self;
	self = MY_STATUS_ICON (obj);
	_g_object_unref0 (self->priv->directory);
	_g_object_unref0 (self->priv->current);
	_g_object_unref0 (self->priv->file_monitor);
	_g_free0 (self->priv->message);
	_g_free0 (self->priv->icon);
	_g_free0 (self->priv->socket);
	_g_object_unref0 (self->priv->password_dialog);
	G_OBJECT_CLASS (my_status_icon_parent_class)->finalize (obj);
}


GType my_status_icon_get_type (void) {
	static volatile gsize my_status_icon_type_id__volatile = 0;
	if (g_once_init_enter (&my_status_icon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MyStatusIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) my_status_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MyStatusIcon), 0, (GInstanceInitFunc) my_status_icon_instance_init, NULL };
		GType my_status_icon_type_id;
		my_status_icon_type_id = g_type_register_static (GTK_TYPE_STATUS_ICON, "MyStatusIcon", &g_define_type_info, 0);
		g_once_init_leave (&my_status_icon_type_id__volatile, my_status_icon_type_id);
	}
	return my_status_icon_type_id__volatile;
}


void show_error (const gchar* e) {
	GtkMessageDialog* _tmp0_ = NULL;
	GtkMessageDialog* m;
	g_return_if_fail (e != NULL);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", e);
	m = g_object_ref_sink (_tmp0_);
	gtk_dialog_run ((GtkDialog*) m);
	gtk_object_destroy ((GtkObject*) m);
	_g_object_unref0 (m);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	MyStatusIcon* _tmp0_ = NULL;
	MyStatusIcon* i;
	GError * _inner_error_ = NULL;
	gtk_init_with_args (&args_length1, &args, "[OPTION...]", entries, "systemd-ask-password-agent", &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch5_g_error;
	}
	notify_init ("Password Agent");
	_tmp0_ = my_status_icon_new (&_inner_error_);
	i = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch5_g_error;
	}
	gtk_main ();
	_g_object_unref0 (i);
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		show_error (e->message);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



