C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=XMPRIO,SSI=0
                        SUBROUTINE XMPRIO
C                       *****************
C
C      ---------------------------------------------------------
     * (NPOINS,NELEMS,NELEPR,NDMATS,
     *  NODES,NODEPR,NPRIOS,NBPRIO,NBCOPR,NREFS,NTRAV)
C      ---------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            EXTRACTION DU MAILLAGE DE PEAU DU MAILLAGE ELEMENTS FINIS *
C            (On ne prend en compte que les noeuds couples)            *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NPOINS   !  E ! D  ! Nombre de noeuds du maillage solide          !
C !  NELEMS   !  E ! D  ! Nombre d'elements du maillage solide         !
C !  NELEPR   !  E ! D  ! Nombre d'elts volumiques avec periodicite    !
C !  NDMATS   !  E ! D  ! Nombre de noeuds par element volumique       !
C !  NODES    ! TE ! D  ! Connectivite maillage volumique solide       !
C !  NODEPR   ! TE ! D  ! Connectivite maillage volumique periodique   !
C !  NPRIOS   ! TE ! D  ! Numeros des noeuds periodiques               |
C !  NBPRIO   !  E ! D  ! Nombre de noeuds periodiques                 |
C !  NBCOPR   !  E ! D  ! Nbre de correspondants pour les noeuds period!
C !  NREFS    ! TE ! D  ! Reference des noeuds du maillage vol. solide |
C !  NTRAV    ! TE ! A  ! Tableau de travail                           |
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : INISOL
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "xrefer.h"
#include "nlofes.h"
#include "optct.h"
C
C***********************************************************************
      INTEGER NDX
      PARAMETER (NDX=10)
C
C.. Variables externes
      INTEGER NELEMS,NDMATS,NPOINS,NELEPR,NBPRIO,NBCOPR
      INTEGER NODES(NELEMS,NDMATS),NREFS(NPOINS)
      INTEGER NODEPR(NELEPR,NDMATS+1)
      INTEGER NPRIOS(NBPRIO,1+NBCOPR),NTRAV(NPOINS)
C
C.. Variables internes
      INTEGER N,M,I,J,L,NR(NDX),NLPR
      LOGICAL LPERIO
C
C***********************************************************************
C
C
C     0- INITIALISATIONS
C     ==================
C
      NLPR = 0
C
      DO 1 N=1,NPOINS
       NTRAV(N) = 0
    1 CONTINUE
C
      DO 2 N=1,NBPRIO
        NTRAV(NPRIOS(N,1)) = N
    2 CONTINUE
C
C
C     1- REPERAGE ET STOCKAGE DES ELEMENTS PERIODIQUES
C     ================================================
C
      DO 100 N=1,NELEMS
C 
        LPERIO = .FALSE.
C
        DO 10 M=1,NDMATS
          NR(M) = NREFS( NODES(N,M))
   10   CONTINUE 
C
        DO 110 M=1,NRFMAX
         DO 111 L=1,NDMATS
          IF ( IREFPR(M).NE.0 .AND. NR(L).EQ.M ) LPERIO = .TRUE.
  111    CONTINUE
  110   CONTINUE
C
        IF (LPERIO) THEN
C
          NLPR = NLPR + 1
          DO 120 M=1,NDMATS
            NODEPR(NLPR,M) = NTRAV(NODES(N,M))
  120     CONTINUE
C
          NODEPR(NLPR,NDMATS+1) = N
C
        ENDIF
C
C
C
  100 CONTINUE
C
C
C     2- CONTROLE DES DEBORDEMENTS DE TABLEAU
C     =======================================
C
      IF (NLPR.GT.NELEPR) THEN
         WRITE(NFECRA,2000) NELEPR,NLPR
         STOP
      ENDIF
C
C     3- IMPREPRION SUR LISTING
C     =========================
C
      IF (NBLBLA.GT.0) WRITE(NFECRA,3000) NELEPR
C 
C
C     4- VERIFICATION DU MAILLAGE LU
C     ==============================
C
      IF (NBLBLA.EQ.10) THEN
C
        WRITE(NFECRA,4000)
        DO 400 I=1,NELEPR
          WRITE(NFECRA,4010) I ,(NODEPR(I,J),J=1,NDMATS)
 400    CONTINUE
C
      ENDIF  
C
C--------
C FORMATS
C--------
 2000 FORMAT(/,' %% ERREUR XMPRIO : LA DIMENSION DU TABLEAU DES ',
     &           'ELEMENTS DE PERIODIQUES (NELEPR) EST INSUFFISANTE',/,
     &         '                    IL VAUT     : ',I9,/,
     &         '                    IL FAUDRAIT : ',I9)
 3000 FORMAT(//,' *** XMPRIO : NOMBRE D''ELEMENTS PERIODIQUES : ',I9)
 4000 FORMAT(/,'  *** XMPRIO : VERIFICATION DU MAILLAGE SOLIDE',
     &         ' DES ELEMENTS PERIODIQUES',/,
     &         '              Table des elements : '/)
 4010 FORMAT(  '              Element ',I9,'  Noeuds : ',6I9)
C
      END
