C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE REGUSY
C                       *****************
C
C      ----------------------------------------------------------
     * (NDIM,NPOINS,COORDS,NREFS,NREFE,NELEMS,NODES,NDMATS,
     *  TMPSA,TMPS,NBFLVS,NPFEL,NFLUVS,VFLUVS,
     *  PHYSOL,NPOUE,NPPEL,NBPHYS)
C      ----------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            (Sous-programme utilisateur pour une regulation thermique * 
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  COORDS   ! TE ! D  ! COORDONNEES DES NOEUDS DU MAILLAGE SOLIDE    !
C !  NREFS    ! TE ! D  ! REFERENCES DES NOEUDS SOLIDES                !
C !  TMPSA    ! TR ! D  ! TEMPERATURE DANS LE SOLIDE A L'ETAPE N       !
C !  NBFLVS   !  E ! D  ! NOMBRE DE NOEUDS AVEC FLUX VOL               !
C !  NFLUVS   ! TE ! D  ! NUMEROS GLOBAUX DES NOEUDS AVEC FLUX VOL     !
C !  VFLUVS   ! TR ! R  ! VALEUR DU FLUX VOLUMIQUE EN CES NOEUDS       !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /OPTCT/   !    ! D  !                                              !
C ! /TEMPS/   !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "divct.h"
#include "syrthu.h"
#include "regul.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NBPHYS,NPOUE,NPPEL
      INTEGER NDIM,NPOINS,NBFLVS,NPFEL,NELEMS,NDMATS
      INTEGER NREFS(NPOINS),NFLUVS(NBFLVS),NREFE(NELEMS)
      INTEGER NODES(NELEMS,NDMATS)
      DOUBLE PRECISION  COORDS(NPOINS,NDIM),TMPSA(NPOINS),TMPS(NPOINS)
      DOUBLE PRECISION  VFLUVS(NBFLVS,NPFEL)
      DOUBLE PRECISION  PHYSOL(NPOUE,NPPEL,NBPHYS)
C
C.. Variables internes
      INTEGER I,N,NUMREF,NUMEL
      DOUBLE PRECISION  T
      LOGICAL OK
C
      DOUBLE PRECISION PERIOR,FLUVOL
      DOUBLE PRECISION ER,UC,UIC,UDC,UPC,VER
C
      INTEGER MATER,NEMPRE
      DOUBLE PRECISION DTAIR,DTSABL,TINI,TDEB
      SAVE VER
      SAVE UDC
      SAVE UIC
C
      SAVE MATER
      SAVE TDEB
C    
      DATA MATER /1/
      DATA TDEB /0./
      DATA UIC /0./
      DATA UDC /0./
      DATA UPC /0./
C***********************************************************************
C     Pour stopper l'execution proprement en cas de probleme
C     mettre LSTOPS a "TRUE" dans vos tests
C     LSTOPS = .FALSE.
C 
C     Temps reel courant sur le solide
      T = TEMPSS
C
C     PROGRAMATION DU CYCLAGE
C     -----------------------
C     On rapelle que l'on commence par de l'air durant
C     la premiere phase (d'une duree de TINI)
c      TINI = 7200
c     montee pendant une journee
      TINI = 3600
C
C     Duree du sable
      DTSABL = 64.
C     Duree de l'air
      DTAIR = 21.
C
C     Reference element de la zone affectee
      NEMPRE = 8
C
C-----------------------------------------------------
      IF (T .GT. TINI) THEN
C     On commence le cyclage (sable/air/sable/.....)
        IF (MATER .EQ. 1) THEN
C          On est dans la configuration ou l'on a de l'air
           IF ((T - TDEB) .LT. DTAIR) THEN
C            On continue avec l'air
             DO N=1,NELEMS
C              References de l'element courant
               NUMREF = NREFE(N)
C
               IF ( NUMREF.EQ.NEMPRE) THEN
C                On met du sable
                 PHYSOL(N,1,1) = 1.283 
                 PHYSOL(N,1,2) = 1293. 
                 PHYSOL(N,1,3) = 0.02454  
               ENDIF
             ENDDO
           ELSE
C            On arrive au changement
             MATER = 0
C            On mets du sable et temperature a 20 degc
             DO N=1,NELEMS
C              References de l'element courant
               NUMREF = NREFE(N)
C
               IF ( NUMREF.EQ.NEMPRE) THEN
C                Pendant 80 secondes on met du sable
                 PHYSOL(N,1,1) =  1500.
                 PHYSOL(N,1,2) =  800.
                 PHYSOL(N,1,3) =  0.58
               ENDIF
             ENDDO
C            Remise a 20 deg de la temperature
             DO N=1,NELEMS
C              References de l'element courant
               NUMREF = NREFE(N)
C
               IF ( NUMREF.EQ.NEMPRE) THEN
                 TMPS(NODES(N,1)) = 20.
                 TMPS(NODES(N,2)) = 20.
                 TMPS(NODES(N,3)) = 20.
                 TMPS(NODES(N,4)) = 20.
                 TMPS(NODES(N,5)) = 20.
                 TMPS(NODES(N,6)) = 20.
               ENDIF
             ENDDO
C
             DO N=1,NELEMS
C              References de l'element courant
               NUMREF = NREFE(N)
C
               IF ( NUMREF.NE.NEMPRE) THEN
                 TMPS(NODES(N,1)) = TMPSA(NODES(N,1))
                 TMPS(NODES(N,2)) = TMPSA(NODES(N,2))
                 TMPS(NODES(N,3)) = TMPSA(NODES(N,3))
                 TMPS(NODES(N,4)) = TMPSA(NODES(N,4))
                 TMPS(NODES(N,5)) = TMPSA(NODES(N,5))
                 TMPS(NODES(N,6)) = TMPSA(NODES(N,6))
               ENDIF
             ENDDO
C            Reactualisation des temperatures aux noeuds
             DO N=1,NPOINS
                 TMPSA(N) = TMPS(N)
             ENDDO
C
C            Actualisation du TDEB
             TDEB = T
C
           ENDIF
C
        ELSE
C          configuration ou l'on a du sable (mater = 0)
           IF (T - TDEB .LT. DTSABL) THEN
C            On continue avec du sable
             DO N=1,NELEMS
C              References de l'element courant
               NUMREF = NREFE(N)
C
               IF ( NUMREF.EQ.NEMPRE) THEN
C                On met du sable
                 PHYSOL(N,1,1) = 1500.
                 PHYSOL(N,1,2) = 800.
                 PHYSOL(N,1,3) = 0.58 
               ENDIF
             ENDDO
           ELSE
             MATER = 1
C            On mets de l'air a temperature a 20 degc
             DO N=1,NELEMS
C              References de l'element courant
               NUMREF = NREFE(N)
C
               IF ( NUMREF.EQ.NEMPRE) THEN
C                Pendant 80 secondes on met du sable
                 PHYSOL(N,1,1) = 1.283 
                 PHYSOL(N,1,2) = 1293. 
                 PHYSOL(N,1,3) = 0.02454  
               ENDIF
             ENDDO
C            Remise a 20 deg de la temperature
             DO N=1,NELEMS
C              References de l'element courant
               NUMREF = NREFE(N)
C
               IF ( NUMREF.EQ. NEMPRE) THEN
                 TMPS(NODES(N,1)) = 20.
                 TMPS(NODES(N,2)) = 20.
                 TMPS(NODES(N,3)) = 20.
                 TMPS(NODES(N,4)) = 20.
                 TMPS(NODES(N,5)) = 20.
                 TMPS(NODES(N,6)) = 20.
               ENDIF
             ENDDO
C
             DO N=1,NELEMS
C              References de l'element courant
               NUMREF = NREFE(N)
C
               IF ( NUMREF.NE. NEMPRE) THEN
                 TMPS(NODES(N,1)) = TMPSA(NODES(N,1))
                 TMPS(NODES(N,2)) = TMPSA(NODES(N,2))
                 TMPS(NODES(N,3)) = TMPSA(NODES(N,3))
                 TMPS(NODES(N,4)) = TMPSA(NODES(N,4))
                 TMPS(NODES(N,5)) = TMPSA(NODES(N,5))
                 TMPS(NODES(N,6)) = TMPSA(NODES(N,6))
               ENDIF
             ENDDO
C            Reactualisation des temperatures aux noeuds
             DO N=1,NPOINS
                 TMPSA(N) = TMPS(N)
             ENDDO
C            Actualisation du TDEB
             TDEB = T
           ENDIF
C
        ENDIF
C             
      ENDIF
C
cc      print*, '  tdeb ', tdeb
cc      print*, ' rho   ',physol(2768,1,1)
cc      print*, '  tmpsa(4232) ', tmpsa(4232)
C
C     =======================================================
C     FIN POUR LES CARACTERISTIQUES PHYSIQUES PAR ELEMENT
C     LES PROPRIETES SONTS CONSTANTES SUR l"ELEMENT
C     =======================================================
C
C     Programmation du regulateur
C     ==========================
C     Pas de temps de la resolution 
      PERIOR = RDTTS
C
C     Algorithme du regulateur
C     -------------------------
      ER = (TREG - TMPS(NODREG))/TREG
     
      IF (ER .GT. (1./KC)) THEN
        UC = 1.
        UIC = 0.
        UDC = 0.
        write(6,111) T,upc,uic,udc,uc
      ELSE
        UPC = KC * ER
        IF (UPC .LE. -1) UPC =-1.
        UIC = UIC+PERIOR/TIC*ER*KC
        IF (UPC.GT.0. .AND. (UIC .GT.  1.-UPC)) UIC = 1.-UPC
        IF (UPC.LT.0. .AND. (UIC .LT. -1.-UPC)) UIC =-1.-UPC
        UDC = TDC * ((ER-VER)*CN*KC+UDC) / (TDC+ CN*PERIOR)
        UC = UPC + UIC + UDC
        write(6,111) T,upc,uic,udc,uc
  111   format(' p: ',5(2X,e15.5))
        IF (UC .GT. 1.) UC = 1.
        IF (UC .LT. 0.) UC = 0.
      ENDIF
C
C     reactualisation
      VER = ER
C
C     Algorithme du regulateur
C     -------------------------
C
C     Calcul du flux volumique 
      FLUVOL = PUINOM * UC
cc      print*,' UC : ',T,'  ',UC
C
C
C     ============================================================
C     TRAITEMENT PAR ELEMENT (FLUX VOLUMIQUE CONSTANT PAR ELEMENT)
C     ============================================================
C     Pour chaque element portant un flux volumique
      DO 100 N=1,NBFLVS
C
C        Numero global de l'element
         NUMEL = NFLUVS(N)
C
C        Reference de l'element
         NUMREF = NREFE(NUMEL)
C
         OK=.FALSE.
         DO I=1,NBRREG
          IF (NUMREF.EQ.NRREG(I)) OK=.TRUE.
         ENDDO
C
        IF (OK) VFLUVS(N,1) = FLUVOL
C
  100 CONTINUE
C
C     Affichage : puissance em m3 et veritablement injectee
c      Print*,' temps  Puissance',T,FLUVOL,FLUVOL*0.000193
C     ============================================================
C     FIN DU TRAITEMENT PAR ELEMENT (FLUX CONSTANT PAR ELEMENT)
C     ============================================================
C
C----
C FIN
C----
      END
