C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=PERIOD,SSI=0
C
                     SUBROUTINE PERIOD
C                    ******************
C
C     -------------------------------------
     *( X,TRAV1,NPOINS,NPRIOS,NBPRIO,NBCOPR)
C     -------------------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------    Prise en compte des conditions de periodicite      *
C                   pour les termes diagonaux                          *
C                                                                      *                                                                     *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   X       !  TR  ! M  ! VECTEUR de dimension NPOINS              !
C   !   TRAV1   !  TR  ! M  ! Tableau de travail  (npoins)             !
C   !   NPOINS  !  E   ! D  ! Nombre de points du maillage             !
C   !   NPRIOS  !  TE  ! D  ! CORRESPONDANCE noeuds periodique-num glob!
C   !   NBPRIO  !  E   ! D  ! Nombre de noeuds periodique              !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ????
C      
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : ????
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
C    
C***********************************************************************
C
C..Variables externes
      INTEGER NPOINS,NBPRIO,NBCOPR
      INTEGER NPRIOS(NBPRIO,1+NBCOPR)
C
      DOUBLE PRECISION X(NPOINS),TRAV1(NPOINS)
C
C..Variables locales
      INTEGER I,K,NG,NLC
C
C***********************************************************************
CC
C     1. TRAITEMENT DES NOEUDS PERIODIQUES (partie diagonale)
C     =======================================================
C
      DO 100 I=1,NPOINS
        TRAV1(I) = 0.D0
 100  CONTINUE      
C
      DO 110 I=1,NBPRIO
        NG  = NPRIOS(I,1)
        NLC = NPRIOS(I,2)
        TRAV1(NG) = TRAV1(NG) + X(NPRIOS(NLC,1))
  110 CONTINUE
C
      DO 120 K=3,NBCOPR+1
        DO 130 I=1,NBPRIO
          NLC = NPRIOS(I,K)
          IF (NLC .GT. 0) THEN
            NG  = NPRIOS(I,1)
            TRAV1(NG) = TRAV1(NG) + X(NPRIOS(NLC,1))
          ENDIF
  130   CONTINUE
  120 CONTINUE
C
      DO 140 I=1,NBPRIO
        NG  = NPRIOS(I,1)
        X(NG) = X(NG) + TRAV1(NG)
  140 CONTINUE      
C
C
C     2- IMPRESSIONS POUR CONTROLE
C     ============================
C
      IF ( NBLBLA.EQ.13 ) THEN
        WRITE(NFECRA,211)
        DO 200 I=1,NPOINS
          WRITE(NFECRA,210) I,X(I),TRAV1(I)
  200   CONTINUE
      ENDIF
C------ 
C FORMAT
C------
 211  FORMAT(/,' *** PERIOD : AJOUT LIE A LA PERIODICITE ',/,
     &         '        NOEUD       DMAT     AJOUT   ')
 210  FORMAT(7X,I6,5X,G10.4,5X,G10.4)
C
      END

