C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=MOBCOR,SSI=0
                        SUBROUTINE MOBCOR
C                       *****************
C
C      --------------------------------------------------------------
     * (NDIM,NPOINS,NELESS,NDMASS,NELESF,NDMASF,
     *  NBCOUS,NBCOUF,COORDS,NODESS,COORDF,NODESF,
     *  BARYF,NCBORF,BARYS,NCBORS,NCOUPS,NCOUPF,NBICOR)
C      --------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            ETABLISSEMENT DE LA TABLE DE CORRESPONDANCE ENTRE LES     *
C            NOEUDS COUPLES DES MAILLAGES FLUIDE ET SOLIDE             *
C            DANS LE CAS DES SOLIDES MOBILES                           * 
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE VOL SOLIDE      !
C !  NELESS   !  E ! D  ! NOMBRE D'ELEMENTS DU MAILLGE SURF SOLIDE     !
C !  NDMASS   !  E ! D  ! NOMBRE DE NOEUDS DES ELT SURF SOLIDE         !
C !  NBCOUS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES COUPLES             !
C !  NBCOUF   !  E ! D  ! NOMBRE DE NOEUDS FLUIDES COUPLES             !
C !  NELESF   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE VOL SOLIDE      !
C !  NDMASF   !  E ! D  ! NOMBRE D'ELEMENTS DU MAILLGE SURF FLUIDE     !
C !  NCOUPF   ! TE ! D  ! NUMEROS GLOBAUX DES NOEUDS FLUIDES COUPLES   !
C !  NCOUPS   ! TE ! D  ! NUMEROS GLOBAUX DES NOEUDS SOLIDES COUPLES   !
C !  COORDS   ! TR ! D  ! COORDONNEES DES NOEUDS DU MAILLAGE SOLIDE    !
C !  NODESS   ! TE ! D  ! TABLEAU DE CONNECTIVITE MAILLAGE SURF SOLIDE !
C !  COORDF   ! TR ! D  ! COORDONNEES DES NOEUDS FLUIDES COUPLES       !
C !  NODESF   ! TE ! D  ! TABLEAU DE CONNECTIVITE MAILLAGE SURF FLUIDE !
C !  BARYF    ! TR ! R  ! COORD BARY DES CORRESPONDANTS DES NOEUDS     !
C !           !    !    ! FLUIDES DANS LES ELEMENTS SOLIDES            !
C !  NCBORF   ! TE ! R  ! NUMERO DE L'ELEMENT SOLIDE CORRESPONDANT     !
C !  BARYS    ! TR ! R  ! COORD BARY DES CORRESPONDANTS DES NOEUDS     !
C !           !    !    ! SOLIDES DANS LES ELEMENTS FLUIDES            !
C !  NCBORS   ! TE ! R  ! NUMERO DE L'ELEMENT FLUIDE CORRESPONDANT     !
C !  NCOUPS   ! TE ! D  ! NUMEROS GLOBAUX DES NOEUDS SOLIDES COUPLES   !
C !  NBICOR   !  E ! D  ! NOMBRE D'INFO SUR LES CORRSPONDANTS (1 ou 2) !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : DPTSEG, CBARY2
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON 
C***********************************************************************
C
#include "optct.h"
#include "mobil.h"
#include "nlofes.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NPOINS,NELESS,NDMASS
      INTEGER NELESF,NDMASF,NBCOUS,NBCOUF,NBICOR
      INTEGER NODESS(NELESS,NDMASS),NODESF(NELESF,NDMASS)
      INTEGER NCBORF(NBCOUF,NBICOR),NCBORS(NBCOUS,NBICOR)
      INTEGER NCOUPS(NBCOUS),NCOUPF(NBCOUF,2)
      DOUBLE PRECISION COORDS(NPOINS,NDIM),COORDF(NBCOUF,NDIM)
      DOUBLE PRECISION BARYF(NBCOUF,NDIM),BARYS(NBCOUS,NDIM)
C
C.. Variables internes
      INTEGER N,NGS,M,NONC
      DOUBLE PRECISION XS,YS,ZS,XF,YF,ZF,D2,DMIN  
C
      LOGICAL LVERIF
C***********************************************************************
C
C     0- INITIALISATIONS
C     ==================
C
      LVERIF = .FALSE.
      NONC=0
C
      DO 1 N=1,NBCOUS*NBICOR
        NCBORS(N,1) = 0
    1 CONTINUE
C
      DO 2 N=1,NBCOUF*NBICOR
        NCBORF(N,1) = 0
    2 CONTINUE
C
      DO 3 N=1,NBCOUF*NDIM
        BARYF(N,1) = 0.D0
    3 CONTINUE
C
      DO 4 N=1,NBCOUS*NDIM
        BARYS(N,1) = 0.D0
    4 CONTINUE
C
C
C     1- REPERAGE DES NOEUDS SOLIDES QUI ONT UN CORRESPONDANT
C     =======================================================
C
C
      IF (.NOT.LCOIN) THEN
C
C      1.1- En dimension 2
C      -------------------
       IF (NDIM.EQ.2) THEN
C
        DO 110 N=1,NBCOUS
C     
          DMIN = 1.E6
          NGS =  NCOUPS(N)
          XS  = COORDS(NGS,1)
          YS  = COORDS(NGS,2)
C
          DO 111 M=1,NBCOUF
            XF  = COORDF(M,1)
            YF  = COORDF(M,2)
C
            D2 = (XS-XF)*(XS-XF) + (YS-YF)*(YS-YF) 
C
            IF (D2.LT.DMIN) THEN
              DMIN = D2
            ENDIF
C
  111     CONTINUE
C
          IF (DMIN.GT.D1MAXF) THEN
            NONC=NONC+1
            NCBORS(N,1) = -1
          ENDIF
C
  110   CONTINUE
C
C      1.2- En dimension 3
C      -------------------
       ELSE
C
        DO 120  N=1,NBCOUS
C     
          DMIN = 1.E6
          NGS =  NCOUPS(N)
          XS  = COORDS(NGS,1)
          YS  = COORDS(NGS,2)
          ZS  = COORDS(NGS,3)
C
          DO 121 M=1,NBCOUF
            XF  = COORDF(M,1)
            YF  = COORDF(M,2)
            ZF  = COORDF(M,3)
C
            D2 = (XS-XF)*(XS-XF) + (YS-YF)*(YS-YF) + (ZS-ZF)*(ZS-ZF) 
C
            IF (D2.LT.DMIN) THEN
              DMIN = D2
            ENDIF
C
  121     CONTINUE
C
          IF (DMIN.GT.D1MAXF) THEN
            NONC=NONC+1
            NCBORS(N,1) = -1
          ENDIF
C
  120    CONTINUE
C
       ENDIF          
C
      ENDIF
C
      IF (NBLBLA.GE.10) WRITE(NFECRA,1000) NBCOUS,NONC
C
C     2- RECHERCHE DES CORRESPONDANTS                         
C     ===============================
C
      IF (LCOIN) THEN
C
         CALL COCOIN (NDIM,NPOINS,NBCOUS,NBCOUF,NBICOR,
     *               COORDS,COORDF,NCBORF,NCBORS,NCOUPS)
C
      ELSE
C
        IF (NDIM.EQ.2) THEN
         CALL CORFS2 (NDIM,NPOINS,NELESS,NDMASS,NELESF,NDMASF,
     *                NBCOUS,NBCOUF,COORDS,NODESS,COORDF,NODESF,
     *                BARYF,NCBORF,BARYS,NCBORS,NCOUPS,NBICOR)
C
        ELSE 
         CALL COROCT (NDIM,NPOINS,NELESS,NDMASS,NELESF,NDMASF,
     *                NBCOUS,NBCOUF,COORDS,NODESS,COORDF,NODESF,
     *                BARYF,NCBORF,BARYS,NCBORS,NCOUPS,NBICOR,
     *                NBLBLA,D2MAXF)

        ENDIF
C
      ENDIF
C
C--------
C FORMATS
C--------
C
 1000 FORMAT(/,' *** MOBCOR : ',/,
     *  '       Nombre de noeuds solides candidats au couplage ',I7,/,
     *  '       Nombre de noeuds pre-elimines du couplage      ',I7)
C----
C FIN
C----
      END
               
