C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LRASY2
C                       *****************
C
C     --------------------------------
     *(NDIM,NPOINR,NELRAY,IREF,INOEUD)
C     --------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C      1ere LECTURE DU MAILLAGE ELEMENTS FINIS  POUR LE RAYONNEMENT    *
C             --> STRUCTURE DE DONNEE ISSUE DE SYRTHES                 *
C             (Necessaire pour les dimensionnements de tableaux)       *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) :
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "nlofct.h"
C
C***********************************************************************
C 
      INTEGER NDX
      PARAMETER (NDX=10)
C
C.. Variables externes
      INTEGER NDIM,NPOINR,NELRAY,IREF(NELRAY),INOEUD(NELRAY*NDIM)
C
C.. Variables internes
      INTEGER I,J,N1,NBNO,IERR
      CHARACTER CH*80
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
C
      NBNO = NDIM
C
C     2- NOMBRE DE NOEUDS ET D'ELEMENTS
C     =================================
C 
      REWIND(NFSGRA)
      READ(NFSGRA,1000) CH,CH,CH,CH
      READ(NFSGRA,1001) CH
      READ(NFSGRA,1001) CH
      READ(NFSGRA,1001) CH
C
C     4- TABLE DES ELEMENTS
C     =====================
C
C     4.1- Recherche de la rubrique contenant la table des noeuds
C     -----------------------------------------------------------
      IERR = 0
      CALL SECGRF(NFSGRA,'C$ RUBRIQUE = ELEMENTS',22,IERR)
      IF (IERR.NE.0) THEN
        WRITE(NFECRA,4100)
        STOP
      ENDIF
C
C
C     4.2- Lecture des elements
C     -------------------------
C
      DO I=1,NELRAY
         READ(NFSGRA,4200) N1,IREF(I),
     &        (INOEUD((J-1)*NELRAY+I),J=1,NBNO)
      ENDDO
C
C
C--------
C FORMATS
C--------
C 
 1000 FORMAT(A80,/,A80,/,A80,/,A80)
 1001 FORMAT(A80)
C
 4100 FORMAT(//,' *** LRASY2 : LE FICHIER GEOMETRIQUE NE CONTIENT ',
     &          'PAS LA TABLE DES ELEMENTS')
 4200 FORMAT(I10,I3,3I10)
C

      END
