C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LECLIM
C                       *****************
C
     * ( NDIM,NPOINS,NELEMS,NREFS,NREFE,
     *   TMPSA,TMPS,TMPSC1,TMPSC2,TMPSC3,COORDS,
     *   NBFLUS,NFLUSS,VFLUSS,NBDIRS,NDIRS,VDIRS,
     *   NBECHS,NECHS,VECHS,NBFLVS,NPFEL,NFLUVS,VFLUVS,
     *   NBRESS,NRESCS,VRESCS,
     *   NBPRIO,NBCOPR,NPRIOS,NBMOBS,NMOBIL,
     *   NPOUE,NPPEL,NBPHYS,PHYSOL,
     *   NDMASS,NREFAL,NELEUS,NFFLUS,VFFLUS,NBFFLU,
     *   NFECHS,VFECHS,NBFECH,NFRESC,VFRESC,NELERC,NELERA,
     *   NBRAIS,NRAYIS,VRAYIS,NBFRAI,NFRAIS,VFRAIS,
     *   ITRAV,ITRAV1,ITRAV2,TRAV1,TRAV2,TRAV3)
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   LECTURE ET INTERPRETATION DU FICHIER syrthes.data       *
C              Lecture des CL et donnees physiques                     *
C              Il peut contenir (quand les valeurs sont constantes) :  *
C                - les valeurs des CL                                  *
C                - les proprietes physiques                            *
C                - les flux volumiques                                 *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/XREFER/!      ! D  !                                             !
C   !/NLOFES/!      ! D  !                                             !
C   !__________________________________________________________________!
C   ! FONCTIONS IMPLICITES                                             !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : POSCOT,POSREE,POSLIS,CCONDI
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : INISOL
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "optct.h"
#include "mobil.h"
#include "xrefer.h"
#include "nlofes.h"
#include "nlofct.h"
#include "divct.h"
#include "regul.h"
C
C**********************************************************************
C
      INTEGER NVV
      PARAMETER (NVV=12)
C
C..Variables externes
      INTEGER NDIM,NPOINS,NBFLUS,NBDIRS,NBECHS,NBFLVS,NPFEL,NBRESS
      INTEGER NELERA,NPOUE,NPPEL,NELEMS
      INTEGER NBPHYS,NBPRIO,NBCOPR,NPRIOS(NBPRIO,1+NBCOPR)
      INTEGER NREFS(NPOINS),NREFE(NELEMS)
      INTEGER NFLUSS(NBFLUS),NDIRS(NBDIRS),NECHS(NBECHS)
      INTEGER NFLUVS(NBFLVS),NRESCS(NBRESS,2)
      INTEGER NBMOBS,NMOBIL(NBMOBS,2)
      INTEGER NDMASS,NELEUS,NBFFLU,NBFECH,NELERC
      INTEGER NREFAL(NELEUS),NFFLUS(NBFFLU)
      INTEGER NFECHS(NBFECH),NFRESC(NELERC)
      INTEGER NBRAIS,NRAYIS(NBRAIS),NBFRAI,NFRAIS(NBFRAI)
      DOUBLE PRECISION COORDS(NPOINS,NDIM),TMPSA(NPOINS),TMPS(NPOINS)
      DOUBLE PRECISION TMPSC1(NPOINS),TMPSC2(NPOINS),TMPSC3(NPOINS)
      DOUBLE PRECISION VFLUSS(NBFLUS),VDIRS(NBDIRS),VECHS(NBECHS,2)
      DOUBLE PRECISION VFLUVS(NBFLVS,NPFEL),VRESCS(NBRESS,2)
      DOUBLE PRECISION VFFLUS(NBFFLU,NDMASS)
      DOUBLE PRECISION VFECHS(NBFECH,NDMASS,2)
      DOUBLE PRECISION VFRESC(NELERC,NDMASS,2)
      DOUBLE PRECISION VRAYIS(NBRAIS,2),VFRAIS(NBFRAI,NDMASS,2)
      DOUBLE PRECISION PHYSOL(NPOUE,NPPEL,NBPHYS)
      INTEGER ITRAV(NPOINS),ITRAV1(NPOINS),ITRAV2(NPOINS)
      DOUBLE PRECISION TRAV1(NPOINS),TRAV2(NPOINS),TRAV3(NPOINS)
C
C..Variables internes
      INTEGER I,I1,I2,N,LCH,II1,II2,NB,M,J,NPS
      INTEGER ITAB(NRFMAX)
      CHARACTER*200 CHAINE,FORMA
      CHARACTER*1 CTYP
      DOUBLE PRECISION VAL,VAL1,VAL2,XK,YK,ZK
      DOUBLE PRECISION VV(NVV)
      LOGICAL ERR
C
C**********************************************************************
C
C     0- INITIALISATIONS
C     ==================
      ERR = .FALSE.
      REWIND (NFCLCT)
      NPS = 0
      NBHSOL=0
C    
C     0.1- CONDITION DE TYPE FLUX : PAR DEFAUT FLUX NUL
C     -------------------------------------------------
C
      IF (LCFACE) THEN
        DO 111 N=1,NBFFLU
          DO 112 J=1,NDMASS
            VFFLUS(N,J) = 0.D0
  112     CONTINUE
  111   CONTINUE
      ELSE
        DO 110 N=1,NBFLUS
           VFLUSS(N) = 0.D0
  110   CONTINUE
      ENDIF
C
C     0.2- CONDITION DE TYPE DIRICHLET : PAR DEFAUT 20 C
C     --------------------------------------------------
      DO 120 N=1,NBDIRS
        VDIRS(N) = 20.D0
  120 CONTINUE
C
C     0.3- CONDITION DE TYPE COEFFICIENT D'ECHANGE : 
C          PAR DEFAUT 20 C ET UN COEFFICIENT H=0.
C     -----------------------------------------------
C
      IF (LCFACE) THEN
        DO 131 N=1,NBFECH
          DO 132 J=1,NDMASS
            VFECHS(N,J,1) = 20.D0
            VFECHS(N,J,2) =  0.D0
  132     CONTINUE
  131   CONTINUE
      ELSE
        DO 130 N=1,NBECHS
          VECHS(N,1) = 20.D0
          VECHS(N,2) =  0.D0
  130   CONTINUE
      ENDIF
C
C
C     0.4- CONDITION DE RESISTANCE DE CONTACT : 
C          PAR DEFAUT 20 C ET UN COEFFICIENT H=0.
C     -------------------------------------------
C
      IF (LCFACE) THEN
        DO 141 N=1,NELERC
          DO 142 J=1,NDMASS
            VFRESC(N,J,1) = 20.D0
            VFRESC(N,J,2) =  0.D0
  142     CONTINUE
  141   CONTINUE
      ELSE
        DO 140 N=1,NBRESS
          VRESCS(N,1) = 20.D0
          VRESCS(N,2) =  0.D0
  140   CONTINUE
      ENDIF
C
C
C     0.6- INITIALISATIONS DES CARACTERISTIQUES PHYSIQUES
C     ---------------------------------------------------
C
      IF (NCTHFS.EQ.2) THEN
         DO 160 M=1,NPPEL
          DO 161 N=1,NPOUE
           PHYSOL(N,M,1) = 7700.
           PHYSOL(N,M,2) = 460.
           PHYSOL(N,M,3) = 25.1
           PHYSOL(N,M,4) = 25.1
           PHYSOL(N,M,5) = 0.  
           PHYSOL(N,M,6) = 0.01
  161    CONTINUE
  160   CONTINUE
      ELSE
         DO 162 M=1,NPPEL
          DO 163 N=1,NPOUE
           PHYSOL(N,M,1) = 7700.
           PHYSOL(N,M,2) = 460.
           IF (ISOTRO.EQ.1) THEN
              PHYSOL(N,M,3) = 25.1
           ELSEIF (ISOTRO.EQ.2) THEN
              PHYSOL(N,M,3) = 25.1
              PHYSOL(N,M,4) = 25.1
              IF (NDIM.EQ.3) PHYSOL(N,M,5) = 25.1
           ELSEIF (ISOTRO.EQ.3) THEN
              IF (NDIM.EQ.2) THEN
                PHYSOL(N,M,3) = 25.1
                PHYSOL(N,M,4) = 25.1
                PHYSOL(N,M,5) = 0.
              ELSE
                PHYSOL(N,M,3) = 25.1
                PHYSOL(N,M,4) = 25.1
                PHYSOL(N,M,5) = 25.1
                PHYSOL(N,M,6) = 0.
                PHYSOL(N,M,7) = 0.
                PHYSOL(N,M,8) = 0.
              ENDIF
           ENDIF
  163    CONTINUE
  162   CONTINUE
      ENDIF
C
C     0.7- INITIALISATION DU CHAMP DE TEMPERATURE
C     -------------------------------------------
C
      DO 170 N=1,NPOINS
         TMPS(N)  = 20.D0
         TMPSA(N) = 20.D0
  170 CONTINUE
C
      IF (NCTHFS.EQ.2) THEN
       DO 171 N=1,NPOINS
         TMPSC1(N) = 20.D0
         TMPSC2(N) =  0.D0
         TMPSC3(N) =  0.D0
  171  CONTINUE
      ENDIF
C
C
C     0.8-CORRESPONDANTS NOEUDS PERIODIQUES
C     -------------------------------------
      DO 180 N=1,NBPRIO
        DO 181 M=1,NBCOPR
          NPRIOS(N,M+1) = 0
  181   CONTINUE
  180 CONTINUE
C
C     0.9-SOLIDES MOBILES
C     -------------------
      TMOB = 20.
      XLMOB = 0.
C
      IF (LSDEPL) THEN
        DO 190 N=1,NRFMAX
          IREFMO (N) = 0
  190   CONTINUE
      ENDIF
C
C     0.10- RAYONNEMENT INFINI
C     ------------------------
      IF (LCFACE) THEN
        DO 200 N=1,NBFRAI
          DO 201 J=1,NDMASS
            VFRAIS(N,J,1) = 20.D0
            VFRAIS(N,J,1) =  1.
  201     CONTINUE
  200  CONTINUE
      ELSE
        DO 202 N=1,NBRAIS
          VRAYIS(N,1) = 20.
          VRAYIS(N,2) =  1.
  202   CONTINUE
      ENDIF
C
C     0.11-TABLEAU DE TRAVAIL
C     -----------------------
      DO 210 N=1,NPOINS
         ITRAV(N) = N
  210 CONTINUE
C
      IF (NBPRIO.GT.0) THEN
        DO 211 N=1,NPOINS
          ITRAV1(N) = 0
          ITRAV2(N) = 0
          TRAV1(N) = 0.
          TRAV2(N) = 0.
          TRAV3(N) = 0.
  211   CONTINUE
      ENDIF
C
      WRITE(NFECRA,*)
C
C     =====================
C     1- LECTURE DU FICHIER
C     =====================
C
      REWIND(NFCLCT)
C
   10 CONTINUE
C
      CHAINE = ' '
      READ(NFCLCT,1000,END=999) CHAINE
C
      IF (CHAINE (1:1) .EQ. '/') GOTO 10
C
      CALL POSCOT(CHAINE,I1,I2,LCH)
C
      IF (I1 .EQ. 0) THEN
C
         GOTO 10
C
      ELSE
C
C        1.1- Traitement des conditions aux limites
C        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
C
         IF (CHAINE(I1:I2) .EQ. 'CLIM') THEN
C
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
C
C           1.1.1- Traitement des Dirichlet
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            IF (CHAINE(I1:I2) .EQ. 'DIRICHLET') THEN
              IF (NBDIRS.EQ.0) THEN
                WRITE(NFECRA,1118)
                ERR = .TRUE.
              ELSE
                CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) VAL
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                CALL CCONDI(VAL,NREFS,NPOINS,NDIRS,VDIRS,NBDIRS,ITAB,NB)
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1110) VAL,(ITAB(I),I=1,NB)
                ENDIF
              ENDIF
C                
C           1.1.2- Traitement des flux
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'FLUX') THEN
              IF (       LCFACE .AND. NBFFLU.EQ.0 .OR. 
     &              .NOT.LCFACE .AND. NBFLUS.EQ.0) THEN
                WRITE(NFECRA,1128)
                ERR = .TRUE.
              ELSE
                CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) VAL
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                IF (LCFACE) THEN
                   CALL CCONDF(VAL,NREFAL,NELEUS,NFFLUS,VFFLUS,NBFFLU,
     &                         NDMASS,ITAB,NB)
                ELSE
                   CALL CCONDI(VAL,NREFS,NPOINS,NFLUSS,VFLUSS,NBFLUS,
     &                         ITAB,NB)
                ENDIF
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1120) VAL,(ITAB(I),I=1,NB)
                ENDIF
              ENDIF
C                
C           1.1.3- Traitement des coefficients d'echange
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'COEF ECH') THEN
              IF (       LCFACE .AND. NBFECH.EQ.0 .OR. 
     &              .NOT.LCFACE .AND. NBECHS.EQ.0) THEN
                WRITE(NFECRA,1138)
                ERR = .TRUE.
              ELSE
                CALL POSREE(CHAINE(I2+2:),2,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,2,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) VAL1,VAL2
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                IF (LCFACE) THEN
                   CALL CCONDF(VAL1,NREFAL,NELEUS,NFECHS,VFECHS(1,1,1),
     &                         NBFECH,NDMASS,ITAB,NB)
                   CALL CCONDF(VAL2,NREFAL,NELEUS,NFECHS,VFECHS(1,1,2),
     &                         NBFECH,NDMASS,ITAB,NB)
                ELSE
                   CALL CCONDI(VAL1,NREFS,NPOINS,NECHS,VECHS(1,1),
     *                         NBECHS,ITAB,NB)
                   CALL CCONDI(VAL2,NREFS,NPOINS,NECHS,VECHS(1,2),
     *                         NBECHS,ITAB,NB)
                ENDIF
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1130) VAL1,VAL2,(ITAB(I),I=1,NB)
                ENDIF
              ENDIF
C
C                
C           1.1.4- Traitement des resistances de contact
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'RES CONTACT') THEN
              IF (NCTHFS.EQ.2) THEN
                WRITE(NFECRA,1147)
                ERR = .TRUE.
              ELSEIF (       LCFACE .AND. NELERC.EQ.0 .OR. 
     &                  .NOT.LCFACE .AND. NBRESS.EQ.0) THEN
                WRITE(NFECRA,1148)
                ERR = .TRUE.
              ELSE
                CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) VAL2
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                IF (LCFACE) THEN
                   CALL CCONDF(VAL2,NREFAL,NELEUS,NFRESC,VFRESC(1,1,2),
     &                         NELERC,NDMASS,ITAB,NB)
                ELSE
                   CALL CCONDI(VAL2,NREFS,NPOINS,NRESCS,VRESCS(1,2),
     *                         NBRESS,ITAB,NB)
                ENDIF
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1140) VAL2,(ITAB(I),I=1,NB)
                ENDIF
              ENDIF
C
C                
C           1.1.6- Traitement de la periodicite
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'PERIODICITE') THEN
             IF (NBPRIO.EQ.0) THEN
              WRITE(NFECRA,1168)
              ERR = .TRUE.
             ELSE
              CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
              I1 = I2 + II1 + 1
              I2 = I1 + LCH - 1
C
              IF (CHAINE(I1:I2).EQ.'T') THEN
                CTYP = 'T'
                CALL POSREE(CHAINE(I2+2:),3,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,3,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (VV(I),I=1,3)
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                CALL IPERIO(CTYP,VV,NVV,NBPRIO,NBCOPR,NDIM,NPOINS,
     &                      NPRIOS,NREFS,ITAB,NB,
     &                      COORDS,ITRAV1,ITRAV2,TRAV1,TRAV2,TRAV3)

              ELSEIF (CHAINE(I1:I2).EQ.'R') THEN
                CTYP = 'R'
                CALL POSREE(CHAINE(I2+2:),9,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,9,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (VV(I),I=1,9)
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                CALL IPERIO(CTYP,VV,NVV,NBPRIO,NBCOPR,NDIM,NPOINS,
     &                      NPRIOS,NREFS,ITAB,NB,
     &                      COORDS,ITRAV1,ITRAV2,TRAV1,TRAV2,TRAV3)
C
              ELSE
                WRITE(NFECRA,1161) CHAINE(I1:I2)
                ERR = .TRUE.
              ENDIF
C
             ENDIF
C                
C           1.1.7- Traitement du rayonnement infini
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'RAYT INFINI') THEN
              IF (       LCFACE .AND. NBFRAI.EQ.0 .OR. 
     &              .NOT.LCFACE .AND. NBRAIS.EQ.0) THEN
                WRITE(NFECRA,1178)
                ERR = .TRUE.
              ELSE
                CALL POSREE(CHAINE(I2+2:),2,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,2,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) VAL1,VAL2
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                IF (LCFACE) THEN
                   CALL CCONDF(VAL1,NREFAL,NELEUS,NFRAIS,VFRAIS(1,1,1),
     &                         NBFRAI,NDMASS,ITAB,NB)
                   CALL CCONDF(VAL2,NREFAL,NELEUS,NFRAIS,VFRAIS(1,1,2),
     &                         NBFRAI,NDMASS,ITAB,NB)
                ELSE
                   CALL CCONDI(VAL1,NREFS,NPOINS,NRAYIS,VRAYIS(1,1),
     *                         NBRAIS,ITAB,NB)
                   CALL CCONDI(VAL2,NREFS,NPOINS,NRAYIS,VRAYIS(1,2),
     *                         NBRAIS,ITAB,NB)
                ENDIF
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1170) VAL1,VAL2,(ITAB(I),I=1,NB)
                ENDIF
              ENDIF
C
C
            ELSE
              WRITE(NFECRA,1162) CHAINE(I1:I2)
              ERR = .TRUE.
            ENDIF
C
C        1.2- Traitement des flux volumiques
C        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
         ELSEIF (CHAINE(I1:I2) .EQ. 'CVOL') THEN  
          IF (NBFLVS.EQ.0) THEN
            WRITE(NFECRA,1728)
            ERR = .TRUE.
          ELSE
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) VAL
            II1 = I2+2
            CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
            IF (NDFLUV.EQ.1) THEN
              CALL CCONDI(VAL,NREFS,NPOINS,NFLUVS,VFLUVS(1,1),
     *                    NBFLVS,ITAB,NB)
            ELSE
              CALL CCONDV(VAL,NREFE,NELEMS,NFLUVS,VFLUVS,
     *                    NBFLVS,NPFEL,ITAB,NB)
            ENDIF
            IF (NBLBLA.GE.2) THEN
              WRITE(NFECRA,1200) VAL,(ITAB(I),I=1,NB)
            ENDIF
          ENDIF
C
C        1.3- Traitement des conditions physiques
C        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
         ELSEIF (CHAINE(I1:I2) .EQ. 'CPHY') THEN  
C
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
C
C           1.3.1- Masse volumique
C           ~~~~~~~~~~~~~~~~~~~~~~~~
            IF (CHAINE(I1:I2) .EQ. 'RHO') THEN
                CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) VAL
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                IF (NDPROP.EQ.1) THEN
                  CALL CCONDI(VAL,NREFS,NPOINS,ITRAV,PHYSOL(1,1,1),
     *                        NPOINS,ITAB,NB)
                ELSE
                  CALL CCONDP(VAL,NREFE,NELEMS,PHYSOL(1,1,1),
     *                        NELEMS,NPPEL,ITAB,NB)
                ENDIF
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1310) VAL,(ITAB(I),I=1,NB)
                ENDIF
C
C           1.3.2- Chaleur specifique
C           ~~~~~~~~~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'CP') THEN
                CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) VAL
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                IF (NDPROP.EQ.1) THEN
                  CALL CCONDI(VAL,NREFS,NPOINS,ITRAV,PHYSOL(1,1,2),
     *                        NPOINS,ITAB,NB)
                ELSE
                  CALL CCONDP(VAL,NREFE,NELEMS,PHYSOL(1,1,2),
     *                        NELEMS,NPPEL,ITAB,NB)
                ENDIF
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1320) VAL,(ITAB(I),I=1,NB)
                ENDIF
C
C           1.3.3- Conductivite isotrope
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'K ISOTROPE') THEN
               IF (NCTHFS.EQ.2) THEN
                 WRITE(NFECRA,1337)
                 ERR = .TRUE.
               ELSEIF (ISOTRO.NE.1) THEN
                 WRITE(NFECRA,1338)
                 ERR = .TRUE.
               ELSE
                CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) VAL
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                IF (NDPROP.EQ.1) THEN
                  CALL CCONDI(VAL,NREFS,NPOINS,ITRAV,PHYSOL(1,1,3),
     *                      NPOINS,ITAB,NB)
                ELSE
                  CALL CCONDP(VAL,NREFE,NELEMS,PHYSOL(1,1,3),
     *                        NELEMS,NPPEL,ITAB,NB)
                ENDIF
                IF (NCTHFS.EQ.2) THEN
                  IF (NDPROP.EQ.1) THEN
                    CALL CCONDI(VAL,NREFS,NPOINS,ITRAV,PHYSOL(1,1,4),
     *                          NPOINS,ITAB,NB)
                  ELSE
                    CALL CCONDP(VAL,NREFE,NELEMS,PHYSOL(1,1,4),
     *                          NELEMS,NPPEL,ITAB,NB)
                  ENDIF
                ENDIF
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1330) VAL,(ITAB(I),I=1,NB)
                ENDIF
              ENDIF
C
C           1.3.4- Conductivite orthotrope
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'K ORTHOTROPE') THEN
               IF (NCTHFS.EQ.2) THEN
                 WRITE(NFECRA,1347)
                 ERR = .TRUE.
               ELSEIF (ISOTRO.NE.2) THEN
                 WRITE(NFECRA,1348)
                 ERR = .TRUE.
               ELSE
                CALL POSREE(CHAINE(I2+2:),3,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,3,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) XK,YK,ZK
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                IF (NDPROP.EQ.1) THEN
                  CALL CCONDI(XK,NREFS,NPOINS,ITRAV,PHYSOL(1,1,3),
     *                        NPOINS,ITAB,NB)
                  CALL CCONDI(YK,NREFS,NPOINS,ITRAV,PHYSOL(1,1,4),
     *                        NPOINS,ITAB,NB)
                ELSE
                  CALL CCONDP(XK,NREFE,NELEMS,PHYSOL(1,1,3),
     *                        NELEMS,NPPEL,ITAB,NB)
                  CALL CCONDP(YK,NREFE,NELEMS,PHYSOL(1,1,4),
     *                        NELEMS,NPPEL,ITAB,NB)
                ENDIF
                IF (NDIM.EQ.3) THEN
                  IF (NDPROP.EQ.1) THEN
                    CALL CCONDI(ZK,NREFS,NPOINS,ITRAV,PHYSOL(1,1,5),
     *                          NPOINS,ITAB,NB)
                  ELSE
                    CALL CCONDP(ZK,NREFE,NELEMS,PHYSOL(1,1,5),
     *                          NELEMS,NPPEL,ITAB,NB)
                  ENDIF
                ENDIF
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1340) XK,YK,ZK,(ITAB(I),I=1,NB)
                ENDIF 
              ENDIF
C
C           1.3.5- Conductivite anisotrope
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'K ANISOTROPE') THEN
               IF (NCTHFS.EQ.2) THEN
                 WRITE(NFECRA,1357)
                 ERR = .TRUE.
               ELSEIF (ISOTRO.NE.3) THEN
                 WRITE(NFECRA,1358)
                 ERR = .TRUE.
              ELSE
                CALL POSREE(CHAINE(I2+2:),6,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,6,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (VV(I),I=1,6)
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                IF (NDPROP.EQ.1) THEN
                  CALL ICONDU (VV,NVV,NDIM,NPOINS,NREFS,
     *                         ITAB,NB,NPOUE,NPPEL,NBPHYS,PHYSOL)
                ELSE
                  CALL ICONDU (VV,NVV,NDIM,NELEMS,NREFE,
     *                         ITAB,NB,NPOUE,NPPEL,NBPHYS,PHYSOL)
                ENDIF
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1350) (VV(I),I=1,6),(ITAB(I),I=1,NB)
                  WRITE(NFECRA,*)
                ENDIF
              ENDIF
C
            ELSE
              WRITE(NFECRA,1351) CHAINE(I1:I2)
              ERR = .TRUE.
            ENDIF
C
C        1.4- Conditions pour le modele coque
C        ^^^^^^^^^^^^^^^~^^^^^^^^^^^^^^^^^^^^
         ELSEIF (CHAINE(I1:I2) .EQ. 'CCOQ') THEN  
C
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
C
C           1.4.1- Epaisseur de la coque
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            IF (CHAINE(I1:I2) .EQ. 'EPAISSEUR') THEN
              IF (NCTHFS.EQ.3) THEN
                WRITE(NFECRA,1418)
                ERR = .TRUE.
              ELSE
                CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) VAL
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                IF (NDPROP.EQ.1) THEN
                  CALL CCONDI(VAL,NREFS,NPOINS,ITRAV,PHYSOL(1,1,6),
     *                        NPOINS,ITAB,NB)
                ELSE
                  CALL CCONDP(VAL,NREFE,NELEMS,PHYSOL(1,1,6),
     *                        NELEMS,NPPEL,ITAB,NB)
               ENDIF
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1410) VAL,(ITAB(I),I=1,NB)
                ENDIF
              ENDIF
C
C           1.4.2- Invariant de Gauss (1/R)
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'INVARIANT GAUSS') THEN
              IF (NCTHFS.EQ.3) THEN
                WRITE(NFECRA,1428)
                ERR = .TRUE.
              ELSE
                CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) VAL
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                IF (NDPROP.EQ.1) THEN
                  CALL CCONDI(VAL,NREFS,NPOINS,ITRAV,PHYSOL(1,1,5),
     *                        NPOINS,ITAB,NB)
                ELSE
                  CALL CCONDP(VAL,NREFE,NELEMS,PHYSOL(1,1,5),
     *                        NELEMS,NPPEL,ITAB,NB)
                ENDIF
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1420) VAL,(ITAB(I),I=1,NB)
                ENDIF
              ENDIF
C
C           1.4.3- Conductivite selon la coque et l'epaisseur
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
           ELSEIF (CHAINE(I1:I2) .EQ. 'K SELON COQUE ET EPAISSEUR') THEN
              IF (NCTHFS.EQ.3) THEN
                WRITE(NFECRA,1438)
                ERR = .TRUE.
              ELSE
                CALL POSREE(CHAINE(I2+2:),2,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,2,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) VAL1,VAL2
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                IF (NDPROP.EQ.1) THEN
                  CALL CCONDI(VAL1,NREFS,NPOINS,ITRAV,PHYSOL(1,1,3),
     *                        NPOINS,ITAB,NB)
                  CALL CCONDI(VAL2,NREFS,NPOINS,ITRAV,PHYSOL(1,1,4),
     *                        NPOINS,ITAB,NB)
                ELSE
                  CALL CCONDP(VAL1,NREFE,NELEMS,PHYSOL(1,1,3),
     *                        NELEMS,NPPEL,ITAB,NB)
                  CALL CCONDP(VAL2,NREFE,NELEMS,PHYSOL(1,1,4),
     *                        NELEMS,NPPEL,ITAB,NB)
                ENDIF
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1430) VAL1,VAL2,(ITAB(I),I=1,NB)
                ENDIF
              ENDIF
C
            ELSE
              WRITE(NFECRA,1440) CHAINE(I1:I2)
              ERR = .TRUE.
            ENDIF
C
C
C        1.5- Traitement des solides mobiles
C        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
         ELSEIF (CHAINE(I1:I2) .EQ. 'SMOB') THEN  
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
C
C           1.5.1- Solide en rotation sur lui-meme
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            IF (CHAINE(I1:I2) .EQ. 'R') THEN
              IF (NBMOBS.EQ.0) THEN
                WRITE(NFECRA,1518)
                ERR = .TRUE.
              ELSE
                CALL POSREE(CHAINE(I2+2:),9,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,9,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (VV(I),I=1,9)
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CTYP = 'R'
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                CALL IMOBIL(CTYP,VV,NVV,NBMOBS,NDIM,NPOINS,NMOBIL,
     *                      NREFS,ITAB,NB,COORDS)
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1510) (VV(I),I=1,9),(ITAB(I),I=1,NB)
                  WRITE(NFECRA,*)
                ENDIF
              ENDIF
C
C           1.5.2- Solide en translation
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'T') THEN
              IF (.NOT.LSDEPL) THEN
                WRITE(NFECRA,1528)
                ERR = .TRUE.
              ELSE
                CALL POSREE(CHAINE(I2+2:),4,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,4,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (VV(I),I=1,4)
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CTYP = 'T'
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                IF (NB.NE.1 .AND. ITAB(1).NE.-1) THEN
                  WRITE(NFECRA,1529)
                  STOP
                ENDIF
                TRXMOB = VV(1)
                TRYMOB = VV(2)
                TRZMOB = VV(3)
                TRNMOB = SQRT(TRXMOB*TRXMOB+TRYMOB*TRYMOB+TRZMOB*TRZMOB)
                VTRMOB = VV(4) 
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1520) (VV(I),I=1,4),(ITAB(I),I=1,NB)
                  WRITE(NFECRA,*)
                ENDIF
              ENDIF
C
C           1.5.3- Solide en mobile : CL sur les noeuds non en
C                  regard du fluide
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'CL NOEUDS ISOLES') THEN
              IF (.NOT.LSDEPL .AND. .NOT. LSROTA) THEN
                WRITE(NFECRA,1538)
                ERR = .TRUE.
              ELSE
                CALL POSREE(CHAINE(I2+2:),2,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,2,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (VV(I),I=1,2)
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CTYP = 'T'
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                IF (NB.NE.1 .AND. ITAB(1).NE.-1) THEN
                  WRITE(NFECRA,1529)
                  STOP
                ENDIF
                TMOB  = VV(1)
                XLMOB = VV(2)
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1530) (VV(I),I=1,2),(ITAB(I),I=1,NB)
                  WRITE(NFECRA,*)
                ENDIF
              ENDIF
C
C           1.5.4- Solide en translation : temperature d'entree
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'TEMPERATURE ENTREE') THEN
              IF (.NOT.LSDEPL) THEN
                WRITE(NFECRA,1548)
                ERR = .TRUE.
              ELSE
                CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) VAL
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                IF (NB.NE.1 .AND. ITAB(1).NE.-1) THEN
                  WRITE(NFECRA,1549)
                  STOP
                ENDIF
                TENMOB  = VAL
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1540) VAL,(ITAB(I),I=1,NB)
                  WRITE(NFECRA,*)
                ENDIF
              ENDIF
C
C           1.5.5- Solide en translation : ref des noeuds extremes
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'REFERENCES EXTREMITES') THEN
              IF (.NOT.LSDEPL) THEN
                WRITE(NFECRA,1548)
                ERR = .TRUE.
              ELSE
                II1 = I2+2
                CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
                I1 = I2 + II1 + 1
                I2 = I1 + LCH - 1
                CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
                READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
                DO 155 I=1,NB
                  IREFMO(ITAB(I)) = 1
  155           CONTINUE
                IF (NBLBLA.GE.2) THEN
                  WRITE(NFECRA,1550) (ITAB(I),I=1,NB)
                  WRITE(NFECRA,*)
                ENDIF
              ENDIF
C
            ELSE
              WRITE(NFECRA,1560) CHAINE(I1:I2)
              ERR = .TRUE.
C
            ENDIF
C
C
C        1.6- Traitement des conditions initiales
C        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
         ELSEIF (CHAINE(I1:I2) .EQ. 'CINI') THEN  
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) VAL1
            II1 = I2+2
            CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
            CALL CCONDI(VAL1,NREFS,NPOINS,ITRAV,TMPSA,NPOINS,ITAB,NB)
            CALL CCONDI(VAL1,NREFS,NPOINS,ITRAV,TMPS, NPOINS,ITAB,NB)
            IF (NCTHFS.EQ.2) 
     *        CALL CCONDI(VAL1,NREFS,NPOINS,ITRAV,TMPSC1,NPOINS,ITAB,NB)
C
C                
C        1.7- Traitement des historiques
C        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
         ELSEIF (CHAINE(I1:I2) .EQ. 'HIST') THEN  
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
C
C           1.7.1- Frequence
C           ~~~~~~~~~~~~~~~~
            IF (CHAINE(I1:I2) .EQ. 'FREQ') THEN
              CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
              I1 = I2 + II1 + 1
              I2 = I1 + LCH - 1
              CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
              READ(CHAINE(I1:I2),FORMA,ERR=9999) XFREQS
C
C           1.7.2- Liste de noeuds
C           ~~~~~~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'NOEUDS') THEN
              II1 = I2+2
              CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
              IF (NB.GT.NRFMAX) THEN
                WRITE(NFECRA,1721) NRFMAX
                ERR=.TRUE.
              ENDIF
              I1 = I2 + II1 + 1
              I2 = I1 + LCH - 1
              CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
              READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
              DO I=1,NB
                NHISOL(NBHSOL+I)=ITAB(I)
              ENDDO
              NBHSOL=NBHSOL+NB
              IF (NBHSOL.GT.NHSMAX) THEN
                WRITE(NFECRA,1722) NHSMAX
                ERR=.TRUE.
              ENDIF
            ENDIF
C
C
C                
C        1.8- Traitement de la regulation
C        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
         ELSEIF (CHAINE(I1:I2) .EQ. 'REGUL') THEN  
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
C
C           1.8.1- Gain
C           ~~~~~~~~~~~~~~~~
            IF (CHAINE(I1:I2) .EQ. 'GAIN') THEN
              CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
              I1 = I2 + II1 + 1
              I2 = I1 + LCH - 1
              CALL CHFORM('I',CHAINE(I1:I2),LCH,1,FORMA)
              READ(CHAINE(I1:I2),FORMA,ERR=9999) KC
C
C           1.8.2- CONSTANTES
C           ~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'CONSTANTES') THEN
              CALL POSREE(CHAINE(I2+2:),3,II1,II2,LCH)
              I1 = I2 + II1 + 1
              I2 = I1 + LCH - 1
              CALL CHFORM('R',CHAINE(I1:I2),LCH,3,FORMA)
              READ(CHAINE(I1:I2),FORMA,ERR=9999) TIC,TDC,CN
C
C           1.8.3- TEMP DE REGUL
C           ~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'TEMP DE REGUL') THEN
              CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
              I1 = I2 + II1 + 1
              I2 = I1 + LCH - 1
              CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
              READ(CHAINE(I1:I2),FORMA,ERR=9999) TREG
C
C           1.8.4- NOEUD DE REGUL
C           ~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'NOEUD DE REGUL') THEN
              CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
              I1 = I2 + II1 + 1
              I2 = I1 + LCH - 1
              CALL CHFORM('I',CHAINE(I1:I2),LCH,1,FORMA)
              READ(CHAINE(I1:I2),FORMA,ERR=9999) NODREG
C
C           1.8.5- PUISSANCE
C           ~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'PUISSANCE') THEN
              CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
              I1 = I2 + II1 + 1
              I2 = I1 + LCH - 1
              CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
              READ(CHAINE(I1:I2),FORMA,ERR=9999) PUINOM
C
C           1.8.3- Liste des references
C           ~~~~~~~~~~~~~~~~~~~~~~~~~~~
            ELSEIF (CHAINE(I1:I2) .EQ. 'REFERENCES') THEN
              II1 = I2+2
              CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
              IF (NB.GT.NRRMAX) THEN
                WRITE(NFECRA,1821) NRRMAX
                ERR=.TRUE.
              ENDIF
              NBRREG=NB
              I1 = I2 + II1 + 1
              I2 = I1 + LCH - 1
              CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
              READ(CHAINE(I1:I2),FORMA,ERR=9999) (NRREG(I),I=1,NB)
            ENDIF
C
C                
C
          ENDIF
      ENDIF
C
      GOTO 10
C
 999  CONTINUE
C
C     STOP EN CAS D'ERREUR DANS LES MOTS-CLES
C     ---------------------------------------
      IF (ERR) STOP
C
      IF (NBHSOL.EQ.0) LHISOL=.FALSE.
C
C     2- IMPRESSIONS DE CONTROLE
C     ==========================
C
      IF (NBLBLA.EQ.10) THEN
C
       IF (LCFACE) THEN
        WRITE(NFECRA,2003) 
        WRITE(NFECRA,*) NFFLUS
        WRITE(NFECRA,2002) 
        WRITE(NFECRA,*) VFFLUS
       ELSE       
        WRITE(NFECRA,2001) 
        WRITE(NFECRA,*) NFLUSS
        WRITE(NFECRA,2002) 
        WRITE(NFECRA,*) VFLUSS
       ENDIF
C        
        WRITE(NFECRA,2011) 
        WRITE(NFECRA,*) NDIRS
        WRITE(NFECRA,2012) 
        WRITE(NFECRA,*) VDIRS
C        
       IF (LCFACE) THEN
        WRITE(NFECRA,2024) 
        WRITE(NFECRA,*) NFECHS
        WRITE(NFECRA,2022) 
        WRITE(NFECRA,*) (VFECHS(N,1,1),N=1,NBFECH)
        WRITE(NFECRA,2023) 
        WRITE(NFECRA,*) (VFECHS(N,1,2),N=1,NBFECH)
       ELSE
        WRITE(NFECRA,2021) 
        WRITE(NFECRA,*) NECHS
        WRITE(NFECRA,2022) 
        WRITE(NFECRA,*) (VECHS(N,1),N=1,NBECHS)
        WRITE(NFECRA,2023) 
        WRITE(NFECRA,*) (VECHS(N,2),N=1,NBECHS)
       ENDIF
C        
        WRITE(NFECRA,2031) 
        WRITE(NFECRA,*) (NRESCS(N,1),N=1,NBRESS)
       IF (LCFACE) THEN
        WRITE(NFECRA,2033) 
        WRITE(NFECRA,*) NFRESC
        WRITE(NFECRA,2032) 
        WRITE(NFECRA,*) (VFRESC(N,1,2),N=1,NELERC)
       ELSE
        WRITE(NFECRA,2032) 
        WRITE(NFECRA,*) (VRESCS(N,2),N=1,NBRESS)
       ENDIF
C        
        WRITE(NFECRA,2051) 
        WRITE(NFECRA,*) NFLUVS
        WRITE(NFECRA,2052) 
        WRITE(NFECRA,*) VFLUVS
C        
        WRITE(NFECRA,2061) 
        WRITE(NFECRA,*) NPOINS
        WRITE(NFECRA,2062) 
        WRITE(NFECRA,*) ((PHYSOL(N,M,1),M=1,NPPEL),N=1,NPOUE)
C        
        WRITE(NFECRA,2071) 
        WRITE(NFECRA,*) NPOINS
        WRITE(NFECRA,2072) 
        WRITE(NFECRA,*) ((PHYSOL(N,M,2),M=1,NPPEL),N=1,NPOUE)
C
        WRITE(NFECRA,2081) 
        WRITE(NFECRA,*) NPOINS
        WRITE(NFECRA,2082) 
        WRITE(NFECRA,*) NBPHYS-2
        WRITE(NFECRA,2083) 
        WRITE(NFECRA,*) ((PHYSOL(N,M,3),M=1,NPPEL),N=1,NPOUE)
C
C
      ENDIF
C
      GOTO 300
C
C     3. Erreur de lecture sur le fichier
C     ===================================
 9999 WRITE(NFECRA,3000) CHAINE
      STOP
C
  300 CONTINUE
C--------
C FORMATS
C--------
 1000 FORMAT(A200)
C
 1110 FORMAT(/,' *** LECLIM : Condition de Dirichlet',/,
     *         14X,'Valeur : ',E12.5,4X,'References : ',32I3)
 1120 FORMAT(/,' *** LECLIM : Condition de type flux',/,
     *         14X,'Valeur : ',E12.5,4X,'References : ',32I3)
 1130 FORMAT(/,' *** LECLIM : Condition de type coefficient ',
     *         'd''echange',/,
     *         14X,'Temperature : ',E12.5,4X,'Coefficient : ',E12.5,/,
     *         14X,'References : ',32I3)
 1140 FORMAT(/,' *** LECLIM : Resistance de contact ',/,
     *         14X,'Coefficient : ',E12.5,4X,'References : ',32I3)
 1200 FORMAT(/,' *** LECLIM : Flux volumiques',/,
     *         14X,'Valeur : ',E12.5,4X,'References : ',32I3)
 1161 FORMAT(/,' %% ERREUR LECLIM : LE TYPE DE TRANSFORMATION INDIQUE',
     &       ' POUR LES NOEUDS PERIODIQUES N''EST PAS RECONNU',/,
     &       '    ??? ',A5)
 1162 FORMAT(/,' %% ERREUR LECLIM : LE TYPE DE CONDITION A LA LIMITE',
     &       ' CITE N''EST PAS RECONNU',/,
     &       '    ??? ',A)
 1170 FORMAT(/,' *** LECLIM : Condition de type rayonnement infini ',/,
     *         14X,'Temperature exterieure: ',E12.5,4X,
     *             'Emissivite : ',E12.5,/,
     *         14X,'References : ',32I3)
C
 1310 FORMAT(/,' *** LECLIM : Masse volumique',/,
     *         14X,'Valeur : ',E12.5,4X,'References : ',32I3)
 1320 FORMAT(/,' *** LECLIM : Chaleur specifique',/,
     *         14X,'Valeur : ',E12.5,4X,'References : ',32I3)
 1330 FORMAT(/,' *** LECLIM : Conductivite isotrope',/,
     *         14X,'Valeur : ',E12.5,4X,'References : ',32I3)
 1340 FORMAT(/,' *** LECLIM : Conductivite orthotrope',/,
     *         14X,'K11,K22,K33 : ',3E12.5,/,
     *         14X,'References : ',32I3)
 1350 FORMAT(/,' *** LECLIM : Conductivite anisotrope',/,
     *         14X,'K11,K22,K33 : ',3E12.5,/,
     *         14X,'TETA X, TETA Y, TETA Z :',3E12.5,/,
     *         14X,'References : ',32I3)
 1351 FORMAT(/,' %% ERREUR LECLIM : LA CONDITION PHYSIQUE INDIQUEE',
     &       ' N''EST PAS RECONNUE',/,
     &       '    ??? ',A)
C
 1410 FORMAT(/,' *** LECLIM : Epaisseur de la coque',/,
     *         14X,'Valeur : ',E12.5,4X,'References : ',32I3)
 1420 FORMAT(/,' *** LECLIM : Invariant de Gauss (1/R)',/,
     *         14X,'Valeur : ',E12.5,4X,'References : ',32I3)
 1430 FORMAT(/,' *** LECLIM : Conductivites suivant la coque ',
     *         'et l''epaisseur',/,
     *         14X,'Valeurs : ',2E12.5,4X,'References : ',32I3)
 1440 FORMAT(/,' %% ERREUR LECLIM : LA CONDITION INDIQUEE POUR LE',
     &       ' MODELE COQUE N''EST PAS RECONNUE',/,
     &       '    ??? ',A)
C
 1510 FORMAT(/,' *** LECLIM : Solide en rotation sur lui-meme ',/,
     *         14X,'Rotation : ',9E12.5,/,
     *         14X,'References : ',32I3)
 1520 FORMAT(/,' *** LECLIM : Solide en translation ',/,
     *         14X,'Translation : ',3E12.5,/,
     *         14X,'Vitesse : ',E12.5,
     *           4X,'References : ',32I3)
 1529 FORMAT(/,' %% ERREUR LECLIM : Translation d''un solide ',/,
     *         '    On ne peut translater le solide que dans son',
     *         ' integralite ==> reference = -1',/)
 1530 FORMAT(/,' *** LECLIM : Solide en translation : CL sur les ',
     *         'noeuds non en regard du fluide',/,
     *         14X,'T : ',E12.5,4X,'h : ',E12.5,
     *           4X,'References : ',32I3)
 1540 FORMAT(/,' *** LECLIM : Solide en translation : temperature ',
     *         'd''entree :',E12.5,/,
     *           14X,'References : ',32I3)
 1549 FORMAT(/,' %% ERREUR LECLIM : Translation d''un solide ',/,
     *         '    La temperature d''entree doit etre identique',
     *         ' sur tous les noeuds ==> reference = -1',/)
 1550 FORMAT(/,' *** LECLIM : Solide en translation : references',
     *         ' des noeuds des extremites :',32I3)
 1560 FORMAT(/,' %% ERREUR LECLIM : MOT-CLE "SMOB", LE PARAMETRE',
     &       ' SUIVANT N''EST PAS RECONNU',/,
     &       '    ??? ',A)
C
 1118 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''CLIM'' ''DIRICHLET'' ',/,
     *  20X,'alors qu''aucun Dirichlet n''a ete defini',/,
     *  20X,'(cf ''REFERENCES NOEUDS SOLIDES AVEC DIRICHLET'')') 
 1128 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''CLIM'' ''FLUX'' ',/,
     *  20X, 'alors qu''aucun flux n''a ete defini',/, 
     *  20X,'(cf ''REFERENCES NOEUDS OU FACES SOLIDES AVEC FLUX'')') 
 1138 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''CLIM'' ''COEF ECH'' ',/,
     *  20X,'alors qu''aucun coefficient d''echange n''a ete defini',/, 
     *  20X,'(cf ''REFERENCES NOEUDS OU FACES SOLIDES AVEC ',
     *        'COEFFICIENT D ECHANGE'')') 
 1147 FORMAT(/,' %% ERREUR LECLIM : Les resistances de contact ne',
     *       ' peuvent etre prise en compte',/,
     *  20X,'dans le cas du modele coque')
 1148 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''CLIM'' ''RES CONTACT'' ',/,
     *  20X,'alors qu''aucune resistance de contact n''a ete definie',/, 
     *  20X,'(cf ''REFERENCES NOEUDS OU FACES SOLIDES AVEC ',
     *        'RESISTANCE DE CONTACT'')') 
 1158 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''CLIM'' ''RAYONNEMENT'' ',/,
     *  20X,'alors qu''aucun noeud avec rayonnement n''a ete defini',/, 
     *  20X,'(cf ''REFERENCES NOEUDS OU FACES SOLIDES AVEC ',
     *          'RAYONNEMENT'')')
 1168 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''CLIM'' ''PERIODICITE'' ',/,
     *  20X,'alors qu''aucun noeud periodique n''a ete defini',/, 
     *  20X,'(cf ''REFERENCES NOEUDS SOLIDES PERIODIQUES'')')
 1178 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''CLIM'' ''RAYT INFINI'' ',/,
     *  20X,'alors qu''aucun noeud ou face de ce type ',
     *       'n''a ete defini',/, 
     *  20X,'(cf ''REFERENCES NOEUDS OU FACES SOLIDES AVEC ',
     *        'RAYONNEMENT INFINI'')') 
C
 1728 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''CVOL''  ',/,
     *  20X,'alors qu''aucun noeud avec flux volumique',
     *      ' n''a ete defini',/, 
     *  20X,'(cf ''REFERENCES NOEUDS SOLIDES AVEC FLUX VOLUMIQUES'')')
C
 1337 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''CPHY'' ''K ISOTROPE'' ',/,
     *  20X,'non autorisee dans le cas du modele coque',/, 
     *  20X,'(cf ''CCOQ''  ''K SELON COQUE ET EPAISSEUR'')')
 1338 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''CPHY'' ''K ISOTROPE'' ',/,
     *  20X,'alors que le materiau n''est pas defini comme isotrope',/, 
     *  20X,'(cf ''ISOTROPIE DU MATERIAU='')')
 1347 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''CPHY'' ''K ORTHOTROPE'' ',/,
     *  20X,'non autorisee dans le cas du modele coque',/, 
     *  20X,'(cf ''CCOQ''  ''K SELON COQUE ET EPAISSEUR'')')
 1348 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''CPHY'' ''K ORTHOTROPE'' ',/,
     *  20X,'alors que le materiau n''est pas defini ',
     *      'comme orthotrope',/, 
     *  20X,'(cf ''ISOTROPIE DU MATERIAU='')')
 1357 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''CPHY'' ''K ANISOTROPE'' ',/,
     *  20X,'non autorisee dans le cas du modele coque',/, 
     *  20X,'(cf ''CCOQ''  ''K SELON COQUE ET EPAISSEUR'')')
 1358 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''CPHY'' ''K ANISOTROPE'' ',/,
     *  20X,'alors que le materiau n''est pas defini ',
     *      'comme anisotrope',/, 
     *  20X,'(cf ''ISOTROPIE DU MATERIAU='')')
C
 1418 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''CCOQ'' ''EPAISSEUR'' ',/,
     *  20X,'sans objet dans le cas du modele general')
 1428 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''CCOQ'' ''INVARIANT GAUSS'' ',/,
     *  20X,'sans objet dans le cas du modele general')
 1438 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''CCOQ'' ''K SELON COQUE ET EPAISSEUR'' ',/,
     *  20X,'sans objet dans le cas du modele general')
C
 1518 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''SMOB'' ''R'' ',/,
     *  20X,'alors qu''aucun noeud n''est defini comme etant ',
     *       'en rotation',/, 
     *  20X,'(cf ''REFERENCES NOEUDS SOLIDES EN ROTATION'')')
 1528 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''SMOB'' ''T'' ',/,
     *  20X,'alors que le solide n''est pas defini comme etant ',
     *       'en translation',/, 
     *  20X,'(cf ''SOLIDE EN TRANSLATION='')')
 1538 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''SMOB'' ''CL NOEUDS ISOLES'' ',/,
     *  20X,'alors que le solide n''est pas mobile ',/,
     *  20X,'(cf ''SOLIDE EN TRANSLATION='' ou',
     *     ' ''REFERENCES NOEUDS SOLIDES EN ROTATION'')')
 1548 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''SMOB'' ''TEMPERATURE ENTREE'' ',/,
     *  20X,'alors que le solide n''est pas en translation',/,
     *  20X,'(cf ''SOLIDE EN TRANSLATION='')')
 1558 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''SMOB''  ''REFERENCES EXTREMITES'' ',/,
     *  20X,'alors que le solide n''est pas en translation ',/,
     *  20X,'(cf ''SOLIDE EN TRANSLATION='')')
 1721 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''HIST''  ''NOEUDS'' ',/,
     *   20X,'Le nombre de noeuds est limite a ',I3,' par ligne',/,
     *   20X,'Utilisez le mot-cle plusieurs fois pour definir ',
     *       ' tous vos noeuds')
 1722 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *         ' ''HIST''  ''NOEUDS'' ',/,
     *  20X,'le nombre d''historiques',
     *      ' sur le solide est limite a ',I4)
C
 1821 FORMAT(/,' %% ERREUR LECLIM : utilisation du mot-cle',
     *       '  ''REGU'' ''REFERENCES'' ',/,
     *   20X,'Le nombre de references limite a ',I3)
C
 2001 FORMAT(/,' --> LECLIM : Numeros des noeuds avec flux')
 2002 FORMAT(/,' --> LECLIM : Valeurs des flux')
 2003 FORMAT(/,' --> LECLIM : Numeros des faces avec flux')
 2011 FORMAT(/,' --> LECLIM : Numeros des noeuds avec Dirichlet')
 2012 FORMAT(/,' --> LECLIM : Valeurs des Dirichlet')
 2021 FORMAT(/,' --> LECLIM : Numeros des noeuds avec coeff d''echange')
 2022 FORMAT(/,' --> LECLIM : Valeurs de la temperature')
 2023 FORMAT(/,' --> LECLIM : Valeurs des coeff d''echange')
 2024 FORMAT(/,' --> LECLIM : Numeros des faces avec coeff d''echange')
 2031 FORMAT(/,' --> LECLIM : Numeros des noeuds avec resistance de ',
     *                   'contact')
 2032 FORMAT(/,' --> LECLIM : Valeurs de la resistance de contact')
 2033 FORMAT(/,' --> LECLIM : Numeros des faces avec resistance de ',
     *                   'contact')
 2051 FORMAT(/,' --> LECLIM : Numeros des noeuds avec flux volumique')
 2052 FORMAT(/,' --> LECLIM : Valeurs des flux volumiques')
 2061 FORMAT(/,' --> LECLIM : Nombre des points avec masse volumique')
 2062 FORMAT(/,' --> LECLIM : Valeurs de la masse volumique')
 2071 FORMAT(/,' --> LECLIM : Nombre des points avec CP')
 2072 FORMAT(/,' --> LECLIM : Valeurs de CP')
 2081 FORMAT(/,' --> LECLIM : Nombre des points avec conductivite')
 2082 FORMAT(/,' --> LECLIM : Nombre de coeff de la mat de ',
     *                       'conductivite')
 2083 FORMAT(/,' --> LECLIM : Valeurs de la conductivite')
C
 3000 FORMAT(/,' %% ERREUR LECLIM : Erreur dans le fichier de donnees',
     * /,20X,'au cours de la lecture des conditions limites et ',
     *       'physiques',/,
     *   20X,'Ligne concernee : ',A)
C
C----
C FIN
C----
C
      RETURN
      END
