C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE FLVNUM
C                       *****************
C
C      -----------------------------------------
     * (NFLUVS,NBFLVS,NREFS,NPOINS,NREFE,NELEMS)
C      -----------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            ETABLISSEMENT DE LA NUMEROTATION LOCALE DES               *
C            FLUX VOLUMIQUES                                           *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NFLUVS   ! TE ! R  ! Numero des noeuds portant un flux volumique  !
C !  NBFLVS   !  E ! D  ! Nombre de noeuds portant un flux volumique   !
C !  NREFS    ! TE ! D  ! References des noeuds solides                !
C !  NPOINS   !  E ! D  ! Nombre de noeuds du maillage solide          !
C !  NREFE    ! TE ! D  ! References des elements solides              !
C !  NELEMS   !  E ! D  ! Nombre d'elements du maillage solide         !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : INISOL
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "xrefer.h"
#include "nlofes.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NBFLVS,NFLUVS(NBFLVS)
      INTEGER NPOINS,NREFS(NPOINS),NELEMS,NREFE(NELEMS)
C
C.. Variables internes
      INTEGER NUMREF,N,N1
      INTEGER NFLV
      LOGICAL ERR
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
C
      DO 1 N=1,NBFLVS
        NFLUVS(N) = 0
    1 CONTINUE
C
      NFLV = 0
C
      IF (NDFLUV.EQ.1) THEN
C
        DO 200 N=1,NPOINS
          NUMREF = ABS(NREFS(N))
          DO 201 N1=1,NRFMAX
            IF (IREFSV(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NFLV = NFLV + 1
              NFLUVS(NFLV) = N
             ENDIF
C
  201     CONTINUE
  200    CONTINUE
C
      ELSE
C
        DO 210 N=1,NELEMS
C
          NUMREF = ABS(NREFE(N))
          DO 211 N1=1,NRFMAX
            IF (IREFSV(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NFLV = NFLV + 1
              NFLUVS(NFLV) = N
             ENDIF
C
  211     CONTINUE
  210    CONTINUE
C
      ENDIF
C
C     2- CONTROLE DES DIMENSIONS
C     ==========================
C
      ERR = .FALSE.
C
      IF (NFLV.NE.NBFLVS) THEN
         WRITE(NFECRA,2000) 'flux volumique',NFLV,NBFLVS
         ERR = .TRUE.
      ENDIF
C
C
C
C     3- IMPRESSIONS DE CONTROLE
C     ==========================
C
      IF (NBLBLA.GT.0) THEN
       IF (NDFLUV.EQ.1) THEN
         WRITE(NFECRA,3000) NBFLVS
       ELSE
         WRITE(NFECRA,3001) NBFLVS
       ENDIF
      ENDIF
C
      IF (NBLBLA.EQ.10) THEN
        IF (NBFLVS.GT.0) THEN
          IF (NDFLUV.EQ.1) THEN
            WRITE(NFECRA,3010) 
          ELSE
            WRITE(NFECRA,3011) 
          ENDIF
          WRITE(NFECRA,3009) (NFLUVS(N),N=1,NBFLVS)
        ENDIF
      ENDIF
C
C     6- ARRET DU PROGRAMME EN CAS D'ERREUR DE DIMENSION
C     ==================================================
      IF (ERR) STOP

C--------
C FORMATS
C--------
C
 2000 FORMAT(' %% ERREUR FLVNUM : incoherence sur les ',A30,/,
     &       '                    On en compte :',I9,/,
     &       '                    Il y en a ',I9,' de declares')
C
 3000 FORMAT(/,' *** FLVNUM : Nombre de noeuds du solide',/,
     &         '              portant un flux volumique  : ',I10)
 3001 FORMAT(/,' *** FLVNUM : Nombre d''elements du solide',/,
     &         '              portant un flux volumique  : ',I10)
C 
 3009 FORMAT(8X,12I9)
 3010 FORMAT(/,8X,'Liste des noeuds solides avec flux volumique :',/)
 3011 FORMAT(/,8X,'Liste des elements solides avec flux volumique :',/)
C
C----
C FIN
C----
      END
