C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE DICOCT
C                       *****************
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   VERIFICATION ORTHOGRAPHIQUE DU FICHIER DE DONNEES       *
C              On verifie la reconnaissance des mots-cles)             *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/OPTCT/ !      ! R  !                                             !
C   !/NLOFCT/!      ! D  !                                             !
C   !/NLOFES/!      ! D  !                                             !
C   !__________________________________________________________________!
C   ! FONCTIONS IMPLICITES                                             !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : POSCOT
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : INISO1
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "nlofes.h"
#include "syrth.h"
#include "nlofct.h"
C
C**********************************************************************
C
C
      INTEGER I1,I2,LCH
      LOGICAL ERR
      CHARACTER*200 CHAINE
C
C**********************************************************************
C
C     0- INITIALISATIONS
C     ==================
C
      REWIND(NFCLCT)
      ERR = .FALSE.
C
C     1- LECTURE DU FICHIER
C     =====================
C
C
   10 CONTINUE
C
      CHAINE = ' '
      READ(NFCLCT,1000,END=999) CHAINE
C
      IF (CHAINE(1:1) .EQ. '/') GOTO 10
C
      CALL POSCOT(CHAINE,I1,I2,LCH)
C
      IF (I1 .EQ. 0) GOTO 10
C
C
C     2- COMPARAISON AVEC LES MOTS-CLES AUTORISES
C     -------------------------------------------
C
      IF (CHAINE(I1:I2).EQ.'ECRITURE MAILLAGE SOLIDE=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.'ECRITURE MAILLAGE PEAU FLUIDE=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.'ECRITURE RESULTATS PEAU FLUIDE=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.'ECRITURE CHRONO PEAU FLUIDE=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.'HISTORIQUES CONDUCTION=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ. 'PAS DES SORTIES CHRONO SOLIDE=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.'PAS DES SORTIES LISTING SOLIDE=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.'NOMBRE ITERATIONS SOLVEUR SOLIDE=') 
     * THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.'FREQUENCE DU CALCUL SOLIDE=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.'ISOTROPIE DU MATERIAU=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.'NOMBRE DE PAS DE TEMPS SOLIDES=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.'PRECISION POUR LE SOLVEUR SOLIDE=') 
     * THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.'PAS DE TEMPS SOLIDE=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.'PAS DE TEMPS MULTIPLES=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.'PAS DE TEMPS AUTOMATIQUE=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.'NOMBRE DE DIRECTIONS PERIODIQUES=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.'SOLIDE EN TRANSLATION=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.'NIVEAU DES IMPRESSIONS POUR LE SOLIDE=') 
     &  THEN
        GOTO 10
C
      ELSEIF 
     &(CHAINE(I1:I2).EQ.'LECTURE DES CORRESPONDANTS SUR FICHIER=') THEN
        GOTO 10
C
      ELSEIF 
     &(CHAINE(I1:I2).EQ.'STOCKAGE DES CORRESPONDANTS SUR FICHIER=') THEN
        GOTO 10
C
      ELSEIF 
     &(CHAINE(I1:I2).EQ.
     & 'RECHERCHE OPTIMISEE DES CORRESPONDANTS - ELOIGNEMENT MAXI=') 
     & THEN
        GOTO 10
C
      ELSEIF 
     &(CHAINE(I1:I2).EQ.
     &  'CONDITIONS LIMITES PAR NOEUD OU PAR FACE=') THEN
        GOTO 10
C
      ELSEIF 
     &(CHAINE(I1:I2).EQ.'TITRE POUR LE CALCUL SOLIDE=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 
     *  'PRISE EN COMPTE DU RAYONNEMENT CONFINE=') THEN  
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 
     *  'DEFINITION DES PROPRIETES PHYSIQUES PAR=') THEN  
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 
     *  'DEFINITION DES FLUX VOLUMIQUES PAR=') THEN  
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 
     *  'CHAMP DE TEMPERATURES MAXIMALES=') THEN  
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 
     *  'ACTIVATION DU MODULE DE REGULATION=') THEN  
        GOTO 10
C
C     3- COMPARAISON AVEC LES TYPES DE REFERENCES AUTORISEES
C     ------------------------------------------------------
C
      ELSEIF (CHAINE(I1:I2).EQ.
     *        'REFERENCES NOEUDS OU FACES SOLIDES COUPLE(E)S') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.
     &  'REFERENCES NOEUDS SOLIDES AVEC DIRICHLET') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.
     &   'REFERENCES NOEUDS OU FACES SOLIDES AVEC FLUX') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.
     & 'REFERENCES NOEUDS OU FACES SOLIDES AVEC COEFFICIENT D ECHANGE') 
     &  THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.
     & 'REFERENCES NOEUDS OU ELEMENTS SOLIDES AVEC FLUX VOLUMIQUES') 
     &  THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.
     & 'REFERENCES NOEUDS OU FACES SOLIDES AVEC RESISTANCE DE CONTACT') 
     &  THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.
     & 'REFERENCES NOEUDS OU FACES SOLIDES AVEC RAYONNEMENT INFINI') 
     &  THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.
     & 'REFERENCES NOEUDS SOLIDES PERIODIQUES') THEN
        GOTO 10
C
C
C     3- COMPARAISON AVEC LES TYPES CONDITIONS AUTORISEES
C     ---------------------------------------------------
C
      ELSEIF (CHAINE(I1:I2) .EQ. 'CLIM') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 'CVOL') THEN  
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 'CPHY') THEN  
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 'CINI') THEN  
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 'HIST') THEN  
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 'BILAN FLUX SURFACIQUES') THEN  
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 'BILAN FLUX VOLUMIQUES') THEN  
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 'REGU') THEN  
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 'DIMENSION DU PROBLEME=') THEN  
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 
     &     'AXE D AXISYMETRIE (AUCUN,OX,OY)=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 'SUITE DE CALCUL=') THEN  
        GOTO 10
C
C
C     5- MOT-CLE NON RECONNU
C     ----------------------
C
      ELSE
        ERR = .TRUE.
        WRITE (NFECRA,5000) CHAINE
        GOTO 10
C
      ENDIF
C
 999  CONTINUE
C
      IF (ERR) STOP
C
C
C--------
C FORMATS
C--------
 1000 FORMAT(A200)
 5000 FORMAT(/,' %% ERREUR DICOCT : MOT-CLE NON RECONNU ',/,
     &       '--> "',A,'"')
C----
C FIN
C----
C
      RETURN
      END
