C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=CORPER,SSI=0
C
                        SUBROUTINE CORPER
C                       *****************
C
     * (NDIM,NPOINS,NBPRIO,NBCOPR,NPRIOS,NPER1,NPER2,
     *  COORDS,XTR,YTR,ZTR)
C
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------                                                           *
C            RECHERCHE DES CORRESPONDANTS                              *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/NLOFES/!      ! D  !                                             !
C   !/XREFER/!      ! D  !                                             !
C   !__________________________________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : IPERIO
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "xrefer.h"
C
C**********************************************************************
C
      INTEGER NNX
      PARAMETER (NNX=8)
C
C..Variables externes
      INTEGER NDIM,NPOINS,NBPRIO,NBCOPR,NPRIOS(NBPRIO,1+NBCOPR)
      INTEGER NPER1(NPOINS),NPER2(NPOINS)
      DOUBLE PRECISION COORDS(NPOINS,NDIM)
      DOUBLE PRECISION XTR(NPOINS),YTR(NPOINS),ZTR(NPOINS)
C
C..Variables internes
      INTEGER N,M,NLMIN,NC,NNL(NNX)
      DOUBLE PRECISION DMIN,DMAX,X1,Y1,Z1,X2,Y2,Z2,D2
      LOGICAL ERR
      DOUBLE PRECISION EPSMAC
C
C**********************************************************************
C
C     0- Initialisations
C     ==================
      DMAX = 0.
      EPSMAC = 1.E-30
      ERR = .FALSE.
C
      DO 10 N=1,NBPRIO
        X2 = ABS(COORDS(NPRIOS(N,1),1))
        Y2 = ABS(COORDS(NPRIOS(N,1),2))
        IF (NDIM .EQ. 3)  Z2 = ABS(COORDS(NPRIOS(N,1),3))
        IF (X2 .LT. EPSMAC) X2 = 0.D0
        IF (Y2 .LT. EPSMAC) Y2 = 0.D0
        IF (NDIM .EQ. 3 .AND. Z2 .LT. EPSMAC) Z2 = 0.D0
  10  CONTINUE
C
C
      DO 100 N=1,NBPRIO
C
        IF (NPER1(N).NE.0) THEN
C
          DMIN  = 1.E6
          NLMIN = 0
          X1 = XTR(NPRIOS(N,1))
          Y1 = YTR(NPRIOS(N,1))
          IF (NDIM.EQ.3) Z1 = ZTR(NPRIOS(N,1))
C
          DO 110 M = 1,NBPRIO
            IF (NPER2(M).NE.0) THEN
              X2 = COORDS(NPRIOS(M,1),1)
              Y2 = COORDS(NPRIOS(M,1),2)
              IF (NDIM.EQ.3) Z2 = COORDS(NPRIOS(M,1),3)
              D2 = (X2-X1)*(X2-X1) + (Y2-Y1)*(Y2-Y1) 
              IF (NDIM.EQ.3) D2 = D2 + (Z2-Z1)*(Z2-Z1) 
              IF (D2.LT.DMIN) THEN
                DMIN = D2
                NLMIN = M
              ENDIF
            ENDIF
  110     CONTINUE
C
          IF (NLMIN.NE.0 .AND. NBCOPR.EQ.1) THEN
            NPRIOS(N,2)     = NLMIN
            NPRIOS(NLMIN,2) = N
          ELSEIF (NLMIN.NE.0) THEN
            NC = 1
  120       NC = NC + 1
            IF (NPRIOS(N,NC).NE.0) GOTO 120
            IF (NC.GT.NBCOPR+1) THEN
              WRITE(NFECRA,1001) N,NPRIOS(N,1)
              ERR = .TRUE.
            ELSE
              NPRIOS(N,NC) = NLMIN
            ENDIF
            NC = 1
  130       NC = NC + 1
            IF (NPRIOS(NLMIN,NC).NE.0) GOTO 130
            IF (NC.GT.NBCOPR+1) THEN
              WRITE(NFECRA,1001) NLMIN,NPRIOS(NLMIN,1)
              ERR = .TRUE.
            ELSE
              NPRIOS(NLMIN,NC) = N
            ENDIF
          ELSE
            WRITE(NFECRA,1002) N,NPRIOS(N,1)
            ERR = .TRUE.
          ENDIF

          IF (DMIN.GT.DMAX) DMAX = DMIN
C
        ENDIF
C
  100 CONTINUE
C
C     2- Impressions
C     --------------
      IF (NBLBLA.GE.10) THEN
        WRITE(NFECRA,2000)
        DO 200 N=1,NBPRIO
          DO 210 M=1,NBCOPR
            NNL(M) = NPRIOS(N,M+1)
            IF (NNL(M).GT.0) NNL(M) = NPRIOS(NNL(M),1)
  210     CONTINUE
          WRITE(NFECRA,2001) N,NPRIOS(N,1),
     &                      (NNL(M),M=1,NBCOPR)
  200   CONTINUE
      ENDIF
C
      IF (NBLBLA.GT.0) WRITE(NFECRA,2010) DMAX 
C
C     3- Arret en erreur
C     ------------------
      IF (ERR) STOP
C
C--------
C FORMATS
C--------
 1001 FORMAT(/,' %% ERREUR CORPER : Le nombre maxi de correspondants',
     &       ' pour un noeud est depasse',/,
     &       '    pour le noeud ',I6,' de numero global ',I6)
 1002 FORMAT(/,' %% ERREUR CORPER : On n''a pas trouve de correspondant'
     &       ,' pour le noeud periodique : ',I6,/,
     &       '                    de numero global : ',I6 )
 2000 FORMAT(' *** CORPER : Correspondants des noeuds periodiques :')
 2001 FORMAT(9I6)
 2010 FORMAT(' *** CORPER : Distance relative maximale entre 2 ',
     &       'noeuds periodiques : ',E12.5)
C----
C FIN
C----
C
      RETURN
      END
