C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE CCONDI
C                       *****************
C
     * ( VAL,NREF,NPE,NCOND,VCOND,NBCOND,IREF,NB )
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   CODAGE DES CONDITIONS (LIMITES, PHYSIQUES,...)          *
C              DANS LES TABLEAUX ADAPTES                               *
C              ON REPERE LES NOEUDS EN UTILISANT LES REFERENCES        *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! VAL    !   R  ! D  ! VALEUR DE LA CONDITION A APPLIQUER          !
C   ! NREF   !  TE  ! D  ! REFERENCES DES NOEUDS OU ELTS SOLIDES       !
C   ! NPE    !   E  ! D  ! NOMBRE DE NOEUDS OU ELT DU MAILLAGE SOLIDE  !
C   ! NCOND  !  TE  ! D  ! NUMERO GLOB DES NOEUDS DE CONDITION "COND"  !
C   ! VCOND  !  TR  ! M  ! VALEUR DE LA CONDITION "COND"               !
C   ! NBCOND !   E  ! D  ! NOMBRE DE NOEUDS DE CONDITION "COND"        !
C   ! IREF   !  TE  ! D  ! REFERENCES SUR LESQUELLES IL FAUT APPLIQUER !
C   !        !      !    ! LA CONDITION "COND"                         !
C   ! NB     !   E  ! D  ! NOMBRE DE REFERENCES CONCERNEES             !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/NLOFES/!      ! D  !                                             !
C   !__________________________________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : LECLIM
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "nlofes.h"
#include "xrefer.h"
#include "optct.h"
C
C**********************************************************************
C
C..Variables externes
      INTEGER NPE,NBCOND,NB
      INTEGER NREF(NPE),NCOND(NBCOND),IREF(NRFMAX)
      DOUBLE PRECISION VCOND(NBCOND),VAL
C
C..Variables internes
      INTEGER N,N1,NR,NBRE,NUMGLO,NUMREF
C
C**********************************************************************
C
C     0- Initialisations
C     ------------------
      NBRE = 0
C
C     1- Cas ou la condition s'applique sur tous les noeuds
C     -----------------------------------------------------
C
      IF (IREF(1) .EQ. -1 ) THEN
C
        DO 110 N=1,NBCOND
           VCOND(N) = VAL
           NBRE = NBRE + 1
  110  CONTINUE
C
      ELSE
C
C     2- Application de la condition aux references citees
C     ----------------------------------------------------
C
C
       DO 200 N1=1,NB
C
         NR = IREF(N1)
C
         DO 210 N=1,NBCOND
C
           NUMGLO = NCOND(N)
           NUMREF = NREF(NUMGLO)
C
           IF (NUMREF .EQ. NR) THEN
              VCOND(N) = VAL
              NBRE = NBRE + 1
           ENDIF
C
  210   CONTINUE
  200  CONTINUE 
C
      ENDIF
C
C
C     3- Impressions de controle
C     --------------------------
C
      IF (NBLBLA.EQ.10) WRITE(NFECRA,3000) NBRE
C
C
C--------
C FORMATS
C--------
 3000 FORMAT('     CCONDI : Nombre de noeuds traites :',I6)
C----
C FIN
C----
C
      RETURN
      END
