C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                    *****************
                     SUBROUTINE BILFLU
C                    *****************
C
C     ---------------------------------------------------
     *( NFFLUS,VFFLUS,NBFFLU,NFECHS,VFECHS,NBFECH, 
     *  NFRESC,VFRESC,NELERC,
     *  NFRAYS,VFRAYS,NELERA,
     *  NFRAIS,VFRAIS,NBFRAI,
     *  NFCOUS,VFCOUS,NELESS,
     *  TMPSA,NODEUS,SURFUS, 
     *  NPOINS,NDIM,NELEUS,NDMASS,NREFAL,COORDS)
C     ---------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     BILANS DE FLUX                                    *
C                                                                      *
C      Les flux au bord du solide sont de plusieurs types:             *
C          Flux dus au couplage thermique fluide -solide               *
C          Flux imposes par l'utilisateur                              *
C          Flux ayant pour origine un coefficient d'echange            *
C          Flux ayant pour origine une resitance de contact            *
C          Flux ayant pour origine un rayonnement                      *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   NFFLUS  !  TE  ! D  ! No de facette flux ---> face glob        !
C   !   VFFLUS  !  TR  ! D  ! Valeur des flux a chaque point de la face!
C   !   NBFFLU  !  E   ! D  ! Nombre de facette de type flux           ! 
C   !   NFECHS  !  TE  ! D  ! No de facette echange ---> face glob     !
C   !   VFECHS  !  TR  ! D  ! Valeur des echan aux points de la face   !
C   !   NBFECH  !  E   ! D  ! Nombre de facette de type echange        ! 
C   !   NFRESC  !  TE  ! D  ! No de facette resistance ---> face glob  !
C   !   VFRESC  !  TR  ! D  ! Valeur des resista aux points de la face !
C   !   NELERC  !  E   ! D  ! Nombre de facette de type resistance     ! 
C   !   NFRAYS  !  TE  ! D  ! No de facette rayonnement ---> face glob !
C   !   VFRAYS  !  TR  ! D  ! Valeur du rayo aux points de la face     !
C   !   NELERA  !  E   ! D  ! Nombre de facette de type rayonnement    ! 
C   !   NFRAIS  !  TE  ! D  ! No de facette rayonnt inf -->  face glob !
C   !   VFRAIS  !  TR  ! D  ! Valeur du rayo inf aux points de la face !
C   !   NBFRAI  !  E   ! D  ! Nombre de facette de type rayonnement inf! 
C   !   NFCOUS  !  TE  ! D  ! No de facette couplee ---> face glob     !
C   !   VFCOUS  !  TR  ! D  ! Valeur du couplage aux points de la face !
C   !   NELESS  !  E   ! D  ! Nombre de facette de type couplee        ! 
C   !   B       !  TR  ! R  ! SECOND MEMBRE                            !
C   !   NODEUS  !  TE  ! D  ! NOEUDS DE BORD( LOCALE 2D --> GLOBALE 3D)!
C   !   SURFUS  !  TR  ! D  ! EN 3D SURFACE DU TRIANGLE DE BORD (flux) !
C   !           !      !    ! EN 2D LONGUEUR DU SEGMENT DE BORD (flux) !
C   !   COORDS  !  TR  ! D  ! COORDONNEES DES NOEUDS DU MAILLAGE       !
C   !   TRAV    !  TR  ! R  ! TABLEAU DE TRAVAIL                       !
C   !   WCT     !  TR  ! M  ! TABLEAUX DE TRAVAIL. ATTENTION On utilise!
C   !           !      !    ! uniquement les  premieres cases          !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ????
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : ????
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "rayonn.h"
#include "bilan.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NPOINS,NDIM,NELEUS,NDMASS
      INTEGER NBFFLU,NBFECH,NELERC,NELERA,NBFRAI,NELESS
      INTEGER NFFLUS(NBFFLU),NFECHS(NBFECH),NFRESC(NELERC)
      INTEGER NFRAYS(NELERA),NFRAIS(NBFRAI),NFCOUS(NELESS)
      INTEGER NODEUS(NELEUS,NDMASS),NREFAL(NELEUS)
C
      DOUBLE PRECISION VFFLUS(NBFFLU,NDMASS),VFECHS(NBFECH,NDMASS,2)
      DOUBLE PRECISION VFRESC(NELERC,NDMASS,2)
      DOUBLE PRECISION VFRAYS(NELERA,NDMASS,2),VFRAIS(NBFRAI,NDMASS,2)
      DOUBLE PRECISION VFCOUS(NELESS,NDMASS,2)
      DOUBLE PRECISION TMPSA(NPOINS)
      DOUBLE PRECISION SURFUS(NELEUS),COORDS(NPOINS,NDIM)   
C
C..Variables internes
      INTEGER I,J,NB,N1,INODE,NUMREF
      INTEGER I1,I2,I3,I4,I5,I6,NCA
      DOUBLE PRECISION HRAYI(6),S,PHI,S24,S12,R1,R2
      DOUBLE PRECISION F1,F2,F3,F4,F5,F6
      LOGICAL OK 
C
C***********************************************************************
      IF (IAXISY.EQ.1) THEN
         NCA=2
      ELSE
         NCA=1
      ENDIF
C
      S24=1./24.
      S12=1./12.
C
      DO NB=1,NBISMX
        BFLUSU(NB,1)=0.
        BFLUSU(NB,2)=0.
        BFLUSU(NB,3)=0.
      ENDDO
C
C     CALCUL DES CONDITIONS SUR LES FACES DE BORD CONCERNEES
C     =========================================================
C
      DO NB=1,NBILAS
C
        DO I=1,NELESS
          NUMREF=NREFAL(NFCOUS(I))
          OK=.FALSE.
          DO N1=1,NRFMA2
            IF (IRBILS(N1,NB).NE.0 .AND. NUMREF.EQ.N1) OK=.TRUE.
          ENDDO
          IF (OK) THEN
            S=SURFUS(NFCOUS(I))
            PHI=0.
            IF (NDIM.EQ.2 .AND.IAXISY.EQ.0) THEN
              I1=NODEUS(NFCOUS(I),1)
              I2=NODEUS(NFCOUS(I),2)
              I3=NODEUS(NFCOUS(I),3)
              F1=VFCOUS(I,1,2)*(VFCOUS(I,1,1)-TMPSA(I1))
              F2=VFCOUS(I,2,2)*(VFCOUS(I,2,1)-TMPSA(I2))
              F3=VFCOUS(I,3,2)*(VFCOUS(I,3,1)-TMPSA(I3))
              BFLUSU(NB,3)=BFLUSU(NB,3)+(F1+F2+2*F3)*0.25*S
            ELSEIF (NDIM.EQ.2 .AND.IAXISY.NE.0) THEN
              R1 = ABS (COORDS(NODEUS(NFCOUS(I),1),NCA))
              R2 = ABS (COORDS(NODEUS(NFCOUS(I),2),NCA))        
              I1=NODEUS(NFCOUS(I),1)
              I2=NODEUS(NFCOUS(I),2)
              I3=NODEUS(NFCOUS(I),3)
              F1=VFCOUS(I,1,2)*(VFCOUS(I,1,1)-TMPSA(I1))
              F2=VFCOUS(I,2,2)*(VFCOUS(I,2,1)-TMPSA(I2))
              F3=VFCOUS(I,3,2)*(VFCOUS(I,3,1)-TMPSA(I3))
              PHI=6*R2*F3+R2*F1+6*R1*F3+5*R1*F1+5*R2*F2+R1*F2
              BFLUSU(NB,3)=BFLUSU(NB,3)+PHI*S24*S
            ELSE
              I1=NODEUS(NFCOUS(I),1)
              I2=NODEUS(NFCOUS(I),2)
              I3=NODEUS(NFCOUS(I),3)
              I4=NODEUS(NFCOUS(I),4)
              I5=NODEUS(NFCOUS(I),5)
              I6=NODEUS(NFCOUS(I),6)
              F1=VFCOUS(I,1,2)*(VFCOUS(I,1,1)-TMPSA(I1))
              F2=VFCOUS(I,2,2)*(VFCOUS(I,2,1)-TMPSA(I2))
              F3=VFCOUS(I,3,2)*(VFCOUS(I,3,1)-TMPSA(I3))
              F4=VFCOUS(I,4,2)*(VFCOUS(I,4,1)-TMPSA(I4))
              F5=VFCOUS(I,5,2)*(VFCOUS(I,5,1)-TMPSA(I5))
              F6=VFCOUS(I,6,2)*(VFCOUS(I,6,1)-TMPSA(I6))
              PHI=F1+F2+F3+ 3*(F4+F5+F6)
              BFLUSU(NB,3)=BFLUSU(NB,3)+PHI*S12*S
           ENDIF
          ENDIF
        ENDDO
C
        DO I=1,NBFFLU
          NUMREF=NREFAL(NFFLUS(I))
          OK=.FALSE.
          DO N1=1,NRFMA2
            IF (IRBILS(N1,NB).NE.0 .AND. NUMREF.EQ.N1) OK=.TRUE.
          ENDDO
          IF (OK) THEN
            S=SURFUS(NFFLUS(I))
            PHI=0.
            IF (NDIM.EQ.2 .AND.IAXISY.EQ.0) THEN
              I1=NODEUS(NFFLUS(I),1)
              I2=NODEUS(NFFLUS(I),2)
              I3=NODEUS(NFFLUS(I),3)
              F1=VFFLUS(I,1)
              F2=VFFLUS(I,2)
              F3=VFFLUS(I,3)
              BFLUSU(NB,1)=BFLUSU(NB,1)+(F1+F2+2*F3)*0.25*S
            ELSEIF (NDIM.EQ.2 .AND.IAXISY.NE.0) THEN
              R1 = ABS (COORDS(NODEUS(NFFLUS(I),1),NCA))
              R2 = ABS (COORDS(NODEUS(NFFLUS(I),2),NCA))        
              I1=NODEUS(NFFLUS(I),1)
              I2=NODEUS(NFFLUS(I),2)
              I3=NODEUS(NFFLUS(I),3)
              F1=VFFLUS(I,1)
              F2=VFFLUS(I,2)
              F3=VFFLUS(I,3)
              PHI=6*R2*F3+R2*F1+6*R1*F3+5*R1*F1+5*R2*F2+R1*F2
              BFLUSU(NB,1)=BFLUSU(NB,1)+PHI*S24*S
            ELSE
              I1=NODEUS(NFFLUS(I),1)
              I2=NODEUS(NFFLUS(I),2)
              I3=NODEUS(NFFLUS(I),3)
              I4=NODEUS(NFFLUS(I),4)
              I5=NODEUS(NFFLUS(I),5)
              I6=NODEUS(NFFLUS(I),6)
              F1=VFFLUS(I,1)
              F2=VFFLUS(I,2)
              F3=VFFLUS(I,3)
              F4=VFFLUS(I,4)
              F5=VFFLUS(I,5)
              F6=VFFLUS(I,6)
              PHI=F1+F2+F3+ 3*(F4+F5+F6)
              BFLUSU(NB,1)=BFLUSU(NB,1)+PHI*S12*S
           ENDIF
          ENDIF
        ENDDO

C
        DO I=1,NBFECH
          NUMREF=NREFAL(NFECHS(I))
          OK=.FALSE.
          DO N1=1,NRFMA2
            IF (IRBILS(N1,NB).NE.0 .AND. NUMREF.EQ.N1) OK=.TRUE.
          ENDDO
          IF (OK) THEN
            S=SURFUS(NFECHS(I))
            PHI=0.
            IF (NDIM.EQ.2 .AND.IAXISY.EQ.0) THEN
              I1=NODEUS(NFECHS(I),1)
              I2=NODEUS(NFECHS(I),2)
              I3=NODEUS(NFECHS(I),3)
              F1=VFECHS(I,1,2)*(VFECHS(I,1,1)-TMPSA(I1))
              F2=VFECHS(I,2,2)*(VFECHS(I,2,1)-TMPSA(I2))
              F3=VFECHS(I,3,2)*(VFECHS(I,3,1)-TMPSA(I3))
              BFLUSU(NB,1)=BFLUSU(NB,1)+(F1+F2+2*F3)*0.25*S
            ELSEIF (NDIM.EQ.2 .AND.IAXISY.NE.0) THEN
              R1 = ABS (COORDS(NODEUS(NFECHS(I),1),NCA))
              R2 = ABS (COORDS(NODEUS(NFECHS(I),2),NCA))        
              I1=NODEUS(NFECHS(I),1)
              I2=NODEUS(NFECHS(I),2)
              I3=NODEUS(NFECHS(I),3)
              F1=VFECHS(I,1,2)*(VFECHS(I,1,1)-TMPSA(I1))
              F2=VFECHS(I,2,2)*(VFECHS(I,2,1)-TMPSA(I2))
              F3=VFECHS(I,3,2)*(VFECHS(I,3,1)-TMPSA(I3))
              PHI=6*R2*F3+R2*F1+6*R1*F3+5*R1*F1+5*R2*F2+R1*F2
              BFLUSU(NB,1)=BFLUSU(NB,1)+PHI*S24*S
            ELSE
              I1=NODEUS(NFECHS(I),1)
              I2=NODEUS(NFECHS(I),2)
              I3=NODEUS(NFECHS(I),3)
              I4=NODEUS(NFECHS(I),4)
              I5=NODEUS(NFECHS(I),5)
              I6=NODEUS(NFECHS(I),6)
              F1=VFECHS(I,1,2)*(VFECHS(I,1,1)-TMPSA(I1))
              F2=VFECHS(I,2,2)*(VFECHS(I,2,1)-TMPSA(I2))
              F3=VFECHS(I,3,2)*(VFECHS(I,3,1)-TMPSA(I3))
              F4=VFECHS(I,4,2)*(VFECHS(I,4,1)-TMPSA(I4))
              F5=VFECHS(I,5,2)*(VFECHS(I,5,1)-TMPSA(I5))
              F6=VFECHS(I,6,2)*(VFECHS(I,6,1)-TMPSA(I6))
              PHI=F1+F2+F3+ 3*(F4+F5+F6)
              BFLUSU(NB,1)=BFLUSU(NB,1)+PHI*S12*S
           ENDIF
          ENDIF
        ENDDO
C
        DO I=1,NBFRAI
          NUMREF=NREFAL(NFRAIS(I))
          OK=.FALSE.
          DO N1=1,NRFMA2
            IF (IRBILS(N1,NB).NE.0 .AND. NUMREF.EQ.N1) OK=.TRUE.
          ENDDO
          IF (OK) THEN
            S=SURFUS(NFRAIS(I))
            PHI=0.
            IF (NDIM.EQ.2 .AND.IAXISY.EQ.0) THEN
              I1=NODEUS(NFRAIS(I),1)
              I2=NODEUS(NFRAIS(I),2)
              I3=NODEUS(NFRAIS(I),3)
              DO J=1,3
                INODE=NODEUS(NFRAIS(I),J)
                HRAYI(J) = VFRAIS(I,J,2)*SIGMA*
     &                 (TMPSA(INODE)+VFRAIS(I,J,1)+2*TKEL)*
     &                 ((TMPSA(INODE)+TKEL)  * (TMPSA(INODE)+TKEL) + 
     &                  (VFRAIS(I,J,1)+TKEL) * (VFRAIS(I,J,1)+TKEL) )
              ENDDO
              F1=HRAYI(1)*(VFRAIS(I,1,1)-TMPSA(I1))
              F2=HRAYI(2)*(VFRAIS(I,2,1)-TMPSA(I2))
              F3=HRAYI(3)*(VFRAIS(I,3,1)-TMPSA(I3))
              BFLUSU(NB,1)=BFLUSU(NB,1)+(F1+F2+2*F3)*0.25*S
            ELSEIF (NDIM.EQ.2 .AND.IAXISY.NE.0) THEN
              R1 = ABS (COORDS(NODEUS(NFRAIS(I),1),NCA))
              R2 = ABS (COORDS(NODEUS(NFRAIS(I),2),NCA))        
              I1=NODEUS(NFRAIS(I),1)
              I2=NODEUS(NFRAIS(I),2)
              I3=NODEUS(NFRAIS(I),3)
              DO J=1,3
                INODE=NODEUS(NFRAIS(I),J)
                HRAYI(J) = VFRAIS(I,J,2)*SIGMA*
     &                 (TMPSA(INODE)+VFRAIS(I,J,1)+2*TKEL)*
     &                 ((TMPSA(INODE)+TKEL)  * (TMPSA(INODE)+TKEL) + 
     &                  (VFRAIS(I,J,1)+TKEL) * (VFRAIS(I,J,1)+TKEL) )
              ENDDO
              F1=HRAYI(1)*(VFRAIS(I,1,1)-TMPSA(I1))
              F2=HRAYI(2)*(VFRAIS(I,2,1)-TMPSA(I2))
              F3=HRAYI(3)*(VFRAIS(I,3,1)-TMPSA(I3))
              PHI=6*R2*F3+R2*F1+6*R1*F3+5*R1*F1+5*R2*F2+R1*F2
              BFLUSU(NB,1)=BFLUSU(NB,1)+PHI*S24*S
            ELSE
              I1=NODEUS(NFRAIS(I),1)
              I2=NODEUS(NFRAIS(I),2)
              I3=NODEUS(NFRAIS(I),3)
              I4=NODEUS(NFRAIS(I),4)
              I5=NODEUS(NFRAIS(I),5)
              I6=NODEUS(NFRAIS(I),6)
              DO J=1,6
                INODE=NODEUS(NFRAIS(I),J)
                HRAYI(J) = VFRAIS(I,J,2)*SIGMA*
     &                 (TMPSA(INODE)+VFRAIS(I,J,1)+2*TKEL)*
     &                 ((TMPSA(INODE)+TKEL)  * (TMPSA(INODE)+TKEL) + 
     &                  (VFRAIS(I,J,1)+TKEL) * (VFRAIS(I,J,1)+TKEL) )
              ENDDO
              F1=HRAYI(1)*(VFRAIS(I,1,1)-TMPSA(I1))
              F2=HRAYI(2)*(VFRAIS(I,2,1)-TMPSA(I2))
              F3=HRAYI(3)*(VFRAIS(I,3,1)-TMPSA(I3))
              F4=HRAYI(4)*(VFRAIS(I,4,1)-TMPSA(I4))
              F5=HRAYI(5)*(VFRAIS(I,5,1)-TMPSA(I5))
              F6=HRAYI(6)*(VFRAIS(I,6,1)-TMPSA(I6))
              PHI=F1+F2+F3+ 3*(F4+F5+F6)
              BFLUSU(NB,1)=BFLUSU(NB,1)+PHI*S12*S
           ENDIF
          ENDIF
        ENDDO
C         
        DO I=1,NELERA
          NUMREF=NREFAL(NFRAYS(I))
          OK=.FALSE.
          DO N1=1,NRFMA2
            IF (IRBILS(N1,NB).NE.0 .AND. NUMREF.EQ.N1) OK=.TRUE.
          ENDDO
          IF (OK) THEN
            S=SURFUS(NFRAYS(I))
            PHI=0.
            IF (NDIM.EQ.2 .AND.IAXISY.EQ.0) THEN
              I1=NODEUS(NFRAYS(I),1)
              I2=NODEUS(NFRAYS(I),2)
              I3=NODEUS(NFRAYS(I),3)
              DO J=1,3
                INODE=NODEUS(NFRAYS(I),J)
                HRAYI(J) = VFRAYS(I,J,2)*SIGMA*
     &                 (TMPSA(INODE)+VFRAYS(I,J,1)+2*TKEL)*
     &                 ((TMPSA(INODE)+TKEL)  * (TMPSA(INODE)+TKEL) + 
     &                  (VFRAYS(I,J,1)+TKEL) * (VFRAYS(I,J,1)+TKEL) )
              ENDDO
              F1=HRAYI(1)*(VFRAYS(I,1,1)-TMPSA(I1))
              F2=HRAYI(2)*(VFRAYS(I,2,1)-TMPSA(I2))
              F3=HRAYI(3)*(VFRAYS(I,3,1)-TMPSA(I3))
              BFLUSU(NB,2)=BFLUSU(NB,2)+(F1+F2+2*F3)*0.25*S
            ELSEIF (NDIM.EQ.2 .AND.IAXISY.NE.0) THEN
              R1 = ABS (COORDS(NODEUS(NFRAYS(I),1),NCA))
              R2 = ABS (COORDS(NODEUS(NFRAYS(I),2),NCA))        
              I1=NODEUS(NFRAYS(I),1)
              I2=NODEUS(NFRAYS(I),2)
              I3=NODEUS(NFRAYS(I),3)
              DO J=1,3
                INODE=NODEUS(NFRAYS(I),J)
                HRAYI(J) = VFRAYS(I,J,2)*SIGMA*
     &                 (TMPSA(INODE)+VFRAYS(I,J,1)+2*TKEL)*
     &                 ((TMPSA(INODE)+TKEL)  * (TMPSA(INODE)+TKEL) + 
     &                  (VFRAYS(I,J,1)+TKEL) * (VFRAYS(I,J,1)+TKEL) )
              ENDDO
              F1=HRAYI(1)*(VFRAYS(I,1,1)-TMPSA(I1))
              F2=HRAYI(2)*(VFRAYS(I,2,1)-TMPSA(I2))
              F3=HRAYI(3)*(VFRAYS(I,3,1)-TMPSA(I3))
              PHI=6*R2*F3+R2*F1+6*R1*F3+5*R1*F1+5*R2*F2+R1*F2
              BFLUSU(NB,2)=BFLUSU(NB,2)+PHI*S24*S
            ELSE
              I1=NODEUS(NFRAYS(I),1)
              I2=NODEUS(NFRAYS(I),2)
              I3=NODEUS(NFRAYS(I),3)
              I4=NODEUS(NFRAYS(I),4)
              I5=NODEUS(NFRAYS(I),5)
              I6=NODEUS(NFRAYS(I),6)
              DO J=1,6
                INODE=NODEUS(NFRAYS(I),J)
                HRAYI(J) = VFRAYS(I,J,2)*SIGMA*
     &                 (TMPSA(INODE)+VFRAYS(I,J,1)+2*TKEL)*
     &                 ((TMPSA(INODE)+TKEL)  * (TMPSA(INODE)+TKEL) + 
     &                  (VFRAYS(I,J,1)+TKEL) * (VFRAYS(I,J,1)+TKEL) )
              ENDDO
              F1=HRAYI(1)*(VFRAYS(I,1,1)-TMPSA(I1))
              F2=HRAYI(2)*(VFRAYS(I,2,1)-TMPSA(I2))
              F3=HRAYI(3)*(VFRAYS(I,3,1)-TMPSA(I3))
              F4=HRAYI(4)*(VFRAYS(I,4,1)-TMPSA(I4))
              F5=HRAYI(5)*(VFRAYS(I,5,1)-TMPSA(I5))
              F6=HRAYI(6)*(VFRAYS(I,6,1)-TMPSA(I6))
              PHI=F1+F2+F3+ 3*(F4+F5+F6)
              BFLUSU(NB,2)=BFLUSU(NB,2)+PHI*S12*S
           ENDIF
          ENDIF
        ENDDO
C
      ENDDO
C
C     IMPRESSIONS
C     -----------
C
      WRITE(NFECRA,1000)
      DO NB=1,NBILAS
         WRITE(NFECRA,1010) NB,(BFLUSU(NB,I),I=1,3)
      ENDDO
C
C--------
C FORMATS
C--------
 1000 FORMAT(/,'Bilans de Flux surfaciques :')
 1010 FORMAT(  ' * Bilan ',I2,' * Cond Lim :',E12.5,
     &         '  Radiatif :',E12.5,'  Convectif :',E12.5)
C                             
      END
