C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                    *****************
                     SUBROUTINE AFAIRE
C                    *****************
C
C     ---------------------------------------------------
     *( NFFLUS,VFFLUS,NBFFLU,NFECHS,VFECHS,NBFECH, 
     *  NFRESC,VFRESC,NELERC,
     *  NFRAYS,VFRAYS,NELERA,
     *  NFRAIS,VFRAIS,NBFRAI,
     *  NFCOUS,VFCOUS,NELESS,
     *  NFLUVS,VFLUVS,NBFLVS,NPFEL,
     *  TMPSA,NODEUS,SURFUS,VOLUME,
     *  NPOINS,NDIM,NELEUS,NDMASS,NREFAL,COORDS,
     *  NREFE,NELEMS,NDMATS,NODES,NODESS)
C     ---------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :   Sous programme utilisateur                         *
C      ---------    Acces a toutes les grandeurs pour traitements      *
C                   specifiques.                                       *
C                                                                      *
C     Rq : pour des exemples d'utilisation des divers tableaux, se     *
C          reporter aux sous-programmes utilisateurs traditionnels     *
C          qui proposent des exemples.                                 *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   NFFLUS  !  TE  ! D  ! No de facette flux ---> face glob        !
C   !   VFFLUS  !  TR  ! D  ! Valeur des flux a chaque point de la face!
C   !   NBFFLU  !  E   ! D  ! Nombre de facette de type flux           ! 
C   !   NFECHS  !  TE  ! D  ! No de facette echange ---> face glob     !
C   !   VFECHS  !  TR  ! D  ! Valeur des echan aux points de la face   !
C   !   NBFECH  !  E   ! D  ! Nombre de facette de type echange        ! 
C   !   NFRESC  !  TE  ! D  ! No de facette resistance ---> face glob  !
C   !   VFRESC  !  TR  ! D  ! Valeur des resista aux points de la face !
C   !   NELERC  !  E   ! D  ! Nombre de facette de type resistance     ! 
C   !   NFRAYS  !  TE  ! D  ! No de facette rayonnement ---> face glob !
C   !   VFRAYS  !  TR  ! D  ! Valeur du rayo aux points de la face     !
C   !   NELERA  !  E   ! D  ! Nombre de facette de type rayonnement    ! 
C   !   NFRAIS  !  TE  ! D  ! No de facette rayonnt inf -->  face glob !
C   !   VFRAIS  !  TR  ! D  ! Valeur du rayo inf aux points de la face !
C   !   NBFRAI  !  E   ! D  ! Nombre de facette de type rayonnement inf! 
C   !   NFCOUS  !  TE  ! D  ! No de facette couplee ---> face glob     !
C   !   VFCOUS  !  TR  ! D  ! Valeur du couplage aux points de la face !
C   !   NELESS  !  E   ! D  ! Nombre de facette de type couplee        ! 
C   !   NODEUS  !  TE  ! D  ! NOEUDS DE BORD( LOCALE 2D --> GLOBALE 3D)!
C   !   SURFUS  !  TR  ! D  ! EN 3D SURFACE DU TRIANGLE DE BORD (flux) !
C   !           !      !    ! EN 2D LONGUEUR DU SEGMENT DE BORD (flux) !
C   !   VOLUME  !  TR  ! D  ! EN 3D VOLUME DU TETRAEDRE                !
C   !           !      !    ! EN 2D SURFACE DU TRIANGLE                !
C   !   COORDS  !  TR  ! D  ! COORDONNEES DES NOEUDS DU MAILLAGE       !
C   !   NODES   !  TE  ! D  ! CONNECTIVITE DU MAILLAGE                 !
C   !   TEMPSA  !  TR  ! D  ! CHAMP DE TEMPERATURE (CELSIUS)           !
C   !   NREFE   !  TE  ! D  ! REFERENCES DES ELEMENTS                  !
C   !   NREFAL  !  TE  ! D  ! REFERENCES DES ELEMENTS DE BORD          !
C   !   NODESS  !  TE  ! D  ! CONNECTIVITE BORD COUPLE AU FLUIDE       !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ????
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : ????
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "rayonn.h"
#include "divct.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NPOINS,NDIM,NELEUS,NDMASS
      INTEGER NBFFLU,NBFECH,NELERC,NELERA,NBFRAI,NELESS
      INTEGER NELEMS,NDMATS,NBFLVS,NPFEL
      INTEGER NFFLUS(NBFFLU),NFECHS(NBFECH),NFRESC(NELERC)
      INTEGER NFRAYS(NELERA),NFRAIS(NBFRAI),NFCOUS(NELESS)
      INTEGER NODEUS(NELEUS,NDMASS),NREFAL(NELEUS)
      INTEGER NREFE(NELEMS),NFLUVS(NBFLVS)
      INTEGER NODES(NELEMS,NDMATS),NODESS(NELESS,NDMASS)
C
      DOUBLE PRECISION VFFLUS(NBFFLU,NDMASS),VFECHS(NBFECH,NDMASS,2)
      DOUBLE PRECISION VFRESC(NELERC,NDMASS,2)
      DOUBLE PRECISION VFRAYS(NELERA,NDMASS,2),VFRAIS(NBFRAI,NDMASS,2)
      DOUBLE PRECISION VFCOUS(NELESS,NDMASS,2)
      DOUBLE PRECISION TMPSA(NPOINS)
      DOUBLE PRECISION SURFUS(NELEUS),COORDS(NPOINS,NDIM)   
      DOUBLE PRECISION  VFLUVS(NBFLVS,NPFEL)
      DOUBLE PRECISION  VOLUME(NELEMS)
C
C..Variables internes
C
C
C
C***********************************************************************
C
C--------
C FORMATS
C--------
C                             
      END
