
from swiginac import *
from SyFi import *
from sfc.integral_tools import geometry_mapping
from sfc.symbolic_utils import symbol, symbols

initSyFi(2)
x =cvar.x; y =cvar.y


triangle = Triangle([1.3, 1.3], [2.4,2.1], [1.4, 2.8])
G, x0 = geometry_mapping(triangle)

print G*matrix(2,1, [0,0]) + x0 
print G*matrix(2,1, [1,0]) + x0 
print G*matrix(2,1, [0,1]) + x0 

Ginv = G.inverse()
print Ginv*(matrix(2,1, [1.3,1.3]) - x0) 
print Ginv*(matrix(2,1, [2.4,2.1]) - x0) 
print Ginv*(matrix(2,1, [1.4,2.8]) - x0) 


fe = Lagrange(triangle)

print "global fe.N(0) ", fe.N(0)

reference_triangle = ReferenceTriangle()
reference_fe = Lagrange(reference_triangle)
xi0, xi1 = symbol("xi0"), symbol("xi1")
N0 = reference_fe.N(0).subs( [x == xi0, y == xi1] ) 
#xi = matrix(2,1,[xi0, xi1])
p = matrix(2,1,[x, y])
xi = Ginv*(p - x0)
N0 = reference_fe.N(0).subs( [xi == xi[0,0], xi1 == xi[1,0]] ) 

print "fe.N(0)        ", fe.N(0)



print "3D"
initSyFi(3)
x =cvar.x; y =cvar.y; z = cvar.z 


tetrahedron = Tetrahedron([1.3, 1.3, 1.3], [2.4, 2.1, 2.2 ], [1.4, 2.8, 1.3], [1.5, 1.3, 3.0])

G, x0 = geometry_mapping(tetrahedron)
print "G ", G
print "x0 ", x0 

print G*matrix(3,1, [0,0,0]) + x0 
print G*matrix(3,1, [1,0,0]) + x0 
print G*matrix(3,1, [0,1,0]) + x0 
print G*matrix(3,1, [0,0,1]) + x0 

Ginv = G.inverse()
print Ginv*(matrix(3,1, [1.3,1.3,1.3]) - x0) 
print Ginv*(matrix(3,1, [2.4,2.1,2.2]) - x0) 
print Ginv*(matrix(3,1, [1.4,2.8,1.3]) - x0) 
print Ginv*(matrix(3,1, [1.5,1.3,3.0]) - x0) 


fe = Lagrange(tetrahedron)

print "global fe.N(0) ", fe.N(0)

reference_tetrahedron= ReferenceTetrahedron()
reference_fe = Lagrange(reference_tetrahedron)
xi0, xi1, xi2 = symbol("xi0"), symbol("xi1"), symbol("xi2")
N0 = reference_fe.N(0).subs( [x == xi0, y == xi1, z == xi2] ) 
#xi = matrix(2,1,[xi0, xi1])
p = matrix(3,1,[x,y,z])
xi = Ginv*(p - x0)
N0 = reference_fe.N(0).subs( [xi == xi[0,0], xi1 == xi[1,0], xi2 == xi[2,0]] ) 

print "fe.N(0)        ", fe.N(0)


