/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "DiffCmd.h"
#include "DiffParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"
#include "svn/ClientContext.h"
#include "svn/DiffSummarize.h"
#include "util/apr.h"


DiffCmd::DiffCmd( DiffParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

DiffCmd::~DiffCmd()
{
  delete _cb;
}

void DiffCmd::run()
{
  sc::Error* err = sc::Success;

  _prgscb->started( _param, getCancel() );

  if( _param->getSummarize() )
  {
    if( _param->isPeg() )
    {
      err = _client->diffSummarize( _param->getPathOrUrl1(), *_param->getRevision1(),
        *_param->getRevision2(), *_param->getPegRevision(), _param->getBaton(),
        _param->getRecurse(), _param->getAncestry() );
    }
    else
    {
      err = _client->diffSummarize( _param->getPathOrUrl1(), *_param->getRevision1(),
        _param->getPathOrUrl2(), *_param->getRevision2(), _param->getBaton(),
        _param->getRecurse(), _param->getAncestry() );
    }
  }
  else if( _param->getPatch() )
  {
    if( _param->isPeg() )
    {
      err = _client->diff( _param->getPathOrUrl1(), *_param->getRevision1(),
        *_param->getRevision2(), *_param->getPegRevision(), _param->getRecurse(),
        _param->getAncestry(), _param->getDeleted(),
        _param->getPatch(), _param->getPatchFile() );
    }
    else
    {
      err = _client->diff( _param->getPathOrUrl1(), *_param->getRevision1(),
        _param->getPathOrUrl2(), *_param->getRevision2(), _param->getRecurse(),
        _param->getAncestry(), _param->getDeleted(),
        _param->getPatch(), _param->getPatchFile() );
    }
  }
  else if( ! _param->getPatch() )
  {
    // run a visual diff
    if( _param->isPeg() )
    {
      err = _client->visualDiff( _param->getPathOrUrl1(), *_param->getRevision1(),
        *_param->getRevision2(), *_param->getPegRevision() );
    }
    else
    {
      err = _client->visualDiff( _param->getPathOrUrl1(), *_param->getRevision1(),
        _param->getPathOrUrl2(), *_param->getRevision2() );
    }
  }

  _param->setError( err );
  _prgscb->finished( _param );

  _cb->handleResult( _param, err );
}
