/* ====================================================================
 * Copyright (c) 2003-2008, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_COPYDIALOG_H
#define _SC_COPYDIALOG_H

// sc
class RevisionWidget;
class ExternProvider;
class CopyParam;
namespace svn
{
  class Revision;
}

// qt
#include <QtGui/QDialog>
class QComboBox;
class QCheckBox;
class QPushButton;


class CopyDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  CopyDialog( ExternProvider* p, QWidget *parent = 0 );
  virtual ~CopyDialog();

  void enableSrc( bool enable );
  void enableDst( bool enable );

  QString getSrcPathOrUrl();
  void setSrcPathOrUrl( const QString& url );

  /** Set the branches location to @a url. */
  void setBranchesUrl( const QString& url );
  /** Set the tags location to @a url. */
  void setTagsUrl( const QString& url );

  QString getDstPathOrUrl();
  void addDstPathOrUrl( const QString& url );

  QString getTargetPathOrUrl();
  svn::Revision* getRevision();

public slots:
  void selectWcPath();
  void checkOk( const QString& text );

private slots:
  void repExtern();
  void copyTypeChanged(int);

private:
  QComboBox*      _src;
  QPushButton*    _srcBrowse;
  RevisionWidget* _srcRev;

  QString         _branches;
  QString         _tags;
  
  QComboBox*      _dstRoot;
  QPushButton*    _dstBrowse;
  QComboBox*      _dstName;

  QPushButton*    _ok;
  
  ExternProvider* _p;
};

#endif // _SC_COPYDIALOG_H
