/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [meta_exp.h]           Meta-Expression Constructors/Destructors          */
/*                                                                          */
/* Copyright (c) 1999 by D\olle, Manns                                      */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef meta_exp_INCL
#define meta_exp_INCL


#include "standard.h"
#include "otab.h"


#ifdef __cplusplus
extern "C" {
#endif


/* ------------------------ Types & Macros ------------------------------ */

typedef Abs_T (*MF_Cpy_T)(Abs_T val); // type of copy function for external value
typedef void  (*MF_Del_T)(Abs_T val); // type of free function for external value

AbstractType(Meta_T) // type of meta element
;

Meta_T Meta_new(c_string id, c_string typ)
/* creates a new meta element with
   identifier 'id' and meta type 'typ'
*/
;

void Meta_delete(Meta_T elm);          /* frees meta element 'elm'          */

/* ------------------------ Constructors ------------------------------- */

/*  
   In the constructor and set functions 'id' and 'typ' will be copied.
   Most of the values won't. Otherwise it's documented explicit.
   For string and abstract values it can be specified by the user.
*/

Meta_T Meta_grp_mk(c_string id, c_string typ, ROW(Meta_T) parts)
/* constructs a meta element of type 'group' and
   child elements in 'parts' as value
*/
;

Meta_T Meta_int_mk(c_string id, c_string typ, long val)
/* constructs a meta element of type 'int' and 'val' as value */
;

Meta_T Meta_abs_mk
       (
         c_string id, c_string typ, Abs_T val, MF_Cpy_T cpy, MF_Del_T del
       )
/* constructs a meta element of type 'abstract', 'val' as value,
   'cpy' as copy function and 'del' as free function
*/
;

Meta_T Meta_str_mk(c_string id, c_string typ, c_string val, c_bool valcopy)
/* constructs a meta element of type 'string' and 'val' as value
   'valcopy' --> copies value
*/
;

Meta_T Meta_raw_mk(c_string id, c_string typ, c_byte* val)
/* constructs a meta element of type 'raw' and 'val' as value
   ( val = ( long ) len byte ... )
*/
;

Meta_T Meta_bin_mk(c_string id, c_string typ, long len, c_byte* val)
/* constructs a meta element of type 'binary' and 'val' as value
   of length 'len' ( copies value )
*/
;

Meta_T Meta_set_loc(Meta_T elm, c_string loc, long row, long col)
/* adds / updates location information 'loc', 'row' and 'col'
   in meta element 'elm' ( no copy of 'loc' )
*/
;

Meta_T Meta_set_key(Meta_T elm, c_string id, c_string typ)
/* adds / updates key information 'id', 'typ' in meta element 'elm' */
;

Meta_T Meta_set_grp(Meta_T elm, ROW(Meta_T) parts)
/* adds / updates group value 'parts' in meta element 'elm' */
;

Meta_T Meta_set_int(Meta_T elm, long val)
/* adds / updates int value 'val' in meta element 'elm' */
;

Meta_T Meta_set_abs(Meta_T elm, Abs_T val, MF_Cpy_T cpy, MF_Del_T del)
/* adds / updates abstract value 'val', 'cpy', 'del'
   in meta element 'elm'
*/
;

Meta_T Meta_set_str(Meta_T elm, c_string val, c_bool valcopy)
/* adds / updates string value 'val' in meta element 'elm'
   'valcopy' --> copies value
*/
;

Meta_T Meta_set_raw(Meta_T elm, c_byte* val)
/* adds / updates raw value 'val' in meta element 'elm' */
;

Meta_T Meta_set_bin(Meta_T elm, long len, c_byte* val)
/* adds / updates binary value 'val' of length 'len'
   in meta element 'elm'
*/
;


/* ------------------------ Destructors -------------------------------- */

void Meat_get_loc(Meta_T elm, c_string* loc, long* row, long* col)
/* get location information of meta element 'elm' */
;

c_bool Meta_grp_de(Meta_T elm, c_string* id, c_string* typ, ROW(Meta_T)* parts)
/* destructs group meta element 'elm' */
;

c_bool Meta_int_de(Meta_T elm, c_string* id, c_string* typ, long* val)
/* destructs int meta element 'elm' */
;

c_bool Meta_abs_de
     (
       Meta_T elm, c_string* id, c_string* typ,
       Abs_T* val, MF_Cpy_T* cpy, MF_Del_T* del
     )
/* destructs abstract meta element 'elm' */
;

c_bool Meta_str_de(Meta_T elm, c_string* id, c_string* typ, c_string* val)
/* destructs string meta element 'elm' */
;

c_bool Meta_raw_de(Meta_T elm, c_string* id, c_string* typ, c_byte** val)
/* destructs raw meta element 'elm' */
;

c_bool Meta_bin_de(Meta_T elm, c_string* id, c_string* typ, long* len, c_byte** val)
/* destructs binary meta element 'elm' */
;



#ifdef __cplusplus
}
#endif

#endif
