/* Strip Club - Online/Offline Comic Reader/Archiver
 *
 * Copyright notice for this file:
 *  Copyright (C) 2004,2005 Benjamin Cutler
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>
#include <unistd.h>
#include <pcre.h>
#include <errno.h>
#include "interface.h"
#include "http.h"
#include "url.h"
#include "load.h"
#include "util.h"

#ifdef WIN32

#include <winsock2.h>

int close(int fd) {
	return closesocket(fd);
}

static void SET_NONBLOCK(int fd) { 
	u_long mode = 1; 
	ioctlsocket(fd, FIONBIO, &mode); 
}

#define INPROGRESS		(WSAGetLastError() == WSAEWOULDBLOCK)
#define WOULDBLOCK		(WSAGetLastError() == WSAEWOULDBLOCK)

#else

#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <fcntl.h>

#define SET_NONBLOCK(fd)	fcntl(fd, F_SETFL, O_NONBLOCK)
#define INPROGRESS		(errno == EINPROGRESS)
#define WOULDBLOCK		(errno == EAGAIN)

#endif

static bool SetIp(sockaddr_in *ip, const char *Host, unsigned short port, bool Force = false);

void RefreshHostCache() {
	char **Hosts;
	Fl_Preferences *HostCache = new Fl_Preferences(Fl_Preferences::USER, "racercksproductions", "hosts");
	int Num = HostCache->entries();
	Hosts = (char **)malloc(sizeof(char *) * Num);
	for (int i = 0; i < Num; i++) {
		Hosts[i] = strdup(HostCache->entry(i));
	}
	delete HostCache;
	Interface.DLRange(0.0, (float)Num);
	Interface.DLValue(0.0);
	for (int i = 0; i < Num; i++) {
		SetIp(NULL, Hosts[i], 80, true);
		Interface.DLValue((float)i);
		free(Hosts[i]);
	}
	free(Hosts);
	Interface.DLValue(0.0);
	Interface.DLLabel("");
}

static bool SetIp(sockaddr_in *ip, const char *Host, unsigned short port, bool Force) {
	Fl_Preferences *HostCache = new Fl_Preferences(Fl_Preferences::USER, "racercksproductions", "hosts");
	sockaddr_in dummy;
	if (!ip) { ip = &dummy; }
        ip->sin_family = AF_INET;          // host byte order
	ip->sin_port = htons(port);
        memset(&(ip->sin_zero), '\0', 8);  // zero the rest of the struct
	if (HostCache->entryExists(Host) && !Force) {
		char *tmp;
		HostCache->get(Host, tmp, 0);
		sscanf(tmp, "%X", &(ip->sin_addr.s_addr));
		free(tmp);
		DbgOut("Host Cached: %s %08X\n", Host, ip->sin_addr.s_addr);
	} else {
		Interface.DLLabel("Looking up host (%s)...", Host);
		hostent *NewHost;
		if ((NewHost = gethostbyname(Host))) {
			memcpy(&(ip->sin_addr.s_addr), NewHost->h_addr, 4);
			DbgOut("Host Saved%s: %s %08X\n", Force ? " (forced)" : "", Host, ip->sin_addr.s_addr);
			HostCache->set(Host, Fl_Preferences::Name("%08X", ip->sin_addr.s_addr));
			Prefs->flush();
		} else {
			MOut("Unable to resolve host %s!\n", Host);
			return false;
		}
	}
	delete HostCache;
	return true;
}

static int WaitForSocket(int fd, int write = 0);

static int WaitForSocket(int fd, int write) {
	fd_set set;
	timeval tv = { 0, 100000 };
	FD_ZERO(&set);
	FD_SET(fd, &set);
	if (write) {
		return select(fd+1, NULL, &set, NULL, &tv);
	} else {
		return select(fd+1, &set, NULL, NULL, &tv);
	}
}

static void CleanUp(int socketfd, FILE *fptr = NULL, sURL *URL = NULL) {
	if (socketfd >= 0) {
		close(socketfd);
	}
	if (fptr) {
		fclose(fptr);
	}
	if (URL) {
		URLDelete(URL);
	}
}

bool GetRemoteInfo(const sURL *URL, const char *Referer, time_t *ModTime, int *ContentLength, char *ContentType) {
	int socketfd;
	sockaddr_in ip;	
	char Header[80];
	char Buffer[400];
	char *Request;
	char month[4];
	char temp;
	int Cur = 0, timeout = 0;
	tm time;

	if (ModTime) {
		*ModTime = 0;
	}
	if (ContentLength) {
		*ContentLength = 0;
	}

	if (!Proxy) {
		if (!SetIp(&ip, URL->Host, atoi(URL->Port))) {
			return false;
		}
	} else {
		if (!SetIp(&ip, Proxy->Host, atoi(Proxy->Port))) {
			return false;
		}
	}

	Interface.DLLabel("Opening connection... (%s)", URL->Host);

	socketfd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);

	if (socketfd == -1) {
		MOut("GetRemoteInfo(): Error creating socket\n");
		return false;
	}

	SET_NONBLOCK(socketfd);

	if (connect(socketfd, (sockaddr *)&ip, sizeof(sockaddr)) && !INPROGRESS) {
		MOut("GetRemoteInfo(): Error connecting socket\n");
		close(socketfd);
		return false;
	}

	while(!WaitForSocket(socketfd, 1)) {
		Interface.DLLabel("Awaiting connection... (%ds)", (++timeout)/10);
		if (timeout > (ValueTimeout->value() * 10)) {			// Wait for X seconds altogether before deciding the connection is dead
			EOut("Error retrieving HEAD, connection timed out.\n");
			close(socketfd);
			return false;
		}
		if (Cancel) {
			DbgOut("Cancel clicked\n");
			close(socketfd);
			return false;
		}
	}

	timeout = 0;

	{
		int headtotal = 0, headcount = 0;
		Prefs->get("headcount", headtotal, 0);
		if (CurComicG) {
			CurComicG->get("headcount", headcount, 0);
		}
		Prefs->set("headcount", ++headtotal);
		if (CurComicG) {
			CurComicG->set("headcount", ++headcount);
		}
	}


	DbgOut("Requesting HEAD for URL: %s\n", URL->Full);

	{
		char UserAgent[80] = "";
		if (CurComicG && CurComicG->entryExists("useragent")) {
			CurComicG->get("useragent", UserAgent, "", 79);
		}
		Request = nstrcat(13, 
			"HEAD ", Proxy ? URL->Full : URL->FullPath, " HTTP/1.1\r\n", 
			"Host: ", URL->Host, "\r\n",
			Referer ? "Referer: " : NULL, Referer ? Referer : NULL, Referer ? "\r\n" : NULL, 
			"User-Agent: ", strlen(UserAgent) ? UserAgent : USERAGENT, "\r\n",
			"Connection: close\r\n\r\n");
	}

	UOut("Sending HTTP request to: %s (%X)\n", (Proxy ? Proxy : URL)->Host, ip.sin_addr.s_addr);
	UOut(Request);

	Interface.DLLabel("Sending HEAD Request...");

	send(socketfd, Request, strlen(Request), 0);	// FIXME: Should maybe check for incomplete/failed send, but it seems unlikely

	Interface.DLLabel("Awaiting HEAD Response... (0s)");

	while(!WaitForSocket(socketfd)) {
		Interface.DLLabel("Awaiting HEAD Response... (%ds)", (++timeout)/10);
		if (timeout > (ValueTimeout->value() * 10)) {
			EOut("Error retrieving HEAD, connection timed out\n");
			close(socketfd);
			return false;
		}
		if (Cancel) {
			DbgOut("Cancel clicked\n");
			close(socketfd);
			return false;
		}
	}

	if(recv(socketfd, Header, 17, 0) < 17) {
		EOut("Error retrieving HEAD, connection refused/closed?\n");
		close(socketfd);
		return false;
	} else if (strncmp(Header, "HTTP/1.1 200 OK", 15) && strncmp(Header, "HTTP/1.0 200 OK", 15)) {	// Accept either 1.1 or 1.0 responses
		int i = 17;
		do {
			recv(socketfd, &temp, 1, 0);		// FIXME: Should maybe check for disconnection, but if it got this far and then died, the server has major problems
			Header[i++] = temp;
		} while((temp != 0xD) && (temp != 0xA));
		Header[i - 1] = '\0';
		MOut("GetRemoteInfo(): Error retrieving HEAD, expected \"HTTP/1.X 200 OK\" but got \"%s\"\n", Header);
		close(socketfd);
		return false;
	}

	Interface.DLLabel("Receiving HEAD response...");

	Header[17] = '\0';
	DOut("Receiving HEAD response from: %s\n", URL->Host);
	DOut(Header);

	while (recv(socketfd, &temp, 1, 0)) {
		Buffer[Cur++] = temp;
		DOut("%c", temp);
		if (temp == 0xA) {
			if (Cur == 2) { 	// Done
				break;
			}
			sscanf(Buffer, "%s", Header);
			Cur = 0;
			if (!strcmp(Header, "Last-Modified:")) {

				if (ModTime) {
					sscanf((Buffer + strlen(Header)), "%*s %d %3s %d %d:%d:%d", &time.tm_mday, month, &time.tm_year, &time.tm_hour, &time.tm_min, &time.tm_sec);

					time.tm_year -= 1900;		// Struct is expected relative to 1900, but header returns full year
					if (!strcmp(month, "Jan")) {
						time.tm_mon = 0;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Feb")) {
						time.tm_mon = 1;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Mar")) {
						time.tm_mon = 2;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Apr")) {
						time.tm_mon = 3;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "May")) {
						time.tm_mon = 4;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Jun")) {
						time.tm_mon = 5;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Jul")) {
						time.tm_mon = 6;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Aug")) {
						time.tm_mon = 7;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Sep")) {
						time.tm_mon = 8;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Oct")) {
						time.tm_mon = 9;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Nov")) {
						time.tm_mon = 10;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Dec")) {
						time.tm_mon = 11;
						*ModTime = mktime(&time);
					} else {
						Out("Invalid Month: %s\n", month);
						*ModTime = 0;
					}	// end Month Block
				}	// if (Modtime)
			} else if (!strcmp(Header, "Content-Length:")) {
				if (ContentLength) {
					*ContentLength = atoi(Buffer + strlen(Header));
				}
			} else if (!strcmp(Header, "Content-Type:")) {
				if (ContentType) {
					sscanf(Buffer, "%*s %100[a-zA-Z1-9/]", ContentType);
					DbgOut("ContentType = %s\n",ContentType);
				}
			}
		}	// if (temp == 0xA) (Newline)
		timeout = 0;
		while(!WaitForSocket(socketfd)) {
			Interface.DLLabel("Receiving HEAD response... (%ds)", (++timeout)/10);
			if (timeout > (ValueTimeout->value() * 10)) {
				EOut("Error retrieving HEAD, connection timed out\n");
				close(socketfd);
				return false;
			}
			if (Cancel) {
				DbgOut("Cancel clicked\n");
				close(socketfd);
				return false;
			}
		}
	}

	close(socketfd);

	if (ContentType && !strlen(ContentType)) {	// Brain damaged servers
		DbgOut("No Content-Type header, assuming text/html\n");
		strcpy(ContentType, "text/html");
	}

	return true;
}

char *GrabHTTPLink(const char *URL, const char *Referer) {
	int socketfd;
	sockaddr_in ip;	
	char Buffer[4096];
	char *Request;
	static char File[2048];
	sURL *Break;
	char temp;
	char type[100] = "";			// Content-Type
	int filelength, length, done = 0, Cur = 0, timeout = 0;
	int gigsdowntotal = 0, gigsdowncomic = 0, bytesdowntotal = 0, bytesdowncomic = 0;
	time_t localmod, remotemod;
	struct stat filestat;
	char *Return;					// KEEP THIS, otherwise it will try to parse images for links
	static char *TReturn = NULL;	// For the temp files
	FILE *fptr;
	bool body = false, chunked = false;		// Chunked = Chunked Transfer encoding?

	if (!URL || !strlen(URL)) {
		MOut("GrabHTTPLink(): Null or empty URL passed, report as a bug!\n");
	}

	Interface.DLLabel("");
	Interface.DLRange(0.0f, 0.0f);
	Interface.DLValue(0.0f);

	Break = URLCreate(URL);

	Interface.CancelButton->activate();
	Cancel = false;

	if(!GetRemoteInfo(Break, Referer, &remotemod, &filelength, type)) {
		if (!Cancel) { EOut("Unable to retrieve HEAD for \"%s\"!\n", URL); }
		URLDelete(Break);
		return NULL;
	}

	if (!Proxy) {
		SetIp(&ip, Break->Host, atoi(Break->Port));
	} else {
		SetIp(&ip, Proxy->Host, atoi(Proxy->Port));
	}

	if (!strcmp(type, "image/jpeg") || !strcmp(type, "image/gif") || !strcmp(type, "image/png") ||			// Attempt to id by Content-Type
		!strcmp(Break->Extension, "jpg") || !strcmp(Break->Extension, "gif") || !strcmp(Break->Extension, "png")) {	// And by extension... (goobery ass Userfriendly telling the program a gif is text/html? What the crap?)
		if (CurComicG->entryExists("imgfilepattern")) {
			pcre *compile;
			char *pattern, ImageFile[40];
			const char *error;
			int erroroffset, result, ovector[10];
			CurComicG->get("imgfilepattern", pattern, "");
			DbgOut("%s\n", pattern);
			compile = pcre_compile(pattern, PCRE_CASELESS | PCRE_DOTALL, &error, &erroroffset, NULL);
			free(pattern);
			if (!compile) {
				MOut("Error compiling Image File Pattern:\n%s\nError at offset %d\n", error, erroroffset);
				URLDelete(Break);
				return NULL;
			}
			result = pcre_exec(compile, NULL, URL, strlen(URL), 0, 0, ovector, 10);
			if (result < 0) {
				MOut("Image URL does not match Image File Pattern!\n");
				pcre_free(compile);
				URLDelete(Break);
				return NULL;
			}
			pcre_copy_substring(URL, ovector, result, 1, ImageFile, 40);
			DbgOut("ImageFile = %s\n", ImageFile);
			strcpy(File, GetCacheFileName(ImageFile));
			pcre_free(compile);
		} else {
			strcpy(File, GetCacheFileName(Break->File));
		}
		Out("Local Filename: %s\n", File);
		if (!stat(File, &filestat)) {		// File exists
			localmod = filestat.st_mtime + timezone;
			DbgOut("Time: Old: %ld %s New: %ld\n", localmod, (localmod >= remotemod) ? ">=" : "< ", remotemod);
			DbgOut("Size: Old: %ld %s New: %ld\n", filestat.st_size, (filestat.st_size == filelength) ? "==" : "!=", filelength);
			if ((localmod >= remotemod) && (remotemod) && (filelength == filestat.st_size)) {		// File is newer or just as recent as the local copy, and remotemod != NULL, and filesizes match
				Interface.DLLabel("Local copy up to date...");
				Out("Local copy up to date\n");
				URLDelete(Break);
				return File;
			}
		}
		if (!(fptr = fopen(File, "wb"))) {		// Rare, but hey
			Interface.DLLabel("Error opening output file!");
			MOut("Error opening \"%s\" for writing!\n", File);
			Interface.DLLabel("");
			URLDelete(Break);
			return NULL;
		}
		Return = File;
	} else if (!strcmp(Break->Extension, "comic")) {
		strcpy(File, GetCacheFileName(Break->File, true, "comics"));
		if (!(fptr = fopen(File, "wb"))) {		// Rare, but hey
			Interface.DLLabel("Error opening output file!");
			MOut("Error opening \"%s\" for writing!\n", File);
			Interface.DLLabel("");
			URLDelete(Break);
			return NULL;
		}
		Return = File;
	} else if (!strcmp(type, "text/plain")) {
		free(TReturn);
		TReturn = strdup(GetCacheFileName(TEMPTXT, true, "temp"));
		fptr = fopen(TReturn, "wb");
		Return = TReturn;
	} else if (!strncmp(type, "text/html", 9)) {
		free(TReturn);
		TReturn = strdup(GetCacheFileName(TEMPHTML, true, "temp"));
		fptr = fopen(TReturn, "wb");
		Return = TReturn;
	} else {		// What the hell are we pointing at?
		MOut("GrabHTTPLink(): File \"%s\" is of unknown type \"%s\"\n", Break->File, type);
		URLDelete(Break);
		return NULL;
	}
	DbgOut("GrabHTTPLink() Return Value: %s\n", Return);

	Interface.DLLabel("Opening connection... (%s %08X)", Break->Host, ip.sin_addr.s_addr);

	socketfd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);

	if (socketfd == -1) {
		MOut("GrabHTTPLink(): Error creating socket\n");
		CleanUp(socketfd, fptr, Break);
		return NULL;
	}

	SET_NONBLOCK(socketfd);

	if (connect(socketfd, (sockaddr *)&ip, sizeof(sockaddr)) && !INPROGRESS) {
		MOut("GrabHTTPLink(): Error connecting socket\n");
		perror("connect");
		CleanUp(socketfd, fptr, Break);
		return NULL;
	}

	while(!WaitForSocket(socketfd, 1)) {
		Interface.DLLabel("Awaiting connection... (%ds)", (++timeout)/10);
		if (timeout > (ValueTimeout->value() * 10)) {
			EOut("Error retrieving file, connection timed out.\n");
			CleanUp(socketfd, fptr, Break);
			return NULL;
		}
		if (Cancel) {
			DbgOut("Cancel clicked\n");
			CleanUp(socketfd, fptr, Break);
			return NULL;
		}
	}

	{
		int gettotal = 0, getcount = 0;
		Prefs->get("getcount", gettotal, 0);
		if (CurComicG) {
			CurComicG->get("getcount", getcount, 0);
		}
		Prefs->set("getcount", ++gettotal);
		if (CurComicG) {
			CurComicG->set("getcount", ++getcount);
		}
	}

	Interface.DLLabel("Sending GET Request...");

	Out("Requesting URL: %s\n", Break->Full);

	{
		char UserAgent[80] = "";
		if (CurComicG && CurComicG->entryExists("useragent")) {
			CurComicG->get("useragent", UserAgent, "", 79);
		}
		Request = nstrcat(13, 
			"GET ", Proxy ? Break->Full : Break->FullPath, " HTTP/1.1\r\n", 
			"Host: ", Break->Host, "\r\n",
			Referer ? "Referer: " : NULL, Referer ? Referer : NULL, Referer ? "\r\n" : NULL, 
			"User-Agent: ", strlen(UserAgent) ? UserAgent : USERAGENT, "\r\n",
			"Connection: close\r\n\r\n");
	}

	UOut("Sending HTTP request to: %s\n", Break->Host);
	UOut(Request);

	send(socketfd, Request, strlen(Request), 0);	// FIXME: Should maybe check for incomplete/failed send, but it seems unlikely

	Interface.DLLabel("Awaiting GET Response... (0s)");

	while(!WaitForSocket(socketfd)) {
		Interface.DLLabel("Awaiting GET Response... (%ds)", (++timeout)/10);
		if (timeout > (ValueTimeout->value() * 10)) {
			EOut("Error retrieving file, connection timed out.\n");
			CleanUp(socketfd, fptr, Break);
			return NULL;
		}
		if (Cancel) {
			DbgOut("Cancel clicked\n");
			CleanUp(socketfd, fptr, Break);
			return NULL;
		}
	}

	Cur = 0;

	DOut("Receiving GET response from: %s\n", Break->Host);
	Interface.DLLabel("Receiving GET Response... (0s)");

	while (!body) {
		if (recv(socketfd, &temp, 1, 0) <= 0) {
			EOut("Error retrieving URL, connection closed while reading header\n");
			CleanUp(socketfd, fptr, Break);
			return NULL;
		}
		Buffer[Cur++] = temp;
		DOut("%c", temp);
		if (temp == 0xA) {
			if (Cur == 2) { 
				body = true; 
			} else {
				char Header[80], Encoding[80];
				sscanf(Buffer, "%79s %79s", Header, Encoding);
				if (!strcmp(Header, "Transfer-Encoding:") && !strcmp(Encoding, "chunked")) { // "Transfer-Encoding: chunked"
					chunked = true;
				}
			}
			Cur = 0;
		}
		timeout = 0;
		while(!WaitForSocket(socketfd)) {
			Interface.DLLabel("Receiving GET response... (%ds)", (++timeout)/10);
			if (timeout > (ValueTimeout->value() * 10)) {
				EOut("Error retrieving file, connection timed out\n");
				CleanUp(socketfd, fptr, Break);
				return NULL;
			}
			if (Cancel) {
				DbgOut("Cancel clicked\n");
				CleanUp(socketfd, fptr, Break);
				return NULL;
			}
		}
	}

	DbgOut("Now receiving body\n");

	if (chunked) {
		DbgOut("Chunked transfer\n");
	}

	Interface.DLLabel("");

	Prefs->get("gigsdown", gigsdowntotal, 0);
	Prefs->get("bytesdown", bytesdowntotal, 0);
	if (CurComicG) {
		CurComicG->get("gigsdown", gigsdowncomic, 0);
		CurComicG->get("bytesdown", bytesdowncomic, 0);
	}

	if (Debug) {
		DbgOut("gigsdowntotal: %d bytesdowntotal: %d gigsdowncomic: %d bytesdowncomic: %d\n", gigsdowntotal, bytesdowntotal, gigsdowncomic, bytesdowncomic);
	}

	if (filelength) {
		Interface.DLRange(0.0f, (float)filelength);
		DbgOut("File Length: %ld\n", filelength);
	}

	while (socketfd > 0) {
		int chunklength = 0, chunkdone = 0;
		char chunkheader[16], tmp;
		if (chunked) {
				do {
					length = recv(socketfd, &tmp, 1, 0);
					if (length < 0) {
						if (!WOULDBLOCK) {
							EOut("Error while downloading URL, connection lost\n");
							CleanUp(socketfd, fptr, Break);
							return NULL;
						}
						tmp = 0;
					} else if (length == 0) {
						if (done < filelength) {
							EOut("Warning: Possible premature disconnection\n");
						}
						close(socketfd);
						socketfd = -1;
						tmp = 0xA;
					} else {
						chunkheader[Cur++] = tmp;
					}
				} while (tmp != 0xA);
				chunkheader[Cur] = 0; 		// End string
				Cur = 0;
				sscanf(chunkheader, "%x", &chunklength);
				DbgOut("Chunkheader: %s", chunkheader);		// Because the chunkheader has it's own newline
				DbgOut("Chunklength: %d\n", chunklength);
				if (!chunklength) {		// Hit the last chunk
					done = filelength;
					close(socketfd);
					socketfd = -1;
					DbgOut("Closed Socket\n");
				}
		} else {
				chunklength = filelength ? filelength : 4096;
		}
		chunkdone = 0;
		while ((socketfd > 0) && (chunkdone < chunklength)) {
			while(!WaitForSocket(socketfd)) {
				if (filelength) {
					Interface.DLLabel("%s %d/%d (%d%%) (%ds)", strlen(Break->File) ? Break->File : "index.html", 
						done, filelength, done*100/filelength, ++timeout/10);
				} else {
					Interface.DLLabel("%s %d (%ds)", strlen(Break->File) ? Break->File : "index.html", done, ++timeout/10);
				}
				if (timeout > (ValueTimeout->value() * 10)) {
					EOut("Error retrieving URL, connection timed out\n");
					CleanUp(socketfd, fptr, Break);
					return NULL;
				}
				if (Cancel) {
					DbgOut("Cancel clicked\n");
					CleanUp(socketfd, fptr, Break);
					return NULL;
				}
			}
			timeout = 0;
			length = recv(socketfd, Buffer, min(chunklength - chunkdone, 4096), 0);
			if (length < 0) {	// Error
				if (!WOULDBLOCK) {	// Not simply a nonblocking issue
					EOut("Error while downloading URL, connection lost\n");
					CleanUp(socketfd, fptr, Break);
					return NULL;
				}
			} else if (length == 0) { // Graceful disconnect
				if (done < filelength) {
					EOut("Warning: Possible premature disconnection\n");
				}
				close(socketfd);
				socketfd = -1;
				DbgOut("Closed socket\n");
			} else {
				fwrite(Buffer, 1, length, fptr);
				chunkdone += length;
				done += length;
				bytesdowntotal += length;
				bytesdowncomic += length;
				if (filelength) {
					Interface.DLLabel("%s %d/%d (%d%%) (0s)", strlen(Break->File) ? Break->File : "index.html", done,
						filelength, done*100/filelength);
					Interface.DLValue((float)done);
				} else {
					Interface.DLLabel("%s %d (0s)", strlen(Break->File) ? Break->File : "index.html", done);
				}
			}
		}
		if (chunked && (socketfd > 0)) {
			recv(socketfd, Buffer, 2, 0);		// Eat the CRLF at the end of the chunk
		}
	}

	if (bytesdowncomic >= (1024*1024*1024)) {
		gigsdowncomic++;
		bytesdowncomic -= (1024*1024*1024);
	}
	if (bytesdowntotal >= (1024*1024*1024)) {
		gigsdowntotal++;
		bytesdowntotal -= (1024*1024*1024);
	}
		

	Prefs->set("gigsdown", gigsdowntotal);
	Prefs->set("bytesdown", bytesdowntotal);
	if (CurComicG) {
		CurComicG->set("gigsdown", gigsdowncomic);
		CurComicG->set("bytesdown", bytesdowncomic);
	}

	if (Debug) {
		DbgOut("gigsdowntotal: %d bytesdowntotal: %d gigsdowncomic: %d bytesdowncomic: %d\n", gigsdowntotal, bytesdowntotal, gigsdowncomic, bytesdowncomic);
	}

	fclose(fptr);

	Interface.DLLabel("");
	Interface.DLValue(0.0);

	Out("Done with Request\n");

	URLDelete(Break);

	DbgOut("Returning: %s\n", Return);

	return Return;
}
