/*===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*/

#include <klib/extern.h>
#include <klib/out.h>
#include "writer-priv.h"
#include <klib/rc.h>
#include <sysalloc.h>

#include <stdarg.h>

LIB_EXPORT KWrtHandler G_out_handler;

LIB_EXPORT rc_t CC KOutInit ( void )
{
    rc_t rc;

    rc = KOutHandlerSetStdOut();

    return rc;
}

LIB_EXPORT rc_t CC KOutMsg ( const char * fmt, ... )
{
    va_list ap;
    rc_t rc;
    size_t used;
    char buffer [16 * 1024];

    if (fmt == NULL)
        return RC (rcRuntime, rcLog, rcLogging, rcParam, rcNull);

    va_start (ap, fmt);

    used = vknprintf (buffer, sizeof (buffer), fmt, ap);

    if (used == 0)
        return 0;
    else if (used > sizeof (buffer))
        rc = RC (rcRuntime, rcLog, rcFormatting, rcBuffer, rcInsufficient);
    else
    {
        char * pbuf;
        size_t to_write;
        size_t written;

        pbuf = buffer;
        written = 0;

        for (to_write = used; to_write > 0; to_write -= written)
        {
            void * pv;

            pv = KOutDataGet();
            rc = KOutWriterGet()(pv, pbuf, to_write, &written);
            if (rc) break;
            pbuf += written;
        }        
    }

    va_end (ap);

    return rc;
}


#ifdef KOutHandlerSetStdOut
#undef KOutHandlerSetStdOut
#endif
LIB_EXPORT rc_t CC KOutHandlerSetStdOut ( void )
{
    return KOutHandlerSet( KWrt_DefaultWriter, KWrt_DefaultWriterDataStdOut );
}


#ifdef KOutHandlerSetStdErr
#undef KOutHandlerSetStdErr
#endif
LIB_EXPORT rc_t CC KOutHandlerSetStdErr ( void )
{
    return KOutHandlerSet( KWrt_DefaultWriter, KWrt_DefaultWriterDataStdErr );
}


#ifdef KOutHandlerSet
#undef KOutHandlerSet
#endif
LIB_EXPORT rc_t CC KOutHandlerSet ( KWrtWriter writer, void * writer_data )
{
    G_out_handler.writer = writer;
    G_out_handler.data = writer_data;
    return 0;
}


#ifdef KOutDataGet
#undef KOutDataGet
#endif
LIB_EXPORT void * CC KOutDataGet ( void )
{
    return ( KOutHandlerGet()->data );
}


#ifdef KOutWriterGet
#undef KOutWriterGet
#endif
LIB_EXPORT KWrtWriter CC KOutWriterGet ( void )
{
    return ( KOutHandlerGet()->writer );
}


#ifdef KOutHandlerGet
#undef KOutHandlerGet
#endif
LIB_EXPORT KWrtHandler * CC KOutHandlerGet ( void )
{
    return ( &G_out_handler );
}



/* EOF */
