.TH SPLAT! 1 "16 de Septiembre de 2007" "KD2BD Software" "KD2BD Software"
.SH NOMBRE
splat  \- An RF \fBS\fPignal \fBP\fPropagation, \fBL\fPoss, \fBA\fPnd \fBT\fPerrain analysis tool
\fBSPLAT!\fP 

splat  \- Es una herramienta para el anlisis de Propagacin de Seales RF, Prdidas, y caractersticas del Terreno 
.SH SINOPSIS
splat [-t  \fIsitio_transmisor.qth\fP]
[-r \fIsitio_receptor.qth\fP]
[-c \fIrx altura de la antena para el anlisis de cobertura LOS (pies/metros) (flotante)\fP]
[-L \fIrx altura de la antena para el anlisis de cobertura Longley-Rice (pies/metros) (flotante)\fP]
[-p \fIperfil_terreno.ext\fP]
[-e \fIperfil_elevacion.ext\fP]
[-h \fIperfil_altura.ext\fP]
[-H \fIperfil_altura_normalizada.ext\fP]
[-l \fIperfil_Longley-Rice.ext\fP]
[-o \fInombre_archivo_mapa_topogrfico.ppm\fP]
[-b \fIarchivo_lmites_cartograficos.dat\fP]
[-s \fIbase_datos_sitios/ciudades.dat\fP]
[-d \fIruta_directorio_sdf\fP]
[-m \fIradio multiplicador tierra (flotante)\fP]
[-f \fIfrequencia (MHz) para clculos de la zona de Fresnel (flotante)\fP]
[-R \fImximo radio de covertura (millas/kilmetros) (flotante)\fP]
[-dB \fImximo contorno de atenuacin a presentar sobre un mapa de prdidas por trayectoria (80-230 dB)\fP]
[-fz \fIporcentaje despejado de la zona de Fresnel (default = 60)\fP]
[-plo \fIarchivo_salida_prdidas_por_trayectoria.txt\fP]
[-pli \fIarchivo_entrada_prdidas_por_trayectoria.txt\fP]
[-udt \fIarchivo_terreno_definido_por_el_usuario.dat\fP]
[-n]
[-N]
[-nf]
[-ngs]
[-geo]
[-kml]
[-metric]
.SH DESCRIPCIN
\fBSPLAT!\fP es una  poderosa herramienta  para el anlisis de terreno 
y propagacin RF cubriendo el espectro entre 20 Megahertz y 20 Gigahertz. 
\fBSPLAT!\fP es Software Libre y est diseado para operar en escritorios 
Unix y basados en Linux. La redistribucin y/ modificacin est permitida
bajo los trminos de la licencia pblica general GNU segn lo publicado por
la Fundacin de Software Libre, versin 2. La adopcin del cdigo fuente de
\fBSPLAT!\fP en aplicaciones propietarias o de fuente-cerrada  es una 
violacin de esta licencia, y esta \fBestrictamente\fP prohibida.

\fBSPLAT!\fP es distribudo con la esperanza de que sea til, pero 
SIN NINGUNA GARANTA, an la garanta implcita de COMERCIALIZACIN
 de la APLICACIN PARA UN PROPSITO PARTICULAR. Vea la licencia GNU 
para ms detalles.
.SH INTRODUCCIN
Las aplicaciones de \fBSPLAT!\fP incluyen la visualizacin, diseo, y 
anlisis de enlaces  de  redes inalmbricas WAN, sistemas de radio 
comunicaciones comerciales y aficionados  sobre los 20 megahertz,  
enlaces  microonda, estudios de interferencia y coordinacin de 
frecuencias, y determinacin del contorno de cobertura de las regiones
de radio y televisin terrestres anlogas y digitales. 

\fBSPLAT!\fP proporciona datos de ingeniera RF del sitio, tales como 
distancias sobre el arco terrestre y azimut entre sitios de transmisin
y recepcin, ngulos de elevacin de la antena (uptilt), ngulos de  
depresin (downtilt), altura de la antena sobre nivel del mar, altura de
la antena sobre el promedio del terreno, azimut, distancias y elevaciones 
para determinar obstrucciones, Atenuaciones de trayectoria Longley-Rice, 
e intensidad de seal recibida, Adicionalmente, los requisitos mnimos 
necesarios de altura de las antenas  para establecer trayectorias de 
comunicacin de lnea-de-vista sin obstrucciones debido al terreno, la 
primera zona de Fresnel, y cualquier porcentaje definido por el usuario 
de la primera zona de Fresnel.

\fBSPLAT!\fP produce informes, grficos, y  mapas topogrficos altamente 
detallados y cuidadosamente descritos que presentan las trayectorias de 
lnea-de-vista,  contornos regionales de prdidas por trayectoria y contornos
de intensidad de seal a travs de los cuales se puede determinar la prediccin 
del rea de cobertura de sistemas de transmisores y  repetidoras. Al realizar 
anlisis de lnea de vista y prdidas Longley-Rice cuando se emplean 
mltiples sitios de transmisores o repetidores, \fBSPLAT!\fP determina las 
reas de cobertura individuales y  mutuas  dentro de la red especificada.  

Simplemente tipee \fCsplat\fR en la consola de comandos, esto retornar un 
resumen de las opciones de lnea de comando de \fBSPLAT!\fP:
\fC


             --==[ SPLAT! v1.2.1 Available Options... ]==--

 -t txsite(s).qth ( max 4 con -c, max 30 con -L)
 -r rxsite.qth (sitio de recepcin)
 -c grafica la cobertura  del TX(s) (antena RX a X pies/metros SNT)
 -L grafica prdidas por trayectoria del TX (RX a X pies/metros SNT)
 -s nombre de archivo(s) de ciudades/sitios a importar (max 5)
 -b nombre de archivo(s) de lmites cartogrficos a importar (max 5)
 -p nombre de archivo para graficar el perfil del terreno 
 -e nombre de archivo para graficar la elevacin del terreno
 -h nombre de archivo para graficar la altura del terreno 
 -H nombre de archivo para graficar la altura normalizada del terreno
 -l nombre de archivo para graficar el modelo Longley-Rice
 -o nombre de archivo para generar el mapa topogrfico (.ppm)
 -u nombre del archivo del terreno definido-por-el-usuario a importar
 -d directorio que contiene los archivos sdf (reemplaza ~/.splat_path)
 -m multiplicador del radio de la tierra
 -n no grafica las rutas de LDV in mapas .ppm 
 -N no produce reportes innecesarios del sitio  reportes de obstruccin 
 -f frecuencia para el clculo de la zona de Fresnel (MHz)
 -R modifica el rango por defecto para -c  -L (millas/kilmetros)
 -db mximo contorno de prdidas por trayectoria  (80-230 dB)
 -nf no grafica la zona de Fresnel en  los grficos de  altura 
 -fz porcentaje de despeje de la zona de Fresnel (default = 60)
 -ngs muestra topografa de escala de grises en blanco (archivos .ppm)
 -erp valor ERP en lugar del declarado en el archivo .lrp (Watts)
 -pli nombre del archivo de entrada de prdidas-por-trayectoria
 -plo nombre del archivo de salida de prdidas-por-trayectoria
 -udt nombre del archivo de entrada de terreno definido-por-el-usuario
 -kml genera archivo compatible Google Earth .kml(enlaces punto-a-punto)
 -geo genera un archivo Xastir de georeferencia .geo (con salida .ppm) 
 -metric usa unidades mtricas en lugar de imperiales (I/O del usuario)
\fR
.SH FICHEROS DE ENTRADA
\fBSPLAT!\fP es una aplicacin manejada por linea de comandos  terminal de 
textos (shell), y lee los datos de entrada a travs de un nmero de ficheros 
de datos. Algunos archivos son obligatorios para la apropiada ejecucin del 
programa, mientras que otros son opcionales. Los archivos obligatorios incluyen 
los modelos topogrficos 3-arco segundo en la forma de archivos de datos de SPLAT 
(archivos SDF), archivos de localizacin del sitio (archivos QTH), y archivos de 
parmetros para el modelo  Longley-Rice (archivos LRP). 
Los archivos opcionales incluyen archivos de localizacin de ciudades/sitios, 
archivos de lmites cartogrficos, archivos de terreno definidos por el usuario, 
archivos de entrada de prdidas-por-trayectoria, archivos de patrones de 
radiacin de antenas, y archivos de definicin de color.
.SH FICHEROS DE DATOS SPLAT
\fBSPLAT!\fP importa los datos topogrficos desde los ficheros de datos SPLAT 
(SDFs). Estos archivos se pueden generar desde varias fuentes de informacin. 
En los Estados Unidos, los ficheros de datos  SPLAT se pueden generar a travs 
de la U.S.  Geological Survey Digital Elevation Models (DEMs) usando la herramienta 
usgs2sdf incluida con \fBSPLAT!\fP. Los modelos de elevacin digital USGS compatibles 
con esta utilidad pueden ser descargados de: 
\fIhttp://edcftp.cr.usgs.gov/pub/data/DEM/250/\fP.

Una resolucin significativamente mejor se puede obtener con el uso 
de los modelos digitales de  elevacin versin 2 SRTM-3. Estos modelos 
son el resultado de la misin topografca del radar  espacial Shuttle 
STS-99, y estn disponibles para la mayora de las regiones pobladas de 
la tierra. Los ficheros de datos SPLAT pueden ser generados desde los 
datos SRTM usando la herramienta incluida srtm2sdf. Los archivo SRTM-3 
versin 2 se pueden obtener a travs de FTP annimo desde: 
\fIftp://e0srp01u.ecs.nasa.gov:21/srtm/version2/\fP

La utilidad \fBstrm2sdf\fP tambin puede ser usada para convertir  los datos
SRTM 3-arco segundo en formato Band Interleaved by Line (.BIL) para usar con
\fBSPLAT!\fP.
Estos datos estn disponibles va web en:
\fIhttp://seamless.usgs.gov/website/seamless/\fP

los datos Band Interleaved by Line deben ser descargados en una manera especfica
para ser compatible con \fBsrtm2sdf\fP y \fBSPLAT!\fP. por favor consulte
la documentacin \fBsrtm2sdf\fP's para instrucciones sobre la descarga de datos
topogrficos .BIL a travs del Sitio Web USGS's Seamless.

A pesar de la exactitud ms alta que los datos SRTM ofrecen, existen  algunos 
vacos en los conjuntos de datos. Cuando se detectan estos vacos, la utilidad 
\fBsrtm2sdf\fP los substituye por los datos  encontrados en los  archivos SDF 
existentes (que presumiblemente fueron creados de datos anteriores de la USGS 
con la utilidad \fBusgs2sdf\fP). Si los datos SDF, USGS-derivados no estn 
disponibles, los vacos se reemplazan con el promedio de los pixeles adyacentes, 
o reemplazo directo.

Los ficheros de datos de SPLAT contienen valores enteros de las elevaciones 
topogrficas (en metros) referenciados al nivel del mar para regiones de la 
tierra de 1-grado por 1-grado con una resolucin de 3-arco segundos. Los 
archivos SDF pueden ser ledos desde el formato estndar (\fI.sdf\fP) 
generado por las utilidades \fBusgs2sdf\fP  y \fBsrtm2sdf\fP,  en formato 
comprimido bzip2 (.sdf .bz2). Puesto que los archivos sin comprimir se pueden 
procesar ligeramente ms rpido que los archivos comprimidos, \fBSPLAT!\fP busca 
los datos SDF necesarios en formato sin comprimir primero. Si los datos sin 
comprimir no pueden ser localizados, \fBSPLAT!\fP entonces busca los datos en 
formato comprimido  bzip2. Si tampoco se pueden encontrar los archivos SDF 
comprimidos para la regin solicitada, \fBSPLAT!\fP asume que la regin es 
el ocano, y asignar una elevacin del nivel del mar a estas reas.

Esta caracterstica de \fBSPLAT!\fP permite realizar el anlisis de 
trayectorias no solamente sobre la tierra, sino tambin entre las reas 
costeras no representadas por los datos del Modelo de Elevacin Digital. 
Sin embargo, este comportamiento de \fBSPLAT!\fP resalta la importancia 
de tener todos los archivos SDF requeridos para la regin a ser analizada, 
para as obtener resultados significativos.
.SH ARCHIVOS DE LOCALIZACIN DEL SITIO (QTH)
\fBSPLAT!\fP SPLAT! importa la  informacin de la localizacin de los sitios 
del transmisor y del receptor analizados por el programa de los archivos 
ASCII que tienen una extensin \fI.qth\fP. Los archivos QTH contienen el 
nombre del sitio, la latitud del sitio (positiva al norte del ecuador, 
negativa al sur), la longitud del sitio (en grados oeste W de 0 a 360 grados), 
y; La altura de la antena del sitio sobre el nivel del suelo (AGL), cada
uno separado por un caracter de salto-de-lnea. La altura de la antena se 
asume a ser especificada en pies a menos que sea seguida por la letra \fIm\fP 
o de la palabra  \fImeters\fP  en maysculas  minsculas. La informacin de la 
latitud y de la longitud se puede expresar en  formato decimal (74.6889) 
 en formato grados, minutos, segundos (DMS) (74 41 20.0). 

Por ejemplo, un archivo de localizacin de sitio que describa la estacin de 
televisin WNJT-DT, Trenton, NJ (\fIwnjt-dt.qth\fP) se puede  leer como sigue:

\fC
        WNJT-DT
        40.2828
        74.6864
        990.00
\fR

Cada sitio de transmisor y receptor analizado por \fBSPLAT!\fP debe ser 
representado por su propio archivo de la localizacin de sitio (QTH).
.SH ARCHIVOS DE PARMETROS LONGLEY-RICE (LRP) 
Los archivos de datos de parmetros Longley-Rice son requeridos 
por \fBSPLAT!\fP para determinar ls prdidas por trayectoria RF
ya sea en el modo punto-a-punto  prediccin de rea. Los datos de 
parmetros para el modelo Longley-Rice desde archivos que tienen el 
mismo nombre base del archivo QTH del sitio del transmisor, pero con 
extensin \fI.lrp\fP. Los Archivos \fBSPLAT!\fP LRP comparte el
siguiente formato (\fIwnjt-dt.lrp\fP):

\fC
        15.000  ; Earth Dielectric Constant (Relative permittivity)
        0.005   ; Earth Conductivity (Siemens per meter)
        301.000 ; Atmospheric Bending Constant (N-units)
        647.000 ; Frequency in MHz (20 MHz to 20 GHz)
        5       ; Radio Climate (5 = Continental Temperate)
        0       ; Polarization (0 = Horizontal, 1 = Vertical)
        0.50    ; Fraction of situations (50% of locations)
        0.90    ; Fraction of time (90% of the time)
        46000.0 ; ERP in Watts (optional)

\fR
Si un archivo LRP correspondiente al archivo QTH del sitio de 
transmisin no puede ser encontrado, \fBSPLAT!\fP explorar el 
directorio de trabajo actual buscando el archivo "splat.lrp". Si 
este archivo tampoco puede ser encontrado, entonces los parmetros 
por defecto enumerados arriba sern asignados por \fBSPLAT!\fP y un 
archivo correspondiente "splat.lrp" conteniendo estos parmetros por 
defecto ser escrito al directorio actual de trabajo. El archivo 
"splat.lrp" generado se puede editar de acuerdo a las necesidades del 
usuario. 

Las constantes dielctricas tpicas de la tierra y sus valores de 
conductividad son los siguientes:
\fC

                           Dielectric Constant  Conductivity
        Salt water       :        80                5.000
        Good ground      :        25                0.020
        Fresh water      :        80                0.010
        Marshy land      :        12                0.007
        Farmland, forest :        15                0.005
        Average ground   :        15                0.005
        Mountain, sand   :        13                0.002
        City             :         5                0.001
        Poor ground      :         4                0.001
\fR

Los cdigos de Clima de Radio usados por \fBSPLAT!\fP son los siguientes: 

\fC
        1: Equatorial (Congo)
        2: Continental Subtropical (Sudan)
        3: Maritime Subtropical (West coast of Africa)
        4: Desert (Sahara)
        5: Continental Temperate
        6: Maritime Temperate, over land (UK and west coasts of US & EU)
        7: Maritime Temperate, over sea
\fR

El clima templado continental es comn a las grandes masas de la tierra 
en la zona templada, tal como los Estados Unidos. Para trayectorias 
inferiores a 100 kilmetros, es poca la diferencia entre los climas templados 
continentales y martimos.

Los parmetros sptimo y octavo en el archivo \fI.lrp\fP corresponden al anlisis estadstico 
proporcionado por el modelo Longley-Rice. En este ejemplo, \fBSPLAT!\fP devolver 
la mxima prdida de trayectoria que ocurre el 50%  del tiempo (fraccin del tiempo) 
en el 90% de las situaciones (fraccin de situaciones). Esto es a menudo denotado
como F(50,90) en los estudios Longley_Rice. En los Estados Unidos un criterio
F(50,90) es tpicamente usado para televisin digital (8-level VSB modulation), 
mientras que F(50,50) es usado para radiodifusin analgica (VSB-AM+NTSC). 

Para mayor informacin de esos parmetros, puede visitar:
\fIhttp://flattop.its.bldrdoc.gov/itm.html\fP and
\fIhttp://www.softwright.com/faq/engineering/prop_longley_rice.html\fP

El parmetro final en el archivo \fI.lrp\fP corresponde a la potencia 
efectiva radiada, y es opcional. Si esta es incluida en el archivo 
\fI.lrp\fP, entonces \fBSPLAT!\fP computar los niveles de intesidad de
seal y los contornos de niveles de intensidad de campo cuando se realicen
los estudios Longley-rice. Si el parmetro es omitido, se computan las 
prdidas por trayectoria en su lugar. El ERP provisto en el archivo \fI.lrp\fP
puede ser invalidado usando la opcin \fBSPLAT!\fP de lnea-de-comando
\fI-erp\fP sin tener que editar el archivo \fI.lrp\fP para conseguir el
mismo resultado.
.SH ARCHIVOS DE LOCALIZACIN DE CIUDADES
Los nombres y las localizaciones de ciudades, sitios de la torre, u otros 
puntos de inters se pueden importar y trazar en los mapas topogrficos 
generados por \fBSPLAT!\fP. \fBSPLAT!\fP importa los nombres de ciudades y 
localizaciones de los archivos ASCII que contienen el nombre, latitud y longitud
de la localizacin de inters. Cada campo es separado por una coma. 
Cada expediente es separado por un caracter de salto-de-linea. Al igual que 
con los archivos \fI.qth\fP, la informacin de la latitud y la longitud se puede 
ingresar en  formato decimal  en formato de grados, minutos, segundos (DMS).

Por ejemplo (\fIcities.dat\fP):
\fC
        Teaneck, 40.891973, 74.014506
        Tenafly, 40.919212, 73.955892
        Teterboro, 40.859511, 74.058908
        Tinton Falls, 40.279966, 74.093924
        Toms River, 39.977777, 74.183580
        Totowa, 40.906160, 74.223310
        Trenton, 40.219922, 74.754665
\fR

Un total de cinco ficheros de datos separados de ciudades se pueden 
importar a la vez, y no hay lmite al tamao de estos archivos. 
\fBSPLAT!\fP lee datos de las ciudades en base a "primero ingresada 
primero servida", y traza solamente las localizaciones cuyas anotaciones 
no estn en conflicto con anotaciones de las localizaciones ledas 
anteriormente durante en el archivo actual de datos de ciudades,  en
archivo previos. Este comportamiento en \fBSPLAT!\fP  reduce al mnimo 
el alboroto al generar  los mapas topogrficos, pero tambin determina 
que por mandato las localizaciones importantes estn puestas al principio 
del primer fichero de datos de ciudades, y las localizaciones de menor 
importancia sean colocadas a continuacin en la lista o en los ficheros 
de datos subsecuentes.

Los ficheros de datos de las ciudades se pueden generar manualmente 
usando cualquier editor de textos, importar de otras fuentes, o derivar 
de los datos disponibles de la oficina de censo de los Estados Unidos, 
usando la herramienta \fBcitydecoder\fP incluida con \fBSPLAT!\fP. 
Estos datos estn disponibles gratuitamente va Internet en: 
http://www.census.gov/geo/www/cob/bdy_files.html, y deben estar en 
formato ASCII.
.SH ARCHIVOS DE DATOS DE LIMITES CARTOGRFICOS
Los datos cartogrficos de lmites se pueden tambin importar para trazar 
los lmites de las ciudades,  condados, o estados en los mapas topogrficos 
generados por \fBSPLAT!\fP. Estos datos deben estar en el formato de  metadatos 
de archivos cartogrficos de lmites  ARC/INFO Ungenerate (formato ASCII), y 
estn disponibles para los E.E.U.U..en la Oficina de Censos va Internet en: 
\fIhttp://www.census.gov/geo/www/cob/co2000.html#ascii\fP y
\fIhttp://www.census.gov/geo/www/cob/pl2000.html#ascii\fP. Un total de cinco 
archivos cartogrficos separados de lmites se puede importar a la vez. 
No es necesario importar lmites de estado si ya  se han importado los 
lmites del condado.
.SH OPERACIN DEL PROGRAMA
\fBSPLAT!\fP Debido a que \fBSPLAT!\fP hace un uso intensivo del CPU y 
la memoria, se invoca va lnea de comandos usando una serie de opciones 
y argumentos, este tipo de interfaz reduce al mnimo gastos indirectos y 
se presta a operaciones  escriptadas (batch). El uso de CPU y prioridad 
de memoria por \fBSPLAT!\fP se pueden modificar con el uso de comandos 
\fBnice\fP Unix.

El nmero y el tipo de opciones pasados a \fBSPLAT!\fP determinan su modo de 
operacin y el mtodo de generacin de los datos de  salida. Casi todos los 
opciones de \fBSPLAT!\fP se pueden llamar en cascada y en cualquier orden 
al invocar el programa desde la lnea de comandos.

\fBSPLAT!\fP opera en dos modos distintos: \fImodo punto-a-punto\fP,
y \fImodo de prediccin del rea de cobertura\fP, y puede ser invocado por el 
usuario usando el modo de lnea de vista (LOS)  el  modelo  de propagacin 
sobre terreno irregular (ITM) Longley-Rice. El radio de tierra verdadera, 
cuatro-tercios, o cualquier otro radio de la tierra definido-por-el-usuario 
pueden ser especificados al realizar los anlisis de lnea-de-vista.
.SH ANLISIS PUNTO-A-PUNTO
\fBSPLAT!\fP puede ser utilizado para determinar si existe lnea de vista 
entre dos localizaciones especificadas realizando para ello el anlisis del 
perfil del terreno. Por ejemplo:

\fCsplat -t tx_site.qth -r rx_site.qth\fR

invoca un anlisis del perfil del terreno entre el transmisor especificado en 
\fItx_site.qth\fP y el receptor especificado en \fIrx_site.qth\f, y escribe un  
Reporte de Obstrucciones \fBSPLAT!\fP al directorio de trabajo actual. El reporte 
contiene los detalles de los sitios del transmisor y del receptor, e identifica la 
localizacin de cualquier obstruccin detectada a lo largo de la trayectoria de 
lnea-de-vista. Si una obstruccin puede ser despejada levantando la antena de 
recepcin a una mayor altitud, \fBSPLAT!\fP indicar la altura mnima de la antena 
requerida para que exista lnea-de-vista entre las localizaciones del transmisor y 
el receptor especificadas. Observe que las unidades imperiales (millas, pies) se 
usan por defecto, a menos que se use la opcin \fI-metric\fP en la orden \fBSPLAT!\fP 
de lnea de comandos.

\fCsplat -t tx_site.qth -r rx_site.qth -metric\fR

Si la antena se debe levantar una cantidad significativa, esta determinacin 
puede tomar una cierta cantidad de tiempo. Observe que los resultados 
proporcionados son el \fImnimo\fP necesario para que exista una trayectoria 
de la lnea-de-vista, y en el caso de este simple ejemplo, no considera los 
requisitos de la zona de Fresnel.

Las extensiones \fIqth\fP son asumidas por SPLAT! para los archivos QTH, y 
son opcionales cuando se especifican los argumentos -t y -r en la lnea de
comandos. \fBSPLAT!\fP lee automticamente todos los ficheros de datos de 
SPLAT necesarios para el anlisis del terreno entre los sitios especificados. 
\fBSPLAT!\fP busca primero los archivos SDF necesarios  en el directorio de 
trabajo actual. Si estos archivos no se encuentran, \fBSPLAT!\fP entonces 
busca en la ruta especificada por la opcin \fI-d\fP:

\fCsplat -t tx_site -r rx_site -d /cdrom/sdf/\fR

Una ruta a un directorio externo puede ser especificada creando el archivo 
".splat_path" en el directorio de trabajo del usuario. Este archivo \fI$HOME/.splat_path\fP 
debe contener una sola lnea de texto ASCII en  la que indique la ruta  
completa  del directorio que contiene todos los archivos SDF.  

\fC/opt/splat/sdf/\fR

Y puede ser generado usando cualquier editor de texto.

Un grfico que muestre el perfil del terreno en funcin de la distancia, 
partiendo desde el receptor, entre las localizaciones del transmisor y 
receptor se puede generar adicionando la opcin \fI-p\fP:

\fCsplat -t tx_site -r rx_site -p terrain_profile.png\fR

SPLAT! invoca al programa \fBgnuplot\fP cuando genera los grficos. 
La extensin del nombre del archivo especificado a \fBSPLAT!\fP determina 
el formato del grfico a ser producido \fI.png\fP generar un archivo de grfico 
PNG a color con una resolucin de 640x480, mientras que \fI.ps\fP o \fI.postscript\fP 
generarn archivos de salida postscritp. La salida en formatos como GIF, 
Adobe Illustrator, AutoCAD dxf, LaTex, y muchos otros estn disponibles. 
Por favor consulte \fBgnuplot\fP, y la documentacin de \fBgnuplot\fP para 
detalles de todos los formatos de salida soportados.

En el lado del receptor  un grfico de elevaciones en funcin de la 
distancia determinado por el ngulo de inclinacin debido al terreno 
entre el receptor y el transmisor se puede generar usando la opcin \fI-e\fP:

\fCsplat -t tx_site -r rx_site -e elevation_profile.png\fR

El grfico producido usando esta opcin ilustra los ngulos de elevacin 
y depresin   resultado del terreno entre la localizacin del receptor y 
el sitio del transmisor desde la perspectiva   del receptor. Un segundo 
trazo es dibujado entre el lado izquierdo del grfico (localizacin del 
receptor) y la localizacin de la antena que transmite a la derecha. 
Este trazo ilustra el ngulo de elevacin requerido para que exista  una 
trayectoria de lnea-de-vista entre el receptor y transmisor. Si la traza 
interseca el perfil de elevacin en cualquier punto del grfico, entonces 
esto es una indicacin que bajo las condiciones dadas no existe una 
trayectoria de lnea-de-vista, y las obstrucciones se pueden identificar 
claramente en el grfico en los puntos de interseccin.

Un grfico ilustrando la altura del terreno referenciado a la trayectoria 
de lnea-de-vista entre el transmisor y el receptor se puede generar 
usando la opcin \fI-h\fP:

\fCsplat -t tx_site -r rx_site -h height_profile.png\fR

La altura del terreno normalizada a las alturas de las antenas del transmisor 
y receptor pueden ser obtenidas con la opcin \fI-H\fP:

\fCsplat -t tx_site -r rx_site -H normalized_height_profile.png\fR

El contorno de curvatura de la Tierra tambin es graficada en este modo.

La primera Zona de Fresnel, y el 60% de la primera Zona de Fresnel puede ser 
adicionada al grfico de perfiles de altura con la opcin \fI-f\fP, y 
especificando una frecuencia (en MHz) a la cual la Zona de Fresnel ser modelada:

\fCsplat -t tx_site -r rx_site -f 439.250 -H normalized_height_profile.png\fR

Zonas de despeje de la zona de Fresnel distintas al 60% pueden ser especificadas
usando la opcin \fI-fz\fP como sigue:

\fCsplat -t tx_site -r rx_site -f 439.250 -fz 75 -H height_profile2.png\fR

Un grfico que muestre las prdidas de trayectoria Longley-Rice se puede 
dibujar usando la opcin \fI-l\fP:

\fCsplat -t tx_site -r rx_site -l path_loss_profile.png\fR

Como antes, adicionando la opcin \fI-metric\fP se forza al grfico 
a usar unidades de medida mtrica.

Al realizar un anlisis punto-a-punto, un reporte \fBSPLAT!\fP de anlisis
de trayectoria es generado en la forma de un archivo de texto con una 
extensin de archivo \fI.txt\fP. El reporte contiene azimut y distancias
entre el transmisor y receptor, as mismo cuando se analizan las perdidas 
por espacio-libre y trayectoria Longley-Rice. El modo de propagacin para
la trayectoria est dado como \fILnea-de-Vista\fP, \fIHorizonte Simple\fP,
\fIHorizonte Doble\fP, \fIDifraccin dominante\fP,  \fITroposcatter 
dominante\fP.

Distancias y localizaciones para identificar las obtrucciones
a lo largo de la trayectoria entre el transmisor y el receptor
tambin se proveen. Si la potencia efectiva radiada del transmisor es 
especificada en el archivo \fI.lrp\fP del transmisor correspondiente,
entonces la prediccin de intensidad de seal y voltaje de antena
en la localizacin de recepcin tambin se provee en el reporte de
anlisis de trayectoria.

Para determinar la relacin seal-a-ruido (SNR) en el sitio remoto 
donde el ruido (trmico) aleatorio de Johnson es el el factor 
limitante primario en la recepcin:

.EQ
SNR = T - NJ - L + G - NF
.EN

donde \fBT\fP es la potencia ERP del transmisor en dBW en la direccin 
del recedptor, \fBNJ\fP es el ruido de Johnson en dBW (-136 dBW para un 
canal de  TV de 6 MHz), \fBL\fP es las prdidas por trayectoria provistas
por \fBSPLAT!\fP en dB (como un nmero \fIpositivo\fP), \fBG\fP es la ganancia 
de la antena receptora en dB referenciada a un radiador isotrpico, 
y \fBNF\fP es la figura de ruido en el receptor en dB.

\fBT\fP puede ser computado como sigue:

.EQ
T = TI + GT
.EN

donde \fBTI\fP es la cantidad actual de potencia RF entregada a la antena 
transmisora en dBW, \fBGT\fP  es la ganancia de la antena transmisora 
(referenciada a una isotrpica) en la direccin del receptor ( al horizonte 
si el receptor est sobre el horizonte).

Para calcular cuanta mas seal est disponible sobre el mnimo necesario para 
conseguir una especfica relacin seal-a-ruido:

.EQ
Signal_Margin = SNR - S
.EN

donde \fBS\fP es la mnima relacin SNR deseada (15.5 dB para 
ATSC (8-level VSB) DTV, 42 dB para televisin analgica NTSC).

Un mapa topogrfico puede ser generado por \fBSPLAT!\fP para visualizar 
la trayectoria entre el transmisor y el receptor desde otra perspectiva. 
Los mapas topogrficos generados por \fBSPLAT!\fP presentan las elevaciones 
usando una escala de grises logartmica, con las elevaciones ms altas 
representadas a travs de capas ms brillantes de gris. El rango dinmico 
de la imagen es escalada entre las elevaciones ms altas y ms bajas presentes 
en el mapa. La nica excepcin de esto es al nivel del mar, el cual se representa 
usando el color azul.

La salida topogrfica se puede especificar  usando la opcin \fI-o\fP:

\fCsplat -t tx_site -r rx_site -o topo_map.ppm\fR

La extensin \fI.ppm\fP del archivo de salida es asumida por \fBSPLAT!\fP,  
y es opcional.

En este ejemplo, \fItopo_map.ppm\fP ilustrar las localizaciones de los 
sitios especificados del transmisor y del receptor. Adems, la trayectoria 
entre los dos sitios ser dibujada sobre las localizaciones para las cuales 
existe una trayectoria sin obstculo hacia el transmisor con  una altura de 
la antena de recepcin  igual a la del sitio del receptor (especificado en 
\fIrx_site.qth\fP).

Puede ser deseable poblar el mapa topogrfico con nombres y localizaciones 
de ciudades, sitios de torres, o de otras localizaciones importantes. 
Un archivo de ciudades se puede pasar a \fBSPLAT!\fP usando  la opcin \fI-s\fP:

\fCsplat -t tx_site -r rx_site -s cities.dat -o topo_map\fR

Hasta cinco archivos separados pueden ser pasados a \fBSPLAT!\fP a la vez 
luego de la opcin \fI-s\fP.

Lmites de estados y ciudades pueden ser adicionados al mapa especificando 
hasta cinco archivos de lmites cartogrficos de Censo Bureu de los U.S. 
usando la opcin \fI-b\fP:

\fCsplat -t tx_site -r rx_site -b co34_d00.dat -o topo_map\fR

En situaciones donde mltiples sitios de transmisores estn en uso, 
se pueden pasar a \fBSPLAT!\fP hasta cuatro localizaciones simultneas para 
sus  anlisis:

\fCsplat -t tx_site1 tx_site2 tx_site3 tx_site4 -r rx_site -p profile.png\fR

En este ejemplo, \fBSPLAT!\fP genera cuatro reportes separados de obstruccin y 
de perfiles de terreno . Un simple mapa topogrfico puede ser especificado 
usando la opcin \fI-o\fP, y las trayectorias de lnea de vista entre cada 
transmisor y el sitio indicado del receptor ser producido en el mapa, cada 
uno en su propio color. La trayectoria entre el primer transmisor especificado 
al receptor ser verde, la trayectoria entre el segundo transmisor y el receptor 
ser cyan, la trayectoria entre el tercer transmisor y el receptor ser violeta, 
y la trayectoria entre el cuarto transmisor y el receptor ser siena.

Los mapas topogrficos generados por SPLAT! son imgenes TrueColor PixMap 
Portables de 24-bit  (PPM) y pueden ser vistos, corregidos, o convertidos 
a otros formatos grficos usando  populares programas de imgenes tales 
como \fBxv\fP, \fBThe GIMP\fP, \fBImageMagick\fP, and \fBXPaint\fP. 
El formato PNG es altamente recomendado para el almacenamiento comprimido 
sin prdidas de los archivos topogrficos de salida  generados por SPLAT!. 
La utilidad de lnea de comandos \fBImageMagick\fP's convierte fcilmente los 
archivos grficos SPLAT! PPM al formato PNG:

\fCconvert splat_map.ppm splat_map.png\fR

Otra utilidad de de lnea de comandos excelente para convertir archivos PPM a
PNG es wpng, y est disponible en:  \fIhttp://www.libpng.org/pub/png/book/sources.html\fP. 
Como recurso adicional, los archivos PPM pueden ser comprimidos usando la 
utilidad bzip2, y ser ledos directamente en este formato por \fBThe GIMP\fP.

La opcin \fI-ngs\fP asigna a todo el terreno el color blanco, y puede
ser usada cuando se quiere generar mapas desprovistos de terreno

\fCsplat -t tx_site -r rx_site -b co34_d00.dat -ngs -o white_map\fR

El archivo imagen .ppm resultante puede ser convertido al formato .png
con un fondo transparente usando la utilidad \fBconvert\fP de \fBImageMagick\fP's.

\fCconvert -transparent "#FFFFFF" white_map.ppm transparent_map.png\fR
.SH DETERMINANDO LA COBERTURA REGIONAL
\fBSPLAT!\fP puede analizar un sitio de transmisor  repetidora, 
 redes de sitios, y predecir la cobertura regional para cada sitio 
especificado. En este modo \fBSPLAT!\fP puede generar un mapa topogrfico 
presentando la lnea-de-vista geomtrica del rea de cobertura  de  
los sitios, basados en la localizacin de cada sitio y la altura de 
la antena receptora que se desea comunicar con el sitio en cuestin. 
Un anlisis regional puede ser realizado por  \fBSPLAT!\fP usando la
opcin \fI-c\fP como sigue:

\fCsplat -t tx_site -c 30.0 -s cities.dat -b co34_d00.dat -o tx_coverage\fR

En este ejemplo, SPLAT! genera un mapa topogrfico llamado \fItx_coverage.ppm\fP 
que ilustra la prediccin de cobertura regional de lnea-de-vista del \fItx_site\fP 
a las estaciones receptoras que tienen una antena de 30 pies de altura sobre el 
nivel del terreno (AGL). Si la opcin \fI-metric\fP es usada, el argumento que 
sigue a la opcin \fI-c\fP es interpretada en metros, en lugar de pies. El contenido 
de cities.dat son dibujados sobre el mapa, como tambin los lmites cartogrficos 
contenidos en el archivo \fIco34_d00.dat\fP.

Cuando se grafica las trayectorias de lnea-de-vista y las reas de 
cobertura regional, \fBSPLAT!\fP por defecto no considera los efectos 
de la flexin atmosfrica. Sin embargo esta caracterstica puede ser 
modificada usando el multiplicador de radio de la tierra con la opcin (\fI-m\fP):

\fCsplat -t wnjt-dt -c 30.0 -m 1.333 -s cities.dat -b counties.dat -o map.ppm\fR

Un radio multiplicador de 1.333 instruye a  \fBSPLAT!\fP a usar el modelo de 
"cuatro-tercios" para el anlisis de propagacin de lnea de vista. 
Cualquier multiplicador del radio de la tierra apropiado puede ser seleccionado 
por el usuario.

Cuandorealiza un anlisis regional, \fBSPLAT!\fP genera un reporte para cada 
estacin analizada. Los reportes de sitio \fBSPLAT!\fP contienen detalles de 
la localizacin geogrfica del sitio, su altura sobre el nivel del mar, 
la altura de la antena sobre el promedio del terreno, y la altura del promedio 
del terreno calculada en las direcciones de los azimut de 0, 45, 90, 135, 
180, 225, 270, y 315 grados.
.SH DETERMINANDO MLTIPLES REGIONES DE COBERTURA DE LDV

\fBSPLAT!\fP tambin puede presentar reas de cobertura de lnea-de-vista hasta 
para  cuatro sitios de transmisores separados sobre un mapa topogrfico comn. 
Por ejemplo: 

\fCsplat -t site1 site2 site3 site4 -c 10.0 -metric -o network.ppm\fR

Grafica las coberturas regionales de lnea de vista del  site1 site2 site3 
y site4 basado en una antena receptora localizada a 10.0 metros sobre el nivel 
del terreno. Un mapa topogrfico entonces es escrito al archivo \fInetwork.ppm\fP. 
El rea de cobertura de lnea-de-vista del transmisor es graficada como sigue 
en los colores indicados (junto con sus valores RGB correspondientes en decimal):
\fC
    site1: Green (0,255,0)
    site2: Cyan (0,255,255)
    site3: Medium Violet (147,112,219)
    site4: Sienna 1 (255,130,71)

    site1 + site2: Yellow (255,255,0)
    site1 + site3: Pink (255,192,203)
    site1 + site4: Green Yellow (173,255,47)
    site2 + site3: Orange (255,165,0)
    site2 + site4: Dark Sea Green 1 (193,255,193)
    site3 + site4: Dark Turquoise (0,206,209)

    site1 + site2 + site3: Dark Green (0,100,0)
    site1 + site2 + site4: Blanched Almond (255,235,205)
    site1 + site3 + site4: Medium Spring Green (0,250,154)
    site2 + site3 + site4: Tan (210,180,140)

    site1 + site2 + site3 + site4: Gold2 (238,201,0)
\fR

Si se generan archivos \fI.qth\fP separados, cada uno representando una 
localizacin de un sitio comn, pero con diferentes alturas de antena, 
\fBSPLAT!\fP puede generar un mapa topogrfico sencillo que ilustra la 
cobertura regional desde las estaciones (hasta cuatro) separadas por la 
altura en un nica torre.
.SH ANALISIS DE PRDIDAS POR TRAYECTORIA LONGLEY-RICE 
Si la opcin \fI-c\fP  se reemplaza por la opcin \fI-L\fP, se puede generar un mapa 
de prdidas de trayectorias Longley-Rice:

\fCsplat -t wnjt -L 30.0 -s cities.dat -b co34_d00.dat -o path_loss_map\fR

En este modo, \fBSPLAT!\fP genera un mapa multicolor que ilustra los niveles de 
seal esperados (prdidas por trayectoria) en las reas alrededor del 
transmisor. Una leyenda en la parte inferior del mapa relaciona cada color 
con sus respectivas prdidas por trayectoria especficas en decibeles 
intensidad de seal en decibeles sobre un microvoltio por metro (dBuV/m).

El rango de anlisis Longley-Rice puede modificado a un valor especfico-de-usuario
con la opcin \fI-R\fP. El argumento debe ser dado en millas ( kilmetros si la 
opcin \fI-metric\fP es usada). Si se especifica un rango mayor que el mapa topogrfico 
generado, \fBSPLAT!\fP realizar los clculos de perdidas Longley-Rice de trayectoria 
entre todas las cuatro esquinas del rea del mapa  de prediccin.

La opcin \fI-db\fP permite limitar el mximo de perdidas de la regin 
a ser graficada en el mapa. Prdidas de trayectoria entre 80 y 230 dB
pueden ser especificadas usando esta opcin. Por ejemplo si las perdidas 
por debajo de -140 dB son irrelevantes al anlisis que se est realizando,  
entonces las prdidas por trayectoria a ser graficadas por \fBSPLAT!\fP 
pueden ser limitadas a la regin de atenuacin del contorno de 140 dB 
como sigue:

\fCsplat -t wnjt-dt -L 30.0 -s cities.dat -b co34_d00.dat -db 140 -o plot.ppm\fR
.SH PARMETROS PARA LA DEFINICIN DE COLOR DEL CONTORNO DE LA SEAL
Los colores usados para ilustrar los contornos de intensidad de seal y
de prdidas por trayectoria en la generacin de mapas de mapa de cobertura
en \fBSPLAT!\fP pueden ser adaptados por el usuario creando o modificando
los archivo de definicin de color \fBSPLAT!\fP. Los ardchivos de definicin
de color \fBSPLAT!\fP tienen el mismo nombre base que el del archivo \fI.qth\fP
del transmisor, pero llevan las extensiones \fI.lcf\fP y \fI.scf\fP.

Cuando un anlisis regional  Longley-Rice es realizado y el ERP del transmisor no
se ha especificado  es cero, un archivo de definicin de color de prdidas por
trayectoria \fI.lcf\fP correspondiente al sitio del transmisor (\fI.qth\fP)
es ledo por \fBSPLAT!\fP desde el directorio de trabajo actual. Si el archivo
\fI .lcf\fP correspondiente al sitio del transmisor no se encuentra, entonces
un archivo por defecto para edicin manual por el usuario es automticamente
generado por \fBSPLAT!\fP. Si el ERP del transmisor es especificado, entonces
un mapa de intensidad de seal es generado y un archivo de definicin de color 
de intensidad de seal es ledo, o generado si no est disponible en el 
directorio de trabajo actual.

Un archivo de definicin de color de prdidas por trayectoria posee la siguiente
estructura:
(\fIwnjt-dt.lcf\fP):

\fC
 ; SPLAT! Auto-generated Path-Loss Color Definition ("wnjt-dt.lcf") File
 ;
 ; Format for the parameters held in this file is as follows:
 ;
 ;    dB: red, green, blue
 ;
 ; ...where "dB" is the path loss (in dB) and
 ; "red", "green", and "blue" are the corresponding RGB color
 ; definitions ranging from 0 to 255 for the region specified.
 ;
 ; The following parameters may be edited and/or expanded
 ; for future runs of SPLAT!  A total of 32 contour regions
 ; may be defined in this file.
 ;
 ;
  80: 255,   0,   0
  90: 255, 128,   0
 100: 255, 165,   0
 110: 255, 206,   0
 120: 255, 255,   0
 130: 184, 255,   0
 140:   0, 255,   0
 150:   0, 208,   0
 160:   0, 196, 196
 170:   0, 148, 255
 180:  80,  80, 255
 190:   0,  38, 255
 200: 142,  63, 255
 210: 196,  54, 255
 220: 255,   0, 255
 230: 255, 194, 204
\fR

Si la prdida por trayectoria es menor que 80 dB, el color Rojo (RGB = 255, 0, 0)
es asignado a la regin. Si la prdida-por-trayectoria es mayor o igual a 
80 dB, pero menor que 90 dB, entonces Naranja Oscuro (255, 128, 0) es
asignado a la regin. Naranja (255, 165, 0) es asignado a regiones que tienen 
una prdida por trayectoria mayor o igual a 90 dB, pero menor que 100 dB, y
as en adelante. El terreno en escala de grises es presentado por debajo del
contorno de prdidas por trayectoria de 230 dB.

El archivo \fBSPLAT!\fP de definicin de color de intensidad de seal comparte una 
estructura muy similar.
structure (\fIwnjt-dt.scf\fP):

\fC
 ; SPLAT! Auto-generated Signal Color Definition ("wnjt-dt.scf") File
 ;
 ; Format for the parameters held in this file is as follows:
 ;
 ;    dBuV/m: red, green, blue
 ;
 ; ...where "dBuV/m" is the signal strength (in dBuV/m) and
 ; "red", "green", and "blue" are the corresponding RGB color
 ; definitions ranging from 0 to 255 for the region specified.
 ;
 ; The following parameters may be edited and/or expanded
 ; for future runs of SPLAT!  A total of 32 contour regions
 ; may be defined in this file.
 ;
 ;
 128: 255,   0,   0
 118: 255, 165,   0
 108: 255, 206,   0
  98: 255, 255,   0
  88: 184, 255,   0
  78:   0, 255,   0
  68:   0, 208,   0
  58:   0, 196, 196
  48:   0, 148, 255
  38:  80,  80, 255
  28:   0,  38, 255
  18: 142,  63, 255
   8: 140,   0, 128
\fR

Si la intensidad de seal es mayor o igual a 128 db sobre 1 microvoltio
por metro (dBuV/m), el color Rojo (255, 0, 0) es presentado para la regin.
Si la intensidad de seal es mayor o igual a 118 dbuV/m, pero menor que
128 dbuV/m, entonces el color naranja (255, 165, 0) es presentado y asi  en
adelante. El terreno en escala de grises es presentado para regiones con
intensidad de seal menores que 8 dBuV/m.

Los contornos de intensidad de seal para algunos servicios de radiodifusin
comunes en VHF y UHF en los Estados Unidos son los siguientes:
\fC

       Analog Television Broadcasting
       ------------------------------
       Channels 2-6:       City Grade: >= 74 dBuV/m
                              Grade A: >= 68 dBuV/m
                              Grade B: >= 47 dBuV/m
       --------------------------------------------
       Channels 7-13:      City Grade: >= 77 dBuV/m
                              Grade A: >= 71 dBuV/m
                              Grade B: >= 56 dBuV/m
       --------------------------------------------
       Channels 14-69:   Indoor Grade: >= 94 dBuV/m
                           City Grade: >= 80 dBuV/m
                              Grade A: >= 74 dBuV/m
                              Grade B: >= 64 dBuV/m

       Digital Television Broadcasting
       -------------------------------
       Channels 2-6:       City Grade: >= 35 dBuV/m
                    Service Threshold: >= 28 dBuV/m
       --------------------------------------------
       Channels 7-13:      City Grade: >= 43 dBuV/m
                    Service Threshold: >= 36 dBuV/m
       --------------------------------------------
       Channels 14-69:     City Grade: >= 48 dBuV/m
                    Service Threshold: >= 41 dBuV/m

       NOAA Weather Radio (162.400 - 162.550 MHz)
       ------------------------------------------
                  Reliable: >= 18 dBuV/m
              Not reliable: <  18 dBuV/m
       Unlikely to receive: <  0 dBuV/m

       FM Radio Broadcasting (88.1 - 107.9 MHz)
       ----------------------------------------
       Analog Service Contour:  60 dBuV/m
       Digital Service Contour: 65 dBuV/m	
\fR

.SH PARMETROS PARA PATRONES DE RADIACIN DE ANTENAS
Los patrones de voltaje de campo normalizado para planos verticales y 
horizontales de antenas transmisoras son importados automticamente dentro 
de \fBSPLAT!\fP cuando se realizan los anlisis de cobertura Longley-Rice.  
Los datos de los patrones de antena son ledos de un par de archivos que 
tienen el mismo nombre base que el transmisor y los archivos LRP, pero con 
extensiones \fI.az\fP y \fI.el\fP, para los patrones de azimut y elevacin 
respectivamente. Especificaciones acerca de la rotacin del patrn (si existe) 
e inclinacin mecnica y direccin de la inclinacin (si existe) tambin son 
contenidos dentro de los archivos de patrones de radiacin de las antenas.

Por ejemplo las primeras pocas lneas de un archivo de patrn de azimut \fBSPLAT!\fP 
podran aparecer como sigue (\fIkvea.az\fP):
\fC
        183.0
        0       0.8950590
        1       0.8966406
        2       0.8981447
        3       0.8995795
        4       0.9009535
        5       0.9022749
        6       0.9035517
        7       0.9047923
        8       0.9060051
\fR

La primera lnea de el archivo \fI.az\fP especifica la cantidad de 
rotacin del patrn de azimut (medido en grados desde el norte verdadero 
en sentido horario) a ser aplicado por \fBSPLAT!\fP a los datos contenidos
en el archivo \fI.az\fP. Esto es seguido por el correspondiente azimut 
(0 a 360 grados) y su asociado patrn de campo normalizado (0.000 a 1.000)
separado por un espacio en blanco.

La estructura del archivo del patrn de elevacin \fBSPLAT!\fP es ligeramente 
diferente. La primera lnea del archivo \fI.el\fP especifica la cantidad de 
elevacin mecnica aplicada a la antena. Note que una \fIelevacin hacia abajo\fP 
(bajo el horizonte) es expresada como un \fIngulo positivo\fP, mientras que \fIhacia 
arriba\fP (sobre el horizonte) es expresada como un \fIngulo negativo\fP. Estos datos 
son seguidos por la direccin del azimut de la elevacin, separado por un 
espacio en blanco. 

El remanente del archivo consiste en los valores de los ngulos de elevacin y su
correspondiente patrn de radiacin de voltaje normalizado (0.000 a 1.000) 
separados por un espacio en blanco. Los ngulos de elevacin deben ser especificados 
sobre un rango de -10 a +90 grados. Igual que la notacin en la elevacin mecnica, 
\fIngulos de elevacin negativa\fP son usados para representar elevaciones \fIsobre el horizonte\fP,
 mientras que los \fIngulos positivos\fP representan elevaciones \fIbajo el horizonte\fP.

Por ejemplo las primeras pocas lneas de un archivo patrn de elevacin \fBSPLAT!\fP 
podra aparecer como sigue (\fIkvea.el\fP):
\fC
        1.1    130.0
       -10.0   0.172
       -9.5    0.109
       -9.0    0.115
       -8.5    0.155
       -8.0    0.157
       -7.5    0.104
       -7.0    0.029
       -6.5    0.109
       -6.0    0.185
\fR

En este ejemplo, la antena es mecanicamente inclinada hacia abajo 1.1 
grados hacia un azimut de 130 grados

Para mejores resultados, la resolucin de los datos de patrones de radiacin 
debera ser especificados lo mas cerca posibles a los grados azimut, 
y la resolucin de datos del patrn de elevacin deveran ser especificados 
lo mas cerca posible a 0.01 grados. Si los datos del patrn especificado 
no alcanzan este nivel de resolucin, \fBSPLAT!\fP interpolar los valores 
provistos para determinar los datos en la resolucin requerida, aunque esto 
puede resultar en una prdida en exactitud.
.SH IMPORTANDO Y EXPORTANDO DATOS DEL CONTORNO REGIONAL DE PRDIDAS POR TRAYECTORIA
Realizar un anlisis de cobertura Longley-Rice puede ser un proceso que consume 
mucho tiempo, especialmente si el anlisis es repetido varias veces para descubrir 
cuales son los efectos que los cambios a los patrones de radiacin de las antenas 
hacen a la prediccin del rea de cobertura

Este proceso puede ser apresurado al exportar los datos del contorno regional 
de prdidas por trayectoria a un archivo de salida, modificar externamente 
los datos de prdida por trayectoria para incorporar los efectos de los 
patrones de antena, y entonces importar nuevamente los datos de prdidas por 
trayectoria modificados dentro de \fBSPLAT!\fP para rapidamente producir un mapa 
revisado de prdidas por trayectoria.

Por ejemplo un archivo de salida de prdidas por trayectoria puede ser generado 
por \fBSPLAT!\fP para un sitio de recepcin a 30 pies sobre el nivel del terreno,
con un radio de 50 millas alrededor del sitio de transmisin para prdidas por 
trayectoria mximas de 140 dB, usando la siguiente sintaxis:

\fCsplat -t kvea -L 30.0 -R 50.0 -db 140 -plo pathloss.dat\fR

Los archivos de salida por prdidas por trayectoria \fBSPLAT!\fP a menudo 
exceden los 100 megabytes de tamao. Contienen la informacin referentes a 
los lmites de la regin que describen seguido por latitudes (grados norte), 
longitudes (grados oeste), azimut, elevaciones(a la primera obstruccin), y 
figuras de prdidas por trayectoria(dB) para una serie de puntos especficos que 
abarca la regin que rodea al sitio de transmisin. Las primeras pocas lneas 
de un archivo de salida de prdidas por trayectoria \fBSPLAT!\fP tiene la siguiente 
apariencia (\fIpathloss.dat\fP):
\fC

        119, 117    ; max_west, min_west
        35, 33      ; max_north, min_north
        34.2265434, 118.0631104, 48.171, -37.461, 67.70
        34.2270355, 118.0624390, 48.262, -26.212, 73.72
        34.2280197, 118.0611038, 48.269, -14.951, 79.74
        34.2285156, 118.0604401, 48.207, -11.351, 81.68
        34.2290077, 118.0597687, 48.240, -10.518, 83.26
        34.2294998, 118.0591049, 48.225, 23.201, 84.60
        34.2304878, 118.0577698, 48.213, 15.769, 137.84
        34.2309799, 118.0570984, 48.234, 15.965, 151.54
        34.2314720, 118.0564346, 48.224, 16.520, 149.45
        34.2319679, 118.0557632, 48.223, 15.588, 151.61
        34.2329521, 118.0544281, 48.230, 13.889, 135.45
        34.2334442, 118.0537643, 48.223, 11.693, 137.37
        34.2339401, 118.0530930, 48.222, 14.050, 126.32
        34.2344322, 118.0524292, 48.216, 16.274, 156.28
        34.2354164, 118.0510941, 48.222, 15.058, 152.65
        34.2359123, 118.0504227, 48.221, 16.215, 158.57
        34.2364044, 118.0497589, 48.216, 15.024, 157.30
        34.2368965, 118.0490875, 48.225, 17.184, 156.36
\fR

No es poco comn para los archivos \fBSPLAT!\fP de prdidas por trayectoria que 
contengan tanto como 3 millones o ms de lneas de datos. Si el archivo es procesado, 
comentarios pueden ser puestos con un caracter de punto y coma. El editor de texto 
\fBvim\fP ha probado ser capaz de editar archivos de este tamao.

Note que al igual que el caso de los archivos de patrones de antena, ngulos
de elevacin negativos se refieren a inclinaciones hacia arriba (sobre el 
horizonte), mientras que ngulos positivos se refieren a inclinaciones hacia 
abajo (bajo el horizonte). Esos ngulos se refieren a la elevacin para la 
antena receptora en la altura sobre el nivel del terreno especificada usando 
la opcin \fI-L\fP si la trayectoria entre el transmisor y el receptor no 
tiene obstrucciones. Si la trayectoria entre el transmisor y el receptor est 
obstruida, entonces el ngulo a la primera obstruccin es retornado por \fBSPLAT!\fP.
Esto es porque el modelo Longley-Rice considera la energa que alcanza un punto 
distante sobre una trayectoria obstruida como un derivado de la energa dispersada 
de la punta de la primera instruccin, solamente. Puesto que la energa no puede 
alcanzar directamente la localizacin obstruida, el actual ngulo de elevacin 
a ese punto es irrelevante.

Cuando se modifican los archivos \fBSPLAT!\fP de prdidas por trayectoria 
para reflejar datos de patrones de antena, \fIsolo la ltima columna (path loss)\fP
deberan ser enmendados para reflejar la ganacia de antena normalizada en los 
ngulos de elevacin y azimut especificados en el archivo. (Por ahora, programas 
y scripts capaces de realizar esta operacin son dejados como tarea al usuario.)

Los mapas modificados de prdidas por trayectoria pueden ser importados nuevamente
a \fBSPLAT!\fP para generar mapas de cobertura revisados.

\fCsplat -t kvea -pli pathloss.dat -s city.dat -b county.dat -o map.ppm\fR

Los archivos \fBSPLAT!\fP de prdidas por trayectoria tambin pueden ser usados 
para guiar estudios de cobertura o interferencia fuera de \fBSPLAT!\fP.
.SH ARCHIVOS DE ENTRADA DE TERRENO DEFINIDOS POR EL USUARIO 
Un archivo de terreno definido por el usuario es un archivo de texto 
generado-por-el-usuario que contiene latitudes, longitudes, y alturas sobre 
el nivel de la tierra de caractersticas de terreno especfica que se cree 
son de importancia para el anlisis que \fBSPLAT!\fP est desarrollando, pero 
perceptiblemente ausentes de los archivos SDF que estn siendo usados. Un archivo 
de terreno definido-por-el-usuario es importado dentro de un anlisis de \fBSPLAT!\fP 
usando la opcin \fI-udt\fP:

\fC splat -t tx_site -r rx_site -udt udt_file.txt -o map.ppm\fR

Un archivo de terreno definido-por-el-usuario tiene la siguiente apariencia y estructura:
\fC

       40.32180556, 74.1325, 100.0 meters
       40.321805, 74.1315, 300.0
       40.3218055, 74.1305, 100.0 meters
\fR

La altura del terreno es interpretada en pies sobre el nivel del suelo a menos que sea 
seguido por la palabra meters, y es adicionado en la parte superior de el terreno 
especificado en los datos SDF para la localizacin especificada. Debe saber que las 
caractersticas especificadas en los archivos de terreno especificados-por-el-usuario
sern interpretados como 3-arco segundos en latitud y longitud. Caractersticas descritas 
en el archivo de terreno definido-por-el-usuario que traslapen las caractersticas 
previamente definidas en el archivo son ignoradas por \fBSPLAT!\fP.
.SH GENERACIN DE MAPAS TOPOGRFICOS SIMPLES
En ciertas ocasiones puede ser deseable generar un mapa topogrfico de una regin sin graficar 
reas de cobertura, trayectorias de lnea-de-vista, o generar reportes de obstrucciones.
Existen varias maneras de hacer esto. Si se desea generar un mapa topogrfico ilustrando 
la localizacin de un sitio del transmisor  y receptor con un breve reporte de texto describiendo 
las localizaciones y distancias entre los sitios, entonces, entonces se debe invocar 
la opcin \fI-n\fP como sigue:

\fCsplat -t tx_site -r rx_site -n -o topo_map.ppm\fR

Si no se desea un reporte de texto, entonces debe usar la opcin \fI-N\fP:

\fCsplat -t tx_site -r rx_site -N -o topo_map.ppm\fR

Si se desea un mapa topogrfico centrado cerca de un sitio para un radio
mnimo especificado, un comando similar al siguiente puede ser utilizado:

\fCsplat -t tx_site -R 50.0 -s NJ_Cities -b NJ_Counties -o topo_map.ppm\fR

donde -R especifica el mnimo radio de el mapa en millas ( kilmetros
si la opcin \fI-metric\fP es usada). Note que el nombre del sitio_tx y
la localizacin no son presentadas en este ejemplo. Si se desea presentar 
esta informacin, simplemente cree un archivo de ciudades \fBSPLAT!\fP
con la opcin (\fI-s\fP) y adicinele a las opciones de la lnea-de-comandos
ilustradas arriba.
Si la opcin \fI-o\fP y el archivo de salida son omitidos en esa operacin,
la salida topogrfica es escrita a un archivo por defecto llamado \fItx_site.ppm\fP 
en el directorio de trabajo actual.
.SH GENERACIN DE ARCHIVOS DE GEOREFERENCIA
Los mapas topogrficos, de cobertura (\fI-c\fP), y contornos de prdidas 
por trayectoria (\fI-L\fP) generados por \fBSPLAT!\fP pueden ser importados 
dentro del programa \fBXastir\fP (X Amateur  Station Tracking and Information
Reporting), generando un archivo de georeferencia usando la opcin \fBSPLAT!\fP \fI-geo\fP:

\fCsplat -t kd2bd -R 50.0 -s NJ_Cities -b NJ_Counties -geo -o map.ppm\fR

El archivo de georeferencia creado tendr el mismo nombre base que el archivo\fI-o\fP 
especificado, pero con extensin \fI .geo\fP, y permite la apropiada interpretacin 
y presentacin de los grficos .ppm \fBSPLAT!\fP en el programa \fBXastir\fP.
.SH GENERACION DE ARCHIVOS KML GOOGLE MAP
Archivos Keyhole Markup Language compatibles con \fBGoogle Earth\fP
pueden ser generados por \fBSPLAT!\fP cuando se realizan anlisis 
punto-a-punto invocando la opcin \fI-kml\fP:

\fCsplat -t wnjt-dt -r kd2bd -kml\fR

El archivo KML generado tendr la misma estructura que el nombre del 
Reporte de Obstrucciones para los sitios del transmisor y receptor dados,
excepto que tendr una extensin \fI .kml\fP.

Una vez cargado dentro del \fBGoogle Earth\fP (Archivo --> Abrir), el archivo 
KLM exhibir las localizaciones de los sitios de transmisin y recepcin en el mapa. 
Los puntos de vista de la imagen sern desde la posicin del sitio de transmisin
mirando hacia la localizacin del receptor. La trayectoria punto-a-punto entre 
los sitios ser presentada como una lnea blanca, mientras que la trayectoria 
de linea-de-vista RF ser presentada en verde. Las herramientas de navegacin 
de \fBGoogle Earth\fP le permiten al usuario "volar" alrededor de la trayectoria, 
identificando seales, caminos, y otras caractersticas contenidas.

Cuando se realiza el anlisis de cobertura regional, el archivo \fI .kml\fP 
generado por \fBSPLAT!\fP permitir a los contornos de intensidad de
seal o de prdidas por trayectoria a ser graficados como capas sobre 
mapas \fBGoogle Earth\fP presentados en una manera semi-transparente.
El archivo \fI.kml\fP generado tendr el mismo nombre base como el del
archivo \fI.ppm\fP normalmente generado.
.SH DETERMINACIN DE LA ALTURA DE LA ANTENA SOBRE EL PROMEDIO DEL TERRENO
\fBSPLAT!\fP determina la altura de la antena sobre el promedio del
terreno (HAAT) de acuerdo al procedimiento definido por la Comisin 
Federal de Comunicaciones. Parte 73.313(d). De acuerdo a esta definicin, 
la elevacin del terreno a lo largo de ocho radiales entre 2 y 16 millas 
(3 y 16 Kilmetros) desde el sitio que est siendo analizado es muestreado 
y promediado para los azimut  cada 45 grados comenzando con el norte verdadero.
Si uno o mas radiales caen enteramente sobre el mar o sobre el continente fuera 
de los Estados Unidos (reas para las cuales no existen disponibles datos 
topogrficos USGS), entonces esos radiales son omitidos de los clculos del 
promedio del terreno. Si parte de los radiales se extienden sobre el mar o 
fuera de los Estados Unidos, entonces solo la parte de esos radiales que caen 
sobre la tierra de los Estados Unidos son usados en la determinacin del 
promedio del terreno.

Note que los datos de elevaciones SRTM, a diferencia de los antiguos datos 
3-arcos segundos USGS, se extienden ms all de las fronteras de los Estados 
Unidos. Por esta razn,  los resultados  HAAT, no estarn en fiel cumplimiento 
con la FCC parte 73.313(d) en reas a lo largo de la frontera de los Estados 
Unidos si los archivos SDF usados por \fBSPLAT!\fP son derivados-SRTM.

Cuando se realiza anlisis punto-a-punto del terreno, \fBSPLAT!\fP determina 
la altura de la antena sobre el promedio del  terreno solo si suficientes 
datos topogrficos han sido cargados por el programa para realizar el anlisis 
punto-a-punto. En la mayora de los casos, esto ser verdadero, a menos que 
el sitio en cuestin no est dentro de 10 millas de la frontera de los datos 
topogrficos cargados en memoria.

Cuando se realiza el anlisis de prediccin de rea, suficientes 
datos topogrficos son normalmente cargados por \fBSPLAT!\fP para 
realizar los clculos del promedio del terreno. Bajo esas condiciones, 
\fBSPLAT!\fP proveer la altura de la antena sobre el promedio del terreno, 
como tambin el promedio del terreno sobre el nivel del mar para los azimut 
de 0, 45, 90, 135, 180, 225, 270, y 315 grados, e incluir dicha informacin 
en el reporte de sitio generado. Si uno o ms de los ocho radiales caen sobre 
el mar o sobre regiones para las cuales no existen datos SDF disponibles, 
\fBSPLAT!\fP  reportar  sin terreno la trayectoria de los radiales afectados.
.SH RESTRINGIENDO EL TAMAO MXIMO DE UNA REGIN ANALIZADA
\fBSPLAT!\fP lee los archivos SDF de acuerdo a sus necesidades dentro de una serie 
de "pginas" de memoria dentro de la estructura del programa. Cada "pgina" contiene 
un archivo SDF representando una regin de terreno de un grado por un grado.
Una sentencia  \fI#define MAXPAGES\fP en las primeras lneas del archivo splat.cpp 
configura el mximo nmero de "pginas"  disponibles para los datos topogrficos. 
Esto tambin configura el  tamao mximo de los mapas generados por \fBSPLAT!\fP. 
Por defecto MAXPAGES es configurado a 9. Si \fBSPLAT!\fP produce un fallo de 
segmentacin al arrancar con estos parmetros por defecto, significa que no hay 
suficiente memoria RAM y/ memoria virtual (particin swap) para correr \fBSPLAT!\fP 
con este nmero de MAXPAGES. En situaciones donde la memoria disponible es baja, 
MAXPAGES pueden ser reducidos a 4 con el entendimiento de que esto limitar grandemente 
la mxima regin que \fBSPLAT!\fP estar habilitado a analizar. Si se tiene disponible 
118 megabytes  mas de la memoria total (particin swap sumada la RAM), entonces MAXPAGES
puede ser incrementado a 16. esto permitir operaciones sobre una regin de 4-grados por 
4-grados, lo cual es suficiente para alturas de antenas  que excedan los 10,000 pies sobre 
el nivel del mar,  distancias punto-a-punto sobre las 1000 millas.
.SH INFORMACIN ADICIONAL
Las ltimas noticias e informacin respecto al programa \fBSPLAT!\fP 
est disponible a travs de la pgina web oficial localizada en:
\fIhttp://www.qsl.net/kd2bd/splat.html\fP.
.SH AUTORES
.TP
John A. Magliacane, KD2BD <\fIkd2bd@amsat.org\fP>
Creator, Lead Developer
.TP
Doug McDonald <\fImcdonald@scs.uiuc.edu\fP>
Original Longley-Rice Model integration
.TP
Ron Bentley <\fIronbentley@earthlink.net\fP>
Fresnel Zone plotting and clearance determination

