/* controller.c generated by valac 0.12.0, the Vala compiler
 * generated from controller.vala, do not modify */

/* Copyright (C) 2011 Red Hat, Inc.*/
/* This library is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU Lesser General Public*/
/* License as published by the Free Software Foundation; either*/
/* version 2.1 of the License, or (at your option) any later version.*/
/* This library is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU*/
/* Lesser General Public License for more details.*/
/* You should have received a copy of the GNU Lesser General Public*/
/* License along with this library; if not, see <http://www.gnu.org/licenses/>.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <spice/controller_prot.h>
#include <gio/gio.h>
#include <custom.h>
#include <glib/gstdio.h>
#include <gio/gunixsocketaddress.h>


#define SPICE_CTRL_TYPE_CONTROLLER (spice_ctrl_controller_get_type ())
#define SPICE_CTRL_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_CTRL_TYPE_CONTROLLER, SpiceCtrlController))
#define SPICE_CTRL_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_CTRL_TYPE_CONTROLLER, SpiceCtrlControllerClass))
#define SPICE_CTRL_IS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_CTRL_TYPE_CONTROLLER))
#define SPICE_CTRL_IS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_CTRL_TYPE_CONTROLLER))
#define SPICE_CTRL_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_CTRL_TYPE_CONTROLLER, SpiceCtrlControllerClass))

typedef struct _SpiceCtrlController SpiceCtrlController;
typedef struct _SpiceCtrlControllerClass SpiceCtrlControllerClass;
typedef struct _SpiceCtrlControllerPrivate SpiceCtrlControllerPrivate;

#define SPICE_CTRL_TYPE_MENU (spice_ctrl_menu_get_type ())
#define SPICE_CTRL_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_CTRL_TYPE_MENU, SpiceCtrlMenu))
#define SPICE_CTRL_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_CTRL_TYPE_MENU, SpiceCtrlMenuClass))
#define SPICE_CTRL_IS_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_CTRL_TYPE_MENU))
#define SPICE_CTRL_IS_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_CTRL_TYPE_MENU))
#define SPICE_CTRL_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_CTRL_TYPE_MENU, SpiceCtrlMenuClass))

typedef struct _SpiceCtrlMenu SpiceCtrlMenu;
typedef struct _SpiceCtrlMenuClass SpiceCtrlMenuClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SpiceCtrlControllerSendMsgData SpiceCtrlControllerSendMsgData;
typedef struct _SpiceCtrlControllerHandleClientData SpiceCtrlControllerHandleClientData;
typedef struct _SpiceCtrlControllerListenData SpiceCtrlControllerListenData;

typedef enum  {
	SPICE_CTRL_ERROR_VALUE
} SpiceCtrlError;
#define SPICE_CTRL_ERROR spice_ctrl_error_quark ()
struct _SpiceCtrlController {
	GObject parent_instance;
	SpiceCtrlControllerPrivate * priv;
};

struct _SpiceCtrlControllerClass {
	GObjectClass parent_class;
};

struct _SpiceCtrlControllerPrivate {
	gchar* _host;
	guint32 _port;
	guint32 _sport;
	gchar* _password;
	unsigned int _display_flags;
	gchar* _tls_ciphers;
	gchar* _host_subject;
	gchar* _ca_file;
	gchar* _title;
	gchar* _hotkeys;
	gchar** _secure_channels;
	gint _secure_channels_length1;
	gint __secure_channels_size_;
	gchar** _disable_channels;
	gint _disable_channels_length1;
	gint __disable_channels_size_;
	SpiceCtrlMenu* _menu;
	GIOStream* excl_connection;
	gint nclients;
	GList* clients;
};

struct _SpiceCtrlControllerSendMsgData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SpiceCtrlController* self;
	guint8* p;
	gint p_length1;
	gboolean result;
	GOutputStream* _tmp0_;
	GList* c_collection;
	GList* c_it;
	GIOStream* _tmp1_;
	GIOStream* c;
	GOutputStream* _tmp2_;
	GError * e;
	GError * _inner_error_;
};

struct _SpiceCtrlControllerHandleClientData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SpiceCtrlController* self;
	GIOStream* c;
	ControllerInit init;
	gboolean excl;
	guint8* p;
	gint p_length1;
	gint _p_size_;
	GInputStream* _tmp0_;
	gssize _tmp1_;
	gssize read;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GInputStream* _tmp6_;
	gssize _tmp7_;
	gssize _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GIOStream* _tmp16_;
	gint _tmp17_;
	guint8* _tmp18_;
	guint8* t;
	gint t_length1;
	gint _t_size_;
	gboolean _tmp19_;
	GInputStream* _tmp20_;
	gssize _tmp21_;
	gssize _tmp22_;
	gboolean _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	ControllerMsg* msg;
	gboolean _tmp28_;
	gint _tmp29_;
	GInputStream* _tmp30_;
	gssize _tmp31_;
	gssize _tmp32_;
	gboolean _tmp33_;
	GError * _inner_error_;
};

struct _SpiceCtrlControllerListenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SpiceCtrlController* self;
	gchar* addr;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _tmp3_;
	GSocketListener* _tmp4_;
	GSocketListener* listener;
	GUnixSocketAddress* _tmp5_;
	GUnixSocketAddress* _tmp6_;
	gboolean _tmp7_;
	GSocketConnection* _tmp8_;
	GSocketConnection* _tmp9_;
	GSocketConnection* c;
	GIOStream* _tmp10_;
	GError * e;
	GError * _inner_error_;
};


static gpointer spice_ctrl_controller_parent_class = NULL;

GQuark spice_ctrl_error_quark (void);
GType spice_ctrl_controller_get_type (void) G_GNUC_CONST;
GType spice_ctrl_menu_get_type (void) G_GNUC_CONST;
#define SPICE_CTRL_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SPICE_CTRL_TYPE_CONTROLLER, SpiceCtrlControllerPrivate))
enum  {
	SPICE_CTRL_CONTROLLER_DUMMY_PROPERTY,
	SPICE_CTRL_CONTROLLER_HOST,
	SPICE_CTRL_CONTROLLER_PORT,
	SPICE_CTRL_CONTROLLER_SPORT,
	SPICE_CTRL_CONTROLLER_PASSWORD,
	SPICE_CTRL_CONTROLLER_DISPLAY_FLAGS,
	SPICE_CTRL_CONTROLLER_TLS_CIPHERS,
	SPICE_CTRL_CONTROLLER_HOST_SUBJECT,
	SPICE_CTRL_CONTROLLER_CA_FILE,
	SPICE_CTRL_CONTROLLER_TITLE,
	SPICE_CTRL_CONTROLLER_HOTKEYS,
	SPICE_CTRL_CONTROLLER_SECURE_CHANNELS,
	SPICE_CTRL_CONTROLLER_DISABLE_CHANNELS,
	SPICE_CTRL_CONTROLLER_MENU
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void spice_ctrl_controller_menu_item_click_msg (SpiceCtrlController* self, gint32 item_id);
void spice_ctrl_controller_send_msg (SpiceCtrlController* self, guint8* p, int p_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean spice_ctrl_controller_send_msg_finish (SpiceCtrlController* self, GAsyncResult* _res_, GError** error);
static void spice_ctrl_controller_send_msg_data_free (gpointer _data);
static guint8* _vala_array_dup1 (guint8* self, int length);
static gboolean spice_ctrl_controller_send_msg_co (SpiceCtrlControllerSendMsgData* data);
static void spice_ctrl_controller_send_msg_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean spice_ctrl_controller_handle_message (SpiceCtrlController* self, ControllerMsg* msg);
static void spice_ctrl_controller_set_host (SpiceCtrlController* self, const gchar* value);
static void spice_ctrl_controller_set_port (SpiceCtrlController* self, guint32 value);
static void spice_ctrl_controller_set_sport (SpiceCtrlController* self, guint32 value);
static void spice_ctrl_controller_set_password (SpiceCtrlController* self, const gchar* value);
static void spice_ctrl_controller_set_secure_channels (SpiceCtrlController* self, gchar** value, int value_length1);
static void spice_ctrl_controller_set_disable_channels (SpiceCtrlController* self, gchar** value, int value_length1);
static void spice_ctrl_controller_set_tls_ciphers (SpiceCtrlController* self, const gchar* value);
static void spice_ctrl_controller_set_ca_file (SpiceCtrlController* self, const gchar* value);
static void spice_ctrl_controller_set_host_subject (SpiceCtrlController* self, const gchar* value);
static void spice_ctrl_controller_set_display_flags (SpiceCtrlController* self, unsigned int value);
static void spice_ctrl_controller_set_title (SpiceCtrlController* self, const gchar* value);
SpiceCtrlMenu* spice_ctrl_menu_new_from_string (const gchar* str);
SpiceCtrlMenu* spice_ctrl_menu_construct_from_string (GType object_type, const gchar* str);
static void spice_ctrl_controller_set_menu (SpiceCtrlController* self, SpiceCtrlMenu* value);
static void spice_ctrl_controller_set_hotkeys (SpiceCtrlController* self, const gchar* value);
static void spice_ctrl_controller_handle_client_data_free (gpointer _data);
static void spice_ctrl_controller_handle_client (SpiceCtrlController* self, GIOStream* c, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void spice_ctrl_controller_handle_client_finish (SpiceCtrlController* self, GAsyncResult* _res_, GError** error);
static gboolean spice_ctrl_controller_handle_client_co (SpiceCtrlControllerHandleClientData* data);
static void spice_ctrl_controller_handle_client_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
SpiceCtrlController* spice_ctrl_controller_new (void);
SpiceCtrlController* spice_ctrl_controller_construct (GType object_type);
static void spice_ctrl_controller_listen_data_free (gpointer _data);
void spice_ctrl_controller_listen (SpiceCtrlController* self, const gchar* addr, GAsyncReadyCallback _callback_, gpointer _user_data_);
void spice_ctrl_controller_listen_finish (SpiceCtrlController* self, GAsyncResult* _res_, GError** error);
static gboolean spice_ctrl_controller_listen_co (SpiceCtrlControllerListenData* data);
static void spice_ctrl_controller_listen_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
const gchar* spice_ctrl_controller_get_host (SpiceCtrlController* self);
guint32 spice_ctrl_controller_get_port (SpiceCtrlController* self);
guint32 spice_ctrl_controller_get_sport (SpiceCtrlController* self);
const gchar* spice_ctrl_controller_get_password (SpiceCtrlController* self);
unsigned int spice_ctrl_controller_get_display_flags (SpiceCtrlController* self);
const gchar* spice_ctrl_controller_get_tls_ciphers (SpiceCtrlController* self);
const gchar* spice_ctrl_controller_get_host_subject (SpiceCtrlController* self);
const gchar* spice_ctrl_controller_get_ca_file (SpiceCtrlController* self);
const gchar* spice_ctrl_controller_get_title (SpiceCtrlController* self);
const gchar* spice_ctrl_controller_get_hotkeys (SpiceCtrlController* self);
gchar** spice_ctrl_controller_get_secure_channels (SpiceCtrlController* self, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
gchar** spice_ctrl_controller_get_disable_channels (SpiceCtrlController* self, int* result_length1);
static gchar** _vala_array_dup3 (gchar** self, int length);
SpiceCtrlMenu* spice_ctrl_controller_get_menu (SpiceCtrlController* self);
static void spice_ctrl_controller_finalize (GObject* obj);
static void _vala_spice_ctrl_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_spice_ctrl_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark spice_ctrl_error_quark (void) {
	return g_quark_from_static_string ("spice_ctrl_error-quark");
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void spice_ctrl_controller_menu_item_click_msg (SpiceCtrlController* self, gint32 item_id) {
	ControllerValue msg = {0};
	guint8* p;
	gint p_length1;
	gint _p_size_;
	g_return_if_fail (self != NULL);
	memset (&msg, 0, sizeof (ControllerValue));
	msg.base.size = (guint32) sizeof (ControllerValue);
	msg.base.id = (guint32) CONTROLLER_MENU_ITEM_CLICK;
	msg.value = (guint32) item_id;
	p = ((guint8*) (&msg)) + 0;
	p_length1 = msg.base.size - 0;
	_p_size_ = msg.base.size - 0;
	spice_ctrl_controller_send_msg (self, p, p_length1, NULL, NULL);
}


static void spice_ctrl_controller_send_msg_data_free (gpointer _data) {
	SpiceCtrlControllerSendMsgData* data;
	data = _data;
	data->p = (g_free (data->p), NULL);
	_g_object_unref0 (data->self);
	g_slice_free (SpiceCtrlControllerSendMsgData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void spice_ctrl_controller_send_msg (SpiceCtrlController* self, guint8* p, int p_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SpiceCtrlControllerSendMsgData* _data_;
	guint8* _tmp0_;
	_data_ = g_slice_new0 (SpiceCtrlControllerSendMsgData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, spice_ctrl_controller_send_msg);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, spice_ctrl_controller_send_msg_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->p = (_tmp0_ = p, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup1 (_tmp0_, p_length1));
	_data_->p_length1 = p_length1;
	spice_ctrl_controller_send_msg_co (_data_);
}


gboolean spice_ctrl_controller_send_msg_finish (SpiceCtrlController* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SpiceCtrlControllerSendMsgData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void spice_ctrl_controller_send_msg_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SpiceCtrlControllerSendMsgData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	spice_ctrl_controller_send_msg_co (data);
}


static gboolean spice_ctrl_controller_send_msg_co (SpiceCtrlControllerSendMsgData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->self->priv->excl_connection != NULL) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = g_io_stream_get_output_stream (data->self->priv->excl_connection);
		data->_state_ = 1;
		g_output_stream_write_async (data->_tmp0_, data->p, (gsize) data->p_length1, G_PRIORITY_DEFAULT, NULL, spice_ctrl_controller_send_msg_ready, data);
		return FALSE;
		_state_1:
		g_output_stream_write_finish (data->_tmp0_, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	} else {
		{
			data->c_collection = data->self->priv->clients;
			for (data->c_it = data->c_collection; data->c_it != NULL; data->c_it = data->c_it->next) {
				data->_tmp1_ = _g_object_ref0 ((GIOStream*) data->c_it->data);
				data->c = data->_tmp1_;
				{
					data->_tmp2_ = NULL;
					data->_tmp2_ = g_io_stream_get_output_stream (data->c);
					data->_state_ = 2;
					g_output_stream_write_async (data->_tmp2_, data->p, (gsize) data->p_length1, G_PRIORITY_DEFAULT, NULL, spice_ctrl_controller_send_msg_ready, data);
					return FALSE;
					_state_2:
					g_output_stream_write_finish (data->_tmp2_, data->_res_, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						_g_object_unref0 (data->c);
						goto __catch1_g_error;
					}
					_g_object_unref0 (data->c);
				}
			}
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("controller.vala:69: %s", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally1:
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->result = TRUE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean spice_ctrl_controller_handle_message (SpiceCtrlController* self, ControllerMsg* msg) {
	gboolean result = FALSE;
	ControllerValue* v;
	ControllerData* d;
	const gchar* str;
	g_return_val_if_fail (self != NULL, FALSE);
	v = (ControllerValue*) (msg);
	d = (ControllerData*) (msg);
	str = (const gchar*) (&(*d).data);
	switch ((*msg).id) {
		case CONTROLLER_HOST:
		{
			spice_ctrl_controller_set_host (self, str);
			break;
		}
		case CONTROLLER_PORT:
		{
			spice_ctrl_controller_set_port (self, (*v).value);
			break;
		}
		case CONTROLLER_SPORT:
		{
			spice_ctrl_controller_set_sport (self, (*v).value);
			break;
		}
		case CONTROLLER_PASSWORD:
		{
			spice_ctrl_controller_set_password (self, str);
			break;
		}
		case CONTROLLER_SECURE_CHANNELS:
		{
			gchar** _tmp0_;
			gchar** _tmp1_ = NULL;
			gchar** _tmp2_;
			gint _tmp2__length1;
			gchar** _tmp3_;
			_tmp1_ = _tmp0_ = g_strsplit (str, ",", 0);
			_tmp2_ = _tmp1_;
			_tmp2__length1 = _vala_array_length (_tmp0_);
			_tmp3_ = _tmp2_;
			spice_ctrl_controller_set_secure_channels (self, _tmp3_, _vala_array_length (_tmp0_));
			_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		case CONTROLLER_DISABLE_CHANNELS:
		{
			gchar** _tmp4_;
			gchar** _tmp5_ = NULL;
			gchar** _tmp6_;
			gint _tmp6__length1;
			gchar** _tmp7_;
			_tmp5_ = _tmp4_ = g_strsplit (str, ",", 0);
			_tmp6_ = _tmp5_;
			_tmp6__length1 = _vala_array_length (_tmp4_);
			_tmp7_ = _tmp6_;
			spice_ctrl_controller_set_disable_channels (self, _tmp7_, _vala_array_length (_tmp4_));
			_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		case CONTROLLER_TLS_CIPHERS:
		{
			spice_ctrl_controller_set_tls_ciphers (self, str);
			break;
		}
		case CONTROLLER_CA_FILE:
		{
			spice_ctrl_controller_set_ca_file (self, str);
			break;
		}
		case CONTROLLER_HOST_SUBJECT:
		{
			spice_ctrl_controller_set_host_subject (self, str);
			break;
		}
		case CONTROLLER_FULL_SCREEN:
		{
			spice_ctrl_controller_set_display_flags (self, (unsigned int) (*v).value);
			break;
		}
		case CONTROLLER_SET_TITLE:
		{
			spice_ctrl_controller_set_title (self, str);
			break;
		}
		case CONTROLLER_CREATE_MENU:
		{
			SpiceCtrlMenu* _tmp8_ = NULL;
			SpiceCtrlMenu* _tmp9_;
			_tmp8_ = spice_ctrl_menu_new_from_string (str);
			_tmp9_ = _tmp8_;
			spice_ctrl_controller_set_menu (self, _tmp9_);
			_g_object_unref0 (_tmp9_);
			break;
		}
		case CONTROLLER_DELETE_MENU:
		{
			spice_ctrl_controller_set_menu (self, NULL);
			break;
		}
		case CONTROLLER_HOTKEYS:
		{
			spice_ctrl_controller_set_hotkeys (self, str);
			break;
		}
		case CONTROLLER_CONNECT:
		{
			g_signal_emit_by_name (self, "do-connect");
			break;
		}
		case CONTROLLER_SHOW:
		{
			g_signal_emit_by_name (self, "show");
			break;
		}
		case CONTROLLER_HIDE:
		{
			g_signal_emit_by_name (self, "hide");
			break;
		}
		default:
		{
			g_warn_if_reached ();
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static void spice_ctrl_controller_handle_client_data_free (gpointer _data) {
	SpiceCtrlControllerHandleClientData* data;
	data = _data;
	_g_object_unref0 (data->c);
	_g_object_unref0 (data->self);
	g_slice_free (SpiceCtrlControllerHandleClientData, data);
}


static void spice_ctrl_controller_handle_client (SpiceCtrlController* self, GIOStream* c, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SpiceCtrlControllerHandleClientData* _data_;
	_data_ = g_slice_new0 (SpiceCtrlControllerHandleClientData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, spice_ctrl_controller_handle_client);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, spice_ctrl_controller_handle_client_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->c = _g_object_ref0 (c);
	spice_ctrl_controller_handle_client_co (_data_);
}


static void spice_ctrl_controller_handle_client_finish (SpiceCtrlController* self, GAsyncResult* _res_, GError** error) {
	SpiceCtrlControllerHandleClientData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void spice_ctrl_controller_handle_client_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SpiceCtrlControllerHandleClientData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	spice_ctrl_controller_handle_client_co (data);
}


static gboolean spice_ctrl_controller_handle_client_co (SpiceCtrlControllerHandleClientData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	memset (&data->init, 0, sizeof (ControllerInit));
	data->excl = FALSE;
	data->p = NULL;
	data->p_length1 = 0;
	data->_p_size_ = 0;
	g_debug ("controller.vala:156: new socket client, reading init header");
	data->p = ((guint8*) (&data->init)) + 0;
	data->p_length1 = sizeof (ControllerInitHeader) - 0;
	data->_p_size_ = sizeof (ControllerInitHeader) - 0;
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_io_stream_get_input_stream (data->c);
	data->_state_ = 1;
	g_input_stream_read_async (data->_tmp0_, data->p, (gsize) data->p_length1, G_PRIORITY_DEFAULT, NULL, spice_ctrl_controller_handle_client_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = g_input_stream_read_finish (data->_tmp0_, data->_res_, &data->_inner_error_);
	data->read = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp2_ = g_warn_if (data->read != sizeof (ControllerInitHeader));
	if (data->_tmp2_) {
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp3_ = g_warn_if (data->init.base.magic != CONTROLLER_MAGIC);
	if (data->_tmp3_) {
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp4_ = g_warn_if (data->init.base.version != CONTROLLER_VERSION);
	if (data->_tmp4_) {
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp5_ = g_warn_if (data->init.base.size < sizeof (ControllerInit));
	if (data->_tmp5_) {
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->p = ((guint8*) (&data->init.credentials)) + 0;
	data->p_length1 = (data->init.base.size - sizeof (ControllerInitHeader)) - 0;
	data->_p_size_ = (data->init.base.size - sizeof (ControllerInitHeader)) - 0;
	data->_tmp6_ = NULL;
	data->_tmp6_ = g_io_stream_get_input_stream (data->c);
	data->_state_ = 2;
	g_input_stream_read_async (data->_tmp6_, data->p, (gsize) data->p_length1, G_PRIORITY_DEFAULT, NULL, spice_ctrl_controller_handle_client_ready, data);
	return FALSE;
	_state_2:
	data->_tmp7_ = g_input_stream_read_finish (data->_tmp6_, data->_res_, &data->_inner_error_);
	data->_tmp8_ = data->_tmp7_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->read = data->_tmp8_;
	data->_tmp9_ = g_warn_if (data->read != (data->init.base.size - sizeof (ControllerInitHeader)));
	if (data->_tmp9_) {
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp10_ = g_warn_if (data->init.credentials != 0);
	if (data->_tmp10_) {
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp11_ = g_warn_if (data->self->priv->excl_connection != NULL);
	if (data->_tmp11_) {
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->excl = (gboolean) (data->init.flags & CONTROLLER_FLAG_EXCLUSIVE);
	if (data->excl) {
		if (data->self->priv->nclients > 1) {
			data->_tmp12_ = NULL;
			data->_tmp12_ = g_strdup_printf ("%i", data->self->priv->nclients);
			data->_tmp13_ = data->_tmp12_;
			data->_tmp14_ = NULL;
			data->_tmp14_ = g_strconcat ("Can't make the client exclusive, there is already ", data->_tmp13_, " connected clients", NULL);
			data->_tmp15_ = data->_tmp14_;
			g_warning ("controller.vala:181: %s", data->_tmp15_);
			_g_free0 (data->_tmp15_);
			_g_free0 (data->_tmp13_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->_tmp16_ = _g_object_ref0 (data->c);
		_g_object_unref0 (data->self->priv->excl_connection);
		data->self->priv->excl_connection = data->_tmp16_;
	}
	data->_tmp18_ = NULL;
	data->_tmp18_ = g_new0 (guint8, data->_tmp17_ = sizeof (ControllerMsg));
	data->t = data->_tmp18_;
	data->t_length1 = data->_tmp17_;
	data->_t_size_ = data->_tmp17_;
	{
		data->_tmp19_ = TRUE;
		while (TRUE) {
			if (!data->_tmp19_) {
			}
			data->_tmp19_ = FALSE;
			data->_tmp20_ = NULL;
			data->_tmp20_ = g_io_stream_get_input_stream (data->c);
			data->_state_ = 3;
			g_input_stream_read_async (data->_tmp20_, data->t + 0, (gsize) (sizeof (ControllerMsg) - 0), G_PRIORITY_DEFAULT, NULL, spice_ctrl_controller_handle_client_ready, data);
			return FALSE;
			_state_3:
			data->_tmp21_ = g_input_stream_read_finish (data->_tmp20_, data->_res_, &data->_inner_error_);
			data->_tmp22_ = data->_tmp21_;
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				data->t = (g_free (data->t), NULL);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			data->read = data->_tmp22_;
			if (data->read == 0) {
				break;
			}
			data->_tmp23_ = g_warn_if (data->read != sizeof (ControllerMsg));
			if (data->_tmp23_) {
				data->_tmp24_ = NULL;
				data->_tmp24_ = g_strdup_printf ("%" G_GSSIZE_FORMAT, data->read);
				data->_tmp25_ = data->_tmp24_;
				data->_tmp26_ = g_strconcat ("read only: ", data->_tmp25_, NULL);
				data->_tmp27_ = data->_tmp26_;
				g_warning ("controller.vala:194: %s", data->_tmp27_);
				_g_free0 (data->_tmp27_);
				_g_free0 (data->_tmp25_);
				break;
			}
			data->msg = (ControllerMsg*) data->t;
			data->_tmp28_ = g_warn_if ((*data->msg).size < sizeof (ControllerMsg));
			if (data->_tmp28_) {
				break;
			}
			if ((*data->msg).size > sizeof (ControllerMsg)) {
				data->_tmp29_ = (gint) (*data->msg).size;
				data->t = g_renew (guint8, data->t, (gint) (*data->msg).size);
				(data->_tmp29_ > data->t_length1) ? memset (data->t + data->t_length1, 0, sizeof (guint8) * (data->_tmp29_ - data->t_length1)) : NULL;
				data->t_length1 = data->_tmp29_;
				data->_t_size_ = data->_tmp29_;
				data->msg = (ControllerMsg*) data->t;
				data->_tmp30_ = NULL;
				data->_tmp30_ = g_io_stream_get_input_stream (data->c);
				data->_state_ = 4;
				g_input_stream_read_async (data->_tmp30_, data->t + sizeof (ControllerMsg), (gsize) ((*data->msg).size - sizeof (ControllerMsg)), G_PRIORITY_DEFAULT, NULL, spice_ctrl_controller_handle_client_ready, data);
				return FALSE;
				_state_4:
				data->_tmp31_ = g_input_stream_read_finish (data->_tmp30_, data->_res_, &data->_inner_error_);
				data->_tmp32_ = data->_tmp31_;
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					data->t = (g_free (data->t), NULL);
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				data->read = data->_tmp32_;
				if (data->read == 0) {
					break;
				}
				data->_tmp33_ = g_warn_if (data->read != ((*data->msg).size - sizeof (ControllerMsg)));
				if (data->_tmp33_) {
					break;
				}
			}
			spice_ctrl_controller_handle_message (data->self, data->msg);
		}
	}
	if (data->excl) {
		_g_object_unref0 (data->self->priv->excl_connection);
		data->self->priv->excl_connection = NULL;
	}
	data->t = (g_free (data->t), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


SpiceCtrlController* spice_ctrl_controller_construct (GType object_type) {
	SpiceCtrlController * self = NULL;
	self = (SpiceCtrlController*) g_object_new (object_type, NULL);
	return self;
}


SpiceCtrlController* spice_ctrl_controller_new (void) {
	return spice_ctrl_controller_construct (SPICE_CTRL_TYPE_CONTROLLER);
}


static void spice_ctrl_controller_listen_data_free (gpointer _data) {
	SpiceCtrlControllerListenData* data;
	data = _data;
	_g_free0 (data->addr);
	_g_object_unref0 (data->self);
	g_slice_free (SpiceCtrlControllerListenData, data);
}


void spice_ctrl_controller_listen (SpiceCtrlController* self, const gchar* addr, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SpiceCtrlControllerListenData* _data_;
	_data_ = g_slice_new0 (SpiceCtrlControllerListenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, spice_ctrl_controller_listen);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, spice_ctrl_controller_listen_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->addr = g_strdup (addr);
	spice_ctrl_controller_listen_co (_data_);
}


void spice_ctrl_controller_listen_finish (SpiceCtrlController* self, GAsyncResult* _res_, GError** error) {
	SpiceCtrlControllerListenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void spice_ctrl_controller_listen_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SpiceCtrlControllerListenData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	spice_ctrl_controller_listen_co (data);
}


static gboolean spice_ctrl_controller_listen_co (SpiceCtrlControllerListenData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->addr == NULL) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = g_getenv ("SPICE_XPI_SOCKET");
		if (data->_tmp0_ != NULL) {
			data->_tmp1_ = NULL;
			data->_tmp1_ = g_getenv ("SPICE_XPI_SOCKET");
			data->_tmp2_ = NULL;
			data->_tmp2_ = g_strdup_printf ("%s", data->_tmp1_);
			data->addr = (const gchar*) data->_tmp2_;
		}
	}
	if (data->addr == NULL) {
		data->_tmp3_ = NULL;
		data->_tmp3_ = g_error_new_literal (SPICE_CTRL_ERROR, SPICE_CTRL_ERROR_VALUE, "Missing SPICE_XPI_SOCKET");
		data->_inner_error_ = data->_tmp3_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	g_unlink (data->addr);
	data->_tmp4_ = NULL;
	data->_tmp4_ = g_socket_listener_new ();
	data->listener = data->_tmp4_;
	data->_tmp5_ = NULL;
	data->_tmp5_ = (GUnixSocketAddress*) g_unix_socket_address_new (data->addr);
	data->_tmp6_ = data->_tmp5_;
	g_socket_listener_add_address (data->listener, (GSocketAddress*) data->_tmp6_, G_SOCKET_TYPE_STREAM, G_SOCKET_PROTOCOL_DEFAULT, NULL, NULL, &data->_inner_error_);
	_g_object_unref0 (data->_tmp6_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->listener);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	{
		data->_tmp7_ = TRUE;
		while (TRUE) {
			if (!data->_tmp7_) {
			}
			data->_tmp7_ = FALSE;
			data->_state_ = 1;
			g_socket_listener_accept_async (data->listener, NULL, spice_ctrl_controller_listen_ready, data);
			return FALSE;
			_state_1:
			data->_tmp8_ = NULL;
			data->_tmp8_ = g_socket_listener_accept_finish (data->listener, data->_res_, NULL, &data->_inner_error_);
			data->_tmp9_ = _g_object_ref0 (data->_tmp8_);
			data->c = data->_tmp9_;
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->listener);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			data->self->priv->nclients = data->self->priv->nclients + 1;
			data->_tmp10_ = _g_object_ref0 ((GIOStream*) data->c);
			data->self->priv->clients = g_list_append (data->self->priv->clients, data->_tmp10_);
			data->_state_ = 2;
			spice_ctrl_controller_handle_client (data->self, (GIOStream*) data->c, spice_ctrl_controller_listen_ready, data);
			return FALSE;
			_state_2:
			spice_ctrl_controller_handle_client_finish (data->self, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
			goto __finally2;
			__catch2_g_error:
			{
				data->e = data->_inner_error_;
				data->_inner_error_ = NULL;
				g_warning ("controller.vala:251: %s", data->e->message);
				_g_error_free0 (data->e);
			}
			__finally2:
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->c);
				_g_object_unref0 (data->listener);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			g_io_stream_close ((GIOStream*) data->c, NULL, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->c);
				_g_object_unref0 (data->listener);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			data->self->priv->clients = g_list_remove (data->self->priv->clients, (GIOStream*) data->c);
			data->self->priv->nclients = data->self->priv->nclients - 1;
			_g_object_unref0 (data->c);
		}
	}
	_g_object_unref0 (data->listener);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


const gchar* spice_ctrl_controller_get_host (SpiceCtrlController* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_host;
	return result;
}


static void spice_ctrl_controller_set_host (SpiceCtrlController* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_host);
	self->priv->_host = _tmp0_;
	g_object_notify ((GObject *) self, "host");
}


guint32 spice_ctrl_controller_get_port (SpiceCtrlController* self) {
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_port;
	return result;
}


static void spice_ctrl_controller_set_port (SpiceCtrlController* self, guint32 value) {
	g_return_if_fail (self != NULL);
	self->priv->_port = value;
	g_object_notify ((GObject *) self, "port");
}


guint32 spice_ctrl_controller_get_sport (SpiceCtrlController* self) {
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_sport;
	return result;
}


static void spice_ctrl_controller_set_sport (SpiceCtrlController* self, guint32 value) {
	g_return_if_fail (self != NULL);
	self->priv->_sport = value;
	g_object_notify ((GObject *) self, "sport");
}


const gchar* spice_ctrl_controller_get_password (SpiceCtrlController* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_password;
	return result;
}


static void spice_ctrl_controller_set_password (SpiceCtrlController* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_password);
	self->priv->_password = _tmp0_;
	g_object_notify ((GObject *) self, "password");
}


unsigned int spice_ctrl_controller_get_display_flags (SpiceCtrlController* self) {
	unsigned int result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_display_flags;
	return result;
}


static void spice_ctrl_controller_set_display_flags (SpiceCtrlController* self, unsigned int value) {
	g_return_if_fail (self != NULL);
	self->priv->_display_flags = value;
	g_object_notify ((GObject *) self, "display-flags");
}


const gchar* spice_ctrl_controller_get_tls_ciphers (SpiceCtrlController* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_tls_ciphers;
	return result;
}


static void spice_ctrl_controller_set_tls_ciphers (SpiceCtrlController* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_tls_ciphers);
	self->priv->_tls_ciphers = _tmp0_;
	g_object_notify ((GObject *) self, "tls-ciphers");
}


const gchar* spice_ctrl_controller_get_host_subject (SpiceCtrlController* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_host_subject;
	return result;
}


static void spice_ctrl_controller_set_host_subject (SpiceCtrlController* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_host_subject);
	self->priv->_host_subject = _tmp0_;
	g_object_notify ((GObject *) self, "host-subject");
}


const gchar* spice_ctrl_controller_get_ca_file (SpiceCtrlController* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_ca_file;
	return result;
}


static void spice_ctrl_controller_set_ca_file (SpiceCtrlController* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_ca_file);
	self->priv->_ca_file = _tmp0_;
	g_object_notify ((GObject *) self, "ca-file");
}


const gchar* spice_ctrl_controller_get_title (SpiceCtrlController* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_title;
	return result;
}


static void spice_ctrl_controller_set_title (SpiceCtrlController* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp0_;
	g_object_notify ((GObject *) self, "title");
}


const gchar* spice_ctrl_controller_get_hotkeys (SpiceCtrlController* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_hotkeys;
	return result;
}


static void spice_ctrl_controller_set_hotkeys (SpiceCtrlController* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_hotkeys);
	self->priv->_hotkeys = _tmp0_;
	g_object_notify ((GObject *) self, "hotkeys");
}


gchar** spice_ctrl_controller_get_secure_channels (SpiceCtrlController* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_secure_channels;
	*result_length1 = self->priv->_secure_channels_length1;
	result = _tmp0_;
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void spice_ctrl_controller_set_secure_channels (SpiceCtrlController* self, gchar** value, int value_length1) {
	gchar** _tmp0_;
	gchar** _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (_tmp1_ = value, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup2 (_tmp1_, value_length1));
	self->priv->_secure_channels = (_vala_array_free (self->priv->_secure_channels, self->priv->_secure_channels_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_secure_channels = _tmp0_;
	self->priv->_secure_channels_length1 = value_length1;
	self->priv->__secure_channels_size_ = value_length1;
	g_object_notify ((GObject *) self, "secure-channels");
}


gchar** spice_ctrl_controller_get_disable_channels (SpiceCtrlController* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_disable_channels;
	*result_length1 = self->priv->_disable_channels_length1;
	result = _tmp0_;
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void spice_ctrl_controller_set_disable_channels (SpiceCtrlController* self, gchar** value, int value_length1) {
	gchar** _tmp0_;
	gchar** _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (_tmp1_ = value, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup3 (_tmp1_, value_length1));
	self->priv->_disable_channels = (_vala_array_free (self->priv->_disable_channels, self->priv->_disable_channels_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_disable_channels = _tmp0_;
	self->priv->_disable_channels_length1 = value_length1;
	self->priv->__disable_channels_size_ = value_length1;
	g_object_notify ((GObject *) self, "disable-channels");
}


SpiceCtrlMenu* spice_ctrl_controller_get_menu (SpiceCtrlController* self) {
	SpiceCtrlMenu* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_menu;
	return result;
}


static void spice_ctrl_controller_set_menu (SpiceCtrlController* self, SpiceCtrlMenu* value) {
	SpiceCtrlMenu* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_menu);
	self->priv->_menu = _tmp0_;
	g_object_notify ((GObject *) self, "menu");
}


static void spice_ctrl_controller_class_init (SpiceCtrlControllerClass * klass) {
	spice_ctrl_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SpiceCtrlControllerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_ctrl_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_ctrl_controller_set_property;
	G_OBJECT_CLASS (klass)->finalize = spice_ctrl_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_HOST, g_param_spec_string ("host", "host", "host", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_PORT, g_param_spec_uint ("port", "port", "port", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_SPORT, g_param_spec_uint ("sport", "sport", "sport", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_PASSWORD, g_param_spec_string ("password", "password", "password", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_DISPLAY_FLAGS, g_param_spec_uint ("display-flags", "display-flags", "display-flags", 0, G_MAXUINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_TLS_CIPHERS, g_param_spec_string ("tls-ciphers", "tls-ciphers", "tls-ciphers", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_HOST_SUBJECT, g_param_spec_string ("host-subject", "host-subject", "host-subject", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_CA_FILE, g_param_spec_string ("ca-file", "ca-file", "ca-file", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_HOTKEYS, g_param_spec_string ("hotkeys", "hotkeys", "hotkeys", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_SECURE_CHANNELS, g_param_spec_boxed ("secure-channels", "secure-channels", "secure-channels", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_DISABLE_CHANNELS, g_param_spec_boxed ("disable-channels", "disable-channels", "disable-channels", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_MENU, g_param_spec_object ("menu", "menu", "menu", SPICE_CTRL_TYPE_MENU, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("do_connect", SPICE_CTRL_TYPE_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("show", SPICE_CTRL_TYPE_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("hide", SPICE_CTRL_TYPE_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void spice_ctrl_controller_instance_init (SpiceCtrlController * self) {
	self->priv = SPICE_CTRL_CONTROLLER_GET_PRIVATE (self);
}


static void spice_ctrl_controller_finalize (GObject* obj) {
	SpiceCtrlController * self;
	self = SPICE_CTRL_CONTROLLER (obj);
	_g_free0 (self->priv->_host);
	_g_free0 (self->priv->_password);
	_g_free0 (self->priv->_tls_ciphers);
	_g_free0 (self->priv->_host_subject);
	_g_free0 (self->priv->_ca_file);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_hotkeys);
	self->priv->_secure_channels = (_vala_array_free (self->priv->_secure_channels, self->priv->_secure_channels_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_disable_channels = (_vala_array_free (self->priv->_disable_channels, self->priv->_disable_channels_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_menu);
	_g_object_unref0 (self->priv->excl_connection);
	__g_list_free__g_object_unref0_0 (self->priv->clients);
	G_OBJECT_CLASS (spice_ctrl_controller_parent_class)->finalize (obj);
}


GType spice_ctrl_controller_get_type (void) {
	static volatile gsize spice_ctrl_controller_type_id__volatile = 0;
	if (g_once_init_enter (&spice_ctrl_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpiceCtrlControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_ctrl_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceCtrlController), 0, (GInstanceInitFunc) spice_ctrl_controller_instance_init, NULL };
		GType spice_ctrl_controller_type_id;
		spice_ctrl_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "SpiceCtrlController", &g_define_type_info, 0);
		g_once_init_leave (&spice_ctrl_controller_type_id__volatile, spice_ctrl_controller_type_id);
	}
	return spice_ctrl_controller_type_id__volatile;
}


static void _vala_spice_ctrl_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SpiceCtrlController * self;
	int length;
	self = SPICE_CTRL_CONTROLLER (object);
	switch (property_id) {
		case SPICE_CTRL_CONTROLLER_HOST:
		g_value_set_string (value, spice_ctrl_controller_get_host (self));
		break;
		case SPICE_CTRL_CONTROLLER_PORT:
		g_value_set_uint (value, spice_ctrl_controller_get_port (self));
		break;
		case SPICE_CTRL_CONTROLLER_SPORT:
		g_value_set_uint (value, spice_ctrl_controller_get_sport (self));
		break;
		case SPICE_CTRL_CONTROLLER_PASSWORD:
		g_value_set_string (value, spice_ctrl_controller_get_password (self));
		break;
		case SPICE_CTRL_CONTROLLER_DISPLAY_FLAGS:
		g_value_set_uint (value, spice_ctrl_controller_get_display_flags (self));
		break;
		case SPICE_CTRL_CONTROLLER_TLS_CIPHERS:
		g_value_set_string (value, spice_ctrl_controller_get_tls_ciphers (self));
		break;
		case SPICE_CTRL_CONTROLLER_HOST_SUBJECT:
		g_value_set_string (value, spice_ctrl_controller_get_host_subject (self));
		break;
		case SPICE_CTRL_CONTROLLER_CA_FILE:
		g_value_set_string (value, spice_ctrl_controller_get_ca_file (self));
		break;
		case SPICE_CTRL_CONTROLLER_TITLE:
		g_value_set_string (value, spice_ctrl_controller_get_title (self));
		break;
		case SPICE_CTRL_CONTROLLER_HOTKEYS:
		g_value_set_string (value, spice_ctrl_controller_get_hotkeys (self));
		break;
		case SPICE_CTRL_CONTROLLER_SECURE_CHANNELS:
		g_value_set_boxed (value, spice_ctrl_controller_get_secure_channels (self, &length));
		break;
		case SPICE_CTRL_CONTROLLER_DISABLE_CHANNELS:
		g_value_set_boxed (value, spice_ctrl_controller_get_disable_channels (self, &length));
		break;
		case SPICE_CTRL_CONTROLLER_MENU:
		g_value_set_object (value, spice_ctrl_controller_get_menu (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_spice_ctrl_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SpiceCtrlController * self;
	gpointer boxed;
	self = SPICE_CTRL_CONTROLLER (object);
	switch (property_id) {
		case SPICE_CTRL_CONTROLLER_HOST:
		spice_ctrl_controller_set_host (self, g_value_get_string (value));
		break;
		case SPICE_CTRL_CONTROLLER_PORT:
		spice_ctrl_controller_set_port (self, g_value_get_uint (value));
		break;
		case SPICE_CTRL_CONTROLLER_SPORT:
		spice_ctrl_controller_set_sport (self, g_value_get_uint (value));
		break;
		case SPICE_CTRL_CONTROLLER_PASSWORD:
		spice_ctrl_controller_set_password (self, g_value_get_string (value));
		break;
		case SPICE_CTRL_CONTROLLER_DISPLAY_FLAGS:
		spice_ctrl_controller_set_display_flags (self, g_value_get_uint (value));
		break;
		case SPICE_CTRL_CONTROLLER_TLS_CIPHERS:
		spice_ctrl_controller_set_tls_ciphers (self, g_value_get_string (value));
		break;
		case SPICE_CTRL_CONTROLLER_HOST_SUBJECT:
		spice_ctrl_controller_set_host_subject (self, g_value_get_string (value));
		break;
		case SPICE_CTRL_CONTROLLER_CA_FILE:
		spice_ctrl_controller_set_ca_file (self, g_value_get_string (value));
		break;
		case SPICE_CTRL_CONTROLLER_TITLE:
		spice_ctrl_controller_set_title (self, g_value_get_string (value));
		break;
		case SPICE_CTRL_CONTROLLER_HOTKEYS:
		spice_ctrl_controller_set_hotkeys (self, g_value_get_string (value));
		break;
		case SPICE_CTRL_CONTROLLER_SECURE_CHANNELS:
		boxed = g_value_get_boxed (value);
		spice_ctrl_controller_set_secure_channels (self, boxed, g_strv_length (boxed));
		break;
		case SPICE_CTRL_CONTROLLER_DISABLE_CHANNELS:
		boxed = g_value_get_boxed (value);
		spice_ctrl_controller_set_disable_channels (self, boxed, g_strv_length (boxed));
		break;
		case SPICE_CTRL_CONTROLLER_MENU:
		spice_ctrl_controller_set_menu (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



