/*
    This file is part of the sly ident daemon (slidentd).
   slidentd was written by Sean Hunter <sean@uncarved.com> as a minimal
    RFC1413 (ident) daemon.

   slidentd is copyright (c) 2001 Uncarved Systems Ltd.

   slidentd is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

   slidentd is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along withslidentd; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef SLIDENTD_CONFIG_H
#define SLIDENTD_CONFIG_H
#include <sys/syslog.h>

/* a fs path to run from.  We chroot here if possible */
#define SLIDENTD_CHROOT_PATH "/usr/share/empty"

/* a path prefix.  If running as root and SLIDENTD_CHROOT_PATH does not exist, 
* we create a directory called SLIDENTD_CHROOT_PREFIX.<pid>, chroot there, then 
* delete it.  This creates an empty "per-instance" chroot() jail.
* Cunning, eh?  Chris Evans' idea. */
#define SLIDENTD_CHROOT_PREFIX "/var/run/slidentd"

/* The path to a device to read to get random junk */
#define SLIDENTD_RAND_PATH "/dev/urandom"

/* a user to change to if I'm running as root */
#define SLIDENTD_UNPRIVILEGED_USER "nobody"

/* the path to the kernel tcp table */
#define SLIDENTD_TCPTABLE_PATH "/proc/net/tcp"

/* use syslog for logging if this is defined */
#define SLIDENTD_USE_SYSLOG 1

/* This is the path to the syslog device if syslog is being used */
#define SLIDENTD_SYSLOG_DEV_PATH "/dev/log"

/* This is the syslog priority to use (if syslog is used) */
#define SLIDENTD_SYSLOG_PRIORITY LOG_NOTICE

/* This is the syslog facility to use (if syslog is used) */
#define SLIDENTD_SYSLOG_FACILITY LOG_DAEMON

/* path to log to if I'm running under inetd or similar */
#define SLIDENTD_LOG_PATH "/var/log/slidentd"

/* How many bytes of entropy to send out as a response */
#define SLIDENTD_RESPONSE_RAND_BYTES 16

/* Include the results of gettimeofday() in the response ? 
* You might want to do this to avoid the possibility of sending 
* the same random cookie twice.  Unlikely, I know.  */
#define SLIDENTD_INCLUDE_TIMEOFDAY 0

/* The maximum length of the ident query */
#define SLIDENTD_MAX_INPUT_BUFFLEN 64

/* the upper bound on port numbers on the system */
#define SLIDENTD_MAX_PORTNUM 65535

/* log badly-formed input? */
#define SLIDENTD_LOG_BADINPUT 1

#endif
