#include "vtkEMSegmentPreProcessingStep.h"

#include "vtkEMSegmentGUI.h"
#include "vtkEMSegmentMRMLManager.h"

#include "vtkKWWizardWidget.h"
#include "vtkSlicerApplication.h"
#include "vtkKWMessageDialog.h"
#include "vtkEMSegmentLogic.h"
#include "vtkKWWizardWorkflow.h"
#include "vtkKWFrameWithLabel.h"
#include "vtkMRMLEMSWorkingDataNode.h"
#include "vtkKWCheckButtonWithLabel.h"
#include "vtkKWEntryWithLabel.h"
#include "vtkKWProgressDialog.h"
#include "vtkSlicerSliceControllerWidget.h"
#include "vtkMRMLEMSVolumeCollectionNode.h"
#include "vtkMRMLEMSGlobalParametersNode.h"

//----------------------------------------------------------------------------
vtkStandardNewMacro(vtkEMSegmentPreProcessingStep);
vtkCxxRevisionMacro(vtkEMSegmentPreProcessingStep, "$Revision: 1.2 $");

//----------------------------------------------------------------------------
vtkEMSegmentPreProcessingStep::vtkEMSegmentPreProcessingStep()
{
  this->SetName("6/9. Define Preprocessing");
  this->SetDescription("Answer questions for preprocessing of input images");
  this->askQuestionsBeforeRunningPreprocessingFlag = 1;
}

//----------------------------------------------------------------------------
vtkEMSegmentPreProcessingStep::~vtkEMSegmentPreProcessingStep()
{
}

//----------------------------------------------------------------------------
void
vtkEMSegmentPreProcessingStep::ShowUserInterface()
{
  this->Superclass::ShowUserInterface();

  //
  // Source TCL Files 
  //
  if (this->SourcePreprocessingTclFiles())
    {
      return;
    }
 
  //
  // Define General Framework For GUI 
  //

  vtkEMSegmentMRMLManager *mrmlManager = this->GetGUI()->GetMRMLManager();
  vtkKWWizardWidget *wizard_widget = this->GetGUI()->GetWizardWidget();
  if (!mrmlManager || !wizard_widget)
    {
    return;
    }

  vtkKWWidget *parent = wizard_widget->GetClientArea();;
  int enabled = parent->GetEnabled();
  wizard_widget->GetCancelButton()->SetEnabled(enabled);

  if (!this->CheckListFrame)
    {
    this->CheckListFrame = vtkKWFrameWithLabel::New();
    }
  if (!this->CheckListFrame->IsCreated())
    {
    this->CheckListFrame->SetParent(parent);
    this->CheckListFrame->Create();
    this->CheckListFrame->SetLabelText("Check List");
    }

  if (this->GetGUI()->IsSegmentationModeAdvanced()) {
    this->Script("pack %s -side top -anchor nw -fill x -padx 0 -pady 2", this->CheckListFrame->GetWidgetName());
  }

  //
  // Define Task Specific GUI 
  //

  this->CreateEntryLists();
  this->Script("::EMSegmenterPreProcessingTcl::ShowUserInterface");

}

//----------------------------------------------------------------------------
void
vtkEMSegmentPreProcessingStep::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os,indent);
}

//----------------------------------------------------------------------------
void
vtkEMSegmentPreProcessingStep::Validate()
{
  
  vtkEMSegmentMRMLManager *mrmlManager = this->GetGUI()->GetMRMLManager();
  vtkKWWizardWorkflow *wizard_workflow = this->GetGUI()->GetWizardWidget()->GetWizardWorkflow();

  // If they are still valid do not repeat preprocessing unless otherwise wanted 
  // Kilian - still to do - save intermediate results 
  // so do special check here 

  if ( mrmlManager->GetRegistrationPackageType() == mrmlManager->GetPackageTypeFromString("CMTK") ) {
    const char* path = this->Script("::EMSegmenterPreProcessingTcl::Get_CMTK_Installation_Path");
    if ( *path == '\0' ) {
      if (!vtkKWMessageDialog::PopupYesNo(this->GetApplication(), NULL, "CMTK is not installed",
                                          "For optimal results please install the CMTK extension. \n\nDo you want to proceed with BRAINSTools instead?",
                                          vtkKWMessageDialog::WarningIcon | vtkKWMessageDialog::InvokeAtPointer))
        {
          wizard_workflow->PushInput(vtkKWWizardStep::GetValidationFailedInput());
          wizard_workflow->ProcessInputs();
          return;
        }
    }
  }

  if (this->askQuestionsBeforeRunningPreprocessingFlag)
    {
      if (mrmlManager->GetWorkingDataNode()->GetAlignedTargetNodeIsValid() && mrmlManager->GetWorkingDataNode()->GetAlignedAtlasNodeIsValid())
    {
      // If it is ask if preprocessing should be done again
      if (!vtkKWMessageDialog::PopupYesNo(this->GetApplication(), NULL, "Redo Preprocessing of images?",
                          "Do you want to redo preprocessing of input images ?", 
                          vtkKWMessageDialog::WarningIcon | vtkKWMessageDialog::InvokeAtPointer))
             {
                 // If not just proceed
                 this->Superclass::Validate();
                 return;
             }
           } else {
    
             if (!vtkKWMessageDialog::PopupYesNo(this->GetApplication(), NULL, "Start Preprocessing of images?",
                           "Preprocessing of images might take a while. Do you want to proceed ?", 
                           vtkKWMessageDialog::WarningIcon | vtkKWMessageDialog::InvokeAtPointer))
               {
                  wizard_workflow->PushInput(vtkKWWizardStep::GetValidationFailedInput());
                  wizard_workflow->ProcessInputs();
                  return;
               }
          }
    }
    this->SetTaskPreprocessingSetting();
    
    vtkKWProgressDialog* progress = vtkKWProgressDialog::New();
    progress->SetParent(this->GetGUI ()->GetApplicationGUI ()->GetMainSlicerWindow ());
    progress->SetMasterWindow (this->GetGUI ()->GetApplicationGUI ()->GetMainSlicerWindow());
    progress->Create();
    progress->SetMessageText("Please wait until pre-processing has been finished.");
    progress->Display();
    int flag = atoi(this->Script("::EMSegmenterPreProcessingTcl::Run"));
    progress->SetParent(NULL);
    progress->Delete();
    
    if (flag)
    {
      vtkKWMessageDialog::PopupMessage(this->GetApplication(), NULL,
        "Error", "Pre-processing did not execute correctly",
        vtkKWMessageDialog::WarningIcon | vtkKWMessageDialog::InvokeAtPointer
      );
      cerr << "Pre-processing did not execute correctly" << endl;
      wizard_workflow->PushInput(vtkKWWizardStep::GetValidationFailedInput());
      wizard_workflow->ProcessInputs();
      return;
    } 

    // Set it to valid so next time we do not have to recompute it 
    mrmlManager->GetWorkingDataNode()->SetAlignedTargetNodeIsValid(1);
    mrmlManager->GetWorkingDataNode()->SetAlignedAtlasNodeIsValid(1);

    vtkMRMLEMSVolumeCollectionNode* targetNode = this->GetGUI()->GetMRMLManager()->GetWorkingDataNode()->GetInputTargetNode();
    if (targetNode) 
      {
        vtkMRMLVolumeNode* output =  targetNode->GetNthVolumeNode(0);
        vtkSlicerApplicationGUI *applicationGUI = this->GetGUI ()->GetApplicationGUI ();

        applicationGUI->GetMainSliceGUI("Red")->GetSliceController()->GetBackgroundSelector()->SetSelected(output);
        applicationGUI->GetMainSliceGUI("Yellow")->GetSliceController()->GetBackgroundSelector()->SetSelected(output);
        applicationGUI->GetMainSliceGUI("Green")->GetSliceController()->GetBackgroundSelector()->SetSelected(output);
      }
  
    cout << "=============================================" << endl;
    cout << "Pre-processing completed successfully" << endl;
    cout << "=============================================" << endl;

    // Everything went smoothly
    this->Superclass::Validate();
}

//----------------------------------------------------------------------------
void
vtkEMSegmentPreProcessingStep::SetTaskPreprocessingSetting()
{
  vtkEMSegmentMRMLManager *mrmlManager = this->GetGUI()->GetMRMLManager();
  if (!mrmlManager || !mrmlManager->GetGlobalParametersNode())
    {
      return;
    }

  vtksys_stl::stringstream defText;

  for (int i =0 ; i < (int)  this->checkButton.size(); i++)
    {
      defText << "|C";
      if (this->checkButton[i] && this->checkButton[i]->GetWidget())
    {
      defText << this->checkButton[i]->GetWidget()->GetSelectedState();
    } 
    }

  for (int i =0 ; i < (int) volumeMenuButtonID.size() ; i++)
    {
       defText << "|V";
       if (this->volumeMenuButtonID[i]) {
     vtkMRMLVolumeNode* volumeNode = mrmlManager->GetVolumeNode(this->volumeMenuButtonID[i]);
     if (!volumeNode) 
       {
         vtkErrorMacro("Volume Node for ID " << this->volumeMenuButtonID[i] << " does not exists" );
         defText << "NULL";
       } 
     else 
       {
         defText << volumeNode->GetID();
       }
       }
      else 
    {
      defText << "NULL";
    }
    }


  for (int i =0 ; i < (int)  this->textEntry.size(); i++)
    {
      defText << "|E";
      if (this->textEntry[i] && this->textEntry[i]->GetWidget())
    {
      defText << this->textEntry[i]->GetWidget()->GetValue();
    } 
    }

  mrmlManager->GetGlobalParametersNode()->SetTaskPreProcessingSetting(defText.str().c_str());
}



