Name:		slat
Version:	2.0
Release:	1
Source:		%{name}-%{version}.tar.gz
Vendor:		The MITRE Corporation

URL:		http://www.mitre.org/tech/selinux
Packager:	The MITRE Corporation <http://www.mitre.org/>
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-buildroot

Summary:	Tools for information flow analysis of SELinux policies
License:	GPL
Group:		System Environment/Base

PreReq:		/sbin/install-info
BuildRequires:	libsepol-devel

%description
Security-Enhanced Linux Analysis Tools (slat) provide a systematic way
to determine if security goals are achieved by a given SELinux policy
configuration.  In particular, slat is concerned with information flow
security goals, which describe desired paths by which information
moves throughout a system.  We provide a simple syntax in which to
express these goals, and tools that check a policy configuration
against the goals.

%package devel 
Summary: Slat Labeled Transition System formula libraries and headers
License: GPL
Group: Development/Libraries

%description devel
This package includes the header files and static libraries that are
needed to build software that uses the formulas for a SLAT Labeled
Transition System.

%prep
%setup -q

%build
%configure
make

%install
rm -rf %{buildroot}
%makeinstall

%clean
rm -rf %{buildroot}

%post
if [ -f %{_infodir}/%{name}.info.gz ]; then
  /sbin/install-info %{_infodir}/%{name}.info.gz %{_infodir}/dir
fi

%postun
if [ $1 -eq 0 ]; then
  if [ -f %{_infodir}/%{name}.info.gz ]; then
    /sbin/install-info --delete %{_infodir}/%{name}.info.gz %{_infodir}/dir
  fi
fi

%files
%defattr (-, root, root)
%doc AUTHORS ChangeLog COPYING INSTALL NEWS README
%{_bindir}/*
%{_mandir}/man1/*
%{_infodir}/*
%{_datadir}/%{name}/*

%files devel
%defattr (-, root, root)
%{_libdir}/*
%{_includedir}/%{name}/*
