/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * The grantlee's filter to format money.
 *
 * @author Stephane MANKOWSKI
 */
#include "skgmoneyfilter.h"
#include "skgtraces.h"
#include "skgservices.h"
#include "skgdocumentbank.h"
#include "skgmainpanel.h"

#include "grantlee/util.h"

QVariant SKGMoneyFilter::doFilter(const QVariant& input, const QVariant& argument, bool autoescape) const
{
    Q_UNUSED(autoescape);
    QString arg = Grantlee::getSafeString(argument);
    SKGMainPanel* mainPanel = SKGMainPanel::getMainPanel();
    SKGDocumentBank* doc = NULL;
    if (mainPanel) doc = qobject_cast< SKGDocumentBank* >(mainPanel->getDocument());
    if (doc) {

        return QVariant(doc->formatMoney(SKGServices::stringToDouble(Grantlee::getSafeString(input)), arg == "2" ? doc->getSecondaryUnit() : doc->getPrimaryUnit()));
    }
    return QVariant();
}

bool SKGMoneyFilter::isSafe() const
{
    return true;
}

QVariant SKGPercentFilter::doFilter(const QVariant& input, const QVariant& argument, bool autoescape) const
{
    Q_UNUSED(autoescape);
    Q_UNUSED(argument);
    SKGMainPanel* mainPanel = SKGMainPanel::getMainPanel();
    SKGDocumentBank* doc = NULL;
    if (mainPanel) doc = qobject_cast< SKGDocumentBank* >(mainPanel->getDocument());
    if (doc) {

        return QVariant(doc->formatPercentage(SKGServices::stringToDouble(Grantlee::getSafeString(input))));
    }
    return QVariant();
}

bool SKGPercentFilter::isSafe() const
{
    return true;
}

QVariant SKGDumpFilter::doFilter(const QVariant& input, const QVariant& argument, bool autoescape) const
{
    Q_UNUSED(autoescape);
    Q_UNUSED(argument);

    if (input.isValid()) {
        QObject* obj = input.value<QObject*>();
        if (obj) {
            const QMetaObject* metaObject = obj->metaObject();
            QString table = "<table>";
            int nb = metaObject->propertyCount();
            for (int i = 0; i < nb; ++i) {
                QVariant val = SKGDumpFilter::doFilter(obj->property(metaObject->property(i).name()), QVariant(), autoescape);
                table += QString("<tr><td>") % metaObject->property(i).name() % "</td><td>" % val.toString() % "</td></tr>";
            }
            table += "</table>";
            return QVariant(table);
        } else if (input.canConvert<SKGObjectBase>()) {
            SKGObjectBase obj = input.value<SKGObjectBase>();
            SKGQStringQStringMap att = obj.getAttributes();
            QStringList keys = att.keys();
            QString table = "<table>";
            int nb = keys.count();
            for (int i = 0; i < nb; ++i) {
                table += QString("<tr><td>") % keys.at(i) % "</td><td>" % att[keys.at(i)] % "</td></tr>";
            }
            table += "</table>";
            return QVariant(table);
        } else if (input.canConvert(QVariant::List)) {
            QList<QVariant> l = input.toList();
            int nb = l.count();
            QString table = "<table>";
            for (int i = 0; i < nb; ++i) {
                QVariant val = SKGDumpFilter::doFilter(l.at(i), QVariant(), autoescape);
                table += QString("<tr><td>") % SKGServices::intToString(i) % "</td><td>" % val.toString() % "</td></tr>";
            }
            table += "</table>";
            return QVariant(table);
        } else if (input.canConvert<SKGObjectBase::SKGListSKGObjectBase>()) {
            SKGObjectBase::SKGListSKGObjectBase l = input.value<SKGObjectBase::SKGListSKGObjectBase>();
            int nb = l.count();
            QString table;
            if (nb) {
                table = "<table><tr><th>#</th>";
                for (int i = 0; i < nb; ++i) {
                    SKGObjectBase obj = l.at(i);
                    SKGQStringQStringMap att = obj.getAttributes();
                    QStringList keys = att.keys();
                    QString line = QString("<tr><td>") % SKGServices::intToString(i) % "</td>";
                    int nbc = keys.count();
                    for (int j = 0; j < nbc; ++j) {
                        if (i == 0) table += QString("<th>") % keys.at(j) % "</th>";
                        line += QString("<td>") % att[keys.at(j)] % "</td>";
                    }
                    if (i == 0) table += "</tr>";
                    line += "</tr>";

                    table += line;
                }
                table += "</table>";
            }
            return QVariant(table);
        } else {
            return QVariant(input.toString());
        }
    }

    return QVariant();
}

bool SKGDumpFilter::isSafe() const
{
    return true;
}
