/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file is Plasma Applet for Report Skroogoid
*
* @author Siddharth SHARMA
*/
#ifndef REPORTSKROOGOID_H
#define REPORTSKROOGOID_H


#include <Plasma/Applet>
#include <Plasma/Label>

#include <skgtablewithgraph.h>
#include <skgservices.h>
#include <skgdocumentbank.h>

#include <QGraphicsGridLayout>
#include <QSignalMapper>

class ReportSkroogoid : public Plasma::Applet
{
    Q_OBJECT
public:
    ReportSkroogoid(QObject *parent, const QVariantList &args);
    ~ReportSkroogoid();
    /**
    * Reimplemented from Plasma::Applet
    */
    virtual void init();
private:
    /**
      *  QGraphicsWidget widget on which we add layout for adding items
      */
    QGraphicsWidget *m_widget;

    /**
    *  QGraphicsGridLayout layout for adding items in grid
    */
    QGraphicsGridLayout *m_layout;

    /**
    *  QGraphicsProxyWidget for adding Qt widgets on Plasma Applet
    */
    QGraphicsProxyWidget* pw;
    SKGTableWithGraph* view;

};

/**
  * For exporting skroogoid as a registered Plasma Applet
  */
K_EXPORT_PLASMA_APPLET(reportskroogoid, ReportSkroogoid)

#endif
