/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
import QtQuick 1.0
import org.kde.plasma.graphicswidgets 0.1 as PlasmaWidgets
import org.kde.plasma.core 0.1 as PlasmaCore
 
Item {
    width: 200
    height: 200

    PlasmaCore.DataSource {
	id: source
	engine: "skgdataengine"
	connectedSources: ["Banks"]
	interval: 500
    }

    Component {
	id: itemDelegate
	Item {
	    width: 180; height: 40
	    Column {
		Text { text: '<b>Name:</b> ' + bank_6 }
		Text { text: '<b>Amount:</b> ' + bank_6 }
	    }
	}
    }

    ListView {
	anchors.fill: parent
	model: PlasmaCore.DataModel {
	    dataSource: source
	}
	delegate:itemDelegate
    }    
}
