#ifndef _udpmessageserver_h
#define _udpmessageserver_h

#include <asio.hpp>
#include "messageserver.h"


class UDPMessageServer : public MessageServer
{
private:
  enum { max_length = 16384 };
  char data[max_length];
  asio::ip::udp::endpoint sender_endpoint;

  asio::io_service & ioservice;
  asio::ip::udp::socket sock;


  void handleReceiveFrom(const asio::error_code& err, size_t length);

public:
  UDPMessageServer(asio::io_service& io_service, unsigned short port_num);
  UDPMessageServer(asio::io_service& io_service, const asio::ip::udp::endpoint & endpoint);
};


#endif
