/* book.c generated by valac 0.13.4, the Vala compiler
 * generated from book.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-ps.h>
#include <zlib.h>
#include <jpeglib.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
typedef struct _BookPrivate BookPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define __g_list_free__page_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__page_unref0_ (var), NULL)))

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_PS_WRITER (ps_writer_get_type ())
#define PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PS_WRITER, PsWriter))
#define PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PS_WRITER, PsWriterClass))
#define IS_PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PS_WRITER))
#define IS_PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PS_WRITER))
#define PS_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PS_WRITER, PsWriterClass))

typedef struct _PsWriter PsWriter;
typedef struct _PsWriterClass PsWriterClass;
typedef struct _PsWriterPrivate PsWriterPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _ps_writer_unref0(var) ((var == NULL) ? NULL : (var = (ps_writer_unref (var), NULL)))

#define TYPE_PDF_WRITER (pdf_writer_get_type ())
#define PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PDF_WRITER, PDFWriter))
#define PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PDF_WRITER, PDFWriterClass))
#define IS_PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PDF_WRITER))
#define IS_PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PDF_WRITER))
#define PDF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PDF_WRITER, PDFWriterClass))

typedef struct _PDFWriter PDFWriter;
typedef struct _PDFWriterClass PDFWriterClass;
typedef struct _PDFWriterPrivate PDFWriterPrivate;
#define _pdf_writer_unref0(var) ((var == NULL) ? NULL : (var = (pdf_writer_unref (var), NULL)))
typedef struct _ParamSpecBook ParamSpecBook;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecPDFWriter ParamSpecPDFWriter;
typedef struct _ParamSpecPsWriter ParamSpecPsWriter;

struct _Book {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookPrivate * priv;
};

struct _BookClass {
	GTypeClass parent_class;
	void (*finalize) (Book *self);
};

struct _BookPrivate {
	GList* pages;
	gboolean needs_saving;
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _PsWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PsWriterPrivate * priv;
	cairo_surface_t* surface;
	GFileOutputStream* stream;
};

struct _PsWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PsWriter *self);
};

struct _PDFWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PDFWriterPrivate * priv;
	gsize offset;
	GList* object_offsets;
};

struct _PDFWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PDFWriter *self);
};

struct _ParamSpecBook {
	GParamSpec parent_instance;
};

struct _PDFWriterPrivate {
	GFileOutputStream* stream;
};

struct _ParamSpecPDFWriter {
	GParamSpec parent_instance;
};

struct _ParamSpecPsWriter {
	GParamSpec parent_instance;
};


static gpointer book_parent_class = NULL;
static gpointer pdf_writer_parent_class = NULL;
static gpointer ps_writer_parent_class = NULL;

gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
#define BOOK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BOOK, BookPrivate))
enum  {
	BOOK_DUMMY_PROPERTY
};
static void _page_unref0_ (gpointer var);
static void _g_list_free__page_unref0_ (GList* self);
Book* book_new (void);
Book* book_construct (GType object_type);
void book_clear (Book* self);
static void book_page_changed_cb (Book* self, Page* page);
void book_set_needs_saving (Book* self, gboolean needs_saving);
GType scan_direction_get_type (void) G_GNUC_CONST;
Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction);
static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self);
static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self);
void book_move_page (Book* self, Page* page, guint location);
void book_delete_page (Book* self, Page* page);
guint book_get_n_pages (Book* self);
Page* book_get_page (Book* self, gint page_number);
guint book_get_page_index (Book* self, Page* page);
static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i);
static void book_save_multi_file (Book* self, const gchar* type, GFile* file, GError** error);
void page_save (Page* self, const gchar* type, GFile* file, GError** error);
static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi);
static void book_save_ps (Book* self, GFile* file, GError** error);
PsWriter* ps_writer_new (GFileOutputStream* stream);
PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream);
gpointer ps_writer_ref (gpointer instance);
void ps_writer_unref (gpointer instance);
GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_ps_writer (GValue* value, gpointer v_object);
void value_take_ps_writer (GValue* value, gpointer v_object);
gpointer value_get_ps_writer (const GValue* value);
GType ps_writer_get_type (void) G_GNUC_CONST;
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
gint page_get_dpi (Page* self);
static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1);
static void book_jpeg_init_cb (struct jpeg_compress_struct* info);
static gboolean book_jpeg_empty_cb (struct jpeg_compress_struct* info);
static void book_jpeg_term_cb (struct jpeg_compress_struct* info);
static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gsize* n_written, int* result_length1);
static void _book_jpeg_init_cb_jpeg_initdestinationfunc (struct jpeg_compress_struct* cinfo);
static gboolean _book_jpeg_empty_cb_jpeg_emptyoutputbufferfunc (struct jpeg_compress_struct* cinfo);
static void _book_jpeg_term_cb_jpeg_termdestinationfunc (struct jpeg_compress_struct* cinfo);
static void book_save_pdf (Book* self, GFile* file, GError** error);
PDFWriter* pdf_writer_new (GFileOutputStream* stream);
PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream);
gpointer pdf_writer_ref (gpointer instance);
void pdf_writer_unref (gpointer instance);
GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pdf_writer (GValue* value, gpointer v_object);
void value_take_pdf_writer (GValue* value, gpointer v_object);
gpointer value_get_pdf_writer (const GValue* value);
GType pdf_writer_get_type (void) G_GNUC_CONST;
void pdf_writer_write_string (PDFWriter* self, const gchar* text);
guint pdf_writer_start_object (PDFWriter* self);
gboolean page_is_color (Page* self);
gint page_get_depth (Page* self);
static guint8* _vala_array_dup1 (guint8* self, int length);
static guint8* _vala_array_dup2 (guint8* self, int length);
void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1);
void book_save (Book* self, const gchar* type, GFile* file, GError** error);
gboolean book_get_needs_saving (Book* self);
static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void book_finalize (Book* obj);
#define PDF_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PDF_WRITER, PDFWriterPrivate))
enum  {
	PDF_WRITER_DUMMY_PROPERTY
};
static void pdf_writer_finalize (PDFWriter* obj);
enum  {
	PS_WRITER_DUMMY_PROPERTY
};
static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1);
static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1);
static void ps_writer_finalize (PsWriter* obj);


static void _page_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (page_unref (var), NULL));
}


static void _g_list_free__page_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _page_unref0_, NULL);
	g_list_free (self);
}


Book* book_construct (GType object_type) {
	Book* self = NULL;
	self = (Book*) g_type_create_instance (object_type);
	return self;
}


Book* book_new (void) {
	return book_construct (TYPE_BOOK);
}


void book_clear (Book* self) {
	g_return_if_fail (self != NULL);
	__g_list_free__page_unref0_0 (self->priv->pages);
	self->priv->pages = NULL;
	g_signal_emit_by_name (self, "cleared");
}


static void book_page_changed_cb (Book* self, Page* page) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	book_set_needs_saving (self, TRUE);
}


static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self) {
	book_page_changed_cb (self, _sender);
}


static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self) {
	book_page_changed_cb (self, _sender);
}


static gpointer _page_ref0 (gpointer self) {
	return self ? page_ref (self) : NULL;
}


Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction) {
	Page* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ScanDirection _tmp3_;
	Page* _tmp4_;
	Page* page;
	Page* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = width;
	_tmp1_ = height;
	_tmp2_ = dpi;
	_tmp3_ = scan_direction;
	_tmp4_ = page_new (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	page = _tmp4_;
	g_signal_connect (page, "pixels-changed", (GCallback) _book_page_changed_cb_page_pixels_changed, self);
	g_signal_connect (page, "crop-changed", (GCallback) _book_page_changed_cb_page_crop_changed, self);
	_tmp5_ = _page_ref0 (page);
	self->priv->pages = g_list_append (self->priv->pages, _tmp5_);
	g_signal_emit_by_name (self, "page-added", page);
	book_set_needs_saving (self, TRUE);
	result = page;
	return result;
}


void book_move_page (Book* self, Page* page, guint location) {
	Page* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	self->priv->pages = g_list_remove (self->priv->pages, _tmp0_);
	_tmp1_ = page;
	_tmp2_ = _page_ref0 (_tmp1_);
	_tmp3_ = location;
	self->priv->pages = g_list_insert (self->priv->pages, _tmp2_, (gint) _tmp3_);
	g_signal_emit_by_name (self, "reordered");
	book_set_needs_saving (self, TRUE);
}


void book_delete_page (Book* self, Page* page) {
	Page* _tmp0_;
	guint _tmp1_ = 0U;
	Page* _tmp2_;
	guint _tmp3_ = 0U;
	Page* _tmp4_;
	Page* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
	_tmp2_ = page;
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
	_tmp4_ = page;
	g_signal_emit_by_name (self, "page-removed", _tmp4_);
	_tmp5_ = page;
	self->priv->pages = g_list_remove (self->priv->pages, _tmp5_);
	book_set_needs_saving (self, TRUE);
}


guint book_get_n_pages (Book* self) {
	guint result = 0U;
	GList* _tmp0_;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->pages;
	_tmp1_ = g_list_length (_tmp0_);
	result = _tmp1_;
	return result;
}


Page* book_get_page (Book* self, gint page_number) {
	Page* result = NULL;
	gint _tmp0_;
	GList* _tmp4_;
	gint _tmp5_;
	gconstpointer _tmp6_ = NULL;
	Page* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = page_number;
	if (_tmp0_ < 0) {
		GList* _tmp1_;
		guint _tmp2_ = 0U;
		gint _tmp3_;
		_tmp1_ = self->priv->pages;
		_tmp2_ = g_list_length (_tmp1_);
		_tmp3_ = page_number;
		page_number = ((gint) _tmp2_) + _tmp3_;
	}
	_tmp4_ = self->priv->pages;
	_tmp5_ = page_number;
	_tmp6_ = g_list_nth_data (_tmp4_, (guint) _tmp5_);
	_tmp7_ = _page_ref0 ((Page*) _tmp6_);
	result = _tmp7_;
	return result;
}


guint book_get_page_index (Book* self, Page* page) {
	guint result = 0U;
	GList* _tmp0_;
	Page* _tmp1_;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (page != NULL, 0U);
	_tmp0_ = self->priv->pages;
	_tmp1_ = page;
	_tmp2_ = g_list_index (_tmp0_, _tmp1_);
	result = (guint) _tmp2_;
	return result;
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i) {
	GFile* result = NULL;
	gint _tmp0_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* basename;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* prefix;
	gchar* _tmp7_;
	gchar* suffix;
	const gchar* _tmp8_;
	gint _tmp9_ = 0;
	gint extension_index;
	gint _tmp10_;
	const gchar* _tmp25_;
	gint _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	GFile* _tmp30_ = NULL;
	GFile* _tmp31_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = i;
	if (_tmp0_ == 0) {
		const gchar* _tmp1_;
		GFile* _tmp2_ = NULL;
		_tmp1_ = uri;
		_tmp2_ = g_file_new_for_uri (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = uri;
	_tmp4_ = g_path_get_basename (_tmp3_);
	basename = _tmp4_;
	_tmp5_ = uri;
	_tmp6_ = g_strdup (_tmp5_);
	prefix = _tmp6_;
	_tmp7_ = g_strdup ("");
	suffix = _tmp7_;
	_tmp8_ = basename;
	_tmp9_ = string_last_index_of_char (_tmp8_, (gunichar) '.', 0);
	extension_index = _tmp9_;
	_tmp10_ = extension_index;
	if (_tmp10_ >= 0) {
		const gchar* _tmp11_;
		gint _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		const gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gchar* _tmp24_ = NULL;
		_tmp11_ = basename;
		_tmp12_ = extension_index;
		_tmp13_ = basename;
		_tmp14_ = strlen (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = string_slice (_tmp11_, (glong) _tmp12_, (glong) _tmp15_);
		_g_free0 (suffix);
		suffix = _tmp16_;
		_tmp17_ = uri;
		_tmp18_ = uri;
		_tmp19_ = strlen (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = suffix;
		_tmp22_ = strlen (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = string_slice (_tmp17_, (glong) 0, (glong) (_tmp20_ - _tmp23_));
		_g_free0 (prefix);
		prefix = _tmp24_;
	}
	_tmp25_ = prefix;
	_tmp26_ = i;
	_tmp27_ = suffix;
	_tmp28_ = g_strdup_printf ("%s-%d%s", _tmp25_, _tmp26_, _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_file_new_for_uri (_tmp29_);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp29_);
	result = _tmp31_;
	_g_free0 (suffix);
	_g_free0 (prefix);
	_g_free0 (basename);
	return result;
}


static void book_save_multi_file (Book* self, const gchar* type, GFile* file, GError** error) {
	gint i;
	GList* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (file != NULL);
	i = 0;
	_tmp0_ = self->priv->pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp0_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			Page* _tmp1_;
			Page* page = NULL;
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
			page = _tmp1_;
			{
				Page* _tmp2_;
				const gchar* _tmp3_;
				GFile* _tmp4_;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				gint _tmp7_;
				GFile* _tmp8_ = NULL;
				GFile* _tmp9_;
				gint _tmp10_;
				_tmp2_ = page;
				_tmp3_ = type;
				_tmp4_ = file;
				_tmp5_ = g_file_get_uri (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = i;
				_tmp8_ = book_make_indexed_file (self, _tmp6_, _tmp7_);
				_tmp9_ = _tmp8_;
				page_save (_tmp2_, _tmp3_, _tmp9_, &_inner_error_);
				_g_object_unref0 (_tmp9_);
				_g_free0 (_tmp6_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_page_unref0 (page);
					return;
				}
				_tmp10_ = i;
				i = _tmp10_ + 1;
				_page_unref0 (page);
			}
		}
	}
}


static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi) {
	cairo_surface_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* context;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GdkPixbuf* _tmp4_;
	cairo_pattern_t* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (surface != NULL);
	g_return_if_fail (image != NULL);
	_tmp0_ = surface;
	_tmp1_ = cairo_create (_tmp0_);
	context = _tmp1_;
	_tmp2_ = dpi;
	_tmp3_ = dpi;
	cairo_scale (context, 72.0 / _tmp2_, 72.0 / _tmp3_);
	_tmp4_ = image;
	gdk_cairo_set_source_pixbuf (context, _tmp4_, (gdouble) 0, (gdouble) 0);
	_tmp5_ = cairo_get_source (context);
	cairo_pattern_set_filter (_tmp5_, CAIRO_FILTER_BEST);
	cairo_paint (context);
	_cairo_destroy0 (context);
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


static void book_save_ps (Book* self, GFile* file, GError** error) {
	GFile* _tmp0_;
	GFileOutputStream* _tmp1_ = NULL;
	GFileOutputStream* stream;
	PsWriter* _tmp2_;
	PsWriter* writer;
	PsWriter* _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_surface_t* _tmp5_;
	cairo_surface_t* surface;
	GList* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
	stream = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = ps_writer_new (stream);
	writer = _tmp2_;
	_tmp3_ = writer;
	_tmp4_ = _tmp3_->surface;
	_tmp5_ = _cairo_surface_reference0 (_tmp4_);
	surface = _tmp5_;
	_tmp6_ = self->priv->pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp6_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			Page* _tmp7_;
			Page* page = NULL;
			_tmp7_ = _page_ref0 ((Page*) page_it->data);
			page = _tmp7_;
			{
				Page* _tmp8_;
				GdkPixbuf* _tmp9_ = NULL;
				GdkPixbuf* image;
				GdkPixbuf* _tmp10_;
				gint _tmp11_ = 0;
				Page* _tmp12_;
				gint _tmp13_ = 0;
				gdouble width;
				GdkPixbuf* _tmp14_;
				gint _tmp15_ = 0;
				Page* _tmp16_;
				gint _tmp17_ = 0;
				gdouble height;
				cairo_surface_t* _tmp18_;
				gdouble _tmp19_;
				gdouble _tmp20_;
				cairo_surface_t* _tmp21_;
				GdkPixbuf* _tmp22_;
				Page* _tmp23_;
				gint _tmp24_ = 0;
				cairo_surface_t* _tmp25_;
				_tmp8_ = page;
				_tmp9_ = page_get_image (_tmp8_, TRUE);
				image = _tmp9_;
				_tmp10_ = image;
				_tmp11_ = gdk_pixbuf_get_width (_tmp10_);
				_tmp12_ = page;
				_tmp13_ = page_get_dpi (_tmp12_);
				width = (_tmp11_ * 72.0) / _tmp13_;
				_tmp14_ = image;
				_tmp15_ = gdk_pixbuf_get_height (_tmp14_);
				_tmp16_ = page;
				_tmp17_ = page_get_dpi (_tmp16_);
				height = (_tmp15_ * 72.0) / _tmp17_;
				_tmp18_ = surface;
				_tmp19_ = width;
				_tmp20_ = height;
				cairo_ps_surface_set_size (_tmp18_, _tmp19_, _tmp20_);
				_tmp21_ = surface;
				_tmp22_ = image;
				_tmp23_ = page;
				_tmp24_ = page_get_dpi (_tmp23_);
				book_save_ps_pdf_surface (self, _tmp21_, _tmp22_, (gdouble) _tmp24_);
				_tmp25_ = surface;
				cairo_surface_show_page (_tmp25_);
				_g_object_unref0 (image);
				_page_unref0 (page);
			}
		}
	}
	_cairo_surface_destroy0 (surface);
	_ps_writer_unref0 (writer);
	_g_object_unref0 (stream);
}


static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1) {
	guint8* result = NULL;
	z_stream stream = {0};
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_ = NULL;
	guint8* out_data;
	gint out_data_length1;
	gint _out_data_size_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	z_stream _tmp7_;
	guint _tmp8_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	z_stream _tmp11_;
	guint _tmp12_;
	guint n_written;
	guint _tmp13_;
	gint _tmp14_ = 0;
	guint8* _tmp15_;
	gint _tmp15__length1;
	g_return_val_if_fail (self != NULL, NULL);
	deflateInit (&stream, (gint) Z_BEST_COMPRESSION);
	_tmp0_ = data;
	_tmp0__length1 = data_length1;
	_tmp1_ = g_new0 (guint8, _tmp0__length1);
	out_data = _tmp1_;
	out_data_length1 = _tmp0__length1;
	_out_data_size_ = out_data_length1;
	_tmp2_ = data;
	_tmp2__length1 = data_length1;
	stream.next_in = _tmp2_;
	stream.avail_in = _tmp2__length1;
	_tmp3_ = out_data;
	_tmp3__length1 = out_data_length1;
	stream.next_out = _tmp3_;
	stream.avail_out = _tmp3__length1;
	while (TRUE) {
		z_stream _tmp4_;
		guint _tmp5_;
		gint _tmp6_ = 0;
		_tmp4_ = stream;
		_tmp5_ = _tmp4_.avail_in;
		if (!(_tmp5_ > ((guint) 0))) {
			break;
		}
		_tmp6_ = deflate (&stream, (gint) Z_FINISH);
		if (_tmp6_ == ((gint) Z_STREAM_ERROR)) {
			break;
		}
	}
	_tmp7_ = stream;
	_tmp8_ = _tmp7_.avail_in;
	if (_tmp8_ > ((guint) 0)) {
		guint8* _tmp9_;
		gint _tmp9__length1;
		_tmp9_ = NULL;
		_tmp9__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp9__length1;
		}
		result = _tmp9_;
		out_data = (g_free (out_data), NULL);
		deflateEnd (&stream);
		return result;
	}
	_tmp10_ = data;
	_tmp10__length1 = data_length1;
	_tmp11_ = stream;
	_tmp12_ = _tmp11_.avail_out;
	n_written = _tmp10__length1 - _tmp12_;
	_tmp13_ = n_written;
	_tmp14_ = (gint) _tmp13_;
	out_data = g_renew (guint8, out_data, (gint) _tmp13_);
	(_tmp14_ > out_data_length1) ? memset (out_data + out_data_length1, 0, sizeof (guint8) * (_tmp14_ - out_data_length1)) : NULL;
	out_data_length1 = _tmp14_;
	_out_data_size_ = _tmp14_;
	_tmp15_ = out_data;
	_tmp15__length1 = out_data_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	deflateEnd (&stream);
	return result;
}


static void book_jpeg_init_cb (struct jpeg_compress_struct* info) {
	g_return_if_fail (info != NULL);
}


static gboolean book_jpeg_empty_cb (struct jpeg_compress_struct* info) {
	gboolean result = FALSE;
	g_return_val_if_fail (info != NULL, FALSE);
	result = TRUE;
	return result;
}


static void book_jpeg_term_cb (struct jpeg_compress_struct* info) {
	g_return_if_fail (info != NULL);
}


static void _book_jpeg_init_cb_jpeg_initdestinationfunc (struct jpeg_compress_struct* cinfo) {
	book_jpeg_init_cb (cinfo);
}


static gboolean _book_jpeg_empty_cb_jpeg_emptyoutputbufferfunc (struct jpeg_compress_struct* cinfo) {
	gboolean result;
	result = book_jpeg_empty_cb (cinfo);
	return result;
}


static void _book_jpeg_term_cb_jpeg_termdestinationfunc (struct jpeg_compress_struct* cinfo) {
	book_jpeg_term_cb (cinfo);
}


static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gsize* n_written, int* result_length1) {
	gsize _vala_n_written = 0UL;
	guint8* result = NULL;
	struct jpeg_compress_struct info = {0};
	struct jpeg_error_mgr jerr = {0};
	struct jpeg_destination_mgr dest_mgr = {0};
	struct jpeg_error_mgr* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_;
	gint _tmp2_ = 0;
	GdkPixbuf* _tmp3_;
	gint _tmp4_ = 0;
	struct jpeg_compress_struct _tmp5_;
	gint _tmp6_;
	struct jpeg_compress_struct _tmp7_;
	gint _tmp8_;
	struct jpeg_compress_struct _tmp9_;
	gint _tmp10_;
	gint max_length;
	gint _tmp11_;
	guint8* _tmp12_ = NULL;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	gint _tmp14_;
	GdkPixbuf* _tmp15_;
	guint8* _tmp16_ = NULL;
	guint8* pixels;
	gint pixels_length1;
	gint _pixels_size_;
	gint _tmp28_;
	struct jpeg_destination_mgr _tmp29_;
	gint _tmp30_;
	guint8* _tmp31_;
	gint _tmp31__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (image != NULL, NULL);
	memset (&info, 0, sizeof (struct jpeg_compress_struct));
	memset (&jerr, 0, sizeof (struct jpeg_error_mgr));
	memset (&dest_mgr, 0, sizeof (struct jpeg_destination_mgr));
	_tmp0_ = jpeg_std_error (&jerr);
	info.err = _tmp0_;
	jpeg_create_compress (&info);
	_tmp1_ = image;
	_tmp2_ = gdk_pixbuf_get_width (_tmp1_);
	info.image_width = _tmp2_;
	_tmp3_ = image;
	_tmp4_ = gdk_pixbuf_get_height (_tmp3_);
	info.image_height = _tmp4_;
	info.input_components = 3;
	info.in_color_space = JCS_RGB;
	jpeg_set_defaults (&info);
	_tmp5_ = info;
	_tmp6_ = _tmp5_.image_width;
	_tmp7_ = info;
	_tmp8_ = _tmp7_.image_height;
	_tmp9_ = info;
	_tmp10_ = _tmp9_.input_components;
	max_length = (_tmp6_ * _tmp8_) * _tmp10_;
	_tmp11_ = max_length;
	_tmp12_ = g_new0 (guint8, _tmp11_);
	data = _tmp12_;
	data_length1 = _tmp11_;
	_data_size_ = data_length1;
	_tmp13_ = data;
	_tmp13__length1 = data_length1;
	dest_mgr.next_output_byte = _tmp13_;
	_tmp14_ = max_length;
	dest_mgr.free_in_buffer = _tmp14_;
	dest_mgr.init_destination = _book_jpeg_init_cb_jpeg_initdestinationfunc;
	dest_mgr.empty_output_buffer = _book_jpeg_empty_cb_jpeg_emptyoutputbufferfunc;
	dest_mgr.term_destination = _book_jpeg_term_cb_jpeg_termdestinationfunc;
	info.dest = &dest_mgr;
	jpeg_start_compress (&info, TRUE);
	_tmp15_ = image;
	_tmp16_ = gdk_pixbuf_get_pixels (_tmp15_);
	pixels = _tmp16_;
	pixels_length1 = -1;
	_pixels_size_ = pixels_length1;
	{
		gint r;
		r = 0;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_;
				gint _tmp20_;
				struct jpeg_compress_struct _tmp21_;
				gint _tmp22_;
				guint8* row[1] = {0};
				guint8* _tmp23_;
				gint _tmp23__length1;
				gint _tmp24_;
				GdkPixbuf* _tmp25_;
				gint _tmp26_ = 0;
				guint8* _tmp27_;
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = r;
					r = _tmp19_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp20_ = r;
				_tmp21_ = info;
				_tmp22_ = _tmp21_.image_height;
				if (!(_tmp20_ < _tmp22_)) {
					break;
				}
				_tmp23_ = pixels;
				_tmp23__length1 = pixels_length1;
				_tmp24_ = r;
				_tmp25_ = image;
				_tmp26_ = gdk_pixbuf_get_rowstride (_tmp25_);
				row[0] = ((guint8*) _tmp23_) + (_tmp24_ * _tmp26_);
				_tmp27_ = row[0];
				jpeg_write_scanlines (&info, row, 1);
			}
		}
	}
	jpeg_finish_compress (&info);
	_tmp28_ = max_length;
	_tmp29_ = dest_mgr;
	_tmp30_ = _tmp29_.free_in_buffer;
	_vala_n_written = (gsize) (_tmp28_ - _tmp30_);
	_tmp31_ = data;
	_tmp31__length1 = data_length1;
	if (result_length1) {
		*result_length1 = _tmp31__length1;
	}
	result = _tmp31_;
	jpeg_destroy_compress (&info);
	if (n_written) {
		*n_written = _vala_n_written;
	}
	return result;
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static void book_save_pdf (Book* self, GFile* file, GError** error) {
	GFile* _tmp0_;
	GFileOutputStream* _tmp1_ = NULL;
	GFileOutputStream* stream;
	PDFWriter* _tmp2_;
	PDFWriter* writer;
	PDFWriter* _tmp3_;
	PDFWriter* _tmp4_;
	PDFWriter* _tmp5_;
	guint _tmp6_ = 0U;
	guint catalog_number;
	PDFWriter* _tmp7_;
	guint _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	PDFWriter* _tmp11_;
	PDFWriter* _tmp12_;
	PDFWriter* _tmp13_;
	guint _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	PDFWriter* _tmp17_;
	PDFWriter* _tmp18_;
	PDFWriter* _tmp19_;
	PDFWriter* _tmp20_;
	guint _tmp21_ = 0U;
	guint pages_number;
	PDFWriter* _tmp22_;
	guint _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	PDFWriter* _tmp26_;
	PDFWriter* _tmp27_;
	PDFWriter* _tmp28_;
	PDFWriter* _tmp39_;
	PDFWriter* _tmp40_;
	guint _tmp41_ = 0U;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_;
	PDFWriter* _tmp44_;
	PDFWriter* _tmp45_;
	PDFWriter* _tmp359_;
	PDFWriter* _tmp360_;
	guint _tmp361_ = 0U;
	guint info_number;
	PDFWriter* _tmp362_;
	guint _tmp363_;
	gchar* _tmp364_ = NULL;
	gchar* _tmp365_;
	PDFWriter* _tmp366_;
	PDFWriter* _tmp367_;
	gchar* _tmp368_ = NULL;
	gchar* _tmp369_;
	PDFWriter* _tmp370_;
	PDFWriter* _tmp371_;
	PDFWriter* _tmp372_;
	gsize _tmp373_;
	gsize xref_offset;
	PDFWriter* _tmp374_;
	PDFWriter* _tmp375_;
	PDFWriter* _tmp376_;
	GList* _tmp377_;
	guint _tmp378_ = 0U;
	gchar* _tmp379_ = NULL;
	gchar* _tmp380_;
	PDFWriter* _tmp381_;
	GList* _tmp382_;
	PDFWriter* _tmp387_;
	PDFWriter* _tmp388_;
	PDFWriter* _tmp389_;
	PDFWriter* _tmp390_;
	GList* _tmp391_;
	guint _tmp392_ = 0U;
	gchar* _tmp393_ = NULL;
	gchar* _tmp394_;
	PDFWriter* _tmp395_;
	guint _tmp396_;
	gchar* _tmp397_ = NULL;
	gchar* _tmp398_;
	PDFWriter* _tmp399_;
	guint _tmp400_;
	gchar* _tmp401_ = NULL;
	gchar* _tmp402_;
	PDFWriter* _tmp403_;
	PDFWriter* _tmp404_;
	PDFWriter* _tmp405_;
	gsize _tmp406_;
	gchar* _tmp407_ = NULL;
	gchar* _tmp408_;
	PDFWriter* _tmp409_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
	stream = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = pdf_writer_new (stream);
	writer = _tmp2_;
	_tmp3_ = writer;
	pdf_writer_write_string (_tmp3_, "%PDF-1.3\n");
	_tmp4_ = writer;
	pdf_writer_write_string (_tmp4_, "%\xe2\xe3\xcf\xd3\n");
	_tmp5_ = writer;
	_tmp6_ = pdf_writer_start_object (_tmp5_);
	catalog_number = _tmp6_;
	_tmp7_ = writer;
	_tmp8_ = catalog_number;
	_tmp9_ = g_strdup_printf ("%u 0 obj\n", _tmp8_);
	_tmp10_ = _tmp9_;
	pdf_writer_write_string (_tmp7_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = writer;
	pdf_writer_write_string (_tmp11_, "<<\n");
	_tmp12_ = writer;
	pdf_writer_write_string (_tmp12_, "/Type /Catalog\n");
	_tmp13_ = writer;
	_tmp14_ = catalog_number;
	_tmp15_ = g_strdup_printf ("/Pages %u 0 R\n", _tmp14_ + 1);
	_tmp16_ = _tmp15_;
	pdf_writer_write_string (_tmp13_, _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = writer;
	pdf_writer_write_string (_tmp17_, ">>\n");
	_tmp18_ = writer;
	pdf_writer_write_string (_tmp18_, "endobj\n");
	_tmp19_ = writer;
	pdf_writer_write_string (_tmp19_, "\n");
	_tmp20_ = writer;
	_tmp21_ = pdf_writer_start_object (_tmp20_);
	pages_number = _tmp21_;
	_tmp22_ = writer;
	_tmp23_ = pages_number;
	_tmp24_ = g_strdup_printf ("%u 0 obj\n", _tmp23_);
	_tmp25_ = _tmp24_;
	pdf_writer_write_string (_tmp22_, _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = writer;
	pdf_writer_write_string (_tmp26_, "<<\n");
	_tmp27_ = writer;
	pdf_writer_write_string (_tmp27_, "/Type /Pages\n");
	_tmp28_ = writer;
	pdf_writer_write_string (_tmp28_, "/Kids [");
	{
		gint i;
		i = 0;
		{
			gboolean _tmp29_;
			_tmp29_ = TRUE;
			while (TRUE) {
				gboolean _tmp30_;
				gint _tmp32_;
				guint _tmp33_ = 0U;
				PDFWriter* _tmp34_;
				guint _tmp35_;
				gint _tmp36_;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_;
				_tmp30_ = _tmp29_;
				if (!_tmp30_) {
					gint _tmp31_;
					_tmp31_ = i;
					i = _tmp31_ + 1;
				}
				_tmp29_ = FALSE;
				_tmp32_ = i;
				_tmp33_ = book_get_n_pages (self);
				if (!(((guint) _tmp32_) < _tmp33_)) {
					break;
				}
				_tmp34_ = writer;
				_tmp35_ = pages_number;
				_tmp36_ = i;
				_tmp37_ = g_strdup_printf (" %u 0 R", (_tmp35_ + 1) + (_tmp36_ * 3));
				_tmp38_ = _tmp37_;
				pdf_writer_write_string (_tmp34_, _tmp38_);
				_g_free0 (_tmp38_);
			}
		}
	}
	_tmp39_ = writer;
	pdf_writer_write_string (_tmp39_, " ]\n");
	_tmp40_ = writer;
	_tmp41_ = book_get_n_pages (self);
	_tmp42_ = g_strdup_printf ("/Count %u\n", _tmp41_);
	_tmp43_ = _tmp42_;
	pdf_writer_write_string (_tmp40_, _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = writer;
	pdf_writer_write_string (_tmp44_, ">>\n");
	_tmp45_ = writer;
	pdf_writer_write_string (_tmp45_, "endobj\n");
	{
		gint i;
		i = 0;
		{
			gboolean _tmp46_;
			_tmp46_ = TRUE;
			while (TRUE) {
				gboolean _tmp47_;
				gint _tmp49_;
				guint _tmp50_ = 0U;
				gint _tmp51_;
				Page* _tmp52_ = NULL;
				Page* page;
				Page* _tmp53_;
				GdkPixbuf* _tmp54_ = NULL;
				GdkPixbuf* image;
				GdkPixbuf* _tmp55_;
				gint _tmp56_ = 0;
				gint width;
				GdkPixbuf* _tmp57_;
				gint _tmp58_ = 0;
				gint height;
				GdkPixbuf* _tmp59_;
				guint8* _tmp60_ = NULL;
				guint8* pixels;
				gint pixels_length1;
				gint _pixels_size_;
				gint _tmp61_;
				Page* _tmp62_;
				gint _tmp63_ = 0;
				gdouble page_width;
				gint _tmp64_;
				Page* _tmp65_;
				gint _tmp66_ = 0;
				gdouble page_height;
				gint depth;
				gchar* _tmp67_;
				gchar* color_space;
				gchar* filter;
				gchar* _tmp68_ = NULL;
				gchar* width_buffer;
				gint width_buffer_length1;
				gint _width_buffer_size_;
				gchar* _tmp69_ = NULL;
				gchar* height_buffer;
				gint height_buffer_length1;
				gint _height_buffer_size_;
				guint8* data = NULL;
				gint data_length1 = 0;
				gint _data_size_ = 0;
				Page* _tmp70_;
				gboolean _tmp71_ = FALSE;
				guint8* _tmp237_;
				gint _tmp237__length1;
				gint _tmp238_ = 0;
				guint8* _tmp239_ = NULL;
				guint8* compressed_data;
				gint compressed_data_length1;
				gint _compressed_data_size_;
				guint8* _tmp240_;
				gint _tmp240__length1;
				PDFWriter* _tmp255_;
				PDFWriter* _tmp256_;
				guint _tmp257_ = 0U;
				guint number;
				PDFWriter* _tmp258_;
				guint _tmp259_;
				gchar* _tmp260_ = NULL;
				gchar* _tmp261_;
				PDFWriter* _tmp262_;
				PDFWriter* _tmp263_;
				PDFWriter* _tmp264_;
				guint _tmp265_;
				gchar* _tmp266_ = NULL;
				gchar* _tmp267_;
				PDFWriter* _tmp268_;
				gint _tmp269_;
				guint _tmp270_;
				gchar* _tmp271_ = NULL;
				gchar* _tmp272_;
				PDFWriter* _tmp273_;
				gdouble _tmp274_;
				gchar* _tmp275_;
				gint _tmp275__length1;
				const gchar* _tmp276_ = NULL;
				gdouble _tmp277_;
				gchar* _tmp278_;
				gint _tmp278__length1;
				const gchar* _tmp279_ = NULL;
				gchar* _tmp280_ = NULL;
				gchar* _tmp281_;
				PDFWriter* _tmp282_;
				guint _tmp283_;
				gchar* _tmp284_ = NULL;
				gchar* _tmp285_;
				PDFWriter* _tmp286_;
				PDFWriter* _tmp287_;
				PDFWriter* _tmp288_;
				PDFWriter* _tmp289_;
				guint _tmp290_ = 0U;
				PDFWriter* _tmp291_;
				guint _tmp292_;
				gchar* _tmp293_ = NULL;
				gchar* _tmp294_;
				PDFWriter* _tmp295_;
				PDFWriter* _tmp296_;
				PDFWriter* _tmp297_;
				PDFWriter* _tmp298_;
				gint _tmp299_;
				gchar* _tmp300_ = NULL;
				gchar* _tmp301_;
				PDFWriter* _tmp302_;
				gint _tmp303_;
				gchar* _tmp304_ = NULL;
				gchar* _tmp305_;
				PDFWriter* _tmp306_;
				const gchar* _tmp307_;
				gchar* _tmp308_ = NULL;
				gchar* _tmp309_;
				PDFWriter* _tmp310_;
				gint _tmp311_;
				gchar* _tmp312_ = NULL;
				gchar* _tmp313_;
				PDFWriter* _tmp314_;
				guint8* _tmp315_;
				gint _tmp315__length1;
				gchar* _tmp316_ = NULL;
				gchar* _tmp317_;
				const gchar* _tmp318_;
				PDFWriter* _tmp323_;
				PDFWriter* _tmp324_;
				PDFWriter* _tmp325_;
				guint8* _tmp326_;
				gint _tmp326__length1;
				PDFWriter* _tmp327_;
				PDFWriter* _tmp328_;
				PDFWriter* _tmp329_;
				gdouble _tmp330_;
				gchar* _tmp331_;
				gint _tmp331__length1;
				const gchar* _tmp332_ = NULL;
				gdouble _tmp333_;
				gchar* _tmp334_;
				gint _tmp334__length1;
				const gchar* _tmp335_ = NULL;
				gint _tmp336_;
				gchar* _tmp337_ = NULL;
				gchar* command;
				PDFWriter* _tmp338_;
				PDFWriter* _tmp339_;
				guint _tmp340_ = 0U;
				PDFWriter* _tmp341_;
				guint _tmp342_;
				gchar* _tmp343_ = NULL;
				gchar* _tmp344_;
				PDFWriter* _tmp345_;
				PDFWriter* _tmp346_;
				const gchar* _tmp347_;
				gint _tmp348_;
				gint _tmp349_;
				gchar* _tmp350_ = NULL;
				gchar* _tmp351_;
				PDFWriter* _tmp352_;
				PDFWriter* _tmp353_;
				PDFWriter* _tmp354_;
				const gchar* _tmp355_;
				PDFWriter* _tmp356_;
				PDFWriter* _tmp357_;
				PDFWriter* _tmp358_;
				_tmp47_ = _tmp46_;
				if (!_tmp47_) {
					gint _tmp48_;
					_tmp48_ = i;
					i = _tmp48_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp49_ = i;
				_tmp50_ = book_get_n_pages (self);
				if (!(((guint) _tmp49_) < _tmp50_)) {
					break;
				}
				_tmp51_ = i;
				_tmp52_ = book_get_page (self, _tmp51_);
				page = _tmp52_;
				_tmp53_ = page;
				_tmp54_ = page_get_image (_tmp53_, TRUE);
				image = _tmp54_;
				_tmp55_ = image;
				_tmp56_ = gdk_pixbuf_get_width (_tmp55_);
				width = _tmp56_;
				_tmp57_ = image;
				_tmp58_ = gdk_pixbuf_get_height (_tmp57_);
				height = _tmp58_;
				_tmp59_ = image;
				_tmp60_ = gdk_pixbuf_get_pixels (_tmp59_);
				pixels = _tmp60_;
				pixels_length1 = -1;
				_pixels_size_ = pixels_length1;
				_tmp61_ = width;
				_tmp62_ = page;
				_tmp63_ = page_get_dpi (_tmp62_);
				page_width = (_tmp61_ * 72.0) / _tmp63_;
				_tmp64_ = height;
				_tmp65_ = page;
				_tmp66_ = page_get_dpi (_tmp65_);
				page_height = (_tmp64_ * 72.0) / _tmp66_;
				depth = 8;
				_tmp67_ = g_strdup ("DeviceRGB");
				color_space = _tmp67_;
				filter = NULL;
				_tmp68_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
				width_buffer = _tmp68_;
				width_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
				_width_buffer_size_ = width_buffer_length1;
				_tmp69_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
				height_buffer = _tmp69_;
				height_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
				_height_buffer_size_ = height_buffer_length1;
				_tmp70_ = page;
				_tmp71_ = page_is_color (_tmp70_);
				if (_tmp71_) {
					gchar* _tmp72_;
					gint _tmp73_;
					gint _tmp74_;
					gint data_length;
					gint _tmp75_;
					guint8* _tmp76_ = NULL;
					depth = 8;
					_tmp72_ = g_strdup ("DeviceRGB");
					_g_free0 (color_space);
					color_space = _tmp72_;
					_tmp73_ = height;
					_tmp74_ = width;
					data_length = ((_tmp73_ * _tmp74_) * 3) + 1;
					_tmp75_ = data_length;
					_tmp76_ = g_new0 (guint8, _tmp75_);
					data = (g_free (data), NULL);
					data = _tmp76_;
					data_length1 = _tmp75_;
					_data_size_ = data_length1;
					{
						gint row;
						row = 0;
						{
							gboolean _tmp77_;
							_tmp77_ = TRUE;
							while (TRUE) {
								gboolean _tmp78_;
								gint _tmp80_;
								gint _tmp81_;
								gint _tmp82_;
								GdkPixbuf* _tmp83_;
								gint _tmp84_ = 0;
								gint in_offset;
								gint _tmp85_;
								gint _tmp86_;
								gint out_offset;
								_tmp78_ = _tmp77_;
								if (!_tmp78_) {
									gint _tmp79_;
									_tmp79_ = row;
									row = _tmp79_ + 1;
								}
								_tmp77_ = FALSE;
								_tmp80_ = row;
								_tmp81_ = height;
								if (!(_tmp80_ < _tmp81_)) {
									break;
								}
								_tmp82_ = row;
								_tmp83_ = image;
								_tmp84_ = gdk_pixbuf_get_rowstride (_tmp83_);
								in_offset = _tmp82_ * _tmp84_;
								_tmp85_ = row;
								_tmp86_ = width;
								out_offset = (_tmp85_ * _tmp86_) * 3;
								{
									gint x;
									x = 0;
									{
										gboolean _tmp87_;
										_tmp87_ = TRUE;
										while (TRUE) {
											gboolean _tmp88_;
											gint _tmp90_;
											gint _tmp91_;
											gint _tmp92_;
											gint _tmp93_;
											gint in_o;
											gint _tmp94_;
											gint _tmp95_;
											gint out_o;
											guint8* _tmp96_;
											gint _tmp96__length1;
											gint _tmp97_;
											guint8* _tmp98_;
											gint _tmp98__length1;
											gint _tmp99_;
											guint8 _tmp100_;
											guint8 _tmp101_;
											guint8* _tmp102_;
											gint _tmp102__length1;
											gint _tmp103_;
											guint8* _tmp104_;
											gint _tmp104__length1;
											gint _tmp105_;
											guint8 _tmp106_;
											guint8 _tmp107_;
											guint8* _tmp108_;
											gint _tmp108__length1;
											gint _tmp109_;
											guint8* _tmp110_;
											gint _tmp110__length1;
											gint _tmp111_;
											guint8 _tmp112_;
											guint8 _tmp113_;
											_tmp88_ = _tmp87_;
											if (!_tmp88_) {
												gint _tmp89_;
												_tmp89_ = x;
												x = _tmp89_ + 1;
											}
											_tmp87_ = FALSE;
											_tmp90_ = x;
											_tmp91_ = width;
											if (!(_tmp90_ < _tmp91_)) {
												break;
											}
											_tmp92_ = in_offset;
											_tmp93_ = x;
											in_o = _tmp92_ + (_tmp93_ * 3);
											_tmp94_ = out_offset;
											_tmp95_ = x;
											out_o = _tmp94_ + (_tmp95_ * 3);
											_tmp96_ = data;
											_tmp96__length1 = data_length1;
											_tmp97_ = out_o;
											_tmp98_ = pixels;
											_tmp98__length1 = pixels_length1;
											_tmp99_ = in_o;
											_tmp100_ = _tmp98_[_tmp99_];
											_tmp96_[_tmp97_] = _tmp100_;
											_tmp101_ = _tmp96_[_tmp97_];
											_tmp102_ = data;
											_tmp102__length1 = data_length1;
											_tmp103_ = out_o;
											_tmp104_ = pixels;
											_tmp104__length1 = pixels_length1;
											_tmp105_ = in_o;
											_tmp106_ = _tmp104_[_tmp105_ + 1];
											_tmp102_[_tmp103_ + 1] = _tmp106_;
											_tmp107_ = _tmp102_[_tmp103_ + 1];
											_tmp108_ = data;
											_tmp108__length1 = data_length1;
											_tmp109_ = out_o;
											_tmp110_ = pixels;
											_tmp110__length1 = pixels_length1;
											_tmp111_ = in_o;
											_tmp112_ = _tmp110_[_tmp111_ + 2];
											_tmp108_[_tmp109_ + 2] = _tmp112_;
											_tmp113_ = _tmp108_[_tmp109_ + 2];
										}
									}
								}
							}
						}
					}
				} else {
					Page* _tmp114_;
					gint _tmp115_ = 0;
					_tmp114_ = page;
					_tmp115_ = page_get_depth (_tmp114_);
					if (_tmp115_ == 2) {
						gint shift_count;
						gchar* _tmp116_;
						gint _tmp117_;
						gint _tmp118_;
						gint data_length;
						gint _tmp119_;
						guint8* _tmp120_ = NULL;
						gint offset;
						guint8* _tmp121_;
						gint _tmp121__length1;
						gint _tmp122_;
						guint8 _tmp123_;
						shift_count = 6;
						depth = 2;
						_tmp116_ = g_strdup ("DeviceGray");
						_g_free0 (color_space);
						color_space = _tmp116_;
						_tmp117_ = height;
						_tmp118_ = width;
						data_length = _tmp117_ * (((_tmp118_ * 2) + 7) / 8);
						_tmp119_ = data_length;
						_tmp120_ = g_new0 (guint8, _tmp119_);
						data = (g_free (data), NULL);
						data = _tmp120_;
						data_length1 = _tmp119_;
						_data_size_ = data_length1;
						offset = 0;
						_tmp121_ = data;
						_tmp121__length1 = data_length1;
						_tmp122_ = offset;
						_tmp121_[_tmp122_] = (guint8) 0;
						_tmp123_ = _tmp121_[_tmp122_];
						{
							gint row;
							row = 0;
							{
								gboolean _tmp124_;
								_tmp124_ = TRUE;
								while (TRUE) {
									gboolean _tmp125_;
									gint _tmp127_;
									gint _tmp128_;
									gint _tmp129_;
									gint _tmp134_;
									GdkPixbuf* _tmp135_;
									gint _tmp136_ = 0;
									gint in_offset;
									_tmp125_ = _tmp124_;
									if (!_tmp125_) {
										gint _tmp126_;
										_tmp126_ = row;
										row = _tmp126_ + 1;
									}
									_tmp124_ = FALSE;
									_tmp127_ = row;
									_tmp128_ = height;
									if (!(_tmp127_ < _tmp128_)) {
										break;
									}
									_tmp129_ = shift_count;
									if (_tmp129_ != 6) {
										gint _tmp130_;
										guint8* _tmp131_;
										gint _tmp131__length1;
										gint _tmp132_;
										guint8 _tmp133_;
										_tmp130_ = offset;
										offset = _tmp130_ + 1;
										_tmp131_ = data;
										_tmp131__length1 = data_length1;
										_tmp132_ = offset;
										_tmp131_[_tmp132_] = (guint8) 0;
										_tmp133_ = _tmp131_[_tmp132_];
										shift_count = 6;
									}
									_tmp134_ = row;
									_tmp135_ = image;
									_tmp136_ = gdk_pixbuf_get_rowstride (_tmp135_);
									in_offset = _tmp134_ * _tmp136_;
									{
										gint x;
										x = 0;
										{
											gboolean _tmp137_;
											_tmp137_ = TRUE;
											while (TRUE) {
												gboolean _tmp138_;
												gint _tmp140_;
												gint _tmp141_;
												guint8* _tmp142_;
												gint _tmp142__length1;
												gint _tmp143_;
												gint _tmp144_;
												guint8 _tmp145_;
												guint8 p;
												guint8 _tmp146_;
												gint _tmp161_;
												_tmp138_ = _tmp137_;
												if (!_tmp138_) {
													gint _tmp139_;
													_tmp139_ = x;
													x = _tmp139_ + 1;
												}
												_tmp137_ = FALSE;
												_tmp140_ = x;
												_tmp141_ = width;
												if (!(_tmp140_ < _tmp141_)) {
													break;
												}
												_tmp142_ = pixels;
												_tmp142__length1 = pixels_length1;
												_tmp143_ = in_offset;
												_tmp144_ = x;
												_tmp145_ = _tmp142_[_tmp143_ + (_tmp144_ * 3)];
												p = _tmp145_;
												_tmp146_ = p;
												if (((gint) _tmp146_) >= 192) {
													guint8* _tmp147_;
													gint _tmp147__length1;
													gint _tmp148_;
													gint _tmp149_;
													guint8 _tmp150_;
													_tmp147_ = data;
													_tmp147__length1 = data_length1;
													_tmp148_ = offset;
													_tmp149_ = shift_count;
													_tmp147_[_tmp148_] |= (guint8) (3 << _tmp149_);
													_tmp150_ = _tmp147_[_tmp148_];
												} else {
													guint8 _tmp151_;
													_tmp151_ = p;
													if (((gint) _tmp151_) >= 128) {
														guint8* _tmp152_;
														gint _tmp152__length1;
														gint _tmp153_;
														gint _tmp154_;
														guint8 _tmp155_;
														_tmp152_ = data;
														_tmp152__length1 = data_length1;
														_tmp153_ = offset;
														_tmp154_ = shift_count;
														_tmp152_[_tmp153_] |= (guint8) (2 << _tmp154_);
														_tmp155_ = _tmp152_[_tmp153_];
													} else {
														guint8 _tmp156_;
														_tmp156_ = p;
														if (((gint) _tmp156_) >= 64) {
															guint8* _tmp157_;
															gint _tmp157__length1;
															gint _tmp158_;
															gint _tmp159_;
															guint8 _tmp160_;
															_tmp157_ = data;
															_tmp157__length1 = data_length1;
															_tmp158_ = offset;
															_tmp159_ = shift_count;
															_tmp157_[_tmp158_] |= (guint8) (1 << _tmp159_);
															_tmp160_ = _tmp157_[_tmp158_];
														}
													}
												}
												_tmp161_ = shift_count;
												if (_tmp161_ == 0) {
													gint _tmp162_;
													guint8* _tmp163_;
													gint _tmp163__length1;
													gint _tmp164_;
													guint8 _tmp165_;
													_tmp162_ = offset;
													offset = _tmp162_ + 1;
													_tmp163_ = data;
													_tmp163__length1 = data_length1;
													_tmp164_ = offset;
													_tmp163_[_tmp164_] = (guint8) 0;
													_tmp165_ = _tmp163_[_tmp164_];
													shift_count = 6;
												} else {
													gint _tmp166_;
													_tmp166_ = shift_count;
													shift_count = _tmp166_ - 2;
												}
											}
										}
									}
								}
							}
						}
					} else {
						Page* _tmp167_;
						gint _tmp168_ = 0;
						_tmp167_ = page;
						_tmp168_ = page_get_depth (_tmp167_);
						if (_tmp168_ == 1) {
							gint mask;
							gchar* _tmp169_;
							gint _tmp170_;
							gint _tmp171_;
							gint data_length;
							gint _tmp172_;
							guint8* _tmp173_ = NULL;
							gint offset;
							guint8* _tmp174_;
							gint _tmp174__length1;
							gint _tmp175_;
							guint8 _tmp176_;
							mask = 0x80;
							depth = 1;
							_tmp169_ = g_strdup ("DeviceGray");
							_g_free0 (color_space);
							color_space = _tmp169_;
							_tmp170_ = height;
							_tmp171_ = width;
							data_length = _tmp170_ * ((_tmp171_ + 7) / 8);
							_tmp172_ = data_length;
							_tmp173_ = g_new0 (guint8, _tmp172_);
							data = (g_free (data), NULL);
							data = _tmp173_;
							data_length1 = _tmp172_;
							_data_size_ = data_length1;
							offset = 0;
							_tmp174_ = data;
							_tmp174__length1 = data_length1;
							_tmp175_ = offset;
							_tmp174_[_tmp175_] = (guint8) 0;
							_tmp176_ = _tmp174_[_tmp175_];
							{
								gint row;
								row = 0;
								{
									gboolean _tmp177_;
									_tmp177_ = TRUE;
									while (TRUE) {
										gboolean _tmp178_;
										gint _tmp180_;
										gint _tmp181_;
										gint _tmp182_;
										gint _tmp187_;
										GdkPixbuf* _tmp188_;
										gint _tmp189_ = 0;
										gint in_offset;
										_tmp178_ = _tmp177_;
										if (!_tmp178_) {
											gint _tmp179_;
											_tmp179_ = row;
											row = _tmp179_ + 1;
										}
										_tmp177_ = FALSE;
										_tmp180_ = row;
										_tmp181_ = height;
										if (!(_tmp180_ < _tmp181_)) {
											break;
										}
										_tmp182_ = mask;
										if (_tmp182_ != 0x80) {
											gint _tmp183_;
											guint8* _tmp184_;
											gint _tmp184__length1;
											gint _tmp185_;
											guint8 _tmp186_;
											_tmp183_ = offset;
											offset = _tmp183_ + 1;
											_tmp184_ = data;
											_tmp184__length1 = data_length1;
											_tmp185_ = offset;
											_tmp184_[_tmp185_] = (guint8) 0;
											_tmp186_ = _tmp184_[_tmp185_];
											mask = 0x80;
										}
										_tmp187_ = row;
										_tmp188_ = image;
										_tmp189_ = gdk_pixbuf_get_rowstride (_tmp188_);
										in_offset = _tmp187_ * _tmp189_;
										{
											gint x;
											x = 0;
											{
												gboolean _tmp190_;
												_tmp190_ = TRUE;
												while (TRUE) {
													gboolean _tmp191_;
													gint _tmp193_;
													gint _tmp194_;
													guint8* _tmp195_;
													gint _tmp195__length1;
													gint _tmp196_;
													gint _tmp197_;
													guint8 _tmp198_;
													gint _tmp203_;
													gint _tmp204_;
													_tmp191_ = _tmp190_;
													if (!_tmp191_) {
														gint _tmp192_;
														_tmp192_ = x;
														x = _tmp192_ + 1;
													}
													_tmp190_ = FALSE;
													_tmp193_ = x;
													_tmp194_ = width;
													if (!(_tmp193_ < _tmp194_)) {
														break;
													}
													_tmp195_ = pixels;
													_tmp195__length1 = pixels_length1;
													_tmp196_ = in_offset;
													_tmp197_ = x;
													_tmp198_ = _tmp195_[_tmp196_ + (_tmp197_ * 3)];
													if (((gint) _tmp198_) != 0) {
														guint8* _tmp199_;
														gint _tmp199__length1;
														gint _tmp200_;
														gint _tmp201_;
														guint8 _tmp202_;
														_tmp199_ = data;
														_tmp199__length1 = data_length1;
														_tmp200_ = offset;
														_tmp201_ = mask;
														_tmp199_[_tmp200_] |= (guint8) _tmp201_;
														_tmp202_ = _tmp199_[_tmp200_];
													}
													_tmp203_ = mask;
													mask = _tmp203_ >> 1;
													_tmp204_ = mask;
													if (_tmp204_ == 0) {
														gint _tmp205_;
														guint8* _tmp206_;
														gint _tmp206__length1;
														gint _tmp207_;
														guint8 _tmp208_;
														_tmp205_ = offset;
														offset = _tmp205_ + 1;
														_tmp206_ = data;
														_tmp206__length1 = data_length1;
														_tmp207_ = offset;
														_tmp206_[_tmp207_] = (guint8) 0;
														_tmp208_ = _tmp206_[_tmp207_];
														mask = 0x80;
													}
												}
											}
										}
									}
								}
							}
						} else {
							gchar* _tmp209_;
							gint _tmp210_;
							gint _tmp211_;
							gint data_length;
							gint _tmp212_;
							guint8* _tmp213_ = NULL;
							depth = 8;
							_tmp209_ = g_strdup ("DeviceGray");
							_g_free0 (color_space);
							color_space = _tmp209_;
							_tmp210_ = height;
							_tmp211_ = width;
							data_length = (_tmp210_ * _tmp211_) + 1;
							_tmp212_ = data_length;
							_tmp213_ = g_new0 (guint8, _tmp212_);
							data = (g_free (data), NULL);
							data = _tmp213_;
							data_length1 = _tmp212_;
							_data_size_ = data_length1;
							{
								gint row;
								row = 0;
								{
									gboolean _tmp214_;
									_tmp214_ = TRUE;
									while (TRUE) {
										gboolean _tmp215_;
										gint _tmp217_;
										gint _tmp218_;
										gint _tmp219_;
										GdkPixbuf* _tmp220_;
										gint _tmp221_ = 0;
										gint in_offset;
										gint _tmp222_;
										gint _tmp223_;
										gint out_offset;
										_tmp215_ = _tmp214_;
										if (!_tmp215_) {
											gint _tmp216_;
											_tmp216_ = row;
											row = _tmp216_ + 1;
										}
										_tmp214_ = FALSE;
										_tmp217_ = row;
										_tmp218_ = height;
										if (!(_tmp217_ < _tmp218_)) {
											break;
										}
										_tmp219_ = row;
										_tmp220_ = image;
										_tmp221_ = gdk_pixbuf_get_rowstride (_tmp220_);
										in_offset = _tmp219_ * _tmp221_;
										_tmp222_ = row;
										_tmp223_ = width;
										out_offset = _tmp222_ * _tmp223_;
										{
											gint x;
											x = 0;
											{
												gboolean _tmp224_;
												_tmp224_ = TRUE;
												while (TRUE) {
													gboolean _tmp225_;
													gint _tmp227_;
													gint _tmp228_;
													guint8* _tmp229_;
													gint _tmp229__length1;
													gint _tmp230_;
													gint _tmp231_;
													guint8* _tmp232_;
													gint _tmp232__length1;
													gint _tmp233_;
													gint _tmp234_;
													guint8 _tmp235_;
													guint8 _tmp236_;
													_tmp225_ = _tmp224_;
													if (!_tmp225_) {
														gint _tmp226_;
														_tmp226_ = x;
														x = _tmp226_ + 1;
													}
													_tmp224_ = FALSE;
													_tmp227_ = x;
													_tmp228_ = width;
													if (!(_tmp227_ < _tmp228_)) {
														break;
													}
													_tmp229_ = data;
													_tmp229__length1 = data_length1;
													_tmp230_ = out_offset;
													_tmp231_ = x;
													_tmp232_ = pixels;
													_tmp232__length1 = pixels_length1;
													_tmp233_ = in_offset;
													_tmp234_ = x;
													_tmp235_ = _tmp232_[_tmp233_ + (_tmp234_ * 3)];
													_tmp229_[_tmp230_ + _tmp231_] = _tmp235_;
													_tmp236_ = _tmp229_[_tmp230_ + _tmp231_];
												}
											}
										}
									}
								}
							}
						}
					}
				}
				_tmp237_ = data;
				_tmp237__length1 = data_length1;
				_tmp239_ = book_compress_zlib (self, _tmp237_, _tmp237__length1, &_tmp238_);
				compressed_data = _tmp239_;
				compressed_data_length1 = _tmp238_;
				_compressed_data_size_ = compressed_data_length1;
				_tmp240_ = compressed_data;
				_tmp240__length1 = compressed_data_length1;
				if (_tmp240_ != NULL) {
					gint _tmp241_;
					const gchar* _tmp251_;
					_tmp241_ = depth;
					if (_tmp241_ > 1) {
						gsize jpeg_length = 0UL;
						GdkPixbuf* _tmp242_;
						gsize _tmp243_ = 0UL;
						gint _tmp244_ = 0;
						guint8* _tmp245_ = NULL;
						guint8* jpeg_data;
						gint jpeg_data_length1;
						gint _jpeg_data_size_;
						gsize _tmp246_;
						guint8* _tmp247_;
						gint _tmp247__length1;
						_tmp242_ = image;
						_tmp245_ = book_compress_jpeg (self, _tmp242_, &_tmp243_, &_tmp244_);
						jpeg_length = _tmp243_;
						jpeg_data = _tmp245_;
						jpeg_data_length1 = _tmp244_;
						_jpeg_data_size_ = jpeg_data_length1;
						_tmp246_ = jpeg_length;
						_tmp247_ = compressed_data;
						_tmp247__length1 = compressed_data_length1;
						if (_tmp246_ < ((gsize) _tmp247__length1)) {
							gchar* _tmp248_;
							guint8* _tmp249_;
							gint _tmp249__length1;
							guint8* _tmp250_;
							gint _tmp250__length1;
							_tmp248_ = g_strdup ("DCTDecode");
							_g_free0 (filter);
							filter = _tmp248_;
							_tmp249_ = jpeg_data;
							_tmp249__length1 = jpeg_data_length1;
							_tmp250_ = (_tmp249_ != NULL) ? _vala_array_dup1 (_tmp249_, _tmp249__length1) : ((gpointer) _tmp249_);
							_tmp250__length1 = _tmp249__length1;
							data = (g_free (data), NULL);
							data = _tmp250_;
							data_length1 = _tmp250__length1;
							_data_size_ = data_length1;
						}
						jpeg_data = (g_free (jpeg_data), NULL);
					}
					_tmp251_ = filter;
					if (_tmp251_ == NULL) {
						gchar* _tmp252_;
						guint8* _tmp253_;
						gint _tmp253__length1;
						guint8* _tmp254_;
						gint _tmp254__length1;
						_tmp252_ = g_strdup ("FlateDecode");
						_g_free0 (filter);
						filter = _tmp252_;
						_tmp253_ = compressed_data;
						_tmp253__length1 = compressed_data_length1;
						_tmp254_ = (_tmp253_ != NULL) ? _vala_array_dup2 (_tmp253_, _tmp253__length1) : ((gpointer) _tmp253_);
						_tmp254__length1 = _tmp253__length1;
						data = (g_free (data), NULL);
						data = _tmp254_;
						data_length1 = _tmp254__length1;
						_data_size_ = data_length1;
					}
				}
				_tmp255_ = writer;
				pdf_writer_write_string (_tmp255_, "\n");
				_tmp256_ = writer;
				_tmp257_ = pdf_writer_start_object (_tmp256_);
				number = _tmp257_;
				_tmp258_ = writer;
				_tmp259_ = number;
				_tmp260_ = g_strdup_printf ("%u 0 obj\n", _tmp259_);
				_tmp261_ = _tmp260_;
				pdf_writer_write_string (_tmp258_, _tmp261_);
				_g_free0 (_tmp261_);
				_tmp262_ = writer;
				pdf_writer_write_string (_tmp262_, "<<\n");
				_tmp263_ = writer;
				pdf_writer_write_string (_tmp263_, "/Type /Page\n");
				_tmp264_ = writer;
				_tmp265_ = pages_number;
				_tmp266_ = g_strdup_printf ("/Parent %u 0 R\n", _tmp265_);
				_tmp267_ = _tmp266_;
				pdf_writer_write_string (_tmp264_, _tmp267_);
				_g_free0 (_tmp267_);
				_tmp268_ = writer;
				_tmp269_ = i;
				_tmp270_ = number;
				_tmp271_ = g_strdup_printf ("/Resources << /XObject << /Im%d %u 0 R >> >>\n", _tmp269_, _tmp270_ + 1);
				_tmp272_ = _tmp271_;
				pdf_writer_write_string (_tmp268_, _tmp272_);
				_g_free0 (_tmp272_);
				_tmp273_ = writer;
				_tmp274_ = page_width;
				_tmp275_ = width_buffer;
				_tmp275__length1 = width_buffer_length1;
				_tmp276_ = g_ascii_formatd (_tmp275_, _tmp275__length1, "%.2f", _tmp274_);
				_tmp277_ = page_height;
				_tmp278_ = height_buffer;
				_tmp278__length1 = height_buffer_length1;
				_tmp279_ = g_ascii_formatd (_tmp278_, _tmp278__length1, "%.2f", _tmp277_);
				_tmp280_ = g_strdup_printf ("/MediaBox [ 0 0 %s %s ]\n", _tmp276_, _tmp279_);
				_tmp281_ = _tmp280_;
				pdf_writer_write_string (_tmp273_, _tmp281_);
				_g_free0 (_tmp281_);
				_tmp282_ = writer;
				_tmp283_ = number;
				_tmp284_ = g_strdup_printf ("/Contents %u 0 R\n", _tmp283_ + 2);
				_tmp285_ = _tmp284_;
				pdf_writer_write_string (_tmp282_, _tmp285_);
				_g_free0 (_tmp285_);
				_tmp286_ = writer;
				pdf_writer_write_string (_tmp286_, ">>\n");
				_tmp287_ = writer;
				pdf_writer_write_string (_tmp287_, "endobj\n");
				_tmp288_ = writer;
				pdf_writer_write_string (_tmp288_, "\n");
				_tmp289_ = writer;
				_tmp290_ = pdf_writer_start_object (_tmp289_);
				number = _tmp290_;
				_tmp291_ = writer;
				_tmp292_ = number;
				_tmp293_ = g_strdup_printf ("%u 0 obj\n", _tmp292_);
				_tmp294_ = _tmp293_;
				pdf_writer_write_string (_tmp291_, _tmp294_);
				_g_free0 (_tmp294_);
				_tmp295_ = writer;
				pdf_writer_write_string (_tmp295_, "<<\n");
				_tmp296_ = writer;
				pdf_writer_write_string (_tmp296_, "/Type /XObject\n");
				_tmp297_ = writer;
				pdf_writer_write_string (_tmp297_, "/Subtype /Image\n");
				_tmp298_ = writer;
				_tmp299_ = width;
				_tmp300_ = g_strdup_printf ("/Width %d\n", _tmp299_);
				_tmp301_ = _tmp300_;
				pdf_writer_write_string (_tmp298_, _tmp301_);
				_g_free0 (_tmp301_);
				_tmp302_ = writer;
				_tmp303_ = height;
				_tmp304_ = g_strdup_printf ("/Height %d\n", _tmp303_);
				_tmp305_ = _tmp304_;
				pdf_writer_write_string (_tmp302_, _tmp305_);
				_g_free0 (_tmp305_);
				_tmp306_ = writer;
				_tmp307_ = color_space;
				_tmp308_ = g_strdup_printf ("/ColorSpace /%s\n", _tmp307_);
				_tmp309_ = _tmp308_;
				pdf_writer_write_string (_tmp306_, _tmp309_);
				_g_free0 (_tmp309_);
				_tmp310_ = writer;
				_tmp311_ = depth;
				_tmp312_ = g_strdup_printf ("/BitsPerComponent %d\n", _tmp311_);
				_tmp313_ = _tmp312_;
				pdf_writer_write_string (_tmp310_, _tmp313_);
				_g_free0 (_tmp313_);
				_tmp314_ = writer;
				_tmp315_ = data;
				_tmp315__length1 = data_length1;
				_tmp316_ = g_strdup_printf ("/Length %d\n", _tmp315__length1);
				_tmp317_ = _tmp316_;
				pdf_writer_write_string (_tmp314_, _tmp317_);
				_g_free0 (_tmp317_);
				_tmp318_ = filter;
				if (_tmp318_ != NULL) {
					PDFWriter* _tmp319_;
					const gchar* _tmp320_;
					gchar* _tmp321_ = NULL;
					gchar* _tmp322_;
					_tmp319_ = writer;
					_tmp320_ = filter;
					_tmp321_ = g_strdup_printf ("/Filter /%s\n", _tmp320_);
					_tmp322_ = _tmp321_;
					pdf_writer_write_string (_tmp319_, _tmp322_);
					_g_free0 (_tmp322_);
				}
				_tmp323_ = writer;
				pdf_writer_write_string (_tmp323_, ">>\n");
				_tmp324_ = writer;
				pdf_writer_write_string (_tmp324_, "stream\n");
				_tmp325_ = writer;
				_tmp326_ = data;
				_tmp326__length1 = data_length1;
				pdf_writer_write (_tmp325_, _tmp326_, _tmp326__length1);
				_tmp327_ = writer;
				pdf_writer_write_string (_tmp327_, "\n");
				_tmp328_ = writer;
				pdf_writer_write_string (_tmp328_, "endstream\n");
				_tmp329_ = writer;
				pdf_writer_write_string (_tmp329_, "endobj\n");
				_tmp330_ = page_width;
				_tmp331_ = width_buffer;
				_tmp331__length1 = width_buffer_length1;
				_tmp332_ = g_ascii_formatd (_tmp331_, _tmp331__length1, "%f", _tmp330_);
				_tmp333_ = page_height;
				_tmp334_ = height_buffer;
				_tmp334__length1 = height_buffer_length1;
				_tmp335_ = g_ascii_formatd (_tmp334_, _tmp334__length1, "%f", _tmp333_);
				_tmp336_ = i;
				_tmp337_ = g_strdup_printf ("q\n%s 0 0 %s 0 0 cm\n/Im%d Do\nQ", _tmp332_, _tmp335_, _tmp336_);
				command = _tmp337_;
				_tmp338_ = writer;
				pdf_writer_write_string (_tmp338_, "\n");
				_tmp339_ = writer;
				_tmp340_ = pdf_writer_start_object (_tmp339_);
				number = _tmp340_;
				_tmp341_ = writer;
				_tmp342_ = number;
				_tmp343_ = g_strdup_printf ("%u 0 obj\n", _tmp342_);
				_tmp344_ = _tmp343_;
				pdf_writer_write_string (_tmp341_, _tmp344_);
				_g_free0 (_tmp344_);
				_tmp345_ = writer;
				pdf_writer_write_string (_tmp345_, "<<\n");
				_tmp346_ = writer;
				_tmp347_ = command;
				_tmp348_ = strlen (_tmp347_);
				_tmp349_ = _tmp348_;
				_tmp350_ = g_strdup_printf ("/Length %d\n", _tmp349_ + 1);
				_tmp351_ = _tmp350_;
				pdf_writer_write_string (_tmp346_, _tmp351_);
				_g_free0 (_tmp351_);
				_tmp352_ = writer;
				pdf_writer_write_string (_tmp352_, ">>\n");
				_tmp353_ = writer;
				pdf_writer_write_string (_tmp353_, "stream\n");
				_tmp354_ = writer;
				_tmp355_ = command;
				pdf_writer_write_string (_tmp354_, _tmp355_);
				_tmp356_ = writer;
				pdf_writer_write_string (_tmp356_, "\n");
				_tmp357_ = writer;
				pdf_writer_write_string (_tmp357_, "endstream\n");
				_tmp358_ = writer;
				pdf_writer_write_string (_tmp358_, "endobj\n");
				_g_free0 (command);
				compressed_data = (g_free (compressed_data), NULL);
				data = (g_free (data), NULL);
				height_buffer = (g_free (height_buffer), NULL);
				width_buffer = (g_free (width_buffer), NULL);
				_g_free0 (filter);
				_g_free0 (color_space);
				_g_object_unref0 (image);
				_page_unref0 (page);
			}
		}
	}
	_tmp359_ = writer;
	pdf_writer_write_string (_tmp359_, "\n");
	_tmp360_ = writer;
	_tmp361_ = pdf_writer_start_object (_tmp360_);
	info_number = _tmp361_;
	_tmp362_ = writer;
	_tmp363_ = info_number;
	_tmp364_ = g_strdup_printf ("%u 0 obj\n", _tmp363_);
	_tmp365_ = _tmp364_;
	pdf_writer_write_string (_tmp362_, _tmp365_);
	_g_free0 (_tmp365_);
	_tmp366_ = writer;
	pdf_writer_write_string (_tmp366_, "<<\n");
	_tmp367_ = writer;
	_tmp368_ = g_strdup_printf ("/Creator (Simple Scan %s)\n", VERSION);
	_tmp369_ = _tmp368_;
	pdf_writer_write_string (_tmp367_, _tmp369_);
	_g_free0 (_tmp369_);
	_tmp370_ = writer;
	pdf_writer_write_string (_tmp370_, ">>\n");
	_tmp371_ = writer;
	pdf_writer_write_string (_tmp371_, "endobj\n");
	_tmp372_ = writer;
	_tmp373_ = _tmp372_->offset;
	xref_offset = _tmp373_;
	_tmp374_ = writer;
	pdf_writer_write_string (_tmp374_, "xref\n");
	_tmp375_ = writer;
	_tmp376_ = writer;
	_tmp377_ = _tmp376_->object_offsets;
	_tmp378_ = g_list_length (_tmp377_);
	_tmp379_ = g_strdup_printf ("1 %zu\n", (gsize) _tmp378_);
	_tmp380_ = _tmp379_;
	pdf_writer_write_string (_tmp375_, _tmp380_);
	_g_free0 (_tmp380_);
	_tmp381_ = writer;
	_tmp382_ = _tmp381_->object_offsets;
	{
		GList* offset_collection = NULL;
		GList* offset_it = NULL;
		offset_collection = _tmp382_;
		for (offset_it = offset_collection; offset_it != NULL; offset_it = offset_it->next) {
			guint offset = 0U;
			offset = GPOINTER_TO_UINT (offset_it->data);
			{
				PDFWriter* _tmp383_;
				guint _tmp384_;
				gchar* _tmp385_ = NULL;
				gchar* _tmp386_;
				_tmp383_ = writer;
				_tmp384_ = offset;
				_tmp385_ = g_strdup_printf ("%010zu 00000 n \n", (gsize) _tmp384_);
				_tmp386_ = _tmp385_;
				pdf_writer_write_string (_tmp383_, _tmp386_);
				_g_free0 (_tmp386_);
			}
		}
	}
	_tmp387_ = writer;
	pdf_writer_write_string (_tmp387_, "trailer\n");
	_tmp388_ = writer;
	pdf_writer_write_string (_tmp388_, "<<\n");
	_tmp389_ = writer;
	_tmp390_ = writer;
	_tmp391_ = _tmp390_->object_offsets;
	_tmp392_ = g_list_length (_tmp391_);
	_tmp393_ = g_strdup_printf ("/Size %zu\n", (gsize) _tmp392_);
	_tmp394_ = _tmp393_;
	pdf_writer_write_string (_tmp389_, _tmp394_);
	_g_free0 (_tmp394_);
	_tmp395_ = writer;
	_tmp396_ = info_number;
	_tmp397_ = g_strdup_printf ("/Info %u 0 R\n", _tmp396_);
	_tmp398_ = _tmp397_;
	pdf_writer_write_string (_tmp395_, _tmp398_);
	_g_free0 (_tmp398_);
	_tmp399_ = writer;
	_tmp400_ = catalog_number;
	_tmp401_ = g_strdup_printf ("/Root %u 0 R\n", _tmp400_);
	_tmp402_ = _tmp401_;
	pdf_writer_write_string (_tmp399_, _tmp402_);
	_g_free0 (_tmp402_);
	_tmp403_ = writer;
	pdf_writer_write_string (_tmp403_, ">>\n");
	_tmp404_ = writer;
	pdf_writer_write_string (_tmp404_, "startxref\n");
	_tmp405_ = writer;
	_tmp406_ = xref_offset;
	_tmp407_ = g_strdup_printf ("%zu\n", _tmp406_);
	_tmp408_ = _tmp407_;
	pdf_writer_write_string (_tmp405_, _tmp408_);
	_g_free0 (_tmp408_);
	_tmp409_ = writer;
	pdf_writer_write_string (_tmp409_, "%%EOF\n");
	_pdf_writer_unref0 (writer);
	_g_object_unref0 (stream);
}


void book_save (Book* self, const gchar* type, GFile* file, GError** error) {
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_strcmp0;
	_tmp1_ = type;
	_tmp2_ = _tmp0_ (_tmp1_, "jpeg");
	if (_tmp2_ == 0) {
		GFile* _tmp3_;
		_tmp3_ = file;
		book_save_multi_file (self, "jpeg", _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	} else {
		GCompareFunc _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_ = 0;
		_tmp4_ = g_strcmp0;
		_tmp5_ = type;
		_tmp6_ = _tmp4_ (_tmp5_, "png");
		if (_tmp6_ == 0) {
			GFile* _tmp7_;
			_tmp7_ = file;
			book_save_multi_file (self, "png", _tmp7_, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				return;
			}
		} else {
			GCompareFunc _tmp8_;
			const gchar* _tmp9_;
			gint _tmp10_ = 0;
			_tmp8_ = g_strcmp0;
			_tmp9_ = type;
			_tmp10_ = _tmp8_ (_tmp9_, "tiff");
			if (_tmp10_ == 0) {
				GFile* _tmp11_;
				_tmp11_ = file;
				book_save_multi_file (self, "tiff", _tmp11_, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return;
				}
			} else {
				GCompareFunc _tmp12_;
				const gchar* _tmp13_;
				gint _tmp14_ = 0;
				_tmp12_ = g_strcmp0;
				_tmp13_ = type;
				_tmp14_ = _tmp12_ (_tmp13_, "ps");
				if (_tmp14_ == 0) {
					GFile* _tmp15_;
					_tmp15_ = file;
					book_save_ps (self, _tmp15_, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						return;
					}
				} else {
					GCompareFunc _tmp16_;
					const gchar* _tmp17_;
					gint _tmp18_ = 0;
					_tmp16_ = g_strcmp0;
					_tmp17_ = type;
					_tmp18_ = _tmp16_ (_tmp17_, "pdf");
					if (_tmp18_ == 0) {
						GFile* _tmp19_;
						_tmp19_ = file;
						book_save_pdf (self, _tmp19_, &_inner_error_);
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							return;
						}
					}
				}
			}
		}
	}
}


void book_set_needs_saving (Book* self, gboolean needs_saving) {
	gboolean _tmp0_;
	gboolean needed_saving;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->needs_saving;
	needed_saving = _tmp0_;
	_tmp1_ = needs_saving;
	self->priv->needs_saving = _tmp1_;
	_tmp2_ = needed_saving;
	_tmp3_ = needs_saving;
	if (_tmp2_ != _tmp3_) {
		g_signal_emit_by_name (self, "needs-saving-changed");
	}
}


gboolean book_get_needs_saving (Book* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->needs_saving;
	result = _tmp0_;
	return result;
}


static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__PAGE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__PAGE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__PAGE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_page (param_values + 1), data2);
}


static void value_book_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_book_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		book_unref (value->data[0].v_pointer);
	}
}


static void value_book_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = book_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_book_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_book_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Book* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = book_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_book_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Book** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = book_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBook* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BOOK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_book (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK), NULL);
	return value->data[0].v_pointer;
}


void value_set_book (GValue* value, gpointer v_object) {
	Book* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		book_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		book_unref (old);
	}
}


void value_take_book (GValue* value, gpointer v_object) {
	Book* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		book_unref (old);
	}
}


static void book_class_init (BookClass * klass) {
	book_parent_class = g_type_class_peek_parent (klass);
	BOOK_CLASS (klass)->finalize = book_finalize;
	g_type_class_add_private (klass, sizeof (BookPrivate));
	g_signal_new ("page_added", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
	g_signal_new ("page_removed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
	g_signal_new ("reordered", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("cleared", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("needs_saving_changed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void book_instance_init (Book * self) {
	self->priv = BOOK_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void book_finalize (Book* obj) {
	Book * self;
	self = BOOK (obj);
	__g_list_free__page_unref0_0 (self->priv->pages);
}


GType book_get_type (void) {
	static volatile gsize book_type_id__volatile = 0;
	if (g_once_init_enter (&book_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_book_init, value_book_free_value, value_book_copy_value, value_book_peek_pointer, "p", value_book_collect_value, "p", value_book_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) book_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Book), 0, (GInstanceInitFunc) book_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType book_type_id;
		book_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Book", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&book_type_id__volatile, book_type_id);
	}
	return book_type_id__volatile;
}


gpointer book_ref (gpointer instance) {
	Book* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void book_unref (gpointer instance) {
	Book* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BOOK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream) {
	PDFWriter* self = NULL;
	GFileOutputStream* _tmp0_;
	GFileOutputStream* _tmp1_;
	g_return_val_if_fail (stream != NULL, NULL);
	self = (PDFWriter*) g_type_create_instance (object_type);
	_tmp0_ = stream;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->stream);
	self->priv->stream = _tmp1_;
	return self;
}


PDFWriter* pdf_writer_new (GFileOutputStream* stream) {
	return pdf_writer_construct (TYPE_PDF_WRITER, stream);
}


void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1) {
	gsize _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFileOutputStream* _tmp0_;
		guint8* _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = self->priv->stream;
		_tmp1_ = data;
		_tmp1__length1 = data_length1;
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("book.vala:529: Error writing PDF: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = self->offset;
	_tmp5_ = data;
	_tmp5__length1 = data_length1;
	self->offset = _tmp4_ + _tmp5__length1;
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
	_result_ = _tmp2_;
	_result__length1 = _tmp1_ + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	_tmp5_ = strlen (self);
	_tmp6_ = _tmp5_;
	memcpy (_tmp4_, self, (gsize) _tmp6_);
	_tmp7_ = _result_;
	_tmp7__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


void pdf_writer_write_string (PDFWriter* self, const gchar* text) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	guint8* _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
	_tmp3_ = (guint8*) _tmp2_;
	_tmp3__length1 = _tmp1_;
	pdf_writer_write (self, _tmp3_, _tmp1_);
	_tmp3_ = (g_free (_tmp3_), NULL);
}


guint pdf_writer_start_object (PDFWriter* self) {
	guint result = 0U;
	gsize _tmp0_;
	GList* _tmp1_;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->offset;
	self->object_offsets = g_list_append (self->object_offsets, GUINT_TO_POINTER ((guint) _tmp0_));
	_tmp1_ = self->object_offsets;
	_tmp2_ = g_list_length (_tmp1_);
	result = _tmp2_;
	return result;
}


static void value_pdf_writer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_pdf_writer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		pdf_writer_unref (value->data[0].v_pointer);
	}
}


static void value_pdf_writer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pdf_writer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_pdf_writer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_pdf_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PDFWriter* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pdf_writer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_pdf_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PDFWriter** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pdf_writer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPDFWriter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PDF_WRITER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_pdf_writer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER), NULL);
	return value->data[0].v_pointer;
}


void value_set_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pdf_writer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pdf_writer_unref (old);
	}
}


void value_take_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pdf_writer_unref (old);
	}
}


static void pdf_writer_class_init (PDFWriterClass * klass) {
	pdf_writer_parent_class = g_type_class_peek_parent (klass);
	PDF_WRITER_CLASS (klass)->finalize = pdf_writer_finalize;
	g_type_class_add_private (klass, sizeof (PDFWriterPrivate));
}


static void pdf_writer_instance_init (PDFWriter * self) {
	self->priv = PDF_WRITER_GET_PRIVATE (self);
	self->offset = (gsize) 0;
	self->ref_count = 1;
}


static void pdf_writer_finalize (PDFWriter* obj) {
	PDFWriter * self;
	self = PDF_WRITER (obj);
	_g_list_free0 (self->object_offsets);
	_g_object_unref0 (self->priv->stream);
}


GType pdf_writer_get_type (void) {
	static volatile gsize pdf_writer_type_id__volatile = 0;
	if (g_once_init_enter (&pdf_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pdf_writer_init, value_pdf_writer_free_value, value_pdf_writer_copy_value, value_pdf_writer_peek_pointer, "p", value_pdf_writer_collect_value, "p", value_pdf_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PDFWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdf_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PDFWriter), 0, (GInstanceInitFunc) pdf_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pdf_writer_type_id;
		pdf_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PDFWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pdf_writer_type_id__volatile, pdf_writer_type_id);
	}
	return pdf_writer_type_id__volatile;
}


gpointer pdf_writer_ref (gpointer instance) {
	PDFWriter* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void pdf_writer_unref (gpointer instance) {
	PDFWriter* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PDF_WRITER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1) {
	cairo_status_t result;
	result = ps_writer_write_cairo_data (self, data, data_length1);
	return result;
}


PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream) {
	PsWriter* self = NULL;
	GFileOutputStream* _tmp0_;
	GFileOutputStream* _tmp1_;
	cairo_surface_t* _tmp2_;
	g_return_val_if_fail (stream != NULL, NULL);
	self = (PsWriter*) g_type_create_instance (object_type);
	_tmp0_ = stream;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->stream);
	self->stream = _tmp1_;
	_tmp2_ = cairo_ps_surface_create_for_stream (_ps_writer_write_cairo_data_cairo_write_func_t, self, (gdouble) 0, (gdouble) 0);
	_cairo_surface_destroy0 (self->surface);
	self->surface = _tmp2_;
	return self;
}


PsWriter* ps_writer_new (GFileOutputStream* stream) {
	return ps_writer_construct (TYPE_PS_WRITER, stream);
}


static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1) {
	cairo_status_t result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		GFileOutputStream* _tmp0_;
		guint8* _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = self->stream;
		_tmp1_ = data;
		_tmp1__length1 = data_length1;
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("book.vala:565: Error writing data: %s", _tmp3_);
		result = CAIRO_STATUS_WRITE_ERROR;
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = CAIRO_STATUS_SUCCESS;
	return result;
}


static void value_ps_writer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_ps_writer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		ps_writer_unref (value->data[0].v_pointer);
	}
}


static void value_ps_writer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ps_writer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_ps_writer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_ps_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PsWriter* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ps_writer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_ps_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PsWriter** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ps_writer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPsWriter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PS_WRITER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_ps_writer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER), NULL);
	return value->data[0].v_pointer;
}


void value_set_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ps_writer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ps_writer_unref (old);
	}
}


void value_take_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ps_writer_unref (old);
	}
}


static void ps_writer_class_init (PsWriterClass * klass) {
	ps_writer_parent_class = g_type_class_peek_parent (klass);
	PS_WRITER_CLASS (klass)->finalize = ps_writer_finalize;
}


static void ps_writer_instance_init (PsWriter * self) {
	self->ref_count = 1;
}


static void ps_writer_finalize (PsWriter* obj) {
	PsWriter * self;
	self = PS_WRITER (obj);
	_cairo_surface_destroy0 (self->surface);
	_g_object_unref0 (self->stream);
}


GType ps_writer_get_type (void) {
	static volatile gsize ps_writer_type_id__volatile = 0;
	if (g_once_init_enter (&ps_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_ps_writer_init, value_ps_writer_free_value, value_ps_writer_copy_value, value_ps_writer_peek_pointer, "p", value_ps_writer_collect_value, "p", value_ps_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PsWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ps_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PsWriter), 0, (GInstanceInitFunc) ps_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType ps_writer_type_id;
		ps_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PsWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&ps_writer_type_id__volatile, ps_writer_type_id);
	}
	return ps_writer_type_id__volatile;
}


gpointer ps_writer_ref (gpointer instance) {
	PsWriter* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void ps_writer_unref (gpointer instance) {
	PsWriter* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PS_WRITER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



