#!/usr/bin/php
<?php
/*
 * format of update files:
 *  db_update_<ver>[-(alpha|beta)<n>]_<ver>[-(alpha|beta)<n>]_<dbtype>.sql
 *
 * examples of update files: 
 *  db_update_0.6.5_0.6.6_postgres.sql
 *  db_update_0.8-beta5_0.8-beta6_mysql.sql
 *  db_update_1.2-alpha3_1.2_alpha4_postgres.sql
 *
 * CAUTION the separator inside the destination version may vary:
 *  db_update_1.2-alpha2_1.2-alpha3_postgres.sql
 *                          ^
 *
 * This script is run manually when necessary (e.g. new upstream release).
 */

error_reporting(E_ALL);

require('gen_sql_libs.inc.php');

$VERBOSE=true;

$p='../../sql/';

$changelog = file('../changelog');
$hit = 0;
foreach ($changelog as $c) {
  if (preg_match('#^serendipity \((([0-9.]+)-[0-9]+)#', $c, $m)) {
    $hit++;
    if ($hit == 1) {
      $v_latest = $m[2];
      $v_latest_full = $m[1];
    }
    if ($hit == 2) {
      $v_previous = $m[2];
      break;
    }
  }
}

if ($VERBOSE) echo "Latest: $v_latest ($v_latest_full), Previous: $v_previous\n\n";

if ($handle = opendir($p)) {
  foreach (glob("dbc/upgrade/*/${v_latest_full}") as $filename) {
    unlink($filename);
  }
  while (false !== ($file = readdir($handle))) {
    if ($file != "." && $file != "..") {
      if (preg_match('#^db_update_([0-9.]+)(?:-(?:alpha|beta)[0-9]+)?_([0-9.]+)(?:(?:-|_)(?:alpha|beta)[0-9]+)?_(mysql|postgres|sqlite)#', $file, $m)) {
	$files["$file"] = array($m[1], $m[2], $m[3]);
      }
    }
  }
  closedir($handle);
 }

ksort($files);
foreach ($files as $k => $v) {
  $v_src = $v[0];
  $v_dst = $v[1];
  $db = $v[2];
  if (version_compare($v_dst, $v_previous, '>') && version_compare($v_dst, $v_latest, '<=')) {
    if ($db == 'postgres') $db = 'pgsql';
    $sqlf = "dbc/upgrade/${db}/${v_latest_full}";
    $newsql = str_replace('{PREFIX}', 's9y_', file_get_contents("$p/$k"));
    $newsql = call_user_func("convert_db_schema_$db", $newsql);
    file_put_contents($sqlf, $newsql, FILE_APPEND);
    if ($VERBOSE) echo $k . "\n";
    exec("svn status $sqlf | grep ^\? && svn add $sqlf");
  }
}
