<?php

define('IN_serendipity', true);
define('LANG_CHARSET', 'UTF-8');

require('../../include/functions_installer.inc.php');

// ------------------------------------------------------------
// Copied from includes/db/*.inc.php and modified to return the
// result instead of inserting it directly

function convert_db_schema_mysql($query) {
    static $search  = array('{AUTOINCREMENT}', '{PRIMARY}',
        '{UNSIGNED}', '{FULLTEXT}', '{FULLTEXT_MYSQL}', '{BOOLEAN}');
    static $replace = array('int(11) not null auto_increment', 'primary key',
        'unsigned'  , 'FULLTEXT', 'FULLTEXT', 'enum (\'true\', \'false\') NOT NULL default \'true\'');
    static $is_utf8 = null;
    global $serendipity;

    if ($is_utf8 === null) {
        $search[] = '{UTF_8}';
        if (  (isset($_POST['charset']) && $_POST['charset'] == 'UTF-8/') ||
              $serendipity['charset'] == 'UTF-8/' ||
              $serendipity['POST']['charset'] == 'UTF-8/' ||
              LANG_CHARSET == 'UTF-8' ) {
            $replace[] = '/*!40100 CHARACTER SET utf8 COLLATE utf8_unicode_ci */';
        } else {
            $replace[] = '';
        }
    }

    $query = trim(str_replace($search, $replace, $query));

    if ($query{0} == '@') {
	return substr($query,1);
    } else {
    	return $query;
    }
}

function convert_db_schema_pgsql($query) {
    static $search  = array('{AUTOINCREMENT}', '{PRIMARY}', '{UNSIGNED}',
        '{FULLTEXT}', '{BOOLEAN}', 'int(1)', 'int(10)', 'int(11)', 'int(4)', '{UTF_8}');
    static $replace = array('SERIAL', 'primary key', '', '', 'BOOLEAN NOT NULL', 'int2',
        'int4', 'int4', 'int4', '');

    if (stristr($query, '{FULLTEXT_MYSQL}')) {
        return '';
    }

    $query = trim(str_replace($search, $replace, $query));

    if ($query{0} == '@') {
	return substr($query,1);
    } else {
    	return $query;
    }
}


function convert_db_schema_sqlite($query) {
    static $search  = array('{AUTOINCREMENT}', '{PRIMARY}', '{UNSIGNED}', '{FULLTEXT}', '{BOOLEAN}', '{UTF_8}');
    static $replace = array('INTEGER', 'PRIMARY KEY', '', '', 'BOOLEAN NOT NULL', '');

    if (stristr($query, '{FULLTEXT_MYSQL}')) {
        return '';
    }

    $query = trim(str_replace($search, $replace, $query));
    if ($query{0} == '@') {
        return substr($query, 1);
    } else {
        return $query;
    }
}

function convert_db_schema_sqlite3($query) {
  // sqlite3 conversion same as sqlite
  return convert_db_schema_sqlite($query);
}

