// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_FIND2_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_FIND2_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// ApproxFindBegin_

template <typename TNeedle, typename TScore, typename HasFindBeginSupport> struct ApproxFindBegin_;       	// "projects/library/seqan/find2/find_approx_find_begin.h"(57)

//____________________________________________________________________________
// DPSearch

template <typename TScore, typename TSpec , typename TFindBeginPatternSpec > struct DPSearch;       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(63)

//____________________________________________________________________________
// FindInfix_

struct FindInfix_;       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(54)

//____________________________________________________________________________
// FindPrefix_

struct FindPrefix_;       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(58)

//____________________________________________________________________________
// FindState_

struct FindState_;       	// "projects/library/seqan/find2/find_base.h"(43)

//____________________________________________________________________________
// Finder

template <typename THaystack, typename TSpec > struct Finder;       	// "projects/library/seqan/find2/find_base.h"(61)

//____________________________________________________________________________
// HammingSimple_

struct HammingSimple_;       	// "projects/library/seqan/find2/find_hamming_simple.h"(43)

//____________________________________________________________________________
// MultipleSimple_

struct MultipleSimple_;       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(43)

//____________________________________________________________________________
// Needle

template <typename TPattern> struct Needle;       	// "projects/library/seqan/find2/find_base.h"(65)

//____________________________________________________________________________
// Pattern

template <typename TNeedle, typename TSpec> struct Pattern;       	// "projects/library/seqan/find2/find_base.h"(57)

//____________________________________________________________________________
// ScoringScheme

template <typename TPattern> struct ScoringScheme;       	// "projects/library/seqan/find2/find_base.h"(76)

//____________________________________________________________________________
// ShiftAnd_

struct ShiftAnd_;       	// "projects/library/seqan/find2/find_exact_shiftand.h"(45)

//____________________________________________________________________________
// UseScoreLimit_

struct UseScoreLimit_;       	// "projects/library/seqan/find2/find_approx_find_begin.h"(101)

//____________________________________________________________________________
// UseScore_

struct UseScore_;       	// "projects/library/seqan/find2/find_approx_find_begin.h"(95)

//____________________________________________________________________________
// WildShiftAnd_

struct WildShiftAnd_;       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(50)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// FindInfix

typedef Tag<FindInfix_> FindInfix;       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(55)

//____________________________________________________________________________
// FindPrefix

typedef Tag<FindPrefix_> FindPrefix;       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(59)

//____________________________________________________________________________
// HammingSimple

typedef Tag<HammingSimple_> HammingSimple;       	// "projects/library/seqan/find2/find_hamming_simple.h"(44)

//____________________________________________________________________________
// MultipleSimple

typedef Tag<MultipleSimple_> MultipleSimple;       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(44)

//____________________________________________________________________________
// ShiftAnd

typedef Tag<ShiftAnd_> ShiftAnd;       	// "projects/library/seqan/find2/find_exact_shiftand.h"(46)

//____________________________________________________________________________
// UseScore

typedef Tag<UseScore_> UseScore;       	// "projects/library/seqan/find2/find_approx_find_begin.h"(96)

//____________________________________________________________________________
// UseScoreLimit

typedef Tag<UseScoreLimit_> UseScoreLimit;       	// "projects/library/seqan/find2/find_approx_find_begin.h"(102)

//____________________________________________________________________________
// WildShiftAnd

typedef Tag<WildShiftAnd_> WildShiftAnd;       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(51)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// _findBeginImpl

template <typename TNeedle, typename TScore, typename THaystack, typename TTag> bool _findBeginImpl(ApproxFindBegin_<TNeedle, TScore, True> & findBeginStruct, TScore const & scoringScheme, typename Value<TScore>::Type const & findScore, typename Position<TNeedle>::Type const & endPosition, THaystack const & haystack, TNeedle const & needle, Tag<TTag> const & tag);       	// "projects/library/seqan/find2/find_approx_find_begin.h"(160)

//____________________________________________________________________________
// _findBeginScoreLimit

template <typename TNeedle, typename TScore> inline typename Value<TScore>::Type _findBeginScoreLimit(ApproxFindBegin_<TNeedle, TScore, True> const &, typename Value<TScore>::Type const & findScore, typename Value<TScore>::Type const &, UseScore const &);       	// "projects/library/seqan/find2/find_approx_find_begin.h"(137)
template <typename TNeedle, typename TScore> inline typename Value<TScore>::Type _findBeginScoreLimit(ApproxFindBegin_<TNeedle, TScore, True> const &, typename Value<TScore>::Type const &, typename Value<TScore>::Type const & findScoreLimit, UseScoreLimit const &);       	// "projects/library/seqan/find2/find_approx_find_begin.h"(147)

//____________________________________________________________________________
// _findShiftAndLargeNeedle

template <typename THaystack, typename TNeedle> inline bool _findShiftAndLargeNeedle(Finder<THaystack, Default> & finder, Pattern<TNeedle, ShiftAnd> & pattern);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(260)

//____________________________________________________________________________
// _findShiftAndSmallNeedle

template <typename THaystack, typename TNeedle> inline bool _findShiftAndSmallNeedle(Finder<THaystack, Default> & finder, Pattern<TNeedle, ShiftAnd> & pattern);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(238)

//____________________________________________________________________________
// _findWildShiftAndGetCharacterClass

inline void _findWildShiftAndGetCharacterClass( CharString & result, CharString const & host, Position<CharString>::Type begin, Position<CharString>::Type end);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(524)

//____________________________________________________________________________
// _findWildShiftAndIsValid

inline bool _findWildShiftAndIsValid(CharString const & needle);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(337)

//____________________________________________________________________________
// _findWildShiftAndLargeNeedle

template <typename THaystack, typename TNeedle> inline bool _findWildShiftAndLargeNeedle(Finder<THaystack, Default> & finder, Pattern<TNeedle, WildShiftAnd> & pattern);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(795)

//____________________________________________________________________________
// _findWildShiftAndLengthWithoutWildcards

inline Position<CharString>::Type _findWildShiftAndLengthWithoutWildcards(CharString const & needle);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(456)

//____________________________________________________________________________
// _findWildShiftAndSmallNeedle

template <typename THaystack, typename TNeedle> inline bool _findWildShiftAndSmallNeedle(Finder<THaystack, Default> & finder, Pattern<TNeedle, WildShiftAnd> & pattern);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(764)

//____________________________________________________________________________
// _initFindBegin

template <typename TNeedle, typename TScore> void _initFindBegin(ApproxFindBegin_<TNeedle, TScore, True> & findBeginStruct, typename Position<TNeedle>::Type const & needleLength, TScore const & scoringScheme, int scoreLimit);       	// "projects/library/seqan/find2/find_approx_find_begin.h"(108)

//____________________________________________________________________________
// _initPattern

template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin> inline void _initPattern(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(273)
template <typename TNeedle> void _initPattern(Pattern<TNeedle, ShiftAnd> & pattern);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(86)

//____________________________________________________________________________
// _initializePattern

template <typename TNeedle> void _initializePattern(Pattern<TNeedle, WildShiftAnd> & me);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(558)

//____________________________________________________________________________
// _isUnsigned

inline bool _isUnsigned(CharString const & number);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(297)

//____________________________________________________________________________
// _setEndPositionShiftAndLargeNeedle

template <typename THaystack, typename TNeedle> inline bool _setEndPositionShiftAndLargeNeedle(Finder<THaystack, Default> & finder, Pattern<TNeedle, ShiftAnd> & pattern, typename Position<THaystack>::Type const & pos);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(380)

//____________________________________________________________________________
// _setEndPositionShiftAndSmallNeedle

template <typename THaystack, typename TNeedle> inline bool _setEndPositionShiftAndSmallNeedle(Finder<THaystack, Default> & finder, Pattern<TNeedle, ShiftAnd> & pattern, typename Position<THaystack>::Type const & pos);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(360)

//____________________________________________________________________________
// begin

template <typename THaystack, typename TTag> typename Iterator<THaystack const>::Type begin(Finder<THaystack, Default> const & finder, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_finder_default.h"(73)
template <typename THaystack, typename TTag> typename Iterator<THaystack const>::Type begin(Finder<THaystack, Default> & finder, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_finder_default.h"(84)
template <typename TNeedle, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type begin(Pattern<TNeedle, Simple> const & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_exact_simple.h"(122)
template <typename TNeedle, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type begin(Pattern<TNeedle, Simple> & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_exact_simple.h"(132)
template <typename TNeedle, typename TStringSetSpec, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type begin(Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> const & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(142)
template <typename TNeedle, typename TStringSetSpec, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type begin(Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(152)
template <typename TNeedle, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type begin(Pattern<TNeedle, HammingSimple> const & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_hamming_simple.h"(152)
template <typename TNeedle, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type begin(Pattern<TNeedle, HammingSimple> & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_hamming_simple.h"(162)
template <typename TNeedle, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type begin(Pattern<TNeedle, WildShiftAnd> const & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(151)
template <typename TNeedle, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type begin(Pattern<TNeedle, WildShiftAnd> & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(161)
template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type begin(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > const & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(201)
template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type begin(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(211)
template <typename TNeedle, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type begin(Pattern<TNeedle, ShiftAnd> const & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(163)
template <typename TNeedle, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type begin(Pattern<TNeedle, ShiftAnd> & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(173)

//____________________________________________________________________________
// beginPosition

template <typename THaystack> typename Position<THaystack const>::Type beginPosition(Finder<THaystack, Default> const & finder);       	// "projects/library/seqan/find2/find_finder_default.h"(112)
template <typename THaystack> typename Position<THaystack>::Type beginPosition(Finder<THaystack, Default> & finder);       	// "projects/library/seqan/find2/find_finder_default.h"(122)
template <typename TNeedle> typename Position<TNeedle>::Type beginPosition(Pattern<TNeedle, Simple> const & pattern);       	// "projects/library/seqan/find2/find_exact_simple.h"(159)
template <typename TNeedle> typename Position<TNeedle>::Type beginPosition(Pattern<TNeedle, Simple> & pattern);       	// "projects/library/seqan/find2/find_exact_simple.h"(169)
template <typename TNeedle, typename TStringSetSpec> typename Position<TNeedle>::Type beginPosition(Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> const & pattern);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(179)
template <typename TNeedle, typename TStringSetSpec> typename Position<TNeedle>::Type beginPosition(Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> & pattern);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(189)
template <typename TNeedle> typename Position<TNeedle>::Type beginPosition(Pattern<TNeedle, HammingSimple> const & pattern);       	// "projects/library/seqan/find2/find_hamming_simple.h"(192)
template <typename TNeedle> typename Position<TNeedle>::Type beginPosition(Pattern<TNeedle, HammingSimple> & pattern);       	// "projects/library/seqan/find2/find_hamming_simple.h"(202)
template <typename TNeedle> typename Position<TNeedle>::Type beginPosition(Pattern<TNeedle, WildShiftAnd> const & pattern);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(187)
template <typename TNeedle> typename Position<TNeedle>::Type beginPosition(Pattern<TNeedle, WildShiftAnd> & pattern);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(197)
template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin> typename Position<TNeedle>::Type beginPosition(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > const & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(237)
template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin> typename Position<TNeedle>::Type beginPosition(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(247)
template <typename TNeedle> typename Position<TNeedle>::Type beginPosition(Pattern<TNeedle, ShiftAnd> const & pattern);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(200)
template <typename TNeedle> typename Position<TNeedle>::Type beginPosition(Pattern<TNeedle, ShiftAnd> & pattern);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(210)

//____________________________________________________________________________
// buildAlignment

template <typename THaystack, typename TNeedle, typename TAlignSeq, typename TAlignSpec> bool buildAlignment(Finder<THaystack, Default> &finder, Pattern<TNeedle, Simple> &pattern, Align<TAlignSeq, TAlignSpec> &outAlignment);       	// "projects/library/seqan/find2/find_exact_simple.h"(321)
template <typename THaystack, typename TNeedle, typename TStringSetSpec, typename TAlignSeq, typename TAlignSpec> bool buildAlignment(Finder<THaystack, Default> &finder, Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> &pattern, Align<TAlignSeq, TAlignSpec> &outAlignment);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(448)
template <typename THaystack, typename TNeedle, typename TAlignSeq, typename TAlignSpec> bool buildAlignment(Finder<THaystack, Default> &finder, Pattern<TNeedle, HammingSimple> &pattern, Align<TAlignSeq, TAlignSpec> &outAlignment);       	// "projects/library/seqan/find2/find_hamming_simple.h"(360)
template <typename THaystack, typename TNeedle, typename TAlignSeq, typename TAlignSpec> bool buildAlignment(Finder<THaystack, Default> &finder, Pattern<TNeedle, WildShiftAnd> &pattern, Align<TAlignSeq, TAlignSpec> &outAlignment);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(273)
template <typename THaystack, typename TNeedle, typename TScore, typename TDPSearchSpec, typename TAlignSeq, typename TAlignSpec> bool buildAlignment(Finder<THaystack, Default> &finder, Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, True> > &pattern, Align<TAlignSeq, TAlignSpec> &outAlignment);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(547)
template <typename THaystack, typename TNeedle, typename TAlignSeq, typename TAlignSpec> bool buildAlignment(Finder<THaystack, Default> &finder, Pattern<TNeedle, ShiftAnd> &pattern, Align<TAlignSeq, TAlignSpec> &outAlignment);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(470)

//____________________________________________________________________________
// end

template <typename THaystack, typename TTag> typename Iterator<THaystack const>::Type end(Finder<THaystack, Default> const & finder, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_finder_default.h"(93)
template <typename THaystack, typename TTag> typename Iterator<THaystack const>::Type end(Finder<THaystack, Default> & finder, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_finder_default.h"(104)
template <typename TNeedle, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type end(Pattern<TNeedle, Simple> const & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_exact_simple.h"(140)
template <typename TNeedle, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type end(Pattern<TNeedle, Simple> & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_exact_simple.h"(151)
template <typename TNeedle, typename TStringSetSpec, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type end(Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> const & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(160)
template <typename TNeedle, typename TStringSetSpec, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type end(Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(171)
template <typename TNeedle, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type end(Pattern<TNeedle, HammingSimple> const & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_hamming_simple.h"(170)
template <typename TNeedle, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type end(Pattern<TNeedle, HammingSimple> & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_hamming_simple.h"(184)
template <typename TNeedle, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type end(Pattern<TNeedle, WildShiftAnd> const & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(169)
template <typename TNeedle, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type end(Pattern<TNeedle, WildShiftAnd> & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(179)
template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type end(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > const & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(219)
template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type end(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(229)
template <typename TNeedle, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type end(Pattern<TNeedle, ShiftAnd> const & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(181)
template <typename TNeedle, typename TTag> typename Iterator<TNeedle const, Tag<TTag> const>::Type end(Pattern<TNeedle, ShiftAnd> & pattern, Tag<TTag> const & spec);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(192)

//____________________________________________________________________________
// endPosition

template <typename THaystack> typename Position<THaystack>::Type endPosition(Finder<THaystack, Default> const & finder);       	// "projects/library/seqan/find2/find_finder_default.h"(130)
template <typename THaystack> typename Position<THaystack>::Type endPosition(Finder<THaystack, Default> & finder);       	// "projects/library/seqan/find2/find_finder_default.h"(140)
template <typename TNeedle> typename Position<TNeedle>::Type endPosition(Pattern<TNeedle, Simple> const & pattern);       	// "projects/library/seqan/find2/find_exact_simple.h"(177)
template <typename TNeedle> typename Position<TNeedle>::Type endPosition(Pattern<TNeedle, Simple> & pattern);       	// "projects/library/seqan/find2/find_exact_simple.h"(188)
template <typename TNeedle, typename TStringSetSpec> typename Position<TNeedle>::Type endPosition(Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> const & pattern);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(197)
template <typename TNeedle, typename TStringSetSpec> typename Position<TNeedle>::Type endPosition(Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> & pattern);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(208)
template <typename TNeedle> typename Position<TNeedle>::Type endPosition(Pattern<TNeedle, HammingSimple> const & pattern);       	// "projects/library/seqan/find2/find_hamming_simple.h"(210)
template <typename TNeedle> typename Position<TNeedle>::Type endPosition(Pattern<TNeedle, HammingSimple> & pattern);       	// "projects/library/seqan/find2/find_hamming_simple.h"(224)
template <typename TNeedle> typename Position<TNeedle>::Type endPosition(Pattern<TNeedle, WildShiftAnd> const & pattern);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(205)
template <typename TNeedle> typename Position<TNeedle>::Type endPosition(Pattern<TNeedle, WildShiftAnd> & pattern);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(215)
template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin> typename Position<TNeedle>::Type endPosition(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > const & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(255)
template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin> typename Position<TNeedle>::Type endPosition(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(265)
template <typename TNeedle> typename Position<TNeedle>::Type endPosition(Pattern<TNeedle, ShiftAnd> const & pattern);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(218)
template <typename TNeedle> typename Position<TNeedle>::Type endPosition(Pattern<TNeedle, ShiftAnd> & pattern);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(229)

//____________________________________________________________________________
// find

template <typename THaystack, typename TNeedle> bool find(Finder<THaystack, Default> & finder, Pattern<TNeedle, Simple> & pattern);       	// "projects/library/seqan/find2/find_exact_simple.h"(197)
template <typename THaystack, typename TNeedle, typename TStringSetSpec> bool find(Finder<THaystack, Default> & finder, Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> & pattern);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(217)
template <typename THaystack, typename TNeedle> bool find(Finder<THaystack, Default> & finder, Pattern<TNeedle, HammingSimple> & pattern);       	// "projects/library/seqan/find2/find_hamming_simple.h"(233)
template <typename THaystack, typename TNeedle> bool find(Finder<THaystack, Default> & finder, Pattern<TNeedle, WildShiftAnd> & pattern);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(837)
template <typename THaystack, typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin> bool find(Finder<THaystack, Default> & finder, Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(301)
template <typename THaystack, typename TNeedle> inline bool find(Finder<THaystack, Default> & finder, Pattern<TNeedle, ShiftAnd> & pattern);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(290)

//____________________________________________________________________________
// findBegin

template <typename THaystack, typename TNeedle> bool findBegin(Finder<THaystack, Default> & finder, Pattern<TNeedle, Simple> & pattern);       	// "projects/library/seqan/find2/find_exact_simple.h"(248)
template <typename THaystack, typename TNeedle, typename TStringSetSpec> bool findBegin(Finder<THaystack, Default> & finder, Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> & pattern);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(302)
template <typename THaystack, typename TNeedle> bool findBegin(Finder<THaystack, Default> & finder, Pattern<TNeedle, HammingSimple> & pattern);       	// "projects/library/seqan/find2/find_hamming_simple.h"(288)
template <typename THaystack, typename TNeedle, typename TScore, typename TFindBeginScoreLimitTag> bool findBegin(Finder<THaystack, Default> & finder, Pattern<TNeedle, DPSearch<TScore, FindInfix, True> > & pattern, TFindBeginScoreLimitTag const & tag);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(391)
template <typename THaystack, typename TNeedle, typename TScore, typename TFindBeginSpec, typename TFindBeginScoreLimitTag> bool findBegin(Finder<THaystack, Default> & finder, Pattern<TNeedle, DPSearch<TScore, FindPrefix, TFindBeginSpec> > & pattern, TFindBeginScoreLimitTag const &);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(419)
template <typename THaystack, typename TNeedle, typename TScore, typename TDPSearchSpec> bool findBegin(Finder<THaystack, Default> & finder, Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, True> > & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(446)
template <typename THaystack, typename TNeedle> bool findBegin(Finder<THaystack, Default> & finder, Pattern<TNeedle, ShiftAnd> & pattern);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(336)

//____________________________________________________________________________
// findBeginScore

template <typename TNeedle, typename TScore> typename Value<typename ScoringScheme<Pattern<TNeedle, DPSearch<TScore, FindInfix, True> > >::Type>::Type findBeginScore(Pattern<TNeedle, DPSearch<TScore, FindInfix, True> > const & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(366)
template <typename TNeedle, typename TScore, typename TFindBeginSpec> typename Value<typename ScoringScheme<Pattern<TNeedle, DPSearch<TScore, FindPrefix, TFindBeginSpec> > >::Type>::Type findBeginScore(Pattern<TNeedle, DPSearch<TScore, FindPrefix, TFindBeginSpec> > const & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(378)

//____________________________________________________________________________
// getScoreLimit

template <typename TNeedle> int getScoreLimit(Pattern<TNeedle, HammingSimple> const & pattern);       	// "projects/library/seqan/find2/find_hamming_simple.h"(82)

//____________________________________________________________________________
// haystack

template <typename THaystack> THaystack const & haystack(Finder<THaystack, Default> const & finder);       	// "projects/library/seqan/find2/find_finder_default.h"(65)

//____________________________________________________________________________
// host

template <typename TNeedle> TNeedle const & host(Pattern<TNeedle, Simple> const & pattern);       	// "projects/library/seqan/find2/find_exact_simple.h"(72)
template <typename TNeedle> TNeedle const & host(Pattern<TNeedle, Simple> & pattern);       	// "projects/library/seqan/find2/find_exact_simple.h"(80)
template <typename TNeedle, typename TStringSetSpec> StringSet<TNeedle, TStringSetSpec> const & host(Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> const & pattern);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(79)
template <typename TNeedle, typename TStringSetSpec> StringSet<TNeedle, TStringSetSpec> const & host(Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> & pattern);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(87)
template <typename TNeedle> TNeedle const & host(Pattern<TNeedle, HammingSimple> const & pattern);       	// "projects/library/seqan/find2/find_hamming_simple.h"(102)
template <typename TNeedle> TNeedle const & host(Pattern<TNeedle, HammingSimple> & pattern);       	// "projects/library/seqan/find2/find_hamming_simple.h"(110)
template <typename TNeedle> TNeedle const & host(Pattern<TNeedle, WildShiftAnd> const & pattern);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(101)
template <typename TNeedle> TNeedle const & host(Pattern<TNeedle, WildShiftAnd> & pattern);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(109)
template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin> TNeedle const & host(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > const & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(151)
template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin> TNeedle const & host(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(159)
template <typename TNeedle> TNeedle const & host(Pattern<TNeedle, ShiftAnd> const & pattern);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(113)
template <typename TNeedle> TNeedle const & host(Pattern<TNeedle, ShiftAnd> & pattern);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(121)

//____________________________________________________________________________
// infix

template <typename THaystack> Segment<THaystack const, InfixSegment> infix(Finder<THaystack, Default> & finder);       	// "projects/library/seqan/find2/find_finder_default.h"(148)
template <typename TNeedle> Segment<TNeedle const, InfixSegment> infix(Pattern<TNeedle, Simple> const & pattern);       	// "projects/library/seqan/find2/find_exact_simple.h"(104)
template <typename TNeedle> Segment<TNeedle const, InfixSegment> infix(Pattern<TNeedle, Simple> & pattern);       	// "projects/library/seqan/find2/find_exact_simple.h"(114)
template <typename TNeedle, typename TStringSetSpec> Segment<TNeedle const, InfixSegment> infix(Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> const & pattern);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(123)
template <typename TNeedle, typename TStringSetSpec> Segment<TNeedle const, InfixSegment> infix(Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> & pattern);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(134)
template <typename TNeedle> Segment<TNeedle const, InfixSegment> infix(Pattern<TNeedle, HammingSimple> const & pattern);       	// "projects/library/seqan/find2/find_hamming_simple.h"(134)
template <typename TNeedle> Segment<TNeedle const, InfixSegment> infix(Pattern<TNeedle, HammingSimple> & pattern);       	// "projects/library/seqan/find2/find_hamming_simple.h"(144)
template <typename TNeedle> Segment<TNeedle const, InfixSegment> infix(Pattern<TNeedle, WildShiftAnd> const & pattern);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(133)
template <typename TNeedle> Segment<TNeedle const, InfixSegment> infix(Pattern<TNeedle, WildShiftAnd> & pattern);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(143)
template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin> Segment<TNeedle const, InfixSegment> infix(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > const & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(183)
template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin> Segment<TNeedle const, InfixSegment> infix(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(193)
template <typename TNeedle> Segment<TNeedle const, InfixSegment> infix(Pattern<TNeedle, ShiftAnd> const & pattern);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(145)
template <typename TNeedle> Segment<TNeedle const, InfixSegment> infix(Pattern<TNeedle, ShiftAnd> & pattern);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(155)

//____________________________________________________________________________
// length

template <typename TNeedle> typename Position<TNeedle>::Type length(Pattern<TNeedle, Simple> const & pattern);       	// "projects/library/seqan/find2/find_exact_simple.h"(95)
template <typename TNeedle, typename TStringSetSpec> typename Position<StringSet<TNeedle, TStringSetSpec> >::Type length(Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> const & pattern);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(112)
template <typename TNeedle> typename Position<TNeedle>::Type length(Pattern<TNeedle, HammingSimple> const & pattern);       	// "projects/library/seqan/find2/find_hamming_simple.h"(125)
template <typename TNeedle> typename Position<TNeedle>::Type length(Pattern<TNeedle, WildShiftAnd> const & pattern);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(124)
template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin> typename Position<TNeedle>::Type length(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > const & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(174)
template <typename TNeedle> typename Position<TNeedle>::Type length(Pattern<TNeedle, ShiftAnd> const & pattern);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(136)

//____________________________________________________________________________
// needle

template <typename TNeedle> TNeedle const & needle(Pattern<TNeedle, Simple> const & pattern);       	// "projects/library/seqan/find2/find_exact_simple.h"(88)
template <typename TNeedle> TNeedle const & needle(Pattern<TNeedle, HammingSimple> const & pattern);       	// "projects/library/seqan/find2/find_hamming_simple.h"(118)
template <typename TNeedle> TNeedle const & needle(Pattern<TNeedle, WildShiftAnd> const & pattern);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(117)
template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin> TNeedle const & needle(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > const & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(167)
template <typename TNeedle> TNeedle const & needle(Pattern<TNeedle, ShiftAnd> const & pattern);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(129)

//____________________________________________________________________________
// needleIndex

template <typename TNeedle, typename TStringSetSpec> typename Position<StringSet<TNeedle, TStringSetSpec> >::Type needleIndex(Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> const & pattern);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(102)

//____________________________________________________________________________
// needles

template <typename TNeedle, typename TStringSetSpec> StringSet<TNeedle, TStringSetSpec> const & needles(Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> const & pattern);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(95)

//____________________________________________________________________________
// score

template <typename TNeedle> int score(Pattern<TNeedle, HammingSimple> const & pattern);       	// "projects/library/seqan/find2/find_hamming_simple.h"(89)
template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin> typename Value<TScore>::Type const & score(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > const & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(138)

//____________________________________________________________________________
// scoreLimit

template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin> typename Value<TScore>::Type const & scoreLimit(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > const & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(131)

//____________________________________________________________________________
// scoringScheme

template <typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin> TScore const & scoringScheme(Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > const & pattern);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(124)

//____________________________________________________________________________
// setBeginPosition

template <typename THaystack, typename TNeedle, typename TPosition> bool setBeginPosition(Finder<THaystack, Default> & finder, Pattern<TNeedle, Simple> & pattern, TPosition const & pos);       	// "projects/library/seqan/find2/find_exact_simple.h"(305)
template <typename THaystack, typename TNeedle, typename TStringSetSpec, typename TPos> bool setBeginPosition(Finder<THaystack, Default> & finder, Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> & pattern, TPos const & pos);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(386)
template <typename THaystack, typename TNeedle, typename TPosition> bool setBeginPosition(Finder<THaystack, Default> & finder, Pattern<TNeedle, HammingSimple> & pattern, TPosition const & pos);       	// "projects/library/seqan/find2/find_hamming_simple.h"(348)
template <typename THaystack, typename TNeedle, typename TPosition> bool setBeginPosition(Finder<THaystack, Default> & finder, Pattern<TNeedle, ShiftAnd> & pattern, TPosition const & pos);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(455)

//____________________________________________________________________________
// setEndPosition

template <typename THaystack, typename TNeedle, typename TPosition> bool setEndPosition(Finder<THaystack, Default> & finder, Pattern<TNeedle, Simple> & pattern, TPosition const & pos);       	// "projects/library/seqan/find2/find_exact_simple.h"(271)
template <typename THaystack, typename TNeedle, typename TStringSetSpec, typename TPos> bool setEndPosition(Finder<THaystack, Default> & finder, Pattern<StringSet<TNeedle, TStringSetSpec>, MultipleSimple> & pattern, TPos const & pos);       	// "projects/library/seqan/find2/find_multiple_exact_simple.h"(325)
template <typename THaystack, typename TNeedle, typename TPosition> bool setEndPosition(Finder<THaystack, Default> & finder, Pattern<TNeedle, HammingSimple> & pattern, TPosition const & pos);       	// "projects/library/seqan/find2/find_hamming_simple.h"(311)
template <typename THaystack, typename TNeedle, typename TPosition> bool setEndPosition(Finder<THaystack, Default> & finder, Pattern<TNeedle, WildShiftAnd> & pattern, TPosition const & pos);       	// "projects/library/seqan/find2/find_pattern_wild_shiftand.h"(236)
template <typename THaystack, typename TNeedle, typename TScore, typename TDPSearchSpec, typename TSupportFindBegin> bool setEndPosition(Finder<THaystack, Default> & finder, Pattern<TNeedle, DPSearch<TScore, TDPSearchSpec, TSupportFindBegin> > & pattern, typename Position<THaystack>::Type const & pos);       	// "projects/library/seqan/find2/find_approx_dpsearch.h"(456)
template <typename THaystack, typename TNeedle> bool setEndPosition(Finder<THaystack, Default> & finder, Pattern<TNeedle, ShiftAnd> & pattern, typename Position<THaystack>::Type const & pos);       	// "projects/library/seqan/find2/find_exact_shiftand.h"(409)

} //namespace seqan

#endif

